<?php
	/************************************************
	* Copyright (C) 2016	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspack/core/lib/infras.lib.php
	* 	\ingroup	InfraS
	* 	\brief		Functions used by InfraS module
	************************************************/

	function infraspack_admin_prepare_head ()
	{
		global $langs, $conf, $user;

		$h				= 0;
		$head			= array();
		
		$head[$h][0]	= dol_buildpath('/infraspack/admin/generalpdf.php',1);
		$head[$h][1]	= $langs->trans("GeneralPDF");
		$head[$h][2]	= 'generalpdf';
		
		$h++;
		$head[$h][0]	= dol_buildpath('/infraspack/admin/infrassetup.php',1);
		$head[$h][1]	= $langs->trans("InfraSPDF");
		$head[$h][2]	= 'infrassetup';
		
		$h++;
		$head[$h][0]	= dol_buildpath('/infraspack/admin/images.php',1);
		$head[$h][1]	= $langs->trans("Images");
		$head[$h][2]	= 'images';
		
		$h++;
		$head[$h][0]	= dol_buildpath('/infraspack/admin/adresses.php',1);
		$head[$h][1]	= $langs->trans("Adresses");
		$head[$h][2]	= 'adresses';
		
		$h++;
		$head[$h][0]	= dol_buildpath('/infraspack/admin/about.php',1);
		$head[$h][1]	= $langs->trans("About");
		$head[$h][2]	= 'about';

		return $head;
	}	// function infraspack_admin_prepare_head ()
	
	/************************************************
	*	Tests version du module et de Dolibarr.
	*	Avertissements si chgt trouvés.
	*
	************************************************/
	function infras_chgtVersions ()
	{
		global $db, $conf, $langs;
		
		$langs->load('infraspack@infraspack');
		
		$infrasdolversion											= isset($conf->global->INFRAS_DOL_VERSION) ? $conf->global->INFRAS_DOL_VERSION : '';
		$lastversion												= isset($conf->global->INFRAS_MAIN_VERSION) ? $conf->global->INFRAS_MAIN_VERSION : '';
		$currentversion												= InfraS_getLocalVersionMinDoli('infraspack');
		if ($infrasdolversion && $infrasdolversion < DOL_VERSION)
		{
			dolibarr_set_const($db, "INFRAS_PDF_VALID_CORE_CHGT",	0, 'chaine', 0, '', $conf->entity);
			setEventMessages($langs->trans('InfraSDolChg', $infrasdolversion, DOL_VERSION), null, 'warnings');
		}	// if ($infrasdolversion && $infrasdolversion < DOL_VERSION)
		if ($lastversion && $lastversion < $currentversion[0])
		{
			dolibarr_set_const($db, "INFRAS_PDF_VALID_CORE_CHGT",	0, 'chaine', 0, '', $conf->entity);
			setEventMessages($langs->trans('InfraSVersionChg', $lastversion, $currentversion[0]), null, 'warnings');
		}	// if ($lastversion && $lastversion < $currentversion[0])
	}	// function infras_chgtVersions ()

	/************************************************
	*	Tests présence de champs supplémentaires dans les tables.
	*
	*	@param   string	$appliname	module name
	************************************************/
	function InfraS_test_new_fields($appliname)
	{		
		InfraS_get_test_new_fields($appliname, 'societe_address', 'email');
		InfraS_get_test_new_fields($appliname, 'societe_address', 'url');
	}	// 	function InfraS_test_new_fields($appliname)
	
	/************************************************
	*	Tests présence d'un champ supplémentaire dans une table.
	*	Exécution du script de création si besoin.
	*
	*	@param   string	$appliname	module name
	*	@param   string	$table		simple table name without any prefix
	*	@param   string	$field		field name
	************************************************/
	function InfraS_get_test_new_fields($appliname, $table, $field)
	{
		global $conf, $db;

		$path			= dol_buildpath($appliname, 0).'/sql';
		$sql_column		= 'SHOW COLUMNS FROM '.MAIN_DB_PREFIX.$table.' LIKE "'.$field.'"';
		$result_columns	= $db->query($sql_column);
		if (! $db->num_rows($result_columns))
		{
			$filetable	= $path.'/llx_'.$table.'.sql';
			$moved		= dol_copy($filetable, $filetable.'.old');
			file_put_contents($filetable, str_replace('llx_'.$table, MAIN_DB_PREFIX.$table, file_get_contents($filetable)));
			$result		= run_sql($filetable, 1, '', 1);
			$moved		= dol_copy($filetable.'.old', $filetable);
			$delete		= dol_delete_file($filetable.'.old');
		}	// 	if (! $db->num_rows($result_columns))
		$db->free($result_columns);
	}	// function InfraS_get_test_new_fields($appliname, $table, $field)

	/************************************************
	*	Sauvegarde les paramètres du module
	*
	*	@param		string		$appliname	module name
	*	@param		integer		$origine	wich action call the function : 1 = backup button on parameters, 2 = module desactivation
	*	@return		string		1 = Ok or -1 = Ko or or 0 and error message
	************************************************/
	function InfraS_bkup_module ($appliname, $origine = 1)
	{
		global $db, $conf, $langs, $errormsg;
			
		// core change Process
		$validcorechg		= $conf->global->INFRAS_PDF_VALID_CORE_CHGT;
		if ($origine == 2)	$validcorechg	= $validcorechg	== 1 ? 2 : $validcorechg;
		// Set to UTF-8
		if (is_a($db, 'DoliDBMysqli'))	$db->db->set_charset('utf8');
		else
		{
			$db->query('SET NAMES utf8');
			$db->query('SET CHARACTER SET utf8');
		}	// else	// if (is_a($db, 'DoliDBMysqli'))
		// Control dir and file
		$path		= dol_buildpath($appliname, 0).'/sql';
		$bkpfile	= $path.'/update.'.$conf->entity;
		if (! file_exists($path))
		{
			if (dol_mkdir($path) < 0)
			{
				$errormsg	= $langs->transnoentities("ErrorCanNotCreateDir", $path);
				return 0;
			}	// if (dol_mkdir($path) < 0)
		}	// if (! file_exists($path))
		if (file_exists($path))
		{
			$handle	= fopen($bkpfile, 'w+');
			if (fwrite($handle, '') === FALSE)
			{
				$langs->load("errors");
				$errormsg	= $langs->trans("ErrorFailedToWriteInDir");
				return -1;
			}	// if (fwrite($handle, '') === FALSE)
			// Print headers and global mysql config vars
			$sqlhead	= '-- '.$db::LABEL.' dump via php with Dolibarr '.DOL_VERSION.'
--
-- Host: '.$db->db->host_info.'    Database: '.$db->database_name.'
-- ------------------------------------------------------
-- Server version	'.$db->db->server_info.'

SET FOREIGN_KEY_CHECKS = 0;
SET SQL_MODE = \'NO_AUTO_VALUE_ON_ZERO\';
LOCK TABLES '.MAIN_DB_PREFIX.'document_model WRITE, '.MAIN_DB_PREFIX.'const WRITE;
';
			fwrite($handle, $sqlhead);
			$sql_model		= 'SELECT nom, entity, type, libelle';
			$sql_model		.= ' FROM '.MAIN_DB_PREFIX.'document_model';
			$sql_model		.= ' WHERE nom like "InfraS_%" AND entity = "'.$conf->entity.'"';
			$listeCols		= array ('nom', 'entity', 'type', 'libelle');
			$duplicate		= array ('3', 'libelle', 'nom');
			fwrite($handle, InfraS_bkup_table ('document_model', $sql_model, $listeCols, $duplicate, 0, ''));
			$sql_const		= 'SELECT name, entity, value, type';
			$sql_const		.= ' FROM '.MAIN_DB_PREFIX.'const';
			$sql_const		.= ' WHERE ((name LIKE "INFRAS_%" AND name NOT LIKE "INFRAS_PDF_VALID_CORE_CHGT") OR (name LIKE "%_ADDON_PDF"  AND value like "InfraS_%"))';
			$sql_const		.= ' AND entity = "'.$conf->entity.'"';
			$autoupdate		= isset($conf->global->MAIN_DISABLE_PDF_AUTOUPDATE)	? $conf->global->MAIN_DISABLE_PDF_AUTOUPDATE : 1;
			$onDuplicate	= $db->type == 'pgsql' ? ' ON CONFLICT (name) DO UPDATE SET ' : ' ON DUPLICATE KEY UPDATE ';
			$add			= 'INSERT INTO '.MAIN_DB_PREFIX.'const (name, entity, value, type) VALUES (\'MAIN_DISABLE_PDF_AUTOUPDATE\', \'__ENTITY__\', \''.$autoupdate.'\', \'chaine\')'.$onDuplicate.'value = \''.$autoupdate.'\';
INSERT INTO '.MAIN_DB_PREFIX.'const (name, entity, value, type) VALUES (\'INFRAS_PDF_VALID_CORE_CHGT\', \'__ENTITY__\', \''.$validcorechg.'\', \'chaine\')'.$onDuplicate.'value = \''.$validcorechg.'\';
';
			$listeCols		= array ('name', 'entity', 'value', 'type');
			$duplicate		= array ('2', 'value', 'name');
			fwrite($handle, InfraS_bkup_table ('const', $sql_const, $listeCols, $duplicate, 0, $add));
			// Enabling back the keys/index checking
			$sqlfooter		= '
ALTER TABLE '.MAIN_DB_PREFIX.'document_model ENABLE KEYS;
ALTER TABLE '.MAIN_DB_PREFIX.'const ENABLE KEYS;

UNLOCK TABLES;
SET FOREIGN_KEY_CHECKS = 1;

-- Dump completed on '.date('Y-m-d G-i-s').'
';
			fwrite($handle, $sqlfooter);
			fclose($handle);
			return 1;
		}	// if (file_exists($path))
	}	// function InfraS_bkup_module ($appliname, $origine = 1)

	/************************************************
	*	Recherche d'un fichier contenant un code langue dans son nom à partir d'une liste
	*
	*	@param	string	$table		table name to backup
	*	@param	string	$sql		sql query to prepare data  for backup
	*	@param	array	$listeCols	list of columns to backup on the table
	*	@param	array	$duplicate	values for 'ON DUPLICATE KEY UPDATE'
	*									[0] = column to update
	*									[1] = column name to update
	*									[2] = key value for conflict control (only postgreSQL)
	*	@param	boolean	$truncate	truncate the table before restore
	*	@param	string	$add		sql data to add on the beginning of the query
	*	@return	string				sql query to restore the datas
	************************************************/
	function InfraS_bkup_table ($table, $sql, $listeCols, $duplicate = array (), $truncate = 0, $add = '')
	{
		global $db, $conf, $langs, $errormsg;
		
		$sqlnewtable	= '';
		$result_sql		= $sql ? $db->query($sql) : '';
		if ($result_sql)
		{
			$truncate		= $truncate ? 'TRUNCATE TABLE '.MAIN_DB_PREFIX.$table.';
' : '';
			$sqlnewtable	= '
-- Dumping data for table '.MAIN_DB_PREFIX.$table.'
'.$truncate.$add;
			while($row	= $db->fetch_row($result_sql))
			{
				// For each row of data we print a line of INSERT
				$colsInsert						= '';
				foreach ($listeCols as $col)	$colsInsert	.= $col.', ';
				$sqlnewtable					.= 'INSERT INTO '.MAIN_DB_PREFIX.$table.' ('.substr($colsInsert, 0, -2).') VALUES (';
				$columns						= count($row);
				$duplicateValue					= '';
				for($j = 0; $j < $columns; $j++)
				{
					// Processing each columns of the row to ensure that we correctly save the value (eg: add quotes for string - in fact we add quotes for everything, it's easier)
					if ($row[$j] == null && !is_string($row[$j]))	$row[$j]	= 'NULL';	// IMPORTANT: if the field is NULL we set it NULL
					elseif(is_string($row[$j]) && $row[$j] == '')	$row[$j]	= '\'\'';	// if it's an empty string, we set it as an empty string
					else																	// else for all other cases we escape the value and put quotes around
					{
						$row[$j]	= addslashes($row[$j]);
						$row[$j]	= preg_replace('#\n#', '\\n', $row[$j]);
						$row[$j]	= '\''.$row[$j].'\'';
					}	// else	// elseif(is_string($row[$j]) && $row[$j] == '')	// if ($row[$j] == null && !is_string($row[$j]))
					if ($j == 1)	$row[$j]	= '\'__ENTITY__\'';
					$onDuplicate	= $db->type == 'pgsql' ? ' ON CONFLICT ('.$duplicate[2].') DO UPDATE SET ' : ' ON DUPLICATE KEY UPDATE ';
					$duplicateValue .= $j == $duplicate[0] ? $onDuplicate.$duplicate[1].' = '.$row[$j] : '';
				}	// for($j = 0; $j < $columns; $j++)
				$sqlnewtable	.= implode(', ', $row).')'.$duplicateValue.';
';
			}	// while($row = $db->fetch_row($result_dict))
		}	// if ($result_sql)
		return $sqlnewtable;
	}	// function InfraS_bkup_table ($table, $sql, $listeCols, $duplicate = array (), $truncate = 0, $add = '')
	
	/************************************************
	*	Conversion de fichier ttf en police TCPDF.
	*
	*	@param	String		$type			Font type. Leave empty for autodetect mode.
	*										Valid values are:
	*											TrueTypeUnicode
	*											TrueType
	*											Type1
	*											CID0JP	= CID-0	Japanese
	*											CID0KR	= CID-0	Korean
	*											CID0CS	= CID-0	Chinese Simplified
	*											CID0CT	= CID-0	Chinese Traditional
	*	@param  String		$enc     		Name of the encoding table to use.
	*										Leave empty for default mode. Omit this parameter for TrueType Unicode and symbolic font like Symbol or ZapfDingBats.
	*	@param  int	    	$flags   		Unsigned 32-bit integer containing flags specifying various characteristics of the font
	*										(PDF32000:2008 - 9.8.2 Font Descriptor Flags):
	*											+1 for fixed font;
	*											+4 for symbol;
	*											+32 for non-symbol;
	*											+64 for italic.
	*											Fixed and Italic mode are generally autodetected so you have to set it to 32 = non-symbolic font (default) or 4 = symbolic font.
	*	@param  String		$outpath		Output path for generated font files (must be writeable by the web server). Leave empty for default font folder.
	* 	@param	String		$platid			Platform ID for CMAP table to extract
	*										(when building a Unicode font for Windows this value should be 3, for Macintosh should be 1).
	* 	@param	Societe		$encid			Encoding ID for CMAP table to extract
	*										(when building a Unicode font for Windows this value should be 1, for Macintosh should be 0).
	*										When Platform ID is 3, legal values for Encoding ID are:
	*											0	= Symbol
	*											1	= Unicode
	*											2	= ShiftJIS
	*											3	= PRC
	*											4	= Big5
	*											5	= Wansung
	*											6	= Johab
	*											7	= Reserved
	*											8	= Reserved
	*											9	= Reserved
	*											10	= UCS-4
	* 	@param	Booleen		$addcbbox		Includes the character bounding box information on the php font file.
	* 	@param	Booleen		$link			Link to system font instead of copying the font data # (not transportable) - Note: do not work with Type1 font.
	* 	@param	String		$font			input font file.
	*	@return	String						Return Font name or false if error.
	************************************************/
	function InfraS_Add_TCPDF_Font ($type = '', $enc = '', $flags = 32, $outpath, $platid = 3, $encid = 1, $addcbbox = false, $link = false, $font)
	{
		require_once TCPDF_PATH.'tcpdf.php';
		
		$options									= array();
		$typefont									= array('TrueTypeUnicode', 'TrueType', 'Type1', 'CID0JP', 'CID0KR', 'CID0CS', 'CID0CT');
		if (in_array($type, $typefont))				$options['type']	= $type;
		else										$options['type']	= '';
		$options['enc']								= $enc;
		$options['flags']							= intval($flags);
		$options['outpath']							= realpath($outpath);
		if (substr($options['outpath'], -1) != '/')	$options['outpath']	.= '/';
		$options['platid']							= min(max(1, intval($platid)), 3);
		$options['encid']							= min(max(0, intval($encid)), 10);
		$options['addcbbox']						= $addcbbox;
		$options['link']							= $link;
		$fontfile									= realpath($font);
		$fontname									= TCPDF_FONTS::addTTFfont($fontfile, $options['type'], $options['enc'], $options['flags'], $options['outpath'], $options['platid'], $options['encid'], $options['addcbbox'], $options['link']);
		return $fontname;
	}	// function InfraS_Add_TCPDF_Font ($type = '', $enc = '', $flags = 32, $outpath, $platid = 3, $encid = 1, $addcbbox = false, $link = false, $font)

	/************************************************
	* Function called to check module name from local changelog
	* Control of the min version of Dolibarr needed and get versions list
	*
	* @param   string	$appliname	module name
	* @return	array				[0] current version from changelog
	*								[1] Dolibarr min version
	*								[2] flag for error (-1 = KO ; 0 = OK)
	*								[3] array => versions list or errors list
	************************************************/
	function InfraS_getLocalVersionMinDoli($appliname)
	{
		global $langs;

		$currentversion	= array();
		$sxe			= InfraS_getChangelogFile($appliname);
		if ($sxe === false)
		{
			$currentversion[0]						= '<font color=red><b>'.$langs->trans("ChangelogXMLError").'</b></font>';
			$currentversion[1]						= $langs->trans("noMinDolVersion");
			$currentversion[2]						= -1;
			foreach (libxml_get_errors() as $error)	$currentversion[3]	.= $error->message;
		}	// if ($sxe === false)
		else
		{
			$currentversion[0]	= $sxe->Version[count($sxe->Version) - 1]->attributes()->Number;
			$currentversion[1]	= $sxe->Dolibarr->attributes()->minVersion;
			$currentversion[2]	= 0;
			$currentversion[3]	= $sxe->Version;
		}	// else	// if ($sxe === false)
		return $currentversion;
	}	// function InfraS_getLocalVersionMinDoli($appliname)

	/************************************************
	 * Function called to check module name from local changelog
	 * Control of the min version of Dolibarr needed and get versions list
	 *
	 * @param   string	$appliname	module name
	 * @return	string				changelog file contents
	************************************************/
	function InfraS_getChangelogFile($appliname)
	{
		libxml_use_internal_errors(true);
		$context	= stream_context_create(array('http' => array('header' => 'Accept: application/xml')));
		$changelog	= @file_get_contents(dol_buildpath($appliname, 0).'/docs/changelog.xml', false, $context);
		$sxe		= @simplexml_load_string(nl2br ($changelog));
		return $sxe;
	}	// function InfraS_getChangelogFile($appliname)

	/************************************************
	 * Function called to get downloaded changelog and compare with the local one
	 * Presentation of results on a HTML table
	 *
	 * @param   string	$appliname		module name
	 * @param   string	$resVersion		flag for error (-1 = KO ; 0 = OK)
	 * @param   string	$tblversions	array => versions list or errors list
	 * @return	string					HTML presentation
	************************************************/
	function InfraS_getChangeLog($appliname, $resVersion, $tblversions)
	{
		global $langs;
				
		$headerPath	= dol_buildpath('/'.$appliname.'/img/InfraSheader.png', 1);
		$logoPath	= dol_buildpath('/'.$appliname.'/img/InfraS.gif', 1);
		$gplv3Path	= dol_buildpath('/'.$appliname.'/img/gplv3.png', 1);
		$listUpD	= dol_buildpath('/'.$appliname.'/img/list_updates.png', 1);
		$urlInfraS	= 'https://www.infras.fr';
		$urldownl	= '/index.php?option=com_content&view=featured&Itemid=161';
		$urldocs	= '/index.php?option=com_jdownloads&view=category&catid=11&Itemid=116';
		$urlDoli	= 'http://www.dolistore.com/search.php?search_query=InfraS';
		$style		= 'color: white; font-size: 16px; font-weight: bold; width: 30%;';
		$InputCarac	= 'class = "butActionChangelog" name = "readmore" type = "button"';
		$ret		= array();
		$ret		= $langs->trans("InfraSParamPresent");
		$ret		.= '<br />';
		$ret		.= '<table  width = "100%" cellspacing = "10" style = "background: url('.$headerPath.'); background-size: cover;">';
		$ret		.= '	<tr>';
		$ret		.= '		<td rowspan = "3" align = "left" valign = "bottom" style="'.$style.'">';
		$ret		.= '			<a href = "'.$urlInfraS.'" target = "_blank"><img border = "0" width = "220" src = "'.$logoPath.'"></a>';
		$ret		.= '			<br/>&nbsp;&nbsp;'.$langs->trans("InfraSParamSlogan");
		$ret		.= '		</td>';
		$ret		.= '		<td align = "center" valign = "middle" width = "30%">';
		$ret		.= '			<a href = "'.$urlInfraS.$urldownl.'" target = "_blank"><input '.$InputCarac.' value = "'.$langs->trans("InfraSParamLienModules").'" /></a>';
		$ret		.= '		</td>';
		$ret		.= '		<td rowspan = "3" align = "center" valign = "middle" width = "30%">';
		$ret		.= '			<a href = "'.$urlDoli.'" target = "_blank"><img border = "0" width = "180" src = "'.DOL_URL_ROOT.'/theme/dolistore_logo.png"></a>';
		$ret		.= '			<br />'.$langs->trans("InfraSParamMoreModulesLink");
		$ret		.= '		</td>';
		$ret		.= '	</tr>';
		$ret		.= '	<tr>';
		$ret		.= '		<td align = "center" valign = "middle">';
		$ret		.= '			<a href = "'.$urlInfraS.$urldocs.'" target = "_blank"><input '.$InputCarac.' value = "'.$langs->trans("InfraSParamLienDocs").'" /></a>';
		$ret		.= '		</td>';
		$ret		.= '	</tr>';
		$ret		.= '	<tr>';
		$ret		.= '		<td align = "center" valign = "middle">';
		$ret		.= '			<img border="0" width="120" src="'.$gplv3Path.'"/>';
		$ret		.= '			<br />'.$langs->trans("InfraSParamLicense");
		$ret		.= '		</td>';
		$ret		.= '	</tr>';
		$ret		.= '</table>';
		$ret		.= load_fiche_titre($langs->trans("InfraSParamHistoryUpdates"), '', $listUpD, 1);
		if (is_file(dol_buildpath($appliname, 0).'/docs/changelogdwn.xml'))	$lastchangelog		= @file_get_contents(dol_buildpath($appliname, 0).'/docs/changelogdwn.xml');
		if ($lastchangelog === FALSE)										$tblversionslast	= array();	// not find
		else
		{
			$sxelast				= simplexml_load_string(nl2br ($lastchangelog));
			if ($sxelast === false)	$tblversionslast	= array();
			else					$tblversionslast	= $sxelast->Version;
		}	// else	// if( $lastchangelog === FALSE)
		$sxe					= InfraS_getChangelogFile($appliname);
		if ($resVersion == -1)	foreach ($tblversions as $error)	$ret	.= $error->message;
		$ret	.= '<table class="noborder" >';
		$ret	.= '	<tr class="liste_titre">';
		$ret	.= '		<th align=center width=100px>'.$langs->trans("InfraSParamNumberVersion").'</th>';
		$ret	.= '		<th align=center width=100px>'.$langs->trans("InfraSParamMonthVersion").'</th>';
		$ret	.= '		<th align=left >'.$langs->trans("InfraSParamChangesVersion").'</th>';
		$ret	.= '	</tr>';
		if (count($tblversionslast) > count($tblversions))	// il y a du nouveau
		{
			for ($i = count($tblversionslast)-1; $i >=0; $i--)
			{
				$color					= "";
				$sxePath				= $sxe->xpath('//Version[@Number="'.$tblversionslast[$i]->attributes()->Number.'"]');
				if (empty($sxePath))	$color='bgcolor=orange';
				$ret	.= '<tr class="oddeven">';
				$ret	.= '		<td align=center '.$color.' valign=top>'.$tblversionslast[$i]->attributes()->Number.'</td>';
				$ret	.= '		<td align=center '.$color.' valign=top>'.$tblversionslast[$i]->attributes()->MonthVersion.'</td>' ;
				$lineversion						= $tblversionslast[$i]->change;
				$ret	.= '		<td align=left '.$color.' valign=top style="padding-top: 0; padding-bottom: 0;">';
				foreach ($lineversion as $changeline)
				{
					if ($changeline->attributes()->type == "fix")		$stylecolor	= ' color: red;';
					else if ($changeline->attributes()->type == "add")	$stylecolor	= ' color: green;';
					else if ($changeline->attributes()->type == "chg")	$stylecolor	= ' color: blue;';
					else												$stylecolor	= ' color: black;';
					$ret	.= '<table>';
					$ret	.= '	<tr>';
					$ret	.= '		<td width = 50px style = "border: none; padding-top: 0; padding-bottom: 0;'.$stylecolor.'">'.$changeline->attributes()->type.'</td>';
					$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;'.$stylecolor.'">'.$changeline.'</td>';
					$ret	.= '	</tr>';
					$ret	.= '</table>';
				}	// foreach ($lineversion as $changeline)
				$ret	.= '		</td>';
				$ret	.= '	</tr>';
			}	// for ($i = count($tblversionslast)-1; $i >=0; $i--)
		}	// if (count($tblversionslast) > count($tblversions))
		elseif (count($tblversionslast) < count($tblversions) && count($tblversionslast) > 0)
		{
			for ($i = count($tblversions)-1; $i >=0; $i--)
			{
				$color						= "";
				$sxelastPath				= $sxelast->xpath('//Version[@Number="'.$tblversions[$i]->attributes()->Number.'"]');
				if (empty($sxelastPath))	$color='bgcolor=lightgreen';
				$ret	.= '<tr class="oddeven">';
				$ret	.= '		<td align=center '.$color.' valign=top>'.$tblversions[$i]->attributes()->Number.'</td>';
				$ret	.= '		<td align=center '.$color.' valign=top>'.$tblversions[$i]->attributes()->MonthVersion.'</td>' ;
				$lineversion						= $tblversions[$i]->change;
				$ret	.= '		<td align=left '.$color.' valign=top style="padding-top: 0; padding-bottom: 0;">';
				foreach ($lineversion as $changeline)
				{
					if ($changeline->attributes()->type == "fix")		$stylecolor	= ' color: red;';
					else if ($changeline->attributes()->type == "add")	$stylecolor	= ' color: green;';
					else if ($changeline->attributes()->type == "chg")	$stylecolor	= ' color: blue;';
					else												$stylecolor	= ' color: black;';
					$ret	.= '<table>';
					$ret	.= '	<tr>';
					$ret	.= '		<td width = 50px style = "border: none; padding-top: 0; padding-bottom: 0;'.$stylecolor.'">'.$changeline->attributes()->type.'</td>';
					$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;'.$stylecolor.'">'.$changeline.'</td>';
					$ret	.= '	</tr>';
					$ret	.= '</table>';
				}	// foreach ($lineversion as $changeline)
				$ret	.= '		</td>';
				$ret	.= '	</tr>';
			}	// for ($i = count($tblversions)-1; $i >=0; $i--)
		}	// elseif (count($tblversionslast) < count($tblversions) && count($tblversionslast) > 0)
		else	//on est à jour des versions ou pas de connection internet 
		{
			for ($i = count($tblversions)-1; $i >=0; $i--)
			{
				$color			= "";
				$ret			.= '<tr class="oddeven">';
				$ret			.= '	<td align=center valign=top>'.$tblversions[$i]->attributes()->Number.'</td>';
				$ret			.= '	<td align=center valign=top>'.$tblversions[$i]->attributes()->MonthVersion.'</td>' ;
				$lineversion	= $tblversions[$i]->change;
				$ret			.= '	<td align=left '.$color.' valign=top style="padding-top: 0; padding-bottom: 0;">';
				foreach ($lineversion as $changeline)
				{
					if ($changeline->attributes()->type == "fix")		$stylecolor	= ' color: red;';
					else if ($changeline->attributes()->type == "add")	$stylecolor	= ' color: green;';
					else if ($changeline->attributes()->type == "chg")	$stylecolor	= ' color: blue;';
					else												$stylecolor	= ' color: black;';
					$ret	.= '<table>';
					$ret	.= '	<tr>';
					$ret	.= '		<td width = 50px style = "border: none; padding-top: 0; padding-bottom: 0;'.$stylecolor.'">'.$changeline->attributes()->type.'</td>';
					$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;'.$stylecolor.'">'.$changeline.'</td>';
					$ret	.= '	</tr>';
					$ret	.= '</table>';
				}	// foreach ($lineversion as $changeline)
				$ret	.= '		</td>';
				$ret	.= '	</tr>';
			}	// for ($i = count($tblversions)-1; $i >=0; $i--)
		}	// else	// elseif	// if (count($tblversionslast) > count($tblversions))
		$ret	.= '</table>';
		return $ret;
	}	// function InfraS_getChangeLog($appliname)

	/************************************************
	 * Function called to get support information
	 * Presentation of results on a HTML table
	 *
	 * @param   string	$currentversion	current version from changelog
	 * @return	string					HTML presentation
	************************************************/
	function InfraS_getSupportInformation($currentversion)
	{
		global $db, $langs;
		
		$ret	.= '<table class="noborder" >';
		$ret	.= '	<tr class="liste_titre">';
		$ret	.= '		<th align=center width=200px>'.$langs->trans("InfraSSupportInformation").'</th>';
		$ret	.= '		<th align=center>'.$langs->trans("Value").'</th>';
		$ret	.= '	</tr>';
		$ret	.= '<tr class="oddeven">';
		$ret	.= '		<td width = 20opx style = "border: none; padding-top: 0; padding-bottom: 0;">'.$langs->trans("DolibarrVersion").'</td>';
		$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;">'.DOL_VERSION.'</td>';
		$ret	.= '	</tr>';
		$ret	.= '<tr class="oddeven">';
		$ret	.= '		<td width = 20opx style = "border: none; padding-top: 0; padding-bottom: 0;">'.$langs->trans("ModuleVersion").'</td>';
		$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;">'.$currentversion.'</td>';
		$ret	.= '	</tr>';
		$ret	.= '<tr class="oddeven">';
		$ret	.= '		<td width = 20opx style = "border: none; padding-top: 0; padding-bottom: 0;">'.$langs->trans("PHPVersion").'</td>';
		$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;">'.version_php().'</td>';
		$ret	.= '	</tr>';
		$ret	.= '<tr class="oddeven">';
		$ret	.= '		<td width = 20opx style = "border: none; padding-top: 0; padding-bottom: 0;">'.$langs->trans("DatabaseVersion").'</td>';
		$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;">'.$db::LABEL." ".$db->getVersion().'</td>';
		$ret	.= '	</tr>';
		$ret	.= '<tr class="oddeven">';
		$ret	.= '		<td width = 20opx style = "border: none; padding-top: 0; padding-bottom: 0;">'.$langs->trans("WebServerVersion").'</td>';
		$ret	.= '		<td style = "border: none; padding-top: 0; padding-bottom: 0;">'.$_SERVER["SERVER_SOFTWARE"].'</td>';
		$ret	.= '	</tr>';
		$ret	.= '</table>';
		$ret	.= '<br />';
		return $ret;
	}	// function InfraS_getSupportInformation($currentversion)

	/************************************************
	*	Changes permissions on files and directories within $dir and dives recursively into found subdirectories.
	*
	*	@param	string	$dir		Preselected type
	*	@param  string	$filePerm	The permissions any found files should get.
	* 	@param	int		$dirPerm	The permissions any found folder should get.
	* 	@param	string	$own		The owner any found file or folder should get.
	* 	@param	string	$grp		The group any found file or folder should get.
	*	@return	boolean				 TRUE if the path if found and FALSE if not.
	************************************************/
	function InfraS_chmod_r($path, $filePerm = '0644', $dirPerm = '0755', $own = 'www-data', $grp = 'www-data')
	{
		if (!file_exists($path))	return(false);	// Check if the path exists
        // See whether this is a file
		if (is_file($path))
		{
			@chmod($path, octdec($filePerm));	// Chmod the file with our given filepermissions
			@chgrp($path, $grp);				// Chgrp the file with our given group
			@chown($path, $own);				// Chown the file with our given owner
		}	// if (is_file($path))
		elseif (is_dir($path))	// If this is a directory...
		{
			$foldersAndFiles				= scandir($path);	// Then get an array of the contents
			$entries						= array_slice($foldersAndFiles, 2);	// Remove "." and ".." from the list
			foreach ($entries as $entry)	InfraS_chmod_r($path.'/'.$entry, $filePerm, $dirPerm, $own, $grp);	// Parse every result... And call this function again recursively, with the same permissions
			@chmod($path, octdec($dirPerm));	// When we are done with the contents of the directory, we chmod the directory itself
			@chgrp($path, $grp);				// When we are done with the contents of the directory, we chgrp the directory itself
			@chown($path, $own);				// When we are done with the contents of the directory, we chown the directory itself
		}	// elseif (is_dir($path))
		return(true);	// Everything seemed to work out well, return true
	}	// function InfraS_chmod_r($path, $filePerm = '0644', $dirPerm = '0755', $own = 'www-data', $grp = 'www-data')
	
	/************************************************
	*	Converts shorthand memory notation value to bytes
	*	From http://php.net/manual/en/function.ini-get.php
	*
	*	@param  string	$val	Memory size shorthand notation
	*	@return	string			value .
	************************************************/
	function InfraS_return_bytes($val)
	{
		$val	= trim($val);
		$last	= strtolower($val[strlen($val)-1]);
		switch($last)
		{
			case 'g':
				$val *= 1024;
			case 'm':
				$val *= 1024;
			case 'k':
				$val *= 1024;
		}	// switch($last)
		return $val;
	}	// function InfraS_return_bytes($val)
?>