<?php
	/************************************************
	* Copyright (C) 2016-2018	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		htdocs/custom/infras/core/modules/commande/doc/pdf_InfraS_commande.modules.php
	* 	\ingroup	InfraS
	* 	\brief		Class file for InfraS PDF command
	************************************************/

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/modules/commande/modules_commande.php';
	require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	dol_include_once('/infraspack/core/lib/infras.pdf.lib.php');

	/************************************************
	*	Class to generate PDF order InfraS
	************************************************/
	class pdf_InfraS_commande extends ModelePDFCommandes
	{
		public $db;
		public $name;
		public $description;
		public $update_main_doc_field;	// Save the name of generated file as the main doc when generating a doc with this template
		public $type;
		public $phpmin	= array(5, 4);
		public $version	= 'dolibarr';
		public $page_largeur;
		public $page_hauteur;
		public $format;
		public $marge_gauche;
		public $marge_droite;
		public $marge_haute;
		public $marge_basse;
		public $emetteur;

		/********************************************
		*	Constructor
		*
		*	@param		DoliDB		$db      Database handler
		********************************************/
		function __construct($db)
		{
			global $conf, $langs, $mysoc;

			if((float)DOL_VERSION >= 8.0)	$langs->loadLangs(array("main", "dict", "bills", "products", "companies", "orders", "infraspack@infraspack"));
			else
			{
				$langs->load("main");
				$langs->load("dict");
				$langs->load("bills");
				$langs->load("products");
				$langs->load("companies");
				$langs->load("orders");
				$langs->load("infraspack@infraspack");
			}	// else	// if((float)DOL_VERSION >= 8.0)
			
			$this->db									= $db;
			$this->name									= $langs->trans('PDFInfraSOrderName');
			$this->description							= $langs->trans('PDFInfraSOrderDescription');
			$this->update_main_doc_field				= 1;	// Save the name of generated file as the main doc when generating a doc with this template
			$this->type									= 'pdf';
			$formatarray								= pdf_InfraS_getFormat();
			$this->page_largeur							= $formatarray['width'];
			$this->page_hauteur							= $formatarray['height'];
			$this->format								= array($this->page_largeur, $this->page_hauteur);
			$this->marge_gauche							= isset($conf->global->MAIN_PDF_MARGIN_LEFT)					? $conf->global->MAIN_PDF_MARGIN_LEFT : 10;
			$this->marge_droite							= isset($conf->global->MAIN_PDF_MARGIN_RIGHT)					? $conf->global->MAIN_PDF_MARGIN_RIGHT : 10;
			$this->marge_haute							= isset($conf->global->MAIN_PDF_MARGIN_TOP)						? $conf->global->MAIN_PDF_MARGIN_TOP : 10;
			$this->marge_basse							= isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)					? $conf->global->MAIN_PDF_MARGIN_BOTTOM : 10;
			$this->font									= isset($conf->global->INFRAS_PDF_FONT)							? $conf->global->INFRAS_PDF_FONT : 'Helvetica';
			$this->use_fpdf								= isset($conf->global->MAIN_USE_FPDF)							? $conf->global->MAIN_USE_FPDF : 0;
			$this->disable_fpdi							= isset($conf->global->MAIN_DISABLE_FPDI)						? $conf->global->MAIN_DISABLE_FPDI : 0;
			$this->add_pdf_bg							= isset($conf->global->MAIN_ADD_PDF_BACKGROUND)					? $conf->global->MAIN_ADD_PDF_BACKGROUND : 0;
			$this->Rounded_rect							= isset($conf->global->INFRAS_PDF_ROUNDED_REC)					? $conf->global->INFRAS_PDF_ROUNDED_REC : 0;
			$this->atleastonediscount					= 0;
			$this->tva									= array();
			$this->localtax1							= array();
			$this->localtax2							= array();
			$this->atleastoneratenotnull				= 0;
			$this->with_picture							= isset($conf->global->INFRAS_PDF_WITH_PICTURE)					? $conf->global->INFRAS_PDF_WITH_PICTURE : 0;
			$this->old_path_photo						= isset($conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO)			? $conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO : 0;
			$this->cat_hq_image							= isset($conf->global->CAT_HIGH_QUALITY_IMAGES)					? $conf->global->CAT_HIGH_QUALITY_IMAGES : 0;
			$this->larg_ref								= isset($conf->global->INFRAS_PDF_LARGCOL_REF)					? $conf->global->INFRAS_PDF_LARGCOL_REF : 28;
			$this->larg_qty								= isset($conf->global->INFRAS_PDF_LARGCOL_QTY)					? $conf->global->INFRAS_PDF_LARGCOL_QTY : 10;
			$this->larg_unit							= isset($conf->global->INFRAS_PDF_LARGCOL_UNIT)					? $conf->global->INFRAS_PDF_LARGCOL_UNIT : 10;
			$this->larg_up								= isset($conf->global->INFRAS_PDF_LARGCOL_UP)					? $conf->global->INFRAS_PDF_LARGCOL_UP : 22;
			$this->larg_tva								= isset($conf->global->INFRAS_PDF_LARGCOL_TVA)					? $conf->global->INFRAS_PDF_LARGCOL_TVA : 14;
			$this->larg_discount						= isset($conf->global->INFRAS_PDF_LARGCOL_DISC)					? $conf->global->INFRAS_PDF_LARGCOL_DISC : 14;
			$this->larg_updisc							= isset($conf->global->INFRAS_PDF_LARGCOL_UPD)					? $conf->global->INFRAS_PDF_LARGCOL_UPD : 22;
			$this->larg_progress						= isset($conf->global->INFRAS_PDF_LARGCOL_PROGRESS)				? $conf->global->INFRAS_PDF_LARGCOL_PROGRESS : 10;
			$this->larg_totalht							= isset($conf->global->INFRAS_PDF_LARGCOL_TOTAL)				? $conf->global->INFRAS_PDF_LARGCOL_TOTAL : 24;
			$this->num_ref								= isset($conf->global->INFRAS_PDF_NUMCOL_REF)					? $conf->global->INFRAS_PDF_NUMCOL_REF : 1;
			$this->num_desc								= isset($conf->global->INFRAS_PDF_NUMCOL_DESC)					? $conf->global->INFRAS_PDF_NUMCOL_DESC : 2;
			$this->num_qty								= isset($conf->global->INFRAS_PDF_NUMCOL_QTY)					? $conf->global->INFRAS_PDF_NUMCOL_QTY : 3;
			$this->num_unit								= isset($conf->global->INFRAS_PDF_NUMCOL_UNIT)					? $conf->global->INFRAS_PDF_NUMCOL_UNIT : 4;
			$this->num_up								= isset($conf->global->INFRAS_PDF_NUMCOL_UP)					? $conf->global->INFRAS_PDF_NUMCOL_UP : 5;
			$this->num_tva								= isset($conf->global->INFRAS_PDF_NUMCOL_TVA)					? $conf->global->INFRAS_PDF_NUMCOL_TVA : 6;
			$this->num_discount							= isset($conf->global->INFRAS_PDF_NUMCOL_DISC)					? $conf->global->INFRAS_PDF_NUMCOL_DISC : 7;
			$this->num_updisc							= isset($conf->global->INFRAS_PDF_NUMCOL_UPD)					? $conf->global->INFRAS_PDF_NUMCOL_UPD : 8;
			$this->num_progress							= isset($conf->global->INFRAS_PDF_NUMCOL_PROGRESS)				? $conf->global->INFRAS_PDF_NUMCOL_PROGRESS : 9;
			$this->num_totalht							= isset($conf->global->INFRAS_PDF_NUMCOL_TOTAL)					? $conf->global->INFRAS_PDF_NUMCOL_TOTAL : 10;
			$this->hide_discount						= isset($conf->global->INFRAS_PDF_HIDE_DISCOUNT)				? $conf->global->INFRAS_PDF_HIDE_DISCOUNT : 0;
			$this->product_use_unit						= isset($conf->global->PRODUCT_USE_UNITS)						? $conf->global->PRODUCT_USE_UNITS : 0;
			$this->hide_up								= isset($conf->global->INFRAS_PDF_HIDE_UP)						? $conf->global->INFRAS_PDF_HIDE_UP : 0;
			$this->show_up_discounted					= isset($conf->global->INFRAS_PDF_SHOW_UP_DISCOUNTED)			? $conf->global->INFRAS_PDF_SHOW_UP_DISCOUNTED : 0;
			$this->hide_vat								= isset($conf->global->INFRAS_PDF_WITHOUT_VAT)					? $conf->global->INFRAS_PDF_WITHOUT_VAT : 0;
			$this->show_ttc_vat_tot						= isset($conf->global->INFRAS_PDF_TTC_WITH_VAT_TOT)				? $conf->global->INFRAS_PDF_TTC_WITH_VAT_TOT : 0;
			if ($this->show_ttc_vat_tot)				$this->hide_vat													= $this->show_ttc_vat_tot;
			$this->hide_vat_col							= isset($conf->global->INFRAS_PDF_WITHOUT_VAT_COLUMN)			? $conf->global->INFRAS_PDF_WITHOUT_VAT_COLUMN : 0;
			$this->show_ref_col							= isset($conf->global->INFRAS_PDF_WITH_REF_COLUMN)				? $conf->global->INFRAS_PDF_WITH_REF_COLUMN : 0;
			$this->small_head2							= isset($conf->global->INFRAS_PDF_SMALL_HEAD_2)					? $conf->global->INFRAS_PDF_SMALL_HEAD_2 : 0;
			$this->emetteur								= $mysoc;
			if (empty($this->emetteur->country_code))	$this->emetteur->country_code									= substr($langs->defaultlang, -2);
			$this->show_sign_area						= isset($conf->global->INFRAS_PDF_COMMANDE_SHOW_SIGNATURE)		? $conf->global->INFRAS_PDF_COMMANDE_SHOW_SIGNATURE : 1;
			$this->formatpage							= array('largeur'=>$this->page_largeur, 'hauteur'=>$this->page_hauteur, 'mgauche'=>$this->marge_gauche, 
																'mdroite'=>$this->marge_droite, 'mhaute'=>$this->marge_haute, 'mbasse'=>$this->marge_basse);
			$this->add_sale_rep_sign_note				= isset($conf->global->MAIN_ADD_SALE_REP_SIGNATURE_IN_NOTE)		? $conf->global->MAIN_ADD_SALE_REP_SIGNATURE_IN_NOTE : 0;
			$this->wpicture								= isset($conf->global->INFRAS_PDF_PICTURE_WIDTH)				? $conf->global->INFRAS_PDF_PICTURE_WIDTH : 20;
			$this->hpicture								= isset($conf->global->INFRAS_PDF_PICTURE_HEIGHT)				? $conf->global->INFRAS_PDF_PICTURE_HEIGHT : 32;
			$this->dash_between_line					= isset($conf->global->MAIN_PDF_DASH_BETWEEN_LINES)				? $conf->global->MAIN_PDF_DASH_BETWEEN_LINES : 1;
			$this->hide_top_table						= isset($conf->global->INFRAS_PDF_HIDE_TOP_TABLE)				? $conf->global->INFRAS_PDF_HIDE_TOP_TABLE : 0;
			$this->CGV									= isset($conf->global->INFRAS_PDF_CGV)							? $conf->global->INFRAS_PDF_CGV : '';
			$this->multilangs							= isset($conf->global->MAIN_MULTILANGS)							? $conf->global->MAIN_MULTILANGS : 0;
			$this->main_umask							= isset($conf->global->MAIN_UMASK)								? $conf->global->MAIN_UMASK : '0755';
			$this->show_first_sales_rep					= isset($conf->global->DOC_SHOW_FIRST_SALES_REP)				? $conf->global->DOC_SHOW_FIRST_SALES_REP : 0;
			$this->use_comp_name_contact				= isset($conf->global->MAIN_USE_COMPANY_NAME_OF_CONTACT)		? $conf->global->MAIN_USE_COMPANY_NAME_OF_CONTACT : 0;
			$this->includealias							= isset($conf->global->PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME)	? $conf->global->PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME : 0;
			$this->use_iso_location						= isset($conf->global->MAIN_PDF_USE_ISO_LOCATION)				? $conf->global->MAIN_PDF_USE_ISO_LOCATION : 0;
			$this->show_recep_details					= isset($conf->global->INFRAS_PDF_SHOW_RECEP_DETAILS)			? $conf->global->INFRAS_PDF_SHOW_RECEP_DETAILS : 0;
			$this->invert_sender_recipient				= isset($conf->global->MAIN_INVERT_SENDER_RECIPIENT)			? $conf->global->MAIN_INVERT_SENDER_RECIPIENT : 0;
			$this->hide_recep_frame						= isset($conf->global->INFRAS_PDF_HIDE_RECEP_FRAME)				? $conf->global->INFRAS_PDF_HIDE_RECEP_FRAME : 0;
			$this->bg_color								= isset($conf->global->INFRAS_PDF_BACKGROUND_COLOR)				? $conf->global->INFRAS_PDF_BACKGROUND_COLOR : '';
			$this->title_bg								= isset($conf->global->INFRAS_PDF_TITLE_BG)						? $conf->global->INFRAS_PDF_TITLE_BG : 0;
			$this->watermark_i_opacity					= isset($conf->global->INFRAS_PDF_I_WATERMARK_OPACITY)			? $conf->global->INFRAS_PDF_I_WATERMARK_OPACITY : 1;
			$this->image_watermark						= isset($conf->global->INFRAS_PDF_IMAGE_WATERMARK)				? $conf->global->INFRAS_PDF_IMAGE_WATERMARK : '';
			$this->watermark_t_opacity					= isset($conf->global->INFRAS_PDF_T_WATERMARK_OPACITY)			? $conf->global->INFRAS_PDF_T_WATERMARK_OPACITY : 10;
			$this->draft_watermark						= isset($conf->global->COMMANDE_DRAFT_WATERMARK)				? $conf->global->COMMANDE_DRAFT_WATERMARK : '';
			$this->fold_mark							= isset($conf->global->INFRAS_PDF_FOLD_MARK)					? $conf->global->INFRAS_PDF_FOLD_MARK : 0;
			$this->txtcolor								= explode(',', pdf_InfraS_txt_color($this->bg_color));
			$this->alpha								= 0.2;
			$this->franchise							= !$this->emetteur->tva_assuj;
			if ($this->franchise)						$this->hide_vat													= $this->franchise;
			$this->chq_num								= isset($conf->global->FACTURE_CHQ_NUMBER)						? $conf->global->FACTURE_CHQ_NUMBER : 0;
			$this->diffsize_title						= isset($conf->global->PDF_DIFFSIZE_TITLE)						? $conf->global->PDF_DIFFSIZE_TITLE : 0;
			$this->hidechq_address						= isset($conf->global->MAIN_PDF_HIDE_CHQ_ADDRESS)				? $conf->global->MAIN_PDF_HIDE_CHQ_ADDRESS : 0;
			$this->rib_num								= isset($conf->global->FACTURE_RIB_NUMBER)						? $conf->global->FACTURE_RIB_NUMBER : 0;
			$this->show_tot_local_cur					= isset($conf->global->INFRAS_PDF_SHOW_TOTAL_LOCAL_CUR)			? $conf->global->INFRAS_PDF_SHOW_TOTAL_LOCAL_CUR : 0;
			$this->number_words							= isset($conf->global->INFRAS_PDF_NUMBER_WORDS)					? $conf->global->INFRAS_PDF_NUMBER_WORDS : 0;
			$this->ht_signarea							= isset($conf->global->INFRAS_PDF_HT_SIGN_AREA)					? $conf->global->INFRAS_PDF_HT_SIGN_AREA : 24;
			$this->type_foot							= isset($conf->global->INFRAS_PDF_TYPE_FOOT)					? $conf->global->INFRAS_PDF_TYPE_FOOT : 0;
			$this->wpicturefoot							= isset($conf->global->INFRAS_PDF_PICTURE_FOOT_WIDTH)			? $conf->global->INFRAS_PDF_PICTURE_FOOT_WIDTH : 188;
			$this->hpicturefoot							= isset($conf->global->INFRAS_PDF_PICTURE_FOOT_HEIGHT)			? $conf->global->INFRAS_PDF_PICTURE_FOOT_HEIGHT : 12;
			$this->maxsizeimgfoot						= array('largeur'=>$this->wpicturefoot, 'hauteur'=>$this->hpicturefoot);
			$this->hidepagenum							= isset($conf->global->INFRAS_PDF_HIDE_PAGE_NUM)				? $conf->global->INFRAS_PDF_HIDE_PAGE_NUM : 0;
			$this->showadrlivr							= isset($conf->global->INFRAS_PDF_SHOW_ADRESSE_RECEPTION)		? $conf->global->INFRAS_PDF_SHOW_ADRESSE_RECEPTION : 0;
			$this->option_logo							= 1;	// Affiche logo
			$this->option_tva							= 1;	// Gere option tva FACTURE_TVAOPTION
			$this->option_modereg						= 1;	// Affiche mode reglement
			$this->option_condreg						= 1;	// Affiche conditions reglement
			$this->option_codeproduitservice			= 1;	// Affiche code produit-service
			$this->option_multilang						= 1;	// Dispo en plusieurs langues
			$this->option_escompte						= 0;	// Affiche si il y a eu escompte
			$this->option_credit_note					= 0;	// Support credit notes
			$this->option_freetext						= 1;	// Support add of a personalised text
			$this->option_draft_watermark				= 1;	// Support add of a watermark on drafts
			$this->tva									= array();
			$this->localtax1							= array();
			$this->localtax2							= array();
		}	// function __construct($db)

		/********************************************
		*	Function to build pdf onto disk
		*
		*	@param		Object		$object				Object to generate
		*	@param		Translate	$outputlangs		Lang output object
		*	@param		string		$srctemplatepath	Full path of source filename for generator using a template file
		*	@param		int			$hidedetails		Do not show line details (inutilisée ! laissé pour la compatibilité)
		*	@param		int			$hidedesc			Do not show desc
		*	@param		int			$hideref			Do not show ref
		*	@return     int             				1=OK, 0=KO
		********************************************/
		function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)
		{
			global $user, $langs, $conf, $db, $hookmanager, $nblignes;

			if (! is_object($outputlangs))	$outputlangs					= $langs;
			// For backward compatibility with FPDF, force output charset to ISO, because FPDF expect text to be encoded in ISO
			if (! empty($this->use_fpdf))	$outputlangs->charset_output	= 'ISO-8859-1';
			
			if((float)DOL_VERSION >= 8.0)	$outputlangs->loadLangs(array("main", "dict", "bills", "products", "companies", "orders", "deliveries", "infraspack@infraspack"));
			else
			{
				$outputlangs->load("main");
				$outputlangs->load("dict");
				$outputlangs->load("bills");
				$outputlangs->load("products");
				$outputlangs->load("companies");
				$outputlangs->load("orders");
				$outputlangs->load("deliveries");
				$outputlangs->load("infraspack@infraspack");
			}	// else	// if((float)DOL_VERSION >= 8.0)

			if ($conf->commande->dir_output)
			{
				$object->fetch_thirdparty();
				// Definition of $dir and $file
				if ($object->specimen)
				{
					$dir	= $conf->commande->dir_output;
					$file	= $dir."/SPECIMEN.pdf";
				}	// if ($object->specimen)
				else
				{
					$objectref	= dol_sanitizeFileName($object->ref);
					$dir		= $conf->commande->dir_output."/".$objectref;
					$file		= $dir."/".$objectref.".pdf";
				}	// else	// if ($object->specimen)
				if (! file_exists($dir))
				{
					if (dol_mkdir($dir) < 0)
					{
						$this->error=$langs->transnoentities("ErrorCanNotCreateDir", $dir);
						return 0;
					}	// if (dol_mkdir($dir) < 0)
				}	// if (! file_exists($dir))
				if (file_exists($dir))
				{
					if (! is_object($hookmanager))	// Add pdfgeneration hook
					{
						include_once DOL_DOCUMENT_ROOT.'/core/class/hookmanager.class.php';
						$hookmanager	= new HookManager($this->db);
					}	// if (! is_object($hookmanager))
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters							= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook							= $hookmanager->executeHooks('beforePDFCreation', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
					$this->adrlivr						= $hookmanager->resArray['adrlivr'];
					$this->pied							= $hookmanager->resArray['pied'];
					$this->hide_cols					= $hookmanager->resArray['hidecols'];
					$this->chkCGV						= $hookmanager->resArray['chkCGV'];
					$nblignes							= count($object->lines);	// Set nblignes with the new facture lines content after hook
					if (! empty($this->show_ref_col))	$hideref = 1;	// Comme on affiche une colonne 'Référence' on s'assure de ne pas répéter l'information
					// Create pdf instance
					$pdf								= pdf_getInstance($this->format);
					$default_font_size					= pdf_getPDFFontSize($outputlangs);																								// Must be after pdf_getInstance
					$pdf->SetAutoPageBreak(1, 0);
					if (class_exists('TCPDF'))
					{
						$pdf->setPrintHeader(false);
						$pdf->setPrintFooter(false);
					}	// if (class_exists('TCPDF'))
					$pdf->SetFont($this->font);
					// Set path to the background PDF File
					if ((empty($this->disable_fpdi) || (float)DOL_VERSION >= 8.0) && ! empty($this->add_pdf_bg))
					{
						$pagecount	= $pdf->setSourceFile($conf->mycompany->dir_output.'/'.$this->add_pdf_bg);
						$tplidx		= $pdf->importPage(1);
					}	// if ((empty($this->disable_fpdi) || (float)DOL_VERSION >= 8.0) && ! empty($this->add_pdf_bg))
					$pdf->Open();
					$pdf->SetTitle($outputlangs->convToOutputCharset($object->ref));
					$pdf->SetSubject($outputlangs->transnoentities("PdfOrderTitle"));
					$pdf->SetCreator("Dolibarr ".DOL_VERSION);
					$pdf->SetAuthor($outputlangs->convToOutputCharset($user->getFullName($outputlangs)));
					$pdf->SetKeyWords($outputlangs->convToOutputCharset($object->ref)." ".$outputlangs->transnoentities("PdfOrderTitle")." ".$outputlangs->convToOutputCharset($object->thirdparty->name));
					$pdf->SetMargins($this->marge_gauche, $this->marge_haute, $this->marge_droite);   // Left, Top, Right
					// First loop on each lines to prepare calculs and variables
					$realpatharray	= array();
					$objphoto		= new Product($this->db);
					for ($i = 0 ; $i < $nblignes ; $i++)
					{
						// Positionne $this->atleastonediscount si on a au moins une remise
						if ($object->lines[$i]->remise_percent)									$this->atleastonediscount++;
						// Collecte des totaux par valeur de tva dans $this->tva["taux"]=total_tva
						if ($conf->multicurrency->enabled && $object->multicurrency_tx != 1)	$tvaligne		= $object->lines[$i]->multicurrency_total_tva;
						else																	$tvaligne		= $object->lines[$i]->total_tva;
						$localtax1ligne															= $object->lines[$i]->total_localtax1;
						$localtax2ligne															= $object->lines[$i]->total_localtax2;
						$localtax1_rate															= $object->lines[$i]->localtax1_tx;
						$localtax2_rate															= $object->lines[$i]->localtax2_tx;
						$localtax1_type															= $object->lines[$i]->localtax1_type;
						$localtax2_type															= $object->lines[$i]->localtax2_type;
						if ($object->remise_percent)											$tvaligne		-= ($tvaligne * $object->remise_percent) / 100;
						if ($object->remise_percent)											$localtax1ligne	-= ($localtax1ligne * $object->remise_percent) / 100;
						if ($object->remise_percent)											$localtax2ligne	-= ($localtax2ligne * $object->remise_percent) / 100;
						$vatrate																= (string) $object->lines[$i]->tva_tx;
						// Retrieve type from database for backward compatibility with old records
						if ((! isset($localtax1_type) || $localtax1_type=='' || ! isset($localtax2_type) || $localtax2_type=='') // if tax type not defined
							&& (! empty($localtax1_rate) || ! empty($localtax2_rate))) // and there is local tax
						{
							$localtaxtmp_array	= getLocalTaxesFromRate($vatrate, 0, $object->thirdparty, $this->emetteur);
							$localtax1_type		= $localtaxtmp_array[0];
							$localtax2_type		= $localtaxtmp_array[2];
						}	// if ((! isset($localtax1_type) || $localtax1_type=='' || ! isset($localtax2_type) || $localtax2_type=='') && (! empty($localtax1_rate) || ! empty($localtax2_rate)))
						// retrieve global local tax
						if ($localtax1_type && $localtax1ligne != 0)		$this->localtax1[$localtax1_type][$localtax1_rate]	+= $localtax1ligne;
						if ($localtax2_type && $localtax2ligne != 0)		$this->localtax2[$localtax2_type][$localtax2_rate]	+= $localtax2ligne;
						if (($object->lines[$i]->info_bits & 0x01) == 0x01)	$vatrate											.= '*';
						if (! isset($this->tva[$vatrate])) 					$this->tva[$vatrate]								= 0;
						$this->tva[$vatrate]								+= $tvaligne;
						// detect if there is at least one image to show
						if (! empty($this->with_picture))
						{
							if (empty($object->lines[$i]->fk_product)) continue;
							$objphoto->fetch($object->lines[$i]->fk_product);
							if (! empty($this->old_path_photo))
							{
								$pdir[0] = get_exdir($objphoto->id, 2, 0, 0, $objphoto, 'product').$objphoto->id ."/photos/";
								$pdir[1] = get_exdir(0, 0, 0, 0, $objphoto, 'product').dol_sanitizeFileName($objphoto->ref).'/';
							}	// if (! empty($this->old_path_photo))
							else
							{
								$pdir[0] = get_exdir(0, 0, 0, 0, $objphoto, 'product').dol_sanitizeFileName($objphoto->ref).'/';	// default
								$pdir[1] = get_exdir($objphoto->id, 2, 0, 0, $objphoto, 'product').$objphoto->id ."/photos/";		// alternative
							}	// else	// if (! empty($this->old_path_photo))
							$arephoto = false;
							foreach ($pdir as $midir)
							{
								if (! $arephoto)
								{
									$dir = $conf->product->dir_output.'/'.$midir;
									foreach ($objphoto->liste_photos($dir, 1) as $key => $obj)
									{
										if (empty($this->cat_hq_image))		// If CAT_HIGH_QUALITY_IMAGES not defined, we use thumb if defined and then original photo
										{
											if ($obj['photo_vignette'])	$filename	= $obj['photo_vignette'];
											else						$filename	= $obj['photo'];
										}	// if (empty($this->cat_hq_image))
										else		$filename	= $obj['photo'];
										$realpath	= $dir.$filename;
										$arephoto	= true;
									}	// foreach ($objphoto->liste_photos($dir,1) as $key => $obj)
								}	// if (! $arephoto)
							}	// foreach ($pdir as $midir)
							if ($realpath && $arephoto) $realpatharray[$i]	= $realpath;
						}	// if (! empty($this->with_picture))
					}	// for ($i = 0 ; $i < $nblignes ; $i++)
					// New page
					$pdf->AddPage();
					if (! empty($tplidx))											$pdf->useTemplate($tplidx);
					$pagenb															= 1;
					$pdf->SetFont('', '', $default_font_size - 1);
					$pdf->MultiCell(0, 3, '');		// Set interline to 3
					// Define width and position of notes frames
					$this->larg_util_txt											= $this->page_largeur - ($this->marge_gauche + $this->marge_droite + ($this->Rounded_rect * 2) + 2);
					$this->larg_util_cadre											= $this->page_largeur - ($this->marge_gauche + $this->marge_droite);
					$this->posx_G_txt												= $this->marge_gauche + $this->Rounded_rect + 1;
					// Define width and position of main table columns
					if (empty($this->show_ref_col))									$this->larg_ref			= 0;
					if(! $this->product_use_unit)									$this->larg_unit		= 0;
					if (!empty($this->hide_up))										$this->larg_up			= 0;
					if (! empty($this->hide_vat) || ! empty($this->hide_vat_col))	$this->larg_tva			= 0;
					if (!empty($this->hide_discount))								$this->larg_discount	= 0;
					else if (empty($this->atleastonediscount))						$this->larg_discount	= 0;
					if (!empty($this->hide_discount))								$this->larg_updisc		= 0;
					else if (empty($this->show_up_discounted))						$this->larg_updisc		= 0;
					else if (empty($this->atleastonediscount))						$this->larg_updisc		= 0;
					if (! $object->situation_cycle_ref)								$this->larg_progress	= 0;
					if (! $this->hide_cols)											$this->larg_desc		= $this->larg_util_cadre - ($this->larg_qty + $this->larg_totalht + 
																												$this->larg_progress + $this->larg_discount + $this->larg_unit + 
																												$this->larg_up + $this->larg_updisc + $this->larg_tva + 
																												$this->larg_ref); // Largeur variable suivant la place restante
					else
					{
						$this->num_desc												= 1;
						$this->larg_desc											= $this->larg_util_cadre;
					}	// else	// if (! $this->hide_cols)
					$this->tableau													= array('ref'		=> array('col' => $this->num_ref,		'larg' => $this->larg_ref,		'posx' => 0), 
																							'desc'		=> array('col' => $this->num_desc,		'larg' => $this->larg_desc,		'posx' => 0), 
																							'qty'		=> array('col' => $this->num_qty,		'larg' => $this->larg_qty,		'posx' => 0), 
																							'unit'		=> array('col' => $this->num_unit,		'larg' => $this->larg_unit,		'posx' => 0), 
																							'up'		=> array('col' => $this->num_up,		'larg' => $this->larg_up,		'posx' => 0), 
																							'tva'		=> array('col' => $this->num_tva,		'larg' => $this->larg_tva,		'posx' => 0), 
																							'discount'	=> array('col' => $this->num_discount,	'larg' => $this->larg_discount,	'posx' => 0), 
																							'updisc'	=> array('col' => $this->num_updisc,	'larg' => $this->larg_updisc,	'posx' => 0), 
																							'progress'	=> array('col' => $this->num_progress,	'larg' => $this->larg_progress,	'posx' => 0), 
																							'totalht'	=> array('col' => $this->num_totalht,	'larg' => $this->larg_totalht,	'posx' => 0), 
																							);
					foreach($this->tableau as $ncol => $ncol_array)
					{
						if ($ncol_array['col'] == 1)	$this->largcol1			= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 2)	$this->largcol2		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 3)	$this->largcol3		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 4)	$this->largcol4		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 5)	$this->largcol5		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 6)	$this->largcol6		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 7)	$this->largcol7		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 8)	$this->largcol8		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 9)	$this->largcol9		= $ncol_array['larg'];
						elseif ($ncol_array['col'] == 10)	$this->largcol10	= $ncol_array['larg'];
					}	// foreach($this->tableau as $ncol => $ncol_array)
					$this->posxcol1		= $this->marge_gauche;
					$this->posxcol2		= $this->posxcol1 + $this->largcol1;
					$this->posxcol3		= $this->posxcol2 + $this->largcol2;
					$this->posxcol4		= $this->posxcol3 + $this->largcol3;
					$this->posxcol5		= $this->posxcol4 + $this->largcol4;
					$this->posxcol6		= $this->posxcol5 + $this->largcol5;
					$this->posxcol7		= $this->posxcol6 + $this->largcol6;
					$this->posxcol8		= $this->posxcol7 + $this->largcol7;
					$this->posxcol9		= $this->posxcol8 + $this->largcol8;
					$this->posxcol10	= $this->posxcol9 + $this->largcol9;
					foreach($this->tableau as $ncol => $ncol_array)
					{
						if ($ncol_array['col'] == 1)		$this->tableau[$ncol]['posx']	= $this->posxcol1;
						elseif ($ncol_array['col'] == 2)	$this->tableau[$ncol]['posx']	= $this->posxcol2;
						elseif ($ncol_array['col'] == 3)	$this->tableau[$ncol]['posx']	= $this->posxcol3;
						elseif ($ncol_array['col'] == 4)	$this->tableau[$ncol]['posx']	= $this->posxcol4;
						elseif ($ncol_array['col'] == 5)	$this->tableau[$ncol]['posx']	= $this->posxcol5;
						elseif ($ncol_array['col'] == 6)	$this->tableau[$ncol]['posx']	= $this->posxcol6;
						elseif ($ncol_array['col'] == 7)	$this->tableau[$ncol]['posx']	= $this->posxcol7;
						elseif ($ncol_array['col'] == 8)	$this->tableau[$ncol]['posx']	= $this->posxcol8;
						elseif ($ncol_array['col'] == 9)	$this->tableau[$ncol]['posx']	= $this->posxcol9;
						elseif ($ncol_array['col'] == 10)	$this->tableau[$ncol]['posx']	= $this->posxcol10;
					}	// foreach($this->tableau as $ncol => $ncol_array)
					// Define width and position of secondary tables columns
					$this->larg_tabtotal	= 80;
					$this->larg_tabinfo		= $this->page_largeur - $this->marge_gauche - $this->marge_droite - $this->larg_tabtotal;
					$this->posxtabtotal		= $this->page_largeur - $this->marge_droite - $this->larg_tabtotal;
					// Calculs de positions
					$this->tab_hl			= 4;
					$this->ht_util_cadre	= $this->page_hauteur - ($this->marge_haute + $this->marge_basse);
					$head					= $this->_pagehead($pdf, $object, 1, $outputlangs);
					$hauteurhead			= $head["totalhead"];
					$hauteurcadre			= $head["hauteurcadre"];
					$tab_top				= $hauteurhead + 5;
					$tab_top_newpage		= (empty($this->small_head2) ? $hauteurhead - $hauteurcadre : 17);
					$this->ht_top_table		= $this->Rounded_rect * 2 > $this->tab_hl ? ($this->Rounded_rect * 2) + 1 : $this->tab_hl;
					$this->ht_decal_round	= $this->Rounded_rect > 0 ? $this->Rounded_rect - 1 : 0;
					$ht_colinfo				= $this->_tableau_info($pdf, $object, $bottomlasttab, $outputlangs, 1);
					$ht_coltotal			= $this->_tableau_tot($pdf, $object, $bottomlasttab, $outputlangs, 1);
					$ht2_coltotal			= pdf_InfraS_free_text($pdf, $object, $this->posxtabtotal, $ht_coltotal + 3, $outputlangs, $this->emetteur, 'ORDER_FREE_TEXT', 1);
					if ($this->show_sign_area)
					{
						if ($ht2_coltotal > 4)	$ht_coltotal	+= ($this->tab_hl * 2) + $this->ht_signarea + 1;
						else					$ht_coltotal	+= ($this->tab_hl * 2) + $this->ht_signarea;
					}	// if ($this->show_sign_area)
					$ht_coltotal		+= $ht2_coltotal;
					$heightforinfotot	= $ht_colinfo > $ht_coltotal ? $ht_colinfo : $ht_coltotal;
					$heightforfooter	= $this->_pagefoot($pdf, $object, $outputlangs, 1);
					$pdf->SetDrawColor(128, 128, 128);
					$pdf->SetTextColor(0, 0, 0);
					// Incoterm
					$height_incoterms	= 0;
					if ($conf->incoterm->enabled)
					{
						$desc_incoterms	= $object->getIncotermsForPDF();
						if ($desc_incoterms)
						{
							$pdf->SetFont('', '', $default_font_size - 1);
							$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($desc_incoterms), 0, 1);
							$nexY				= $pdf->GetY();
							$height_incoterms	= $this->Rounded_rect * 2 > $nexY - $tab_top ? $this->Rounded_rect * 2 : $nexY - $tab_top;
							$pdf->RoundedRect($this->marge_gauche, $tab_top - 1, $this->larg_util_cadre, $height_incoterms + 1, $this->Rounded_rect, '1111');
							$height_incoterms	+= $this->tab_hl;
						}	// if ($desc_incoterms)
					}	// if ($conf->incoterm->enabled)
					$tab_top		+= $height_incoterms;
					// Livraison
					$height_livr	= 0;
					if ($this->showadrlivr && $this->adrlivr)
					{
						$recepdetails						= $this->show_recep_details ? 'targetwithdetails' : 'target';
						if ($this->adrlivr == 'Default')	$livrshow	= pdf_InfraS_build_address($outputlangs, $this->emetteur, $object->thirdparty, '', 0, $recepdetails, $object, 0);
						else								$livrshow	= pdf_InfraS_build_address($outputlangs, $this->emetteur, $this->adrlivr, '', 0, $recepdetails, $object, 0);
						if ($livrshow)
						{
							$pdf->SetFont('', 'B', $default_font_size + 2);
							$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($outputlangs->transnoentities("PDFInfraSLivr")), 0, 1);
							$xlivr	= $pdf->GetX() + $pdf->GetStringWidth($outputlangs->transnoentities("PDFInfraSLivr"), '', 'B', $default_font_size + 2) + 5;
							if ($this->adrlivr->name != '')
							{
								$pdf->SetFont('', 'B', $default_font_size);
								$pdf->writeHTMLCell($this->larg_util_txt - $xlivr - 3, $this->tab_hl, $xlivr, $tab_top + 0.6, dol_htmlentitiesbr($this->adrlivr->name), 0, 1);
								$nexY	= $pdf->GetY();
							}	// if ($this->adrlivr->name)
							else	$nexY	= $tab_top + 0.6;
							$pdf->SetFont('', '', $default_font_size - 1);
							$pdf->writeHTMLCell($this->larg_util_txt - $xlivr - 3, $this->tab_hl, $xlivr, $nexY, dol_htmlentitiesbr($livrshow), 0, 1);
							$nexY			= $pdf->GetY();
							$height_livr	= $this->Rounded_rect * 2 > $nexY - $tab_top ? $this->Rounded_rect * 2 : $nexY - $tab_top;
							$pdf->RoundedRect($this->marge_gauche, $tab_top - 1, $this->larg_util_cadre, $height_livr + 2, $this->Rounded_rect, '1111');
							$height_livr	+= $this->tab_hl;
						}	// if ($livrshow)
					}	// if ($this->showadrlivr && $this->adrlivr)
					$tab_top		+= $height_livr;
					// Affiche notes
					$height_note	= 0;
					$notetoshow		= '';
					if (! empty($this->add_sale_rep_sign_note))
					{
						if (is_object($object->thirdparty))
						{
							$salereparray							= $object->thirdparty->getSalesRepresentatives($user);
							$salerepobj								= new User($this->db);
							$salerepobj->fetch($salereparray[0]['id']);
							if (! empty($salerepobj->signature))	$notetoshow	= dol_concatdesc($notetoshow, $salerepobj->signature);
						}	// if (is_object($object->thirdparty))
					}	// if (! empty($this->add_sale_rep_sign_note))
					$notetoshow	.= empty($notetoshow) ? '' : '<br />';
					$notetoshow	.= empty($object->note_public) ? '' : $object->note_public;
					if ($notetoshow)
					{
						$substitutionarray	= pdf_getSubstitutionArray($outputlangs, null, $object);
						complete_substitutions_array($substitutionarray, $outputlangs, $object);
						$notetoshow			= make_substitutions($notetoshow, $substitutionarray, $outputlangs);
						$pdf->SetFont('', '', $default_font_size - 1);
						$pdf->startTransaction();
						$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($notetoshow), 0, 1);
						if ($pdf->getPage() > 1 || $pdf->GetY() > ($this->page_hauteur - (($this->tab_hl * 4) + $this->ht_top_table + $this->ht_decal_round + $heightforfooter))) // Notes need pagebreak or There is no space left for footer
						{
							$pdf->rollbackTransaction(true);
							$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($outputlangs->transnoentities("PDFInfrasNoteTooLong")), 0, 1);
						}	// if ($pdf->getPage() > 1 || $pdf->GetY() > ($this->page_hauteur - (($this->tab_hl * 4) + $this->ht_top_table + $this->ht_decal_round + $heightforfooter)))
						else				$pdf->commitTransaction();
						
						$nexY			= $pdf->GetY();
						$height_note	= $this->Rounded_rect * 2 > $nexY - $tab_top ? $this->Rounded_rect * 2 : $nexY - $tab_top;
						$pdf->RoundedRect($this->marge_gauche, $tab_top - 1, $this->larg_util_cadre, $height_note + 2, $this->Rounded_rect, '1111');
						$height_note	+= $this->tab_hl;
					}	// if ($notetoshow)
					$tab_top	+= $height_note + $this->tab_hl;
					$nexY		= $tab_top + $this->ht_top_table + $this->ht_decal_round;
					// Loop on each lines
					for ($i = 0 ; $i < $nblignes ; $i++)
					{
						$curY								= $nexY;
						$pdf->SetFont('', '', $default_font_size - 1);   // Into loop to work with multipage
						$pdf->SetTextColor(0, 0, 0);
						// Define size of image if we need it
						if ($this->tableau['desc']['larg'] - 2 < $this->wpicture)	$this->wpicture	= $this->tableau['desc']['larg'] - 2;	// corrige la largeur maximal de l'image pour être au plus égale à la largeur colonne
						$imglinesize						= array();
						if (! empty($realpatharray[$i]))	$imglinesize	= pdf_InfraS_getSizeForImage($realpatharray[$i], $this->wpicture, $this->hpicture);
						if (empty($this->hide_top_table))	$pdf->setTopMargin($tab_top_newpage + $this->ht_top_table + $this->ht_decal_round);
						else								$pdf->setTopMargin($tab_top_newpage);
						$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
						$pageposbefore						= $pdf->getPage();
						$showpricebeforepagebreak			= 1;
						// We start with Photo of product line
						if (isset($imglinesize['width']) && isset($imglinesize['height']))
						{
							if (($curY + $imglinesize['height']) > ($this->page_hauteur - ($heightforfooter)))	// If photo too high, we moved completely on new page
							{
								$pdf->AddPage('', '', true);
								if (! empty($tplidx))		$pdf->useTemplate($tplidx);
								$pdf->setPage($pageposbefore + 1);
								$curY						= $tab_top_newpage + ($this->hide_top_table ? $this->ht_decal_round : $this->ht_top_table + $this->ht_decal_round);
								$showpricebeforepagebreak	= 1;
							}	// if (($curY + $imglinesize['height']) > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
							$posxpicture	= ($this->tableau['desc']['posx'] - 1) + (($this->tableau['desc']['larg'] - 2 - $imglinesize['width']) / 2);	// centre l'image dans la colonne
							$pdf->Image($realpatharray[$i], $posxpicture, $curY, $imglinesize['width'], $imglinesize['height'], '', '', '', 2, 300);	// Use 300 dpi
							$curY			+= $imglinesize['height'];	// $pdf->Image does not increase value return by getY, so we save it manually
						}	// if (isset($imglinesize['width']) && isset($imglinesize['height']))
						// Description of product line
						$pdf->startTransaction();
						pdf_InfraS_writelinedesc($pdf, $object, $i, $outputlangs, $this->tableau['desc']['larg'], $this->tab_hl, $this->tableau['desc']['posx'], $curY, $hideref, $hidedesc);
						$pageposafter	= $pdf->getPage();
						$pageposdesc				= $pdf->getPage();
						$posyafter		= $pdf->GetY();
						if ($pageposafter > $pageposbefore)	// There is a pagebreak
						{
							$pdf->rollbackTransaction(true);
							$pageposafter	= $pageposbefore;
							$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
							$pageposdesc	= $pdf->getPage();
							pdf_InfraS_writelinedesc($pdf, $object, $i, $outputlangs, $this->tableau['desc']['larg'], $this->tab_hl, $this->tableau['desc']['posx'], $curY, $hideref, $hidedesc);
							$pageposafter	= $pdf->getPage();
							$posyafter		= $pdf->GetY();
							if ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))	// There is no space left for total+free text
							{
								if ($i == ($nblignes - 1))	// No more lines, and no space left to show total, so we create a new page
								{
									$pdf->AddPage('', '', true);
									if (! empty($tplidx))	$pdf->useTemplate($tplidx);
									$pdf->setPage($pageposafter + 1);
							}	// if ($i == ($nblignes - 1))
							}	// if ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
							else								$showpricebeforepagebreak	= 0;
						}	// if ($pageposafter > $pageposbefore)
						elseif ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
						{
							$pdf->rollbackTransaction(true);
							$pageposafter	= $pageposbefore;
							$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
							$pageposdesc	= $pdf->getPage();
							pdf_InfraS_writelinedesc($pdf, $object, $i, $outputlangs, $this->tableau['desc']['larg'], $this->tab_hl, $this->tableau['desc']['posx'], $curY, $hideref, $hidedesc);
							$pageposafter	= $pdf->getPage();
							$posyafter		= $pdf->GetY();
							if ($i == ($nblignes - 1))	// No more lines, and no space left to show total, so we create a new page
							{
								$pdf->AddPage('', '', true);
								if (! empty($tplidx))	$pdf->useTemplate($tplidx);
								$pdf->setPage($pageposafter + 1);
							}	// if ($i == ($nblignes - 1))
						}	// elseif ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
						else				$pdf->commitTransaction();	// No pagebreak
						$nexY			= $pdf->GetY();
						$pageposafter	= $pdf->getPage();
						$pdf->setPage($pageposbefore);
						$pdf->setTopMargin($this->marge_haute);
						$pdf->setPageOrientation('', 1, 0);	// The only function to edit the bottom margin of current page to set it.
						if ($pageposafter > $pageposbefore && empty($showpricebeforepagebreak))
						{
							if ($curY > ($this->page_hauteur - $heightforfooter - $this->tab_hl))
							{
								$pdf->setPage($pageposafter);
								$curY	= $tab_top_newpage + ($this->hide_top_table ? $this->ht_decal_round : $this->ht_top_table + $this->ht_decal_round);
							}	// if ($curY > ($this->page_hauteur - $heightforfooter - $this->tab_hl))
							else	$pdf->setPage($pageposdesc);
						}	// if ($pageposafter > $pageposbefore && empty($showpricebeforepagebreak))
						$pdf->SetFont('', '', $default_font_size - 1);   // On repositionne la police par defaut
						if (! $this->hide_cols)
						{
							// Reference
							if (! empty($this->show_ref_col))
							{
								$ref	= pdf_getlineref($object, $i, $outputlangs, $hidedetails);
								$pdf->SetXY($this->tableau['ref']['posx'], $curY);
								$pdf->MultiCell($this->tableau['ref']['larg'], $this->tab_hl, $ref, 0, 'L');
							}	// if (! empty($this->show_ref_col))
							// Quantity
							$qty	= pdf_getlineqty($object, $i, $outputlangs, $hidedetails);
							$pdf->SetXY($this->tableau['qty']['posx'], $curY);
							$pdf->MultiCell($this->tableau['qty']['larg'], $this->tab_hl, $qty, 0, 'R');
							// Unit
							if($this->product_use_unit)
							{
								$unit	= pdf_getlineunit($object, $i, $outputlangs, $hidedetails, $hookmanager);
								$pdf->SetXY($this->tableau['unit']['posx'], $curY);
								$pdf->MultiCell($this->tableau['unit']['larg'], $this->tab_hl, $unit, 0, 'L');
							}	// if($this->product_use_unit)
							// Unit price
							if (empty($this->hide_discount))
							{
								if (empty($this->hide_vat))	$up_line	= pdf_InfraS_getlineupexcltax($object, $i, $outputlangs, $hidedetails);
								else						$up_line	= pdf_InfraS_getlineupincltax($object, $i, $outputlangs, $hidedetails);
							}	// if (empty($this->hide_discount))
							else
							{
								if (empty($this->hide_vat))	$up_line	= pdf_InfraS_getlineincldiscountexcltax($object, $i, $outputlangs, $hidedetails);
								else						$up_line	= pdf_InfraS_getlineincldiscountincltax($object, $i, $outputlangs, $hidedetails);
							}	// else	// if (empty($this->hide_discount))
							if (empty($this->hide_up))
							{
								$pdf->SetXY($this->tableau['up']['posx'], $curY);
								$pdf->MultiCell($this->tableau['up']['larg'], $this->tab_hl, $up_line, 0, 'R', 0);
							}	// if (!empty($this->hide_up))
							// VAT Rate
							if (empty($this->hide_vat) && empty($this->hide_vat_col))
							{
								$vat_rate	= pdf_getlinevatrate($object, $i, $outputlangs, $hidedetails);
								$pdf->SetXY($this->tableau['tva']['posx'], $curY);
								$pdf->MultiCell($this->tableau['tva']['larg'], $this->tab_hl, $vat_rate, 0, 'R');
							}	// if (empty($this->hide_vat) && empty($this->hide_vat_col))
							// Discount on line
							if ($object->lines[$i]->remise_percent && empty($this->hide_discount))
							{
								$remise_percent	= pdf_getlineremisepercent($object, $i, $outputlangs, $hidedetails);
								$pdf->SetXY($this->tableau['discount']['posx'], $curY);
								$pdf->MultiCell($this->tableau['discount']['larg'], $this->tab_hl, $remise_percent, 0, 'R');
							}	// if ($object->lines[$i]->remise_percent && empty($this->hide_discount))
							// Discounted price
							if ($object->lines[$i]->remise_percent && empty($this->hide_discount) && $this->show_up_discounted)
							{
								if (empty($this->hide_vat))	$up_disc	= pdf_InfraS_getlineincldiscountexcltax($object, $i, $outputlangs, $hidedetails);
								else						$up_disc	= pdf_InfraS_getlineincldiscountincltax($object, $i, $outputlangs, $hidedetails);
								$pdf->SetXY($this->tableau['updisc']['posx'], $curY);
								$pdf->MultiCell($this->tableau['updisc']['larg'], $this->tab_hl, $up_disc, 0, 'R');
							}	// if ($object->lines[$i]->remise_percent && empty($this->hide_discount) && $this->show_up_discounted)
							// Total line
							if (empty($this->hide_vat))	$total_line		= pdf_InfraS_getlinetotalexcltax($object, $i, $outputlangs, $hidedetails);
							else						$total_line 	= pdf_InfraS_getlinetotalincltax($object, $i, $outputlangs, $hidedetails);
							$pdf->SetXY($this->tableau['totalht']['posx'], $curY);
							$pdf->MultiCell($this->tableau['totalht']['larg'], $this->tab_hl, $total_line, 0, 'R', 0);
						}	// if (! $this->hide_cols)
						// Add dash or space between line
						if ($this->dash_between_line && $i < ($nblignes - 1))
						{
							$pdf->setPage($pageposafter);
							$pdf->SetLineStyle(array('color'=>array(128, 128 ,128)));
							$pdf->line($this->marge_gauche, $nexY + 1, $this->page_largeur - $this->marge_droite, $nexY + 1);
							$nexY	+= 2;
						}	// if ($this->dash_between_line && $i < ($nblignes - 1))
						else								$nexY	+= $this->tab_hl;
						// Detect if some page were added automatically and output _tableau for past pages
						while ($pagenb < $pageposafter)
						{
							$pdf->setPage($pagenb);
							$heightforfooter				= $this->_pagefoot($pdf, $object, $outputlangs, 0);
							if ($pagenb == 1)				$this->_tableau($pdf, $object, $tab_top, $this->page_hauteur - $tab_top - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							else							$this->_tableau($pdf, $object, $tab_top_newpage, $this->page_hauteur - $tab_top_newpage - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							$pagenb++;
							$pdf->setPage($pagenb);
							$pdf->setPageOrientation('', 1, 0);	// The only function to edit the bottom margin of current page to set it.
							if (empty($this->small_head2))	$this->_pagehead($pdf, $object, 0, $outputlangs);
							else							$this->_pagesmallhead($pdf, $object, 0, $outputlangs);
						}	// while ($pagenb < $pageposafter)
						if (isset($object->lines[$i + 1]->pagebreak) && $object->lines[$i + 1]->pagebreak)
						{
							$heightforfooter				= $this->_pagefoot($pdf, $object, $outputlangs, 0);
							if ($pagenb == 1)				$this->_tableau($pdf, $object, $tab_top, $this->page_hauteur - $tab_top - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							else							$this->_tableau($pdf, $object, $tab_top_newpage, $this->page_hauteur - $tab_top_newpage - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							// New page
							$pdf->AddPage();
							if (! empty($tplidx))			$pdf->useTemplate($tplidx);
							$pagenb++;
							if (empty($this->small_head2))	$this->_pagehead($pdf, $object, 0, $outputlangs);
							else							$this->_pagesmallhead($pdf, $object, 0, $outputlangs);
						}	// if (isset($object->lines[$i + 1]->pagebreak) && $object->lines[$i + 1]->pagebreak)
					}	// for ($i = 0 ; $i < $nblignes ; $i++)
					$bottomlasttab							= $this->page_hauteur - $heightforinfotot - $heightforfooter - 1;
					if ($pagenb == 1)						$this->_tableau($pdf, $object, $tab_top, $bottomlasttab - $tab_top, $outputlangs, $this->hide_top_table, 1, $pagenb);
					else									$this->_tableau($pdf, $object, $tab_top_newpage, $bottomlasttab - $tab_top_newpage, $outputlangs, $this->hide_top_table, 0, $pagenb);
					$posyinfo								= $this->_tableau_info($pdf, $object, $bottomlasttab, $outputlangs, 0);
					$posytot								= $this->_tableau_tot($pdf, $object, $bottomlasttab, $outputlangs, 0);
					if ($ht2_coltotal > 4)					$pdf->Line($this->posxtabtotal, $posytot + 2, $this->page_largeur - $this->marge_droite, $posytot + 2);
					$pdf->SetTextColor(0, 0, 0);
					$posyfreetext							= pdf_InfraS_free_text($pdf, $object, $this->posxtabtotal, $posytot + 3, $outputlangs, $this->emetteur, 'ORDER_FREE_TEXT', 0);
					if ($this->show_sign_area)
					{
						if ($ht2_coltotal > 4)
						{
							$pdf->Line($this->posxtabtotal, $posyfreetext + 2, $this->page_largeur - $this->marge_droite, $posyfreetext + 2);
							$posysignarea	= $this->_signature_area($pdf, $object, $posyfreetext + 3, $outputlangs);
						}	// if ($ht2_coltotal > 4)
						else	$posysignarea	= $this->_signature_area($pdf, $object, $posyfreetext, $outputlangs);
					}	// if ($this->show_sign_area)
					$posy	= $posyinfo > $posysignarea ? $posyinfo : $posysignarea;
					$this->_pagefoot($pdf, $object, $outputlangs, 0);
					if (method_exists($pdf, 'AliasNbPages'))	$pdf->AliasNbPages();
					// If merge CGV is active
					if (!empty($this->CGV) && $this->chkCGV)	pdf_InfraS_CGV($pdf, $this->CGV, $tplidx, $this->hidepagenum);
					$pdf->Close();
					$pdf->Output($file, 'F');
					// Add pdfgeneration hook
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters									= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook=$hookmanager->executeHooks('afterPDFCreation',$parameters,$this,$action);    // Note that $action and $object may have been modified by some hooks
					if (! empty($this->main_umask))				@chmod($file, octdec($this->main_umask));
					$this->result								= array('fullpath' => $file);
					return 1;   // Pas d'erreur
				}	// if (file_exists($dir))
				else
				{
					$this->error=$langs->transnoentities("ErrorCanNotCreateDir", $dir);
					return 0;
				}	// else	// if (file_exists($dir))
			}	// if ($conf->commande->dir_output)
			else
			{
				$this->error=$langs->transnoentities("ErrorConstantNotDefined", "COMMANDE_OUTPUTDIR");
				return 0;
			}	// else	// if ($conf->commande->dir_output)
		}	// function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)

		/********************************************
		*	Show top header of page.
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object     	Object to show
		*	@param		int	    	$showaddress    0=no, 1=yes
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		string		$titlekey		Translation key to show as title of document
		*	@return		array		$hauteurhead	'totalhead'		= hight of header
		*											'hauteurcadre	= hight of frame
		********************************************/
		function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PdfOrderTitle")
		{
			global $conf, $langs, $hookmanager;

			if((float)DOL_VERSION >= 8.0)	$outputlangs->loadLangs(array("main", "bills", "companies", "orders", "propal", "commercial"));
			else
			{
				$outputlangs->load("main");
				$outputlangs->load("bills");
				$outputlangs->load("companies");
				$outputlangs->load("orders");
				$outputlangs->load("propal");
				$outputlangs->load("commercial");
			}	// else	// if((float)DOL_VERSION >= 8.0)
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			pdf_pagehead($pdf, $outputlangs, $this->page_hauteur);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('', 'B', $default_font_size + 3);
			$w		= 100;
			$posy	= $this->marge_haute;
			$posx	= $this->page_largeur - $this->marge_droite - $w;
			$pdf->SetXY($this->marge_gauche, $posy);
			// Logo
			$logo	= $conf->mycompany->dir_output.'/logos/'.$this->emetteur->logo;
			if ($logo)
			{
				if (is_file($logo) && is_readable($logo))
				{
					$heightLogo	= pdf_getHeightForLogo($logo);
					$pdf->Image($logo, $this->marge_gauche, $posy, 0, $heightLogo);	// width=0 (auto)
				}	// if (is_file($logo) && is_readable($logo))
				else
				{
					$pdf->SetTextColor(200, 0, 0);
					$pdf->SetFont('', 'B', $default_font_size - 2);
					$pdf->MultiCell($w, $this->tab_hl, $outputlangs->transnoentities("ErrorLogoFileNotFound",$logo), 0, 'L');
					$pdf->MultiCell($w, $this->tab_hl, $outputlangs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
					$pdf->SetTextColor(0, 0, 0);
				}	// else	// if (is_file($logo) && is_readable($logo))
			}	// if ($logo)
			else
			{
				$text=$this->emetteur->name;
				$pdf->MultiCell($w, $this->tab_hl, $outputlangs->convToOutputCharset($text), 0, 'L');
				$heightLogo = $this->tab_hl;
			}	// else// if ($logo)
			$heightLogo	+= $posy + $this->tab_hl;
			$pdf->SetFont('', 'B', $default_font_size * 2);
			$title		= $outputlangs->transnoentities($titlekey);
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl * 2, $title, '', 'R');
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$posy		+= $this->tab_hl * 2;
			$txtref		= $outputlangs->transnoentities("PDFInfrasRef")." : ".$outputlangs->convToOutputCharset($object->ref);
			if ($object->statut == 0)
			{
				$pdf->SetTextColor(128, 0, 0);
				$txtref .= ' - '.$outputlangs->transnoentities("NotValidated");
				$pdf->SetTextColor(0, 0, 0);
			}	// if ($object->statut == 0)
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl, $txtref, '', 'R');
			$pdf->SetFont('', '', $default_font_size - 2);
			$posy		+= $this->tab_hl;
			$txtdt		= $outputlangs->transnoentities("PDFInfraSOrderDate")." : ".dol_print_date($object->date_commande, "day", false, $outputlangs, true);
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl, $txtdt, '', 'R');
			if ($object->ref_client)
			{
				$posy	+= $this->tab_hl - 0.5;
				$txtcc	= $outputlangs->transnoentities("RefCustomer")." : ".$outputlangs->convToOutputCharset($object->ref_client);
				$pdf->SetXY($posx, $posy);
				$pdf->MultiCell($w, $this->tab_hl, $txtcc, '', 'R');
			}	// if ($object->ref_client)
			if (!empty($this->show_first_sales_rep))
			{
				$arrayidcontact	= $object->getIdContact('internal', 'SALESREPFOLL');
				if (count($arrayidcontact) > 0)
				{
					$usertmp	= new User($this->db);
					$usertmp->fetch($arrayidcontact[0]);
					$posy		+= $this->tab_hl - 0.5;
					$pdf->SetXY($posx, $posy);
					$pdf->MultiCell($w, $this->tab_hl, $langs->transnoentities("SalesRepresentative")." : ".$usertmp->getFullName($langs), '', 'R');
				}	// if (count($arrayidcontact) > 0)
			}	// if (!empty($this->show_first_sales_rep))
			// Show list of linked objects
			$posy		= pdf_InfraS_writeLinkedObjects($pdf, $object, $outputlangs, $posx, $posy, $w, $this->tab_hl, 'R');
			$posy		+= 0.5;
			$posycadre	= ($this->use_iso_location ? 40 : ($heightLogo > $posy + $this->tab_hl ? $heightLogo : $posy + $this->tab_hl));
			if ($showaddress)
			{
				// Sender properties
				$carac_emetteur	= '';
				// Add internal contact of proposal if defined
				$arrayidcontact	= $object->getIdContact('internal', 'SALESREPFOLL');
				if (count($arrayidcontact) > 0 && empty($this->show_first_sales_rep))
				{
					$object->fetch_user($arrayidcontact[0]);
					$labelbeforecontactname	= ($outputlangs->transnoentities("FromContactName") != 'FromContactName' ? $outputlangs->transnoentities("FromContactName") : $outputlangs->transnoentities("Name"));
					$carac_emetteur		.= ($carac_emetteur ? "\n" : '' ).$labelbeforecontactname." ".$outputlangs->convToOutputCharset($object->user->getFullName($outputlangs))."\n";
				}	// if (count($arrayidcontact) > 0 && empty($this->show_first_sales_rep))
				$carac_emetteur .= pdf_InfraS_build_address($outputlangs, $this->emetteur, $object->client, '', 0, 'source', null, 1);
				// Recipient properties
				// If CUSTOMER contact defined, we use it
				$usecontact		= false;
				$arrayidcontact	= $object->getIdContact('external', 'CUSTOMER');
				if (count($arrayidcontact) > 0)
				{
					$usecontact	= true;
					$result		= $object->fetch_contact($arrayidcontact[0]);
				}	// if (count($arrayidcontact) > 0)
				//Recipient name
				// On peut utiliser le nom de la societe du contact
				if ($usecontact && !empty($this->use_comp_name_contact))	$thirdparty	= $object->contact;
				else														$thirdparty	= $object->thirdparty;
				$carac_client_name	= pdf_InfraS_Build_Third_party_Name($thirdparty, $outputlangs, $this->includealias);
				$recepdetails		= $this->show_recep_details ? 'targetwithdetails' : 'target';
				$carac_client		= pdf_InfraS_build_address($outputlangs, $this->emetteur, $object->thirdparty, ($usecontact ? $object->contact : ''), $usecontact, $recepdetails, $object, 1);
				// Show sender
				$largeurcadreS	= 92;
				if (! empty($this->invert_sender_recipient))	$posx	= $this->page_largeur - $this->marge_droite - $largeurcadreS;
				else											$posx	= $this->marge_gauche;
				$posxcadre	= $posx;
				$posy		= $posycadre;
				// Show sender name
				$pdf->SetFont('', 'B', $default_font_size);
				$pdf->SetXY($posx + 2, $posy + 1);
				$pdf->MultiCell($largeurcadreS - 4, $this->tab_hl, $outputlangs->convToOutputCharset($this->emetteur->name), 0, 'L');
				$posy	= $pdf->getY();
				// Show sender information
				$pdf->SetFont('', '', $default_font_size - 1);
				$pdf->SetXY($posx + 2, $posy);
				$pdf->MultiCell($largeurcadreS - 4, $this->tab_hl, $carac_emetteur, 0, 'L');
				$posyendsender	= $pdf->getY();
				//Show Recipient
				$largeurcadreR	= 92;
				if ($this->page_largeur < 210) $largeurcadreR = 84;	// To work with US executive format
				if (! empty($this->invert_sender_recipient))	$posx	= $this->marge_gauche;
				else											$posx	= $this->page_largeur - $this->marge_droite - $largeurcadreR;
				$posy	= $posycadre;
				// Show recipient name
				$pdf->SetFont('', 'B', $default_font_size);
				$pdf->SetXY($posx + 2, $posy + 1);
				$pdf->MultiCell($largeurcadreR - 4, $this->tab_hl, $carac_client_name, 0, 'L');
				$posy	= $pdf->getY();
				// Show recipient information
				$pdf->SetFont('', '', $default_font_size - 1);
				$pdf->SetXY($posx + 2, $posy);
				$pdf->MultiCell($largeurcadreR - 4, $this->tab_hl, $carac_client, 0, 'L');
				$posyendrecipient	= $pdf->getY();
				//Calcul hauteur des cadres
				if ($posyendsender > $posyendrecipient)	$hauteurcadre	= ($posyendsender - $posycadre) + 1;
				else									$hauteurcadre	= ($posyendrecipient - $posycadre) + 1;
				// Show sender frame
				$pdf->SetFont('', '', $default_font_size - 2);
				$pdf->SetXY($posxcadre + $this->Rounded_rect, $posycadre - 4);
				if (! $this->hide_recep_frame)			$pdf->MultiCell($largeurcadreS, $this->tab_hl + 1, $outputlangs->transnoentities("BillFrom").":", 0, 'L');
				$pdf->SetAlpha($this->alpha);
				$pdf->RoundedRect($posxcadre, $posycadre, $largeurcadreS, $hauteurcadre, $this->Rounded_rect, '1111', 'F' ,null , explode(',', $this->bg_color));
				$pdf->SetAlpha(1);
				// Show recipient frame
				if (! $this->hide_recep_frame)
				{
					$pdf->SetFont('', '', $default_font_size - 2);
					$pdf->SetXY($posx + $this->Rounded_rect, $posycadre - 4);
					$pdf->MultiCell($largeurcadreR, $this->tab_hl + 1, $outputlangs->transnoentities("BillTo").":", 0, 'L');
					$pdf->RoundedRect($posx, $posycadre, $largeurcadreR, $hauteurcadre, $this->Rounded_rect, '1111');
				}	// if (! $this->hide_recep_frame)
			}	// if ($showaddress)
			$hauteurhead = array('totalhead'=>$posycadre + $hauteurcadre, 'hauteurcadre'=>$hauteurcadre);
			return $hauteurhead;
		}	// function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PdfOrderTitle")

		/********************************************
		*	Show top small header of page.
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object     	Object to show
		*	@param		int	    	$showaddress    0=no, 1=yes
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		string		$titlekey		Translation key to show as title of document
		*	@return		void
		********************************************/
		function _pagesmallhead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PdfOrderTitle")
		{
			global $conf, $langs, $hookmanager;
			
			$fromcompany	= $this->emetteur;
			$logo			= $conf->mycompany->dir_output.'/logos/'.$this->emetteur->logo;
			$title			= $outputlangs->transnoentities($titlekey);
			pdf_InfraS_pagesmallhead($pdf, $object, $showaddress, $outputlangs, $title, $fromcompany, $this->formatpage, $this->Rounded_rect, $logo);
		}	// function _pagesmallhead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PdfOrderTitle")

		/********************************************
		*   Show table for lines
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param  	Object		$object     	Object to show
		*	@param		float		$tab_top		Top position of table
		*	@param		float		$tab_height		Height of table (rectangle)
		*	@param		Translate	$outputlangs	Langs object
		*	@param		int			$hidetop		1=Hide top bar of array and title, 0=Hide nothing, -1=Hide only title
		*	@param		int			$hidebottom		Hide bottom bar of array
		*	@return		void
		********************************************/
		function _tableau(&$pdf, $object, $tab_top, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)
		{
			global $conf;

			// Force to disable hidetop and hidebottom
			$hidebottom			= 0;
			if ($hidetop)		$hidetop	= -1;
			$currency			= !empty($object->multicurrency_code) ? $object->multicurrency_code : $conf->currency;
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('', '', $default_font_size - 2);
			// Output Rounded Rectangle
			if (empty($hidetop) || $pagenb == 1)
			{
				if ($pagenb == 1)
				{
					$infocurrency	= $outputlangs->transnoentities("AmountInCurrency", $outputlangs->transnoentitiesnoconv("Currency".$currency));
					$pdf->SetXY($this->page_largeur - $this->marge_droite - ($pdf->GetStringWidth($infocurrency) + 3) - $this->Rounded_rect, $tab_top - $this->tab_hl);
					$pdf->MultiCell(($pdf->GetStringWidth($infocurrency) + 3), 2, $infocurrency);
				}	// if ($pagenb == 1)
				if (! empty($this->title_bg))
				{
					$bg_color	= explode(',', $this->bg_color);
					$pdf->SetDrawColor($bg_color[0], $bg_color[1], $bg_color[2]);
					$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111', 'DF', null, explode(',', $this->bg_color));
					$pdf->SetDrawColor(128, 128, 128);
				}	// if (! empty($this->title_bg))
				else	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111');
				$pdf->RoundedRect($this->marge_gauche, $tab_top + $this->ht_top_table, $this->larg_util_cadre, $tab_height - $this->ht_top_table, $this->Rounded_rect, '1111');
			}	// if (empty($hidetop) || $pagenb == 1)
			else	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $tab_height, $this->Rounded_rect, '1111');
			// Show Watermarks
			$pdf->SetAlpha($this->watermark_i_opacity / 100);
			$filigrane	= $conf->mycompany->dir_output.'/logos/'.$this->image_watermark;
			if ($filigrane && is_readable($filigrane))
			{
				$imglinesize	= pdf_InfraS_getSizeForImage($filigrane, $this->larg_util_cadre, $tab_height);
				if (isset($imglinesize['width']) && isset($imglinesize['height']))
				{
					$posXfiligrane			= $this->marge_gauche + (($this->larg_util_cadre - $imglinesize['width']) / 2);	// centrer le filigrane
					if (empty($hidetop))	$pdf->Image($filigrane, $posXfiligrane, $tab_top + $this->ht_top_table + ($tab_height / 2) - ($imglinesize['height'] / 2), $imglinesize['width'], 0);	// width=0 (auto)
					else					$pdf->Image($filigrane, $posXfiligrane, $tab_top + ($tab_height / 2) - ($imglinesize['height'] / 2), $imglinesize['width'], 0);	// width=0 (auto)
				}	// if (isset($imglinesize['width']) && isset($imglinesize['height']))
			}	// if ($filigrane && is_readable($filigrane))
			$pdf->SetAlpha($this->watermark_t_opacity / 100);
			if ($object->statut == 0 && (! empty($this->draft_watermark)))
			{
				if (empty($hidetop))	pdf_InfraS_watermark($pdf, $outputlangs, $this->draft_watermark, $tab_top + $this->ht_top_table + ($tab_height / 2), $this->larg_util_cadre, $this->page_hauteur, 'mm');
				else					pdf_InfraS_watermark($pdf, $outputlangs, $this->draft_watermark, $tab_top + ($tab_height / 2), $this->larg_util_cadre, $this->page_hauteur, 'mm');
			}	// if ($object->statut == 0 && (! empty($this->draft_watermark)))
			$pdf->SetAlpha(1);
			// Show Folder mark
			if (! empty($this->fold_mark))
			{
				$pdf->Line(0, ($this->page_hauteur)/3, $this->fold_mark, ($this->page_hauteur)/3);
				$pdf->Line($this->page_largeur - $this->fold_mark, ($this->page_hauteur)/3, $this->page_largeur, ($this->page_hauteur)/3);
			}	// if (! empty($this->fold_mark))
			if (! $this->hide_cols)
			{
				// Colonnes
				if ($this->posxcol2 > $this->posxcol1)	$pdf->line($this->posxcol2, $tab_top, $this->posxcol2, $tab_top + $tab_height);
				if ($this->posxcol3 > $this->posxcol2)	$pdf->line($this->posxcol3, $tab_top, $this->posxcol3, $tab_top + $tab_height);
				if ($this->posxcol4 > $this->posxcol3)	$pdf->line($this->posxcol4, $tab_top, $this->posxcol4, $tab_top + $tab_height);
				if ($this->posxcol5 > $this->posxcol4)	$pdf->line($this->posxcol5, $tab_top, $this->posxcol5, $tab_top + $tab_height);
				if ($this->posxcol6 > $this->posxcol5)	$pdf->line($this->posxcol6, $tab_top, $this->posxcol6, $tab_top + $tab_height);
				if ($this->posxcol7 > $this->posxcol6)	$pdf->line($this->posxcol7, $tab_top, $this->posxcol7, $tab_top + $tab_height);
				if ($this->posxcol8 > $this->posxcol7)	$pdf->line($this->posxcol8, $tab_top, $this->posxcol8, $tab_top + $tab_height);
				if ($this->posxcol9 > $this->posxcol8)	$pdf->line($this->posxcol9, $tab_top, $this->posxcol9, $tab_top + $tab_height);
				if ($this->posxcol10 > $this->posxcol9)	$pdf->line($this->posxcol10, $tab_top, $this->posxcol10, $tab_top + $tab_height);
			}	// if (! $this->hide_cols)
			// En-tête tableau
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$this->title_bg ? $pdf->SetTextColor($this->txtcolor[0], $this->txtcolor[1], $this->txtcolor[2]) : $pdf->SetTextColor(0, 0, 0);
			if (empty($hidetop) || $pagenb == 1)
			{
				$pdf->SetXY($this->tableau['desc']['posx'], $tab_top);
				$pdf->MultiCell($this->tableau['desc']['larg'], $this->ht_top_table, $outputlangs->transnoentities("Designation"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
				if (! $this->hide_cols)
				{
					if (! empty($this->show_ref_col))
					{
						$pdf->SetXY($this->tableau['ref']['posx'], $tab_top);
						$pdf->MultiCell($this->tableau['ref']['larg'], $this->ht_top_table, $outputlangs->transnoentities("PDFInfrasRef"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
					}	// if (! empty($this->show_ref_col))
					$pdf->SetXY($this->tableau['qty']['posx'], $tab_top);
					$pdf->MultiCell($this->tableau['qty']['larg'], $this->ht_top_table, $outputlangs->transnoentities("Qty"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
					if($this->product_use_unit)
					{
						$pdf->SetXY($this->tableau['unit']['posx'], $tab_top);
						$pdf->MultiCell($this->tableau['unit']['larg'], $this->ht_top_table, $outputlangs->transnoentities("Unit"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
					}	// if($this->product_use_unit)
					if (empty($this->hide_up))
					{
						$pdf->SetXY($this->tableau['up']['posx'], $tab_top);
						if (empty($this->hide_vat))	$pdf->MultiCell($this->tableau['up']['larg'], $this->ht_top_table, $outputlangs->transnoentities("PriceUHT"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
						else						$pdf->MultiCell($this->tableau['up']['larg'], $this->ht_top_table, $outputlangs->transnoentities("PriceUTTC"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
					}	// if (empty($this->hide_up))
					if (empty($this->hide_vat) && empty($this->hide_vat_col))
					{
						$pdf->SetXY($this->tableau['tva']['posx'], $tab_top);
						$pdf->MultiCell($this->tableau['tva']['larg'], $this->ht_top_table, $outputlangs->transnoentities("VAT"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
					}	// if (empty($this->hide_vat) && empty($this->hide_vat_col))
					if ($this->atleastonediscount && empty($this->hide_discount))
					{
						if ($this->show_up_discounted)
						{
							$pdf->SetXY($this->tableau['updisc']['posx'], $tab_top);
							$pdf->MultiCell($this->tableau['updisc']['larg'], $this->ht_top_table, $outputlangs->transnoentities("PDFInfrasDiscountedPrice"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
						}	// if ($this->show_up_discounted)
						$pdf->SetXY($this->tableau['discount']['posx'], $tab_top);
						$pdf->MultiCell($this->tableau['discount']['larg'], $this->ht_top_table, $outputlangs->transnoentities("ReductionShort"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
					}	// if ($this->atleastonediscount && empty($this->hide_discount))
					$pdf->SetXY($this->tableau['totalht']['posx'], $tab_top);
					if (empty($this->hide_vat))	$pdf->MultiCell($this->tableau['totalht']['larg'], $this->ht_top_table, $outputlangs->transnoentities("TotalHT"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
					else						$pdf->MultiCell($this->tableau['totalht']['larg'], $this->ht_top_table, $outputlangs->transnoentities("TotalTTC"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
				}	// if (! $this->hide_cols)
			}	// if (empty($hidetop) || $pagenb == 1)
		}	// function _tableau(&$pdf, $object, $tab_top, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)

		/********************************************
		*	Show miscellaneous information (payment mode, payment term, ...)
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object			Object to show
		*	@param		int			$posy			Y
		*	@param		Translate	$outputlangs	Langs object
		*	@return		int			$posy			Position pour suite
		********************************************/
		function _tableau_info(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)
		{
			global $conf;
			
			$pdf->startTransaction();
			$default_font_size							= pdf_getPDFFontSize($outputlangs);
			$posytabinfo								= $posy + 1;
			$tabinfo_hl									= $this->tab_hl;
			$pdf->SetFont('', '', $default_font_size - 1);
			$pdf->SetTextColor(0, 0, 0);
			$larg_tabinfo								= $this->larg_tabinfo;
			$larg_col1info								= 40;
			$larg_col2info								= $larg_tabinfo - $larg_col1info;
			$posxtabinfo								= $this->marge_gauche;
			$posxcol2info								= $posxtabinfo + $larg_col1info;
			// If France, show VAT mention if not applicable
			if ($this->emetteur->country_code == 'FR' && $this->franchise == 1)
			{
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$pdf->SetXY($posxtabinfo, $posytabinfo);
				$pdf->MultiCell($larg_tabinfo, $tabinfo_hl, $outputlangs->transnoentities("VATIsNotUsedForInvoice"), 0, 'L', 0);
				$posytabinfo							= $pdf->GetY() + 2;
			}	// if ($this->emetteur->country_code == 'FR' && $this->franchise == 1)
			// Show shipping date
			if (! empty($object->date_livraison))
			{
				$outputlangs->load("sendings");
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$titre									= $outputlangs->transnoentities("DateDeliveryPlanned").' : ';
				$pdf->SetXY($posxtabinfo, $posytabinfo);
				$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, 0, 'L');
				$pdf->SetFont('', '', $default_font_size - 2);
				$dlp									= dol_print_date($object->date_livraison, "daytext", false, $outputlangs, true);
				$pdf->SetXY($posxcol2info, $posytabinfo);
				$pdf->MultiCell($larg_col2info, $tabinfo_hl, $dlp, 0, 'L');
				$posytabinfo							= $pdf->GetY() + 1;
			}	// if (! empty($object->date_livraison))
			elseif ($object->availability_code || $object->availability)    // Show availability conditions
			{
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$titre									= $outputlangs->transnoentities("AvailabilityPeriod").' : ';
				$pdf->SetXY($posxtabinfo, $posytabinfo);
				$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, 0, 'L');
				$pdf->SetFont('', '', $default_font_size - 2);
				$lib_availability						= $outputlangs->transnoentities("AvailabilityType".$object->availability_code) != ('AvailabilityType'.$object->availability_code) ? $outputlangs->transnoentities("AvailabilityType".$object->availability_code) : $outputlangs->convToOutputCharset(isset($object->availability) ? $object->availability : '');
				$lib_availability						= str_replace('\n', "\n", $lib_availability);
				$pdf->SetXY($posxcol2info, $posytabinfo);
				$pdf->MultiCell($larg_col2info, $tabinfo_hl, $lib_availability, 0, 'L');
				$posytabinfo							= $pdf->GetY() + 1;
			}	// elseif ($object->availability_code || $object->availability)
			// Show shipping method
			if ($object->shipping_method_id > 0)
			{
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$titre									= $outputlangs->transnoentities("SendingMethod").' : ';
				$pdf->SetXY($posxtabinfo, $posytabinfo);
				$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, 0, 'L');
				$pdf->SetFont('', '', $default_font_size - 2);
				$shipping_code							= $outputlangs->getLabelFromKey($this->db, $object->shipping_method_id, 'c_shipment_mode', 'rowid', 'code');	// Get code using getLabelFromKey
				$lib_shipping_method					= $outputlangs->trans("SendingMethod".strtoupper($shipping_code));
				$pdf->SetXY($posxcol2info, $posytabinfo);
				$pdf->MultiCell($larg_col2info, $tabinfo_hl, $lib_shipping_method, 0, 'L');
				$posytabinfo							= $pdf->GetY() + 1;
			}	//if ($object->shipping_method_id > 0)
			// Show payments conditions
			if ($object->cond_reglement_code || $object->cond_reglement)
			{
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$titre									= $outputlangs->transnoentities("PaymentConditions").' : ';
				$pdf->SetXY($posxtabinfo, $posytabinfo);
				$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, 0, 'L');
				$pdf->SetFont('', '', $default_font_size - 2);
				$lib_condition_paiement					= $outputlangs->transnoentities("PaymentCondition".$object->cond_reglement_code) != ('PaymentCondition'.$object->cond_reglement_code) ? $outputlangs->transnoentities("PaymentCondition".$object->cond_reglement_code) : $outputlangs->convToOutputCharset($object->cond_reglement_doc);
				$lib_condition_paiement					= str_replace('\n', "\n", $lib_condition_paiement);
				$pdf->SetXY($posxcol2info, $posytabinfo);
				$pdf->MultiCell($larg_col2info, $tabinfo_hl, $lib_condition_paiement, 0, 'L');
				$posytabinfo							= $pdf->GetY() + 1;
			}	// if ($object->cond_reglement_code || $object->cond_reglement)
			// Show payment mode
			if ($object->mode_reglement_code && $object->mode_reglement_code != 'CHQ' && $object->mode_reglement_code != 'VIR')
			{
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$titre									= $outputlangs->transnoentities("PaymentMode").' : ';
				$pdf->SetXY($posxtabinfo, $posytabinfo);
				$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, 0, 'L');
				$pdf->SetFont('', '', $default_font_size - 2);
				$lib_mode_reg							= $outputlangs->transnoentities("PaymentType".$object->mode_reglement_code) != ('PaymentType'.$object->mode_reglement_code) ? $outputlangs->transnoentities("PaymentType".$object->mode_reglement_code) : $outputlangs->convToOutputCharset($object->mode_reglement);
				$pdf->SetXY($posxcol2info, $posytabinfo);
				$pdf->MultiCell($larg_col2info, $tabinfo_hl, $lib_mode_reg, 0, 'L');
				$posytabinfo							= $pdf->GetY() + 1;
			}	// if ($object->mode_reglement_code && $object->mode_reglement_code != 'CHQ' && $object->mode_reglement_code != 'VIR')
			// Show payment mode CHQ
			if (empty($object->mode_reglement_code) || $object->mode_reglement_code == 'CHQ')
			{
				// Si mode reglement non force ou si force a CHQ
				if (! empty($this->chq_num))
				{
					$diffsizetitle=(empty($this->diffsize_title)?3:$this->diffsize_title);
					if ($this->chq_num > 0)
					{
						$account						= new Account($this->db);
						$account->fetch($this->chq_num);
						$pdf->SetFont('', 'B', $default_font_size - $diffsizetitle);
						$pdf->SetXY($posxtabinfo, $posytabinfo);
						$pdf->MultiCell($larg_tabinfo, $tabinfo_hl, $outputlangs->transnoentities('PaymentByChequeOrderedTo',$account->proprio),0,'L',0);
						$posytabinfo					= $pdf->GetY() + 1;
						if (empty($this->hidechq_address))
						{
							$pdf->SetFont('', '', $default_font_size - $diffsizetitle);
							$pdf->SetXY($posxtabinfo, $posytabinfo);
							$pdf->MultiCell($larg_tabinfo, $tabinfo_hl, $outputlangs->convToOutputCharset($account->owner_address), 0, 'L', 0);
							$posytabinfo				= $pdf->GetY() + 1;
						}	// if (empty($this->hidechq_address))
					}	// if ($this->chq_num > 0)
					if ($this->chq_num == -1)
					{
						$pdf->SetFont('', 'B', $default_font_size - $diffsizetitle);
						$pdf->SetXY($posxtabinfo, $posytabinfo);
						$pdf->MultiCell($larg_tabinfo, $tabinfo_hl, $outputlangs->transnoentities('PaymentByChequeOrderedTo',$this->emetteur->name),0,'L',0);
						$posytabinfo					= $pdf->GetY() + 1;
						if (empty($this->hidechq_address))
						{
							$pdf->SetFont('', '', $default_font_size - $diffsizetitle);
							$pdf->SetXY($posxtabinfo, $posytabinfo);
							$pdf->MultiCell($larg_tabinfo, $tabinfo_hl, $outputlangs->convToOutputCharset($this->emetteur->getFullAddress()), 0, 'L', 0);
							$posytabinfo				= $pdf->GetY() + 1;
						}	// if (empty($this->hidechq_address))
					}	// if ($this->chq_num == -1)
				}	// if (! empty($this->chq_num))
			}	// if (empty($object->mode_reglement_code) || $object->mode_reglement_code == 'CHQ')
			// If payment mode not forced or forced to VIR, show payment with BAN
			if (empty($object->mode_reglement_code) || $object->mode_reglement_code == 'VIR')
			{
				if (! empty($object->fk_account) || ! empty($object->fk_bank) || ! empty($this->rib_num))
				{
					$bankid								= (empty($object->fk_account) ? $this->rib_num : $object->fk_account);
					if (! empty($object->fk_bank)) $bankid=$object->fk_bank;   // For backward compatibility when object->fk_account is forced with object->fk_bank
					$account							= new Account($this->db);
					$account->fetch($bankid);
					$posytabinfo						= pdf_bank($pdf, $outputlangs, $posxtabinfo, $posytabinfo, $account, 0, $default_font_size);
					$posytabinfo						+= 1;
				}	// if (! empty($object->fk_account) || ! empty($object->fk_bank) || ! empty($this->rib_num))
			}	// if (empty($object->mode_reglement_code) || $object->mode_reglement_code == 'VIR')
			if ($calculseul)
			{
				$heightforinfo						= $posytabinfo - $posy;
				$pdf->rollbackTransaction(true);
				return $heightforinfo;
			}	// if ($calculseul)
			else
			{
				$pdf->commitTransaction();
				return $posytabinfo;
			}	// else // if ($calculseul)
		}	// function _tableau_info(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)

		/********************************************
		*	Show total to pay
		*
		*	@param		PDF			$pdf            Object PDF
		*	@param		Facture		$object         Object invoice
		*	@param		int			$posy			y
		*	@param		Translate	$outputlangs	Objet langs
		*	@return		int							Position pour suite
		********************************************/
		function _tableau_tot(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)
		{
			global $conf;
			
			$pdf->startTransaction();
			$default_font_size					= pdf_getPDFFontSize($outputlangs);
			$posytabtot							= $posy + 1;
			$tabtot_hl							= $this->tab_hl;
			$pdf->SetFont('', '', $default_font_size - 1);
			$bg_color							= explode(',', $this->bg_color);
			$pdf->SetDrawColor($bg_color[0], $bg_color[1], $bg_color[2]);
			$pdf->SetTextColor(0, 0, 0);
			// Tableau total
			$larg_tabtotal						= $this->larg_tabtotal;
			$larg_col2total						= $this->larg_totalht;
			$larg_col1total						= $larg_tabtotal - $larg_col2total;
			$posxtabtotal						= $this->posxtabtotal;
			$posxcol2total						= $this->posxtabtotal + $larg_col1total;
			$index								= 0;
			// Total HT
			$this->atleastoneratenotnull		= 0;
			if (empty($this->hide_vat) || $this->show_ttc_vat_tot)
			{
				$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
				$pdf->MultiCell($larg_col1total, $tabtot_hl, $outputlangs->transnoentities("TotalHT"), 0, 'L', 0);
				$total_ht						= ($conf->multicurrency->enabled && $object->multicurrency_tx != 1 ? $object->multicurrency_total_ht : $object->total_ht);
				$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
				$pdf->MultiCell($larg_col2total, $tabtot_hl, price($total_ht + (! empty($object->remise) ? $object->remise : 0), 0, $outputlangs), 0, 'R', 0);
				// Show VAT by rates and total
				$tvaisnull	= ((! empty($this->tva) && count($this->tva) == 1 && isset($this->tva['0.000']) && is_float($this->tva['0.000'])) ? true : false);
				if (! empty($this->hide_vat_ISNULL) && $tvaisnull)
				{
					// Nothing to do
				}
				else
				{
					//Local tax 1 before VAT
					foreach ($this->localtax1 as $localtax_type => $localtax_rate)
					{
						if (in_array((string) $localtax_type, array('1', '3', '5'))) continue;
						foreach ($localtax_rate as $tvakey => $tvaval)
						{
							if ($tvakey != 0)    // On affiche pas taux 0
							{
								$index++;
								$pdf->SetAlpha($this->alpha);
								$pdf->RoundedRect($posxtabtotal, $posytabtot + ($tabtot_hl * $index), $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF' ,null , explode(',', $this->bg_color));
								$pdf->SetAlpha(1);
								$tvacompl		= '';
								if (preg_match('/\*/', $tvakey))
								{
									$tvakey		= str_replace('*', '', $tvakey);
									$tvacompl	= " (".$outputlangs->transnoentities("NonPercuRecuperable").")";
								}	// if (preg_match('/\*/', $tvakey))
								$totalvat		= $outputlangs->transcountrynoentities("TotalLT1", $this->emetteur->country_code).' ';
								$totalvat		.= vatrate(abs($tvakey), 1).$tvacompl;
								$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col1total, $tabtot_hl, $totalvat, 0, 'L', 0);
								$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col2total, $tabtot_hl, price($tvaval, 0, $outputlangs), 0, 'R', 0);
							}	// if ($tvakey != 0)
						}	// foreach ($localtax_rate as $tvakey => $tvaval)
					}	// foreach ($this->localtax1 as $localtax_type => $localtax_rate)
					//Local tax 2 before VAT
					foreach ($this->localtax2 as $localtax_type => $localtax_rate)
					{
						if (in_array((string) $localtax_type, array('1', '3', '5'))) continue;
						foreach ($localtax_rate as $tvakey => $tvaval)
						{
							if ($tvakey != 0)    // On affiche pas taux 0
							{
								$index++;
								$pdf->SetAlpha($this->alpha);
								$pdf->RoundedRect($posxtabtotal, $posytabtot + ($tabtot_hl * $index), $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF' ,null , explode(',', $this->bg_color));
								$pdf->SetAlpha(1);
								$tvacompl		= '';
								if (preg_match('/\*/', $tvakey))
								{
									$tvakey		= str_replace('*', '', $tvakey);
									$tvacompl	= " (".$outputlangs->transnoentities("NonPercuRecuperable").")";
								}	// if (preg_match('/\*/', $tvakey))
								$totalvat		= $outputlangs->transcountrynoentities("TotalLT2", $this->emetteur->country_code).' ';
								$totalvat		.= vatrate(abs($tvakey), 1).$tvacompl;
								$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col1total, $tabtot_hl, $totalvat, 0, 'L', 0);
								$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col2total, $tabtot_hl, price($tvaval, 0, $outputlangs), 0, 'R', 0);
							}	// if ($tvakey != 0)
						}	// foreach ($localtax_rate as $tvakey => $tvaval)
					}	// foreach ($this->localtax2 as $localtax_type => $localtax_rate)
					// VAT
					foreach ($this->tva as $tvakey => $tvaval)
					{
						if ($tvakey > 0)    // On affiche pas taux 0
						{
							$this->atleastoneratenotnull++;
							$index++;
							$pdf->SetAlpha($this->alpha);
							$pdf->RoundedRect($posxtabtotal, $posytabtot + ($tabtot_hl * $index), $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF' ,null , explode(',', $this->bg_color));
							$pdf->SetAlpha(1);
							$tvacompl			= '';
							if (preg_match('/\*/', $tvakey))
							{
								$tvakey			= str_replace('*', '', $tvakey);
								$tvacompl		= " (".$outputlangs->transnoentities("NonPercuRecuperable").")";
							}	// if (preg_match('/\*/', $tvakey))
							$totalvat			= $outputlangs->transcountrynoentities("TotalVAT", $this->emetteur->country_code).' ';
							$totalvat			.= vatrate($tvakey, 1).$tvacompl;
							$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
							$pdf->MultiCell($larg_col1total, $tabtot_hl, $totalvat, 0, 'L', 0);
							$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
							$pdf->MultiCell($larg_col2total, $tabtot_hl, price($tvaval, 0, $outputlangs), 0, 'R', 0);
						}	// if ($tvakey > 0)
					}	// foreach ($this->tva as $tvakey => $tvaval)
					//Local tax 1 after VAT
					foreach ($this->localtax1 as $localtax_type => $localtax_rate)
					{
						if (in_array((string) $localtax_type, array('2', '4', '6'))) continue;
						foreach ($localtax_rate as $tvakey => $tvaval)
						{
							if ($tvakey != 0)    // On affiche pas taux 0
							{
								$index++;
								$pdf->SetAlpha($this->alpha);
								$pdf->RoundedRect($posxtabtotal, $posytabtot + ($tabtot_hl * $index), $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF' ,null , explode(',', $this->bg_color));
								$pdf->SetAlpha(1);
								$tvacompl		= '';
								if (preg_match('/\*/', $tvakey))
								{
									$tvakey		= str_replace('*', '', $tvakey);
									$tvacompl	= " (".$outputlangs->transnoentities("NonPercuRecuperable").")";
								}	// if (preg_match('/\*/', $tvakey))
								$totalvat		= $outputlangs->transcountrynoentities("TotalLT1", $this->emetteur->country_code).' ';
								$totalvat		.= vatrate(abs($tvakey), 1).$tvacompl;
								$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col1total, $tabtot_hl, $totalvat, 0, 'L', 0);
								$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col2total, $tabtot_hl, price($tvaval, 0, $outputlangs), 0, 'R', 0);
							}	// if ($tvakey != 0)
						}	// foreach ($localtax_rate as $tvakey => $tvaval)
					}	// foreach ($this->localtax1 as $localtax_type => $localtax_rate)
					//Local tax 2 after VAT
					foreach ($this->localtax2 as $localtax_type => $localtax_rate)
					{
						if (in_array((string) $localtax_type, array('2', '4', '6'))) continue;
						foreach ($localtax_rate as $tvakey => $tvaval)
						{
							if ($tvakey != 0)    // On affiche pas taux 0
							{
								$index++;
								$pdf->SetAlpha($this->alpha);
								$pdf->RoundedRect($posxtabtotal, $posytabtot + ($tabtot_hl * $index), $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF' ,null , explode(',', $this->bg_color));
								$pdf->SetAlpha(1);
								$tvacompl		= '';
								if (preg_match('/\*/', $tvakey))
								{
									$tvakey		= str_replace('*', '', $tvakey);
									$tvacompl	= " (".$outputlangs->transnoentities("NonPercuRecuperable").")";
								}	// if (preg_match('/\*/', $tvakey))
								$totalvat		= $outputlangs->transcountrynoentities("TotalLT2", $this->emetteur->country_code).' ';
								$totalvat		.= vatrate(abs($tvakey), 1).$tvacompl;
								$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col1total, $tabtot_hl, $totalvat, 0, 'L', 0);
								$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
								$pdf->MultiCell($larg_col2total, $tabtot_hl, price($tvaval, 0, $outputlangs), 0, 'R', 0);
							}	// if ($tvakey != 0)
						}	// foreach ($localtax_rate as $tvakey => $tvaval)
					}	// foreach ($this->localtax2 as $localtax_type => $localtax_rate)
				}	// else	// if (! empty($this->hide_vat_IFNULL) && $tvaisnull)
				$index++;
			}	// if (empty($this->hide_vat) || $this->show_ttc_vat_tot)
			// Total TTC
			$pdf->RoundedRect($posxtabtotal, $posytabtot + ($tabtot_hl * $index), $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF' ,null , explode(',', $this->bg_color));
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$this->title_bg ? $pdf->SetTextColor($this->txtcolor[0], $this->txtcolor[1], $this->txtcolor[2]) : $pdf->SetTextColor(0, 0, 0);
			$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
			$pdf->MultiCell($larg_col1total, $tabtot_hl, $outputlangs->transnoentities("TotalTTC"), 0, 'L', 0);
			$total_ttc							= ($conf->multicurrency->enabled && $object->multicurrency_tx != 1) ? $object->multicurrency_total_ttc : $object->total_ttc;
			$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
			$pdf->MultiCell($larg_col2total, $tabtot_hl, price($total_ttc, 0, $outputlangs), 0, 'R', 0);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			if ($conf->multicurrency->enabled && $object->multicurrency_tx != 1 && $this->show_tot_local_cur)
			{
				$index++;
				$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
				$pdf->MultiCell($larg_col1total, $tabtot_hl, $outputlangs->transnoentities("TotalTTC")." (".$conf->currency.")", 0, 'L', 0);
				$total_ttc_loc_cur				= $object->total_ttc;
				$pdf->SetXY($posxcol2total, $posytabtot + ($tabtot_hl * $index));
				$pdf->MultiCell($larg_col2total, $tabtot_hl, price($total_ttc_loc_cur, 0, $outputlangs), 0, 'R', 0);
			}	// if ($conf->multicurrency->enabled && $object->multicurrency_tx != 1 && $this->show_tot_local_cur)
			$pdf->SetFont('', '', $default_font_size - 1);
			if (!empty($this->number_words))
			{
				$index++;
				$savcurrency					= $conf->currency;
				$conf->currency					= !empty($object->multicurrency_code) ? $object->multicurrency_code : $conf->currency;
				$total_ttc_words				= $outputlangs->transnoentities("PDFInfrasOrderArrete").' : '.$outputlangs->getLabelFromNumber($total_ttc, 1);
				$pdf->SetXY($posxtabtotal, $posytabtot + ($tabtot_hl * $index));
				$pdf->MultiCell($larg_tabtotal, $tabtot_hl, $total_ttc_words, 0, 'L', 0);
				$conf->currency					= $savcurrency;
			}	// if (!empty($this->number_words))
			$posytabtot							= $pdf->GetY() + 1;
			if ($calculseul)
			{
				$heightfortot					= $posytabtot - $posy;
				$pdf->rollbackTransaction(true);
				return $heightfortot;
			}	// if ($calculseul)
			else
			{
				$pdf->commitTransaction();
				return $posytabtot;
			}	// else // if ($calculseul)
		}	// function _tableau_tot(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)

		/********************************************
		*	Show area for the customer to sign
		*
		*	@param		PDF			$pdf            Object PDF
		*	@param		Facture		$object         Object invoice
		*	@param		int			$posy			y
		*	@param		Translate	$outputlangs	Objet langs
		*	@return		int							Position pour suite
		********************************************/
		function _signature_area(&$pdf, $object, $posy, $outputlangs)
		{
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$signarea_top		= $posy + 1;
			$signarea_hl		= $this->tab_hl;
			$pdf->SetFont('', '', $default_font_size - 2);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			$larg_signarea		= $this->larg_tabtotal;
			$posxsignarea		= $this->posxtabtotal;
			$pdf->SetXY($posxsignarea + $this->Rounded_rect, $signarea_top);
			$pdf->MultiCell($larg_signarea, $signarea_hl, $outputlangs->transnoentities("ProposalCustomerSignature"), 0, 'L', 0);
			$pdf->RoundedRect($posxsignarea, $signarea_top + $signarea_hl, $larg_signarea, $this->ht_signarea, $this->Rounded_rect, '1111');
			return ($signarea_top + ($signarea_hl * 7));
		}	// function _signature_area(&$pdf, $object, $posy, $outputlangs)

		/********************************************
		*	Show footer of page. Need this->emetteur object
		*
		*	@param		PDF			$pdf     		The PDF factory
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		Societe		$fromcompany	Object company
		*	@param		int			$marge_basse	Margin bottom we use for the autobreak
		*	@param		int			$marge_gauche	Margin left
		*	@param		int			$page_hauteur	Page height
		*	@param		Object		$object			Object shown in PDF
		*	@param		int			$showdetails	Show company details into footer. This param seems to not be used by standard version.
													(10=minimum, 11 = 1 + Logos de pied, 20 = Show address and managers, 21 = Show 2 + Logos de pied)
		*	@param		int			$hidesupline	Completly hide the line up to footer (for some edition with only table)
		*	@param		int			$calculseul		Arrête la fonction au calcul de hauteur nécessaire
		*	@return		int							Return height of bottom margin including footer text
		********************************************/
		function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
		{
			global $conf, $langs;
			
			$showdetails									= 10;
			if (! empty($this->type_foot))	$showdetails	= 20;
			if (! empty($this->pied))		$showdetails	+= 1;
			return pdf_InfraS_pagefoot($pdf, $outputlangs, $this->emetteur, $this->formatpage, $showdetails, 0, $calculseul, $this->pied, $this->maxsizeimgfoot, $this->hidepagenum);
		}	// function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
	}	// class pdf_InfraS_devis extends ModelePDFPropales
?>