<?php
	/************************************************
	* Copyright (C) 2016	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		htdocs/custom/infras/core/modules/commande/doc/pdf_InfraS_proforma.modules.php
	* 	\ingroup	InfraS
	* 	\brief		Class file for InfraS PDF proforma
	************************************************/

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	dol_include_once('/infraspack/core/modules/commande/doc/pdf_InfraS_commande.modules.php');
	dol_include_once('/infraspack/core/lib/infras.pdf.lib.php');

	/************************************************
	 *	Class to generate PDF proforma order InfraS
	************************************************/
	class pdf_InfraS_proforma extends pdf_InfraS_commande
	{
		/********************************************
		 *	Constructor
		 *
		 *  @param		DoliDB		$db      Database handler
		********************************************/
		function __construct($db)
		{
			global $conf, $langs, $mysoc;

			parent::__construct($db);

			$this->name			= $langs->trans('PDFInfraSProformaName');
			$this->description	= $langs->trans('PDFInfraSProformaDescription');
		}	// function __construct($db)

		/********************************************
		 *  Show top header of page.
		 *
		 *  @param	PDF			$pdf     		Object PDF
		 *  @param  Object		$object     	Object to show
		 *  @param  int	    	$showaddress    0=no, 1=yes
		 *  @param  Translate	$outputlangs	Object lang for output
		 *  @param	string		$titlekey		Translation key to show as title of document
		*	@return	array		$hauteurhead	'totalhead'		= hight of header
		*										'hauteurcadre	= hight of frame
		********************************************/
		function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "InvoiceProForma")
		{
			global $conf, $langs, $hookmanager;

			return parent::_pagehead($pdf, $object, $showaddress, $outputlangs, $titlekey);
		}	// function _pagehead($pdf, $object, $showaddress, $outputlangs, $titlekey = "InvoiceProForma")

		/********************************************
		 *  Show top small header of page.
		 *
		 *  @param	PDF			$pdf     		Object PDF
		 *  @param  Object		$object     	Object to show
		 *  @param  int	    	$showaddress    0=no, 1=yes
		 *  @param  Translate	$outputlangs	Object lang for output
		 *  @param	string		$titlekey		Translation key to show as title of document
		 *  @return	void
		********************************************/
		function _pagesmallhead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "InvoiceProForma")
		{
			global $conf, $langs, $hookmanager;

			parent::_pagesmallhead($pdf, $object, $showaddress, $outputlangs, $titlekey);
		}	// function _pagesmallhead($pdf, $object, $showaddress, $outputlangs, $titlekey = "InvoiceProForma");
	}	// class pdf_InfraS_proforma extends pdf_InfraS_commande
?>