<?php
	/************************************************
	* Copyright (C) 2016-2017	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		htdocs/custom/infras/core/modules/propale/doc/pdf_InfraS_devis.modules.php
	* 	\ingroup	InfraS
	* 	\brief		Class file for InfraS PDF commercial proposal
	************************************************/

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/modules/contract/modules_contract.php';
	require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	dol_include_once('/infraspack/core/lib/infras.pdf.lib.php');

	/************************************************
	*	Class to generate PDF proposal InfraS
	************************************************/
	class pdf_InfraS_contract extends ModelePDFContract
	{
		public $db;
		public $name;
		public $description;
		public $type;
		public $phpmin	= array(5, 4);
		public $version	= 'dolibarr';
		public $page_largeur;
		public $page_hauteur;
		public $format;
		public $marge_gauche;
		public $marge_droite;
		public $marge_haute;
		public $marge_basse;
		public $emetteur;
		public $recipient;

		/********************************************
		*	Constructor
		*
		*	@param		DoliDB		$db      Database handler
		********************************************/
		function __construct($db)
		{
			global $conf, $langs, $mysoc;

			if((float)DOL_VERSION >= 8.0)	$langs->loadLangs(array("main", "dict", "companies", "contracts", "infraspack@infraspack"));
			else
			{
				$langs->load("main");
				$langs->load("dict");
				$langs->load("companies");
				$langs->load("contracts");
				$langs->load("infraspack@infraspack");
			}	// else	// if((float)DOL_VERSION >= 8.0)
			
			$this->db									= $db;
			$this->name									= $langs->trans('PDFInfraSCrontractName');
			$this->description							= $langs->trans('PDFInfraSCrontractDescription');
			$this->type									= 'pdf';
			$formatarray								= pdf_InfraS_getFormat();
			$this->page_largeur							= $formatarray['width'];
			$this->page_hauteur							= $formatarray['height'];
			$this->format								= array($this->page_largeur, $this->page_hauteur);
			$this->marge_gauche							= isset($conf->global->MAIN_PDF_MARGIN_LEFT)					? $conf->global->MAIN_PDF_MARGIN_LEFT : 10;
			$this->marge_droite							= isset($conf->global->MAIN_PDF_MARGIN_RIGHT)					? $conf->global->MAIN_PDF_MARGIN_RIGHT : 10;
			$this->marge_haute							= isset($conf->global->MAIN_PDF_MARGIN_TOP)						? $conf->global->MAIN_PDF_MARGIN_TOP : 10;
			$this->marge_basse							= isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)					? $conf->global->MAIN_PDF_MARGIN_BOTTOM : 10;
			$this->font									= isset($conf->global->INFRAS_PDF_FONT)							? $conf->global->INFRAS_PDF_FONT : 'Helvetica';
			$this->use_fpdf								= isset($conf->global->MAIN_USE_FPDF)							? $conf->global->MAIN_USE_FPDF : 0;
			$this->disable_fpdi							= isset($conf->global->MAIN_DISABLE_FPDI)						? $conf->global->MAIN_DISABLE_FPDI : 0;
			$this->add_pdf_bg							= isset($conf->global->MAIN_ADD_PDF_BACKGROUND)					? $conf->global->MAIN_ADD_PDF_BACKGROUND : 0;
			$this->Rounded_rect							= isset($conf->global->INFRAS_PDF_ROUNDED_REC)					? $conf->global->INFRAS_PDF_ROUNDED_REC : 0;
			$this->with_picture							= isset($conf->global->INFRAS_PDF_WITH_PICTURE)					? $conf->global->INFRAS_PDF_WITH_PICTURE : 0;
			$this->old_path_photo						= isset($conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO)			? $conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO : 0;
			$this->cat_hq_image							= isset($conf->global->CAT_HIGH_QUALITY_IMAGES)					? $conf->global->CAT_HIGH_QUALITY_IMAGES : 0;
			$this->small_head2							= isset($conf->global->INFRAS_PDF_SMALL_HEAD_2)					? $conf->global->INFRAS_PDF_SMALL_HEAD_2 : 0;
			$this->emetteur								= $mysoc;
			if (empty($this->emetteur->country_code))	$this->emetteur->country_code									= substr($langs->defaultlang, -2);
			$this->show_sign_area						= isset($conf->global->INFRAS_PDF_CONTRACT_SHOW_SIGNATURE)		? $conf->global->INFRAS_PDF_CONTRACT_SHOW_SIGNATURE : 1;
			$this->formatpage							= array('largeur'=>$this->page_largeur, 'hauteur'=>$this->page_hauteur, 'mgauche'=>$this->marge_gauche, 
																'mdroite'=>$this->marge_droite, 'mhaute'=>$this->marge_haute, 'mbasse'=>$this->marge_basse);
			$this->includealias							= isset($conf->global->PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME)	? $conf->global->PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME : 0;
			$this->wpicture								= isset($conf->global->INFRAS_PDF_PICTURE_WIDTH)				? $conf->global->INFRAS_PDF_PICTURE_WIDTH : 20;
			$this->hpicture								= isset($conf->global->INFRAS_PDF_PICTURE_HEIGHT)				? $conf->global->INFRAS_PDF_PICTURE_HEIGHT : 32;
			$this->dash_between_line					= isset($conf->global->MAIN_PDF_DASH_BETWEEN_LINES)				? $conf->global->MAIN_PDF_DASH_BETWEEN_LINES : 1;
			$this->hide_top_table						= isset($conf->global->INFRAS_PDF_HIDE_TOP_TABLE)				? $conf->global->INFRAS_PDF_HIDE_TOP_TABLE : 0;
			$this->CGV									= isset($conf->global->INFRAS_PDF_CGV)							? $conf->global->INFRAS_PDF_CGV : '';
			$this->main_umask							= isset($conf->global->MAIN_UMASK)								? $conf->global->MAIN_UMASK : '0755';
			$this->use_comp_name_contact				= isset($conf->global->MAIN_USE_COMPANY_NAME_OF_CONTACT)		? $conf->global->MAIN_USE_COMPANY_NAME_OF_CONTACT : 0;

			$this->use_iso_location						= isset($conf->global->MAIN_PDF_USE_ISO_LOCATION)				? $conf->global->MAIN_PDF_USE_ISO_LOCATION : 0;
			$this->show_recep_details					= isset($conf->global->INFRAS_PDF_SHOW_RECEP_DETAILS)			? $conf->global->INFRAS_PDF_SHOW_RECEP_DETAILS : 0;
			$this->invert_sender_recipient				= isset($conf->global->MAIN_INVERT_SENDER_RECIPIENT)			? $conf->global->MAIN_INVERT_SENDER_RECIPIENT : 0;
			$this->hide_recep_frame						= isset($conf->global->INFRAS_PDF_HIDE_RECEP_FRAME)				? $conf->global->INFRAS_PDF_HIDE_RECEP_FRAME : 0;
			$this->bg_color								= isset($conf->global->INFRAS_PDF_BACKGROUND_COLOR)				? $conf->global->INFRAS_PDF_BACKGROUND_COLOR : '';
			$this->title_bg								= isset($conf->global->INFRAS_PDF_TITLE_BG)						? $conf->global->INFRAS_PDF_TITLE_BG : 0;
			$this->watermark_i_opacity					= isset($conf->global->INFRAS_PDF_I_WATERMARK_OPACITY)			? $conf->global->INFRAS_PDF_I_WATERMARK_OPACITY : 1;
			$this->image_watermark						= isset($conf->global->INFRAS_PDF_IMAGE_WATERMARK)				? $conf->global->INFRAS_PDF_IMAGE_WATERMARK : '';
			$this->watermark_t_opacity					= isset($conf->global->INFRAS_PDF_T_WATERMARK_OPACITY)			? $conf->global->INFRAS_PDF_T_WATERMARK_OPACITY : 10;
			$this->draft_watermark						= isset($conf->global->PROPALE_DRAFT_WATERMARK)					? $conf->global->PROPALE_DRAFT_WATERMARK : '';
			$this->fold_mark							= isset($conf->global->INFRAS_PDF_FOLD_MARK)					? $conf->global->INFRAS_PDF_FOLD_MARK : 0;
			$this->txtcolor								= explode(',', pdf_InfraS_txt_color($this->bg_color));
			$this->alpha								= 0.2;
			$this->ht_signarea							= isset($conf->global->INFRAS_PDF_HT_SIGN_AREA)					? $conf->global->INFRAS_PDF_HT_SIGN_AREA : 24;
			$this->type_foot							= isset($conf->global->INFRAS_PDF_TYPE_FOOT)					? $conf->global->INFRAS_PDF_TYPE_FOOT : 0;
			$this->wpicturefoot							= isset($conf->global->INFRAS_PDF_PICTURE_FOOT_WIDTH)			? $conf->global->INFRAS_PDF_PICTURE_FOOT_WIDTH : 188;
			$this->hpicturefoot							= isset($conf->global->INFRAS_PDF_PICTURE_FOOT_HEIGHT)			? $conf->global->INFRAS_PDF_PICTURE_FOOT_HEIGHT : 12;
			$this->maxsizeimgfoot						= array('largeur'=>$this->wpicturefoot, 'hauteur'=>$this->hpicturefoot);
			$this->hidepagenum							= isset($conf->global->INFRAS_PDF_HIDE_PAGE_NUM)				? $conf->global->INFRAS_PDF_HIDE_PAGE_NUM : 0;
			$this->option_logo							= 1;	// Affiche logo
			$this->option_tva							= 0;	// Gere option tva FACTURE_TVAOPTION
			$this->option_modereg						= 0;	// Affiche mode reglement
			$this->option_condreg						= 0;	// Affiche conditions reglement
			$this->option_codeproduitservice			= 0;	// Affiche code produit-service
			$this->option_multilang						= 1;	// Dispo en plusieurs langues
			$this->option_escompte						= 0;	// Affiche si il y a eu escompte
			$this->option_credit_note					= 0;	// Support credit notes
			$this->option_freetext						= 1;	// Support add of a personalised text
			$this->option_draft_watermark				= 1;	// Support add of a watermark on drafts
		}	// function __construct($db)

		/********************************************
		*	Function to build pdf onto disk
		*
		*	@param		Object		$object				Object to generate
		*	@param		Translate	$outputlangs		Lang output object
		*	@param		string		$srctemplatepath	Full path of source filename for generator using a template file
		*	@param		int			$hidedetails		Do not show line details (inutilisée ! laissé pour la compatibilité)
		*	@param		int			$hidedesc			Do not show desc
		*	@param		int			$hideref			Do not show ref
		*	@return     int             				1=OK, 0=KO
		********************************************/
		function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)
		{
			global $user, $langs, $conf, $db, $hookmanager;

			if (! is_object($outputlangs)) $outputlangs	= $langs;
			// For backward compatibility with FPDF, force output charset to ISO, because FPDF expect text to be encoded in ISO
			if (! empty($this->use_fpdf)) $outputlangs->charset_output	= 'ISO-8859-1';
			
			if((float)DOL_VERSION >= 8.0)	$outputlangs->loadLangs(array("main", "dict", "companies", "contracts", "infraspack@infraspack"));
			else
			{
				$outputlangs->load("main");
				$outputlangs->load("dict");
				$outputlangs->load("companies");
				$outputlangs->load("contracts");
				$outputlangs->load("infraspack@infraspack");
			}	// else	// if((float)DOL_VERSION >= 8.0)

			if ($conf->contrat->dir_output)
			{
				$object->fetch_thirdparty();
				// Definition of $dir and $file
				if ($object->specimen)
				{
					$dir				= $conf->contrat->dir_output;
					$file				= $dir."/SPECIMEN.pdf";
				}	// if ($object->specimen)
				else
				{
					$objectref			= dol_sanitizeFileName($object->ref);
					$dir				= $conf->contrat->dir_output."/".$objectref;
					$file				= $dir."/".$objectref.".pdf";
				}	// else	// if ($object->specimen)
				if (! file_exists($dir))
				{
					if (dol_mkdir($dir) < 0)
					{
						$this->error	= $langs->transnoentities("ErrorCanNotCreateDir", $dir);
						return 0;
					}	// if (dol_mkdir($dir) < 0)
				}	// if (! file_exists($dir))
				if (file_exists($dir))
				{
					if (! is_object($hookmanager))	// Add pdfgeneration hook
					{
						include_once DOL_DOCUMENT_ROOT.'/core/class/hookmanager.class.php';
						$hookmanager					= new HookManager($this->db);
					}	// if (! is_object($hookmanager))
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters			= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook			= $hookmanager->executeHooks('beforePDFCreation', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
					$this->pied			= $hookmanager->resArray['pied'];
					$this->chkCGV		= $hookmanager->resArray['chkCGV'];
					$nblignes			= count($object->lines);	// Set nblignes with the new facture lines content after hook
					// Create pdf instance
					$pdf				= pdf_getInstance($this->format);
					$default_font_size	= pdf_getPDFFontSize($outputlangs);																								// Must be after pdf_getInstance
					$pdf->SetAutoPageBreak(1, 0);
					if (class_exists('TCPDF'))
					{
						$pdf->setPrintHeader(false);
						$pdf->setPrintFooter(false);
					}	// if (class_exists('TCPDF'))
					$pdf->SetFont($this->font);
					// Set path to the background PDF File
					if ((empty($this->disable_fpdi) || (float)DOL_VERSION >= 8.0) && ! empty($this->add_pdf_bg))
					{
						$pagecount	= $pdf->setSourceFile($conf->mycompany->dir_output.'/'.$this->add_pdf_bg);
						$tplidx		= $pdf->importPage(1);
					}	// if ((empty($this->disable_fpdi) || (float)DOL_VERSION >= 8.0) && ! empty($this->add_pdf_bg))
					$pdf->Open();
					$pdf->SetTitle($outputlangs->convToOutputCharset($object->ref));
					$pdf->SetSubject($outputlangs->transnoentities("ContractCard"));
					$pdf->SetCreator("Dolibarr ".DOL_VERSION);
					$pdf->SetAuthor($outputlangs->convToOutputCharset($user->getFullName($outputlangs)));
					$pdf->SetKeyWords($outputlangs->convToOutputCharset($object->ref)." ".$outputlangs->transnoentities("ContractCard")." ".$outputlangs->convToOutputCharset($object->thirdparty->name));
					$pdf->SetMargins($this->marge_gauche, $this->marge_haute, $this->marge_droite);   // Left, Top, Right
					// First loop on each lines to prepare calculs and variables
					$realpatharray		= array();
					$objphoto			= new Product($this->db);
					for ($i = 0 ; $i < $nblignes ; $i++)
					{
						// detect if there is at least one image to show
						if (! empty($this->with_picture))
						{
							if (empty($object->lines[$i]->fk_product)) continue;
							$objphoto->fetch($object->lines[$i]->fk_product);
							if (! empty($this->old_path_photo))
							{
								$pdir[0] = get_exdir($objphoto->id, 2, 0, 0, $objphoto, 'product').$objphoto->id ."/photos/";
								$pdir[1] = get_exdir(0, 0, 0, 0, $objphoto, 'product').dol_sanitizeFileName($objphoto->ref).'/';
							}	// if (! empty($this->old_path_photo))
							else
							{
								$pdir[0] = get_exdir(0, 0, 0, 0, $objphoto, 'product').dol_sanitizeFileName($objphoto->ref).'/';	// default
								$pdir[1] = get_exdir($objphoto->id, 2, 0, 0, $objphoto, 'product').$objphoto->id ."/photos/";		// alternative
							}	// else	// if (! empty($this->old_path_photo))
							$arephoto = false;
							foreach ($pdir as $midir)
							{
								if (! $arephoto)
								{
									$dir = $conf->product->dir_output.'/'.$midir;
									foreach ($objphoto->liste_photos($dir, 1) as $key => $obj)
									{
										if (empty($this->cat_hq_image))		// If CAT_HIGH_QUALITY_IMAGES not defined, we use thumb if defined and then original photo
										{
											if ($obj['photo_vignette'])	$filename	= $obj['photo_vignette'];
											else						$filename	= $obj['photo'];
										}	// if (empty($this->cat_hq_image))
										else		$filename	= $obj['photo'];
										$realpath	= $dir.$filename;
										$arephoto	= true;
									}	// foreach ($objphoto->liste_photos($dir,1) as $key => $obj)
								}	// if (! $arephoto)
							}	// foreach ($pdir as $midir)
							if ($realpath && $arephoto) $realpatharray[$i]	= $realpath;
						}	// if (! empty($this->with_picture))
					}	// for ($i = 0 ; $i < $nblignes ; $i++)
					// New page
					$pdf->AddPage();
					if (! empty($tplidx))											$pdf->useTemplate($tplidx);
					$pagenb															= 1;
					$pdf->SetFont('', '', $default_font_size - 1);
					$pdf->MultiCell(0, 3, '');		// Set interline to 3
					// Define width and position of notes frames
					$this->larg_util_txt											= $this->page_largeur - ($this->marge_gauche + $this->marge_droite + ($this->Rounded_rect * 2) + 2);
					$this->larg_util_cadre											= $this->page_largeur - ($this->marge_gauche + $this->marge_droite);
					$this->posx_G_txt												= $this->marge_gauche + $this->Rounded_rect + 1;
					// Define width and position of main table columns
					$this->posxdesc													= $this->marge_gauche + 1;
					$this->larg_desc												= $this->page_largeur - $this->marge_gauche - $this->posxdesc; // Largeur variable suivant la place restante
					// Define width and position of secondary tables columns
					$this->larg_tabtotal			= 80;
					$this->larg_tabinfo				= $this->page_largeur - $this->marge_gauche - $this->marge_droite - $this->larg_tabtotal;
					$this->posxtabtotal				= $this->page_largeur - $this->marge_droite - $this->larg_tabtotal;
					// Calculs de positions
					$this->tab_hl					= 4;
					$head							= $this->_pagehead($pdf, $object, 1, $outputlangs);
					$hauteurhead					= $head["totalhead"];
					$hauteurcadre					= $head["hauteurcadre"];
					$tab_top						= $hauteurhead + 5;
					$tab_top_newpage				= (empty($this->small_head2) ? $hauteurhead - $hauteurcadre : 17);
					$this->ht_top_table				= $this->Rounded_rect * 2 > $this->tab_hl ? ($this->Rounded_rect * 2) + 1 : $this->tab_hl;
					$this->ht_decal_round			= $this->Rounded_rect > 0 ? $this->Rounded_rect - 1 : 0;
					$ht_coltotal					= $bottomlasttab;
					$ht2_coltotal					= pdf_InfraS_free_text($pdf, $object, $this->marge_gauche, $ht_coltotal + 3, $outputlangs, $this->emetteur, 'CONTRACT_FREE_TEXT', 1);
					if ($this->show_sign_area)
					{
						if ($ht2_coltotal > 4)		$ht_coltotal			+= ($this->tab_hl * 2) + $this->ht_signarea + 1;
						else						$ht_coltotal			+= ($this->tab_hl * 2) + $this->ht_signarea;
					}	// if ($this->show_sign_area)
					$ht_coltotal					+= $ht2_coltotal;
					$heightforinfotot				= $ht_colinfo > $ht_coltotal ? $ht_colinfo : $ht_coltotal;
					$heightforfooter				= $this->_pagefoot($pdf, $object, $outputlangs, 1);
					$pdf->SetDrawColor(128, 128, 128);
					$pdf->SetTextColor(0, 0, 0);
					// Affiche notes
					$height_note					= 0;
					$notetoshow						= empty($object->note_public) ? '' : $object->note_public;
					if ($notetoshow)
					{
						$pdf->SetFont('', '', $default_font_size - 1);
						$pdf->startTransaction();
						$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($notetoshow), 0, 1);
						if ($pdf->getPage() > 1 || $pdf->GetY() > ($this->page_hauteur - $this->ht_top_table - $heightforfooter - 30)) // Notes need pagebreak or There is no space left for footer
						{
							$pdf->rollbackTransaction(true);
							$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($outputlangs->transnoentities("PDFInfrasNoteTooLong")), 0, 1);
						}	// if ($pdf->getPage() > 1 || $pdf->GetY() > ($this->page_hauteur - $heightforfooter))
						else						$pdf->commitTransaction();
						
						$nexY						= $pdf->GetY();
						$height_note				= $this->Rounded_rect * 2 > $nexY - $tab_top ? $this->Rounded_rect * 2 : $nexY - $tab_top;
						$pdf->RoundedRect($this->marge_gauche, $tab_top - 1, $this->larg_util_cadre, $height_note + 2, $this->Rounded_rect, '1111');
						$height_note				+= $this->tab_hl;
					}	// if ($notetoshow)
					$tab_top						+= $height_note;
					$nexY							= $tab_top + $this->ht_top_table + $this->ht_decal_round;
					// Loop on each lines
					for ($i = 0 ; $i < $nblignes ; $i++)
					{
						$curY											= $nexY;
						$pdf->SetFont('', '', $default_font_size - 1);   // Into loop to work with multipage
						$pdf->SetTextColor(0, 0, 0);
						// Define size of image if we need it
						if ($this->larg_desc - 2 < $this->wpicture)	$this->wpicture	= $this->larg_desc - 2;	// corrige la largeur maximal de l'image pour être au plus égale à la largeur colonne
						$imglinesize									= array();
						if (! empty($realpatharray[$i]))				$imglinesize	= pdf_InfraS_getSizeForImage($realpatharray[$i], $this->wpicture, $this->hpicture);
						if (empty($this->hide_top_table))				$pdf->setTopMargin($tab_top_newpage + $this->ht_top_table + $this->ht_decal_round);
						else											$pdf->setTopMargin($tab_top_newpage);
						$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
						$pageposbefore									= $pdf->getPage();
						$showpricebeforepagebreak						= 1;
						// We start with Photo of product line
						if (isset($imglinesize['width']) && isset($imglinesize['height']))
						{
							if (($curY + $imglinesize['height']) > ($this->page_hauteur - ($heightforfooter)))	// If photo too high, we moved completely on new page
							{
								$pdf->AddPage('', '', true);
								if (! empty($tplidx))			$pdf->useTemplate($tplidx);
								$pdf->setPage($pageposbefore + 1);
								$curY							= $tab_top_newpage + ($this->hide_top_table ? $this->ht_decal_round : $this->ht_top_table + $this->ht_decal_round);
								$showpricebeforepagebreak		= 1;
							}	// if (($curY + $imglinesize['height']) > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
							$posxpicture			= $this->marge_gauche + (($this->larg_desc - 2 - $imglinesize['width']) / 2);	// centre l'image dans la colonne
							$pdf->Image($realpatharray[$i], $posxpicture, $curY, $imglinesize['width'], $imglinesize['height'], '', '', '', 2, 300);	// Use 300 dpi
							$curY					+= $imglinesize['height'];	// $pdf->Image does not increase value return by getY, so we save it manually
						}	// if (isset($imglinesize['width']) && isset($imglinesize['height']))
						// Description of product line
						$objectligne	= $object->lines[$i];
						$valide			= empty($objectligne->id) ? 0 : $objectligne->fetch($objectligne->id);
						if ($valide > 0 || $object->specimen)
						{
							if ($objectligne->date_ouverture_prevue)	$datei	= dol_print_date($objectligne->date_ouverture_prevue, 'day', false, $outputlangs, true);
							else										$datei	= $langs->trans("Unknown");
							if ($objectligne->date_fin_validite)
							{
								$durationi	= convertSecondToTime($objectligne->date_fin_validite - $objectligne->date_ouverture_prevue, 'allwithouthour');
								$datee		= dol_print_date($objectligne->date_fin_validite,'day',false,$outputlangs,true);
							}	// if ($objectligne->date_fin_validite)
							else
							{
								$durationi = $langs->trans("Unknown");
								$datee = $langs->trans("Unknown");
							}	// else // if ($objectligne->date_fin_validite)
							if ($objectligne->date_ouverture)			$daters	= dol_print_date($objectligne->date_ouverture,'day',false,$outputlangs,true);
							else										$daters	= $langs->trans("Unknown");
							if ($objectligne->date_cloture)				$datere	= dol_print_date($objectligne->date_cloture,'day',false,$outputlangs,true);
							else										$datere	= $langs->trans("Unknown");
							$txtpredefinedservice						= $objectligne->product_ref;
							if ($objectligne->product_label)			$txtpredefinedservice	.= ' - '.$objectligne->product_label;
							$txt										= '<strong>'.dol_htmlentitiesbr($outputlangs->transnoentities("DateStartPlannedShort")." : ".$datei." - ".$outputlangs->transnoentities("DateEndPlanned")." : ".$datee,1,$outputlangs->charset_output).'</strong>';
							$txt										.= '<br>';
							$txt										.= '<strong>'.dol_htmlentitiesbr($outputlangs->transnoentities("DateStartRealShort")." : ".$daters,1,$outputlangs->charset_output);
							if ($objectligne->date_cloture)				$txt	.= dol_htmlentitiesbr(" - ".$outputlangs->transnoentities("DateEndRealShort")." : ".$datere,1,$outputlangs->charset_output).'</strong>';
							$desc										= dol_htmlentitiesbr($objectligne->desc, 1);
							$pdf->startTransaction();
							$pdf->writeHTMLCell(0, 0, $curX, $curY, dol_concatdesc($txt, dol_concatdesc($txtpredefinedservice, $desc)), 0, 1, 0);
							$pageposafter				= $pdf->getPage();
							$pageposdesc				= $pdf->getPage();
							$posyafter					= $pdf->GetY();
							if ($pageposafter > $pageposbefore)	// There is a pagebreak
							{
								$pdf->rollbackTransaction(true);
								$pageposafter	= $pageposbefore;
								$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
								$pageposdesc	= $pdf->getPage();
								$pdf->writeHTMLCell(0, 0, $curX, $curY, dol_concatdesc($txt,dol_concatdesc($txtpredefinedservice, $desc)), 0, 1, 0);
								$pageposafter	= $pdf->getPage();
								$posyafter		= $pdf->GetY();
								if ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))	// There is no space left for total+free text
								{
									if ($i == ($nblignes - 1))	// No more lines, and no space left to show total, so we create a new page
									{
										$pdf->AddPage('','',true);
										if (! empty($tplidx))			$pdf->useTemplate($tplidx);
										$pdf->setPage($pageposafter + 1);
									}	// if ($i == ($nblignes - 1))
								}	// if ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
								else	$showpricebeforepagebreak	= 0; // we found a pagebreak
							}	// if ($pageposafter > $pageposbefore)
							elseif ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
							{
								$pdf->rollbackTransaction(true);
								$pageposafter	= $pageposbefore;
								$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
								$pageposdesc	= $pdf->getPage();
								$pdf->writeHTMLCell(0, 0, $curX, $curY, dol_concatdesc($txt,dol_concatdesc($txtpredefinedservice, $desc)), 0, 1, 0);
								$pageposafter	= $pdf->getPage();
								$posyafter		= $pdf->GetY();
								if ($i == ($nblignes - 1))	// No more lines, and no space left to show total, so we create a new page
								{
									$pdf->AddPage('', '', true);
									if (! empty($tplidx))				$pdf->useTemplate($tplidx);
									$pdf->setPage($pageposafter + 1);
								}	// if ($i == ($nblignes - 1))
							}	// elseif ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
							else	$pdf->commitTransaction();	// No pagebreak
							$nexY										= $pdf->GetY();
							$pageposafter								= $pdf->getPage();
							$pdf->setPage($pageposbefore);
							$pdf->setTopMargin($this->marge_haute);
							$pdf->setPageOrientation('', 1, 0);	// The only function to edit the bottom margin of current page to set it.
							if ($pageposafter > $pageposbefore && empty($showpricebeforepagebreak))
								$pdf->setPage($pageposdesc);
							$pdf->SetFont('','', $default_font_size - 1);   // On repositionne la police par defaut
							// Add dash or space between line
							if ($this->dash_between_line && $i < ($nblignes - 1))
							{
								$pdf->setPage($pageposafter);
								$pdf->SetLineStyle(array('color'=>array(128, 128 ,128)));
								$pdf->line($this->marge_gauche, $nexY + 1, $this->page_largeur - $this->marge_droite, $nexY + 1);
								$nexY	+= 2;
							}	// if ($this->dash_between_line && $i < ($nblignes - 1))
							else								$nexY	+= $this->tab_hl;
							// Detect if some page were added automatically and output _tableau for past pages
							while ($pagenb < $pageposafter)
							{
								$pdf->setPage($pagenb);
								$heightforfooter				= $this->_pagefoot($pdf, $object, $outputlangs, 0);
								if ($pagenb == 1)				$this->_tableau($pdf, $object, $tab_top, $this->page_hauteur - $tab_top - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $object->multicurrency_code, $pagenb);
								else							$this->_tableau($pdf, $object, $tab_top_newpage, $this->page_hauteur - $tab_top_newpage - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $object->multicurrency_code, $pagenb);
								$pagenb++;
								$pdf->setPage($pagenb);
								$pdf->setPageOrientation('', 1, 0);	// The only function to edit the bottom margin of current page to set it.
								if (empty($this->small_head2))	$this->_pagehead($pdf, $object, 0, $outputlangs);
								else							$this->_pagesmallhead($pdf, $object, 0, $outputlangs);
							}	// while ($pagenb < $pageposafter)
							if (isset($object->lines[$i + 1]->pagebreak) && $object->lines[$i + 1]->pagebreak)
							{
								$heightforfooter				= $this->_pagefoot($pdf, $object, $outputlangs, 0);
								if ($pagenb == 1)				$this->_tableau($pdf, $object, $tab_top, $this->page_hauteur - $tab_top - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $object->multicurrency_code, $pagenb);
								else							$this->_tableau($pdf, $object, $tab_top_newpage, $this->page_hauteur - $tab_top_newpage - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $object->multicurrency_code, $pagenb);
								// New page
								$pdf->AddPage();
								if (! empty($tplidx))			$pdf->useTemplate($tplidx);
								$pagenb++;
								if (empty($this->small_head2))	$this->_pagehead($pdf, $object, 0, $outputlangs);
								else							$this->_pagesmallhead($pdf, $object, 0, $outputlangs);
							}	// if (isset($object->lines[$i + 1]->pagebreak) && $object->lines[$i + 1]->pagebreak)
						}	// if ($valide > 0 || $object->specimen)
					}	// for ($i = 0 ; $i < $nblignes ; $i++)
					$bottomlasttab							= $this->page_hauteur - $heightforinfotot - $heightforfooter - 1;
					if ($pagenb == 1)						$this->_tableau($pdf, $object, $tab_top, $bottomlasttab - $tab_top, $outputlangs, $this->hide_top_table, 1, $pagenb);
					else									$this->_tableau($pdf, $object, $tab_top_newpage, $bottomlasttab - $tab_top_newpage, $outputlangs, $this->hide_top_table, 0, $pagenb);
					$pdf->SetTextColor(0, 0, 0);
					$posyfreetext							= pdf_InfraS_free_text($pdf, $object, $this->marge_gauche, $bottomlasttab + 3, $outputlangs, $this->emetteur, 'CONTRACT_FREE_TEXT', 0);
					if ($this->show_sign_area)
					{
						if ($ht2_coltotal > 4)
						{
							$pdf->Line($this->marge_gauche, $posyfreetext + 2, $this->page_largeur - $this->marge_droite, $posyfreetext + 2);
							$posysignarea					= $this->_signature_area($pdf, $object, $posyfreetext + 3, $outputlangs);
						}	// if ($ht2_coltotal > 4)
						else								$posysignarea	= $this->_signature_area($pdf, $object, $posyfreetext, $outputlangs);
					}	// if ($this->show_sign_area)
					$posy									= $posyinfo > $posysignarea ? $posyinfo : $posysignarea;
					$this->_pagefoot($pdf, $object, $outputlangs, 0);
					if (method_exists($pdf, 'AliasNbPages'))	$pdf->AliasNbPages();
					// If merge CGV is active
					if (!empty($this->CGV) && $this->chkCGV)	pdf_InfraS_CGV($pdf, $this->CGV, $tplidx, $this->hidepagenum);
					$pdf->Close();
					$pdf->Output($file, 'F');
					// Add pdfgeneration hook
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters									= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook=$hookmanager->executeHooks('afterPDFCreation',$parameters,$this,$action);    // Note that $action and $object may have been modified by some hooks
					if (! empty($this->main_umask))				@chmod($file, octdec($this->main_umask));
					$this->result								= array('fullpath' => $file);
					return 1;   // Pas d'erreur
				}	// if (file_exists($dir))
				else
				{
					$this->error=$langs->trans("ErrorCanNotCreateDir",$dir);
					return 0;
				}	// else	// if (file_exists($dir))
			}	// if ($conf->contrat->dir_output)
			else
			{
				$this->error=$langs->trans("ErrorConstantNotDefined","CONTRACT_OUTPUTDIR");
				return 0;
			}	// else	// if ($conf->contrat->dir_output)
		}	// function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)

		/********************************************
		*	Show top header of page.
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object     	Object to show
		*	@param		int	    	$showaddress    0=no, 1=yes
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		string		$titlekey		Translation key to show as title of document
		*	@return		array		$hauteurhead	'totalhead'		= hight of header
		*											'hauteurcadre	= hight of frame
		********************************************/
		function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "ContractCard")
		{
			global $conf, $langs, $hookmanager;

			if((float)DOL_VERSION >= 8.0)	$outputlangs->loadLangs(array("main", "bills", "companies", "contracts", "commercial"));
			else
			{
				$outputlangs->load("main");
				$outputlangs->load("bills");
				$outputlangs->load("companies");
				$outputlangs->load("contracts");
				$outputlangs->load("commercial");
			}	// else	// if((float)DOL_VERSION >= 8.0)
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			pdf_pagehead($pdf, $outputlangs, $this->page_hauteur);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('', 'B', $default_font_size + 3);
			$w		= 100;
			$posy	= $this->marge_haute;
			$posx	= $this->page_largeur - $this->marge_droite - $w;
			$pdf->SetXY($this->marge_gauche, $posy);
			// Logo
			$logo	= $conf->mycompany->dir_output.'/logos/'.$this->emetteur->logo;
			if ($logo)
			{
				if (is_file($logo) && is_readable($logo))
				{
					$heightLogo	= pdf_getHeightForLogo($logo);
					$pdf->Image($logo, $this->marge_gauche, $posy, 0, $heightLogo);	// width=0 (auto)
				}	// if (is_file($logo) && is_readable($logo))
				else
				{
					$pdf->SetTextColor(200, 0, 0);
					$pdf->SetFont('', 'B', $default_font_size - 2);
					$pdf->MultiCell($w, $this->tab_hl, $outputlangs->transnoentities("ErrorLogoFileNotFound",$logo), 0, 'L');
					$pdf->MultiCell($w, $this->tab_hl, $outputlangs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
					$pdf->SetTextColor(0, 0, 0);
				}	// else	// if (is_file($logo) && is_readable($logo))
			}	// if ($logo)
			else
			{
				$text=$this->emetteur->name;
				$pdf->MultiCell($w, $this->tab_hl, $outputlangs->convToOutputCharset($text), 0, 'L');
				$heightLogo = $this->tab_hl;
			}	// else// if ($logo)
			$heightLogo	+= $posy + $this->tab_hl;
			$pdf->SetFont('', 'B', $default_font_size * 2);
			$title		= $outputlangs->transnoentities($titlekey);
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl * 2, $title, '', 'R');
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$posy		+= $this->tab_hl * 2;
			$txtref		= $outputlangs->transnoentities("PDFInfrasRef")." : ".$outputlangs->convToOutputCharset($object->ref);
			if ($object->statut == 0)
			{
				$pdf->SetTextColor(128, 0, 0);
				$txtref .= ' - '.$outputlangs->transnoentities("NotValidated");
				$pdf->SetTextColor(0, 0, 0);
			}	// if ($object->statut == 0)
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl, $txtref, '', 'R');
			$pdf->SetFont('', '', $default_font_size - 2);
			$posy		+= $this->tab_hl;
			$txtdt		= $outputlangs->transnoentities("Date")." : ".dol_print_date($object->date_contrat, "day", false, $outputlangs, true);
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl, $txtdt, '', 'R');
			if ($object->ref_customer || $object->ref_supplier)
			{
				$posy	+= $this->tab_hl - 0.5;
				$txtcc	= '';
				if ($object->ref_customer)
					$txtcc	.= $outputlangs->transnoentities("RefCustomer")." : ".$outputlangs->convToOutputCharset($object->ref_customer);
				if ($object->ref_supplier)
					$txtcc	.= ' / '.$outputlangs->transnoentities("RefSupplier")." : ".$outputlangs->transnoentities($object->ref_supplier);
				$pdf->SetXY($posx, $posy);
				$pdf->MultiCell($w, $this->tab_hl, $txtcc, '', 'R');
			}	// if ($object->ref_customer || $object->ref_supplier)
			// Show list of linked objects
			$posy		= pdf_InfraS_writeLinkedObjects($pdf, $object, $outputlangs, $posx, $posy, $w, $this->tab_hl, 'R');
			$posy		+= 0.5;
			$posycadre	= ($this->use_iso_location ? 40 : ($heightLogo > $posy + $this->tab_hl ? $heightLogo : $posy + $this->tab_hl));
			if ($showaddress)
			{
				// Sender properties
				$carac_emetteur	= '';
				// Add internal contact of proposal if defined
				$arrayidcontact	= $object->getIdContact('internal','INTERREPFOLL');
				if (count($arrayidcontact) > 0)
				{
					$object->fetch_user($arrayidcontact[0]);
					$carac_emetteur			.= ($carac_emetteur ? "\n" : '' ).$outputlangs->convToOutputCharset($object->user->getFullName($outputlangs))."\n";
				}	// if (count($arrayidcontact) > 0)
				$carac_emetteur .= pdf_InfraS_build_address($outputlangs, $this->emetteur, $object->thirdparty, '', 0, 'source', null, 1);
				// Recipient properties
				// If CUSTOMER contact defined, we use it
				$usecontact		= false;
				$arrayidcontact	= $object->getIdContact('external', 'CUSTOMER');
				if (count($arrayidcontact) > 0)
				{
					$usecontact	= true;
					$result		= $object->fetch_contact($arrayidcontact[0]);
				}	// if (count($arrayidcontact) > 0)
				//Recipient name
				// On peut utiliser le nom de la societe du contact
				if ($usecontact && !empty($this->use_comp_name_contact))	$thirdparty	= $object->contact;
				else														$thirdparty	= $object->thirdparty;
				$carac_client_name	= pdf_InfraS_Build_Third_party_Name($thirdparty, $outputlangs, $this->includealias);
				$recepdetails		= $this->show_recep_details ? 'targetwithdetails' : 'target';
				$carac_client		= pdf_InfraS_build_address($outputlangs, $this->emetteur, $object->thirdparty, ($usecontact ? $object->contact : ''), $usecontact, $recepdetails, $object, 1);
				// Show sender
				$largeurcadreS	= 92;
				if (! empty($this->invert_sender_recipient))	$posx	= $this->page_largeur - $this->marge_droite - $largeurcadreS;
				else											$posx	= $this->marge_gauche;
				$posxcadre	= $posx;
				$posy		= $posycadre;
				// Show sender name
				$pdf->SetFont('', 'B', $default_font_size);
				$pdf->SetXY($posx + 2, $posy + 1);
				$pdf->MultiCell($largeurcadreS - 4, $this->tab_hl, $outputlangs->convToOutputCharset($this->emetteur->name), 0, 'L');
				$posy	= $pdf->getY();
				// Show sender information
				$pdf->SetFont('', '', $default_font_size - 1);
				$pdf->SetXY($posx + 2, $posy);
				$pdf->MultiCell($largeurcadreS - 4, $this->tab_hl, $carac_emetteur, 0, 'L');
				$posyendsender	= $pdf->getY();
				//Show Recipient
				$largeurcadreR	= 92;
				if ($this->page_largeur < 210) $largeurcadreR = 84;	// To work with US executive format
				if (! empty($this->invert_sender_recipient))	$posx	= $this->marge_gauche;
				else											$posx	= $this->page_largeur - $this->marge_droite - $largeurcadreR;
				$posy	= $posycadre;
				// Show recipient name
				$pdf->SetFont('', 'B', $default_font_size);
				$pdf->SetXY($posx + 2, $posy + 1);
				$pdf->MultiCell($largeurcadreR - 4, $this->tab_hl, $carac_client_name, 0, 'L');
				$posy	= $pdf->getY();
				// Show recipient information
				$pdf->SetFont('', '', $default_font_size - 1);
				$pdf->SetXY($posx + 2, $posy);
				$pdf->MultiCell($largeurcadreR - 4, $this->tab_hl, $carac_client, 0, 'L');
				$posyendrecipient	= $pdf->getY();
				//Calcul hauteur des cadres
				if ($posyendsender > $posyendrecipient)	$hauteurcadre	= ($posyendsender - $posycadre) + 1;
				else									$hauteurcadre	= ($posyendrecipient - $posycadre) + 1;
				// Show sender frame
				$pdf->SetFont('', '', $default_font_size - 2);
				$pdf->SetXY($posxcadre + $this->Rounded_rect, $posycadre - 4);
				if (! $this->hide_recep_frame)			$pdf->MultiCell($largeurcadreS, $this->tab_hl + 1, $outputlangs->transnoentities("BillFrom").":", 0, 'L');
				$pdf->SetAlpha($this->alpha);
				$pdf->RoundedRect($posxcadre, $posycadre, $largeurcadreS, $hauteurcadre, $this->Rounded_rect, '1111', 'F' ,null , explode(',', $this->bg_color));
				$pdf->SetAlpha(1);
				// Show recipient frame
				if (! $this->hide_recep_frame)
				{
					$pdf->SetFont('', '', $default_font_size - 2);
					$pdf->SetXY($posx + $this->Rounded_rect, $posycadre - 4);
					$pdf->MultiCell($largeurcadreR, $this->tab_hl + 1, $outputlangs->transnoentities("BillTo").":", 0, 'L');
					$pdf->RoundedRect($posx, $posycadre, $largeurcadreR, $hauteurcadre, $this->Rounded_rect, '1111');
				}	// if (! $this->hide_recep_frame)
			}	// if ($showaddress)
			$hauteurhead = array('totalhead'=>$posycadre + $hauteurcadre, 'hauteurcadre'=>$hauteurcadre);
			return $hauteurhead;
		}	// function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "ContractCard")

		/********************************************
		*	Show top small header of page.
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object     	Object to show
		*	@param		int	    	$showaddress    0=no, 1=yes
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		string		$titlekey		Translation key to show as title of document
		*	@return		void
		********************************************/
		function _pagesmallhead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "ContractCard")
		{
			global $conf, $langs, $hookmanager;
			
			$fromcompany	= $this->emetteur;
			$logo			= $conf->mycompany->dir_output.'/logos/'.$this->emetteur->logo;
			$title			= $outputlangs->transnoentities($titlekey);
			pdf_InfraS_pagesmallhead($pdf, $object, $showaddress, $outputlangs, $title, $fromcompany, $this->formatpage, $this->Rounded_rect, $logo);
		}	// function _pagesmallhead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "ContractCard")

		/********************************************
		*   Show table for lines
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param  	Object		$object     	Object to show
		*	@param		float		$tab_top		Top position of table
		*	@param		float		$tab_height		Height of table (rectangle)
		*	@param		Translate	$outputlangs	Langs object
		*	@param		int			$hidetop		1=Hide top bar of array and title, 0=Hide nothing, -1=Hide only title
		*	@param		int			$hidebottom		Hide bottom bar of array
		*	@return		void
		********************************************/
		function _tableau(&$pdf, $object, $tab_top, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)
		{
			global $conf;

			// Force to disable hidetop and hidebottom
			$hidebottom			= 0;
			if ($hidetop)		$hidetop	= -1;
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('', '', $default_font_size - 2);
			// Output Rounded Rectangle
			if (empty($hidetop) || $pagenb == 1)
			{
				if (! empty($this->title_bg))
				{
					$bg_color	= explode(',', $this->bg_color);
					$pdf->SetDrawColor($bg_color[0], $bg_color[1], $bg_color[2]);
					$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111', 'DF', null, explode(',', $this->bg_color));
					$pdf->SetDrawColor(128, 128, 128);
				}	// if (! empty($this->title_bg))
				else	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111');
				$pdf->RoundedRect($this->marge_gauche, $tab_top + $this->ht_top_table, $this->larg_util_cadre, $tab_height - $this->ht_top_table, $this->Rounded_rect, '1111');
			}	// if (empty($hidetop) || $pagenb == 1)
			else	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $tab_height, $this->Rounded_rect, '1111');
			// Show Watermarks
			$pdf->SetAlpha($this->watermark_i_opacity / 100);
			$filigrane	= $conf->mycompany->dir_output.'/logos/'.$this->image_watermark;
			if ($filigrane && is_readable($filigrane))
			{
				$imglinesize	= pdf_InfraS_getSizeForImage($filigrane, $this->larg_util_cadre, $tab_height);
				if (isset($imglinesize['width']) && isset($imglinesize['height']))
				{
					$posXfiligrane			= $this->marge_gauche + (($this->larg_util_cadre - $imglinesize['width']) / 2);	// centrer le filigrane
					if (empty($hidetop))	$pdf->Image($filigrane, $posXfiligrane, $tab_top + $this->ht_top_table + ($tab_height / 2) - ($imglinesize['height'] / 2), $imglinesize['width'], 0);	// width=0 (auto)
					else					$pdf->Image($filigrane, $posXfiligrane, $tab_top + ($tab_height / 2) - ($imglinesize['height'] / 2), $imglinesize['width'], 0);	// width=0 (auto)
				}	// if (isset($imglinesize['width']) && isset($imglinesize['height']))
			}	// if ($filigrane && is_readable($filigrane))
			$pdf->SetAlpha($this->watermark_t_opacity / 100);
			if ($object->statut == 0 && (! empty($this->draft_watermark)))
			{
				if (empty($hidetop))	pdf_InfraS_watermark($pdf, $outputlangs, $this->draft_watermark, $tab_top + $this->ht_top_table + ($tab_height / 2), $this->larg_util_cadre, $this->page_hauteur, 'mm');
				else					pdf_InfraS_watermark($pdf, $outputlangs, $this->draft_watermark, $tab_top + ($tab_height / 2), $this->larg_util_cadre, $this->page_hauteur, 'mm');
			}	// if ($object->statut == 0 && (! empty($this->draft_watermark)))
			$pdf->SetAlpha(1);
			// Show Folder mark
			if (! empty($this->fold_mark))
			{
				$pdf->Line(0, ($this->page_hauteur)/3, $this->fold_mark, ($this->page_hauteur)/3);
				$pdf->Line($this->page_largeur - $this->fold_mark, ($this->page_hauteur)/3, $this->page_largeur, ($this->page_hauteur)/3);
			}	// if (! empty($this->fold_mark))
			// Colonnes
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$this->title_bg ? $pdf->SetTextColor($this->txtcolor[0], $this->txtcolor[1], $this->txtcolor[2]) : $pdf->SetTextColor(0, 0, 0);
			if (empty($hidetop) || $pagenb == 1)
			{
				$pdf->SetXY($this->posxdesc, $tab_top);
				$pdf->MultiCell($this->larg_desc, $this->ht_top_table, $outputlangs->transnoentities("Description"), '', 'C', 0, 1, '', '', true, 0, false, true, $this->ht_top_table, 'M');
			}	// if (empty($hidetop) || $pagenb == 1)
		}	// function _tableau(&$pdf, $object, $tab_top, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)

		/********************************************
		*	Show area for the customer to sign
		*
		*	@param		PDF			$pdf            Object PDF
		*	@param		Facture		$object         Object invoice
		*	@param		int			$posy			y
		*	@param		Translate	$outputlangs	Objet langs
		*	@return		int							Position pour suite
		********************************************/
		function _signature_area(&$pdf, $object, $posy, $outputlangs)
		{
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$signarea_top		= $posy + 1;
			$signarea_hl		= $this->tab_hl;
			$pdf->SetFont('', '', $default_font_size - 2);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			$larg_signarea		= $this->larg_tabtotal;
			$posxsignarea1		= $this->marge_gauche;
			$posxsignarea2		= $this->posxtabtotal;
			$pdf->SetXY($posxsignarea1 + $this->Rounded_rect, $signarea_top);
			$pdf->MultiCell($larg_signarea, $signarea_hl, $outputlangs->transnoentities("ContactNameAndSignature", $object->thirdparty->name), 0, 'L', 0);
			$pdf->RoundedRect($posxsignarea1, $signarea_top + $signarea_hl, $larg_signarea, $this->ht_signarea, $this->Rounded_rect, '1111');
			$pdf->SetXY($posxsignarea2 + $this->Rounded_rect, $signarea_top);
			$pdf->MultiCell($larg_signarea, $signarea_hl, $outputlangs->transnoentities("ContactNameAndSignature", $this->emetteur->name), 0, 'L', 0);
			$pdf->RoundedRect($posxsignarea2, $signarea_top + $signarea_hl, $larg_signarea, $this->ht_signarea, $this->Rounded_rect, '1111');
			return ($signarea_top + ($signarea_hl * 7));
		}	// function _signature_area(&$pdf, $object, $posy, $outputlangs)

		/********************************************
		*	Show footer of page. Need this->emetteur object
		*
		*	@param		PDF			$pdf     		The PDF factory
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		Societe		$fromcompany	Object company
		*	@param		int			$marge_basse	Margin bottom we use for the autobreak
		*	@param		int			$marge_gauche	Margin left
		*	@param		int			$page_hauteur	Page height
		*	@param		Object		$object			Object shown in PDF
		*	@param		int			$showdetails	Show company details into footer. This param seems to not be used by standard version.
													(10=minimum, 11 = 1 + Logos de pied, 20 = Show address and managers, 21 = Show 2 + Logos de pied)
		*	@param		int			$hidesupline	Completly hide the line up to footer (for some edition with only table)
		*	@param		int			$calculseul		Arrête la fonction au calcul de hauteur nécessaire
		*	@return		int							Return height of bottom margin including footer text
		********************************************/
		function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
		{
			global $conf, $langs;
			
			$showdetails									= 10;
			if (! empty($this->type_foot))	$showdetails	= 20;
			if (! empty($this->pied))		$showdetails	+= 1;
			return pdf_InfraS_pagefoot($pdf, $outputlangs, $this->emetteur, $this->formatpage, $showdetails, 0, $calculseul, $this->pied, $this->maxsizeimgfoot, $this->hidepagenum);
		}	// function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
	}	// class pdf_InfraS_fichinter extends ModelePDFFicheinter
?>