<?php
	/************************************************
	* Copyright (C) 2016	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspack/core/modules/modinfras.class.php
	* 	\ingroup	InfraS
	* 	\brief		Description and activation file for module InfraS
	************************************************/

	// Libraries ************************************
	include_once DOL_DOCUMENT_ROOT.'/core/modules/DolibarrModules.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
	dol_include_once('/infraspack/core/lib/infraspack.lib.php');

	// Description and activation class *************
	class modinfraspack extends DolibarrModules
	{
		/************************************************
		 * Constructor. Define names, constants, directories, boxes, permissions
		 * @param DoliDB $db Database handler
		************************************************/
		function __construct($db)
		{
			global $langs, $conf;

			$langs->load('infraspack@infraspack');

			$this->db				= $db;
			$this->numero			= 500000;												// Unique Id for module
			$this->name				= preg_replace('/^mod/i', '', get_class($this));		// Module label (no space allowed)
			$this->editor_name		= '<b>InfraS - sylvain Legrand</b>';
			$this->editor_web		= 'https://www.infras.fr/';
			$this->rights_class		= $langs->trans("modcomname");							// Key text used to identify module (for permissions, menus, etc...)
			$this->family			= 'Modules '.$langs->trans("basename");					// used to group modules in module setup page
			$this->description		= $langs->trans('Module500000Desc');					// Module description
			$this->version			= $this->getLocalVersion();								// Version : 'development', 'experimental', 'dolibarr' or 'dolibarr_deprecated' or version
			$this->const_name		= 'MAIN_MODULE_'.strtoupper($this->name);				// llx_const table to save module status enabled/disabled
			$this->special			= 0;													// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
			$this->picto			= 'infraspack@infraspack';								// Name of image file used for this module. If in theme => 'pictovalue' ; if in module => 'pictovalue@module' under name object_pictovalue.png
			$this->module_parts		= array('models'	=> 1,								// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
											'hooks'		=> array('login',
																 'formfile',
																 'pdfgeneration')
											);
			$this->dirs				= array('/mycompany/logos/', 
											'/mycompany/logos/thumbs/');					// Data directories to create when module is enabled. Example: this->dirs = array("/mymodule/temp");
			$this->config_page_url	= array('infrassetup.php@'.$langs->trans("modname"));	// List of php page, stored into mymodule/admin directory, to use to setup module.
			// Dependencies
			$this->hidden			= false;												// A condition to hide module
			$this->depends			= array();												// List of modules id that must be enabled if this module is enabled
			$this->requiredby		= array();												// List of modules id to disable if this one is disabled
			$this->conflictwith		= array();												// List of modules id this module is in conflict with
			$this->phpmin			= array(5, 4);											// Minimum version of PHP required by module
			$this->langfiles		= array('infraspack@infraspack');
			$this->const			= array(1 => array('INFRAS_MAIN_VERSION', 'chaine', $this->version, '', 0, $this->name, 1),
											2 => array('INFRAS_DOL_VERSION', 'chaine', DOL_VERSION, '', 0, $this->name, 1)
											);												// List of particular constants to add when module is enabled
			$this->tabs				= array();
			if (! isset($conf->infraspack->enabled))
			{
				$conf->infraspack			= new stdClass();
				$conf->infraspack->enabled	= 0;
			}	// if (! isset($conf->infraspack->enabled))
			$this->dictionaries	= array();	// Dictionaries
			$this->boxes		= array();	// List of boxes
			$this->cronjobs		= array();	// List of cron jobs entries to add
			$this->rights		= array();	// Permission array used by this module
			$this->menu			= array();	// List of menus to add
		}	// function __construct($db)

		/************************************************
		 *		Function called when module is enabled.
		 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
		 *		It also creates data directories
		 *      @param		string		$options		Options when enabling module ('', 'noboxes')
		 *      @return		int							1 if OK, 0 if KO
		************************************************/
		function init($options='')
		{
			global $langs, $conf, $db;
			
			$memory_limit											= InfraS_return_bytes(ini_get('memory_limit'));
			if ($memory_limit < (128 * 1024 * 1024))				ini_set('memory_limit','128M');
			$sql													= array();
			$path													= dol_buildpath($this->name, 0);
			$pathsql												= $path.'/sql/';
			if (strtoupper(substr(PHP_OS, 0, 3)) != 'WIN')			InfraS_chmod_r($path, '0755', '0755', 'www-data', 'www-data');
			dolCopyDir($path.'/fonts', DOL_DOCUMENT_ROOT.'/includes/tecnickcom/tcpdf/fonts', 0, 1);
			// Check if there is an old file for param update and change its name
			$filesqlold												= $pathsql.'update.sql';
			if (is_file($filesqlold))								$moved	= dol_move($filesqlold, $filesqlold.'.old');
			$filesql												= $pathsql.'update.'.$conf->entity;
			if (is_file($filesql))									$moved	= dol_copy($filesql, $filesql.'.sql');
			$this->_load_tables('/'.$this->name.'/sql/');
			$delete													= dol_delete_file($filesql.'.sql');
			dolibarr_set_const($db, "MAIN_DISABLE_PDF_AUTOUPDATE", 1, 'chaine', 0, '', $conf->entity);
			return $this->_init($sql, $options);
		}	// function init($options='')	

		/************************************************
		 * Function called when module is disabled.
		 * Remove from database constants, boxes and permissions from Dolibarr database.
		 * Data directories are not deleted
		 * @param		string		$options		Options when enabling module ('', 'noboxes')
		 * @return		int							1 if OK, 0 if KO
		************************************************/
		function remove($options = '')
		{
			global $langs, $conf;
			
			InfraS_bkup_module ($this->name, 2);
			$sql	= array('DELETE FROM '.MAIN_DB_PREFIX.'const WHERE name like "INFRAS_%" AND entity = "'.$conf->entity.'"', 
							'DELETE FROM '.MAIN_DB_PREFIX.'const WHERE name like "%_ADDON_PDF" AND value like "InfraS_%" AND entity = "'.$conf->entity.'"',
							'DELETE FROM '.MAIN_DB_PREFIX.'document_model WHERE nom like "InfraS_%" AND entity = "'.$conf->entity.'"');
			return $this->_remove($sql);
		}	// function remove($options = '')
		
		/************************************************
		 * Function called to get used version and check the available ones
		 * If possible, every 7 days, downloads the last changelog
		 * Show if new version is available and the new changelog with hightlights off the changes
		 * @return		string		current version with information about new ones on tooltip or error message
		************************************************/
		function getVersion($translated = 1)
		{
			global $langs, $conf;
			
			$path												= dol_buildpath($this->name, 0);
			$currentversion										= $this->getLocalVersion();
			if ($conf->global->INFRAS_SKIP_CHECKVERSION == 1)	return $currentversion;
			if ($this->disabled)
			{
				$newversion		= $langs->trans("DolibarrMinVersionRequiered")." : ".$this->need_dolibarr_version;
				$currentversion	= '<font color=red><b>'.img_error($newversion).$currentversion.'</b></font>';
				return $currentversion;
			}	// if ($this->disabled)
			$context	= stream_context_create(array('http' => array('header' => 'Accept: application/xml')));
			if (is_file($path.'/docs/changelogdwn.xml'))
			{
				$lasthtmlversion					= @file_get_contents($path.'/docs/changelogdwn.xml', false, $context);
				$sxelasthtmlversion					= simplexml_load_string(nl2br ($lasthtmlversion));
				if ($sxelasthtmlversion === false)	$lasthtmldate	= '19000101';
				else								$lasthtmldate	= $sxelasthtmlversion->InfraS->attributes()->Downloaded;
			}	// if (is_file($path.'/docs/changelogdwn.xml'))
			else	$lasthtmldate	= '19000101';
			if ($lasthtmldate < date('Ymd', strtotime('-7 day')))
			{
				$context						= stream_context_create(array('http' => array('header' => 'Accept: application/xml'), 'ssl' => array('verify_peer' => false, 'verify_peer_name' => false)));
				$newhtmlversion					= @file_get_contents($this->editor_web.'jdownloads/Technique/Modules%20Dolibarr/Changelogs/'.$this->name.'/changelog.xml', false, $context);
				if ($newhtmlversion === false)	return $currentversion;	// not connected
				else
				{
					$newhtmlversion		= preg_replace('#Downloaded=\".+\"#', 'Downloaded="'.date('Ymd').'"', $newhtmlversion);
					file_put_contents($path.'/docs/changelogdwn.xml', $newhtmlversion);
					$sxelasthtmlversion	= simplexml_load_string(nl2br ($newhtmlversion));
				}	// else	// if ($newhtmlversion === false)
			}	// if ($lasthtmldate < date('Ymd', strtotime('-7 day')))
			if ($sxelasthtmlversion === false)	return $currentversion;
			else								$tblversionslast	= $sxelasthtmlversion->Version;
			$lastversion						= $tblversionslast[count($tblversionslast) - 1]->attributes()->Number;
			if ($lastversion != (string) $currentversion)
			{
				if ($lastversion > (string) $currentversion)	
				{
					$newversion		= $langs->trans("NewVersionAviable")." : ".$lastversion;
					$currentversion	= '<font title="'.$newversion.'" color=orange><b>'.$currentversion.'</b></font>';
				}	// if ($lastversion > (string) $currentversion)
				else	$currentversion		= '<font title="'.$langs->trans("PiloteVersion").'" color=red><b>'.$currentversion.'</b></font>';
			}	// if ($lastversion != (string) $currentversion)
			return $currentversion;
		}	// function getVersion($translated = 1)

		/************************************************
		 * Function called to view changelog
		 * @return		string		html view
		************************************************/
		function getChangeLog()
		{
			$currentversion	= InfraS_getLocalVersionMinDoli($this->name);
			$ChangeLog		= InfraS_getChangeLog($this->name, $currentversion[2], $currentversion[3]);
			return $ChangeLog;
		}	// function getChangeLog()

		/************************************************
		 * Function called to check module name from changelog
		 * Control of the min version of Dolibarr needed
		 * If dolibarr version does'nt match the min version the module is disabled
		 * @return		string		current version or error message
		************************************************/
		function getLocalVersion()
		{
			global $langs;
			
			$currentversion																= array();
			$currentversion																= InfraS_getLocalVersionMinDoli($this->name);
			$this->need_dolibarr_version												= $currentversion[1];
			if ($currentversion[2] == 0 && DOL_VERSION < $this->need_dolibarr_version)	$this->disabled	= true;
			return $currentversion[0];
		}	// function getLocalVersion()
	}	// class modinfras extends DolibarrModules
?>
