<?php
	/************************************************
	* Copyright (C) 2017	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		htdocs/custom/infras/core/modules/product/doc/pdf_InfraS_product.modules.php
	* 	\ingroup	InfraS
	* 	\brief		Class file for InfraS PDF product card
	************************************************/

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/modules/product/modules_product.class.php';
	require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
	require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.product.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	dol_include_once('/infraspack/core/lib/infras.pdf.lib.php');

	/************************************************
	*	Class to generate PDF product card InfraS
	************************************************/
	class pdf_InfraS_product extends ModelePDFProduct
	{
		public $db;
		public $name;
		public $description;
		public $type;
		public $phpmin	= array(5, 4);
		public $version	= 'dolibarr';
		public $page_largeur;
		public $page_hauteur;
		public $format;
		public $marge_gauche;
		public $marge_droite;
		public $marge_haute;
		public $marge_basse;
		public $emetteur;

		/********************************************
		*	Constructor
		*
		*	@param		DoliDB		$db      Database handler
		********************************************/
		public function __construct($db)
		{
			global $conf, $langs, $mysoc;

			if((float)DOL_VERSION >= 8.0)	$langs->loadLangs(array("main", "companies", "infraspack@infraspack"));
			else
			{
				$langs->load("main");
				$langs->load("companies");
				$langs->load("infraspack@infraspack");
			}	// else	// if((float)DOL_VERSION >= 8.0)
			
			$this->db									= $db;
			$this->name									= $langs->trans('PDFInfraSProductName');
			$this->description							= $langs->trans('PDFInfraSProductDescription');
			$this->type									= 'pdf';
			$formatarray								= pdf_InfraS_getFormat();
			$this->page_largeur							= $formatarray['width'];
			$this->page_hauteur							= $formatarray['height'];
			$this->format								= array($this->page_largeur, $this->page_hauteur);
			$this->marge_gauche							= isset($conf->global->MAIN_PDF_MARGIN_LEFT)					? $conf->global->MAIN_PDF_MARGIN_LEFT : 10;
			$this->marge_droite							= isset($conf->global->MAIN_PDF_MARGIN_RIGHT)					? $conf->global->MAIN_PDF_MARGIN_RIGHT : 10;
			$this->marge_haute							= isset($conf->global->MAIN_PDF_MARGIN_TOP)						? $conf->global->MAIN_PDF_MARGIN_TOP : 10;
			$this->marge_basse							= isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)					? $conf->global->MAIN_PDF_MARGIN_BOTTOM : 10;
			$this->font									= isset($conf->global->INFRAS_PDF_FONT)							? $conf->global->INFRAS_PDF_FONT : 'Helvetica';
			$this->use_fpdf								= isset($conf->global->MAIN_USE_FPDF)							? $conf->global->MAIN_USE_FPDF : 0;
			$this->disable_fpdi							= isset($conf->global->MAIN_DISABLE_FPDI)						? $conf->global->MAIN_DISABLE_FPDI : 0;
			$this->add_pdf_bg							= isset($conf->global->MAIN_ADD_PDF_BACKGROUND)					? $conf->global->MAIN_ADD_PDF_BACKGROUND : 0;
			$this->Rounded_rect							= isset($conf->global->INFRAS_PDF_ROUNDED_REC)					? $conf->global->INFRAS_PDF_ROUNDED_REC : 0;
			$this->with_picture							= isset($conf->global->INFRAS_PDF_WITH_PICTURE)					? $conf->global->INFRAS_PDF_WITH_PICTURE : 0;
			$this->old_path_photo						= isset($conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO)			? $conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO : 0;
			$this->cat_hq_image							= isset($conf->global->CAT_HIGH_QUALITY_IMAGES)					? $conf->global->CAT_HIGH_QUALITY_IMAGES : 0;
			$this->product_use_unit						= isset($conf->global->PRODUCT_USE_UNITS)						? $conf->global->PRODUCT_USE_UNITS : 0;
			$this->small_head2							= isset($conf->global->INFRAS_PDF_SMALL_HEAD_2)					? $conf->global->INFRAS_PDF_SMALL_HEAD_2 : 0;
			$this->emetteur								= $mysoc;
			if (empty($this->emetteur->country_code))	$this->emetteur->country_code									= substr($langs->defaultlang, -2);
			$this->formatpage							= array('largeur'=>$this->page_largeur, 'hauteur'=>$this->page_hauteur, 'mgauche'=>$this->marge_gauche, 
																'mdroite'=>$this->marge_droite, 'mhaute'=>$this->marge_haute, 'mbasse'=>$this->marge_basse);
			$this->wpicture								= isset($conf->global->INFRAS_PDF_PICTURE_WIDTH)				? $conf->global->INFRAS_PDF_PICTURE_WIDTH : 20;
			$this->hpicture								= isset($conf->global->INFRAS_PDF_PICTURE_HEIGHT)				? $conf->global->INFRAS_PDF_PICTURE_HEIGHT : 32;
			$this->main_umask							= isset($conf->global->MAIN_UMASK)								? $conf->global->MAIN_UMASK : '0755';
			$this->bg_color								= isset($conf->global->INFRAS_PDF_BACKGROUND_COLOR)				? $conf->global->INFRAS_PDF_BACKGROUND_COLOR : '';
			$this->title_bg								= isset($conf->global->INFRAS_PDF_TITLE_BG)						? $conf->global->INFRAS_PDF_TITLE_BG : 0;
			$this->txtcolor								= explode(',', pdf_InfraS_txt_color($this->bg_color));
			$this->fold_mark							= isset($conf->global->INFRAS_PDF_FOLD_MARK)					? $conf->global->INFRAS_PDF_FOLD_MARK : 0;
			$this->type_foot							= isset($conf->global->INFRAS_PDF_TYPE_FOOT)					? $conf->global->INFRAS_PDF_TYPE_FOOT : 0;
			$this->wpicturefoot							= isset($conf->global->INFRAS_PDF_PICTURE_FOOT_WIDTH)			? $conf->global->INFRAS_PDF_PICTURE_FOOT_WIDTH : 188;
			$this->hpicturefoot							= isset($conf->global->INFRAS_PDF_PICTURE_FOOT_HEIGHT)			? $conf->global->INFRAS_PDF_PICTURE_FOOT_HEIGHT : 12;
			$this->maxsizeimgfoot						= array('largeur'=>$this->wpicturefoot, 'hauteur'=>$this->hpicturefoot);
			$this->hidepagenum							= isset($conf->global->INFRAS_PDF_HIDE_PAGE_NUM)				? $conf->global->INFRAS_PDF_HIDE_PAGE_NUM : 0;
			$this->option_logo							= 1;	// Affiche logo
			$this->option_codeproduitservice			= 0;	// Affiche code produit-service
			$this->option_multilang						= 1;	// Dispo en plusieurs langues
			$this->option_freetext						= 0;	// Support add of a personalised text
		}	// public function __construct($db)

		/********************************************
		*	Function to build pdf onto disk
		*
		*	@param		Product		$object				Object source to build document
		*	@param		Translate	$outputlangs		Lang output object
		*	@param		string		$srctemplatepath	Full path of source filename for generator using a template file
		*	@param		int			$hidedetails		Do not show line details (inutilisée ! laissé pour la compatibilité)
		*	@param		int			$hidedesc			Do not show desc
		*	@param		int			$hideref			Do not show ref
		*	@return     int             				1=OK, 0=KO
		********************************************/
		function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)
		{
			global $user, $langs, $conf, $db, $hookmanager;

			if (! is_object($outputlangs)) $outputlangs	= $langs;
			// For backward compatibility with FPDF, force output charset to ISO, because FPDF expect text to be encoded in ISO
			if (! empty($this->use_fpdf)) $outputlangs->charset_output	= 'ISO-8859-1';
			
			if((float)DOL_VERSION >= 8.0)	$outputlangs->loadLangs(array("main", "dict", "bills", "products", "deliveries", "companies", "orders", "infraspack@infraspack"));
			else
			{
				$outputlangs->load("main");
				$outputlangs->load("dict");
				$outputlangs->load("bills");
				$outputlangs->load("products");
				$outputlangs->load("deliveries");
				$outputlangs->load("companies");
				$outputlangs->load("orders");
				$outputlangs->load("infraspack@infraspack");
			}	// else	// if((float)DOL_VERSION >= 8.0)

			if ($conf->produit->dir_output)
			{
				// Definition of $dir and $file
				if ($object->specimen)
				{
					$dir										= $conf->produit->dir_output;
					$file										= $dir."/SPECIMEN.pdf";
				}	// if ($object->specimen)
				else
				{
					$objectref									= dol_sanitizeFileName($object->ref);
					$dir										= $conf->produit->dir_output."/".$objectref;
					$file										= $dir."/".$objectref.".pdf";
				}	// else	// if ($object->specimen)
				$productFournisseur								= new ProductFournisseur($this->db);
				$supplierprices									= $productFournisseur->list_product_fournisseur_price($object->id);
				$object->supplierprices							= $supplierprices;
				if (! file_exists($dir))
				{
					if (dol_mkdir($dir) < 0)
					{
						$this->error							= $langs->transnoentities("ErrorCanNotCreateDir", $dir);
						return -1;
					}	// if (dol_mkdir($dir) < 0)
				}	// if (! file_exists($dir))
				if (file_exists($dir))
				{
					if (! is_object($hookmanager))	// Add pdfgeneration hook
					{
						include_once DOL_DOCUMENT_ROOT.'/core/class/hookmanager.class.php';
						$hookmanager							= new HookManager($this->db);
					}	// if (! is_object($hookmanager))
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters									= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook									= $hookmanager->executeHooks('beforePDFCreation', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
					$this->pied									= $hookmanager->resArray['pied'];
					// Create pdf instance
					$pdf										= pdf_getInstance($this->format);
					$default_font_size							= pdf_getPDFFontSize($outputlangs);																								// Must be after pdf_getInstance
					$pdf->SetAutoPageBreak(1, 0);
					if (class_exists('TCPDF'))
					{
						$pdf->setPrintHeader(false);
						$pdf->setPrintFooter(false);
					}	// if (class_exists('TCPDF'))
					$pdf->SetFont($this->font);
					// Set path to the background PDF File
					if ((empty($this->disable_fpdi) || (float)DOL_VERSION >= 8.0) && ! empty($this->add_pdf_bg))
					{
						$pagecount	= $pdf->setSourceFile($conf->mycompany->dir_output.'/'.$this->add_pdf_bg);
						$tplidx		= $pdf->importPage(1);
					}	// if ((empty($this->disable_fpdi) || (float)DOL_VERSION >= 8.0) && ! empty($this->add_pdf_bg))
					$pdf->Open();
					$pdf->SetDrawColor(128, 128, 128);
					$pdf->SetTitle($outputlangs->convToOutputCharset($object->ref));
					$pdf->SetSubject($outputlangs->transnoentities("Order"));
					$pdf->SetCreator("Dolibarr ".DOL_VERSION);
					$pdf->SetAuthor($outputlangs->convToOutputCharset($user->getFullName($outputlangs)));
					$pdf->SetKeyWords($outputlangs->convToOutputCharset($object->ref)." ".$outputlangs->transnoentities("Order")." ".$outputlangs->convToOutputCharset($object->thirdparty->name));
					$pdf->SetMargins($this->marge_gauche, $this->marge_haute, $this->marge_droite);   // Left, Top, Right
					// New page
					$pdf->AddPage();
					if (! empty($tplidx))						$pdf->useTemplate($tplidx);
					$pagenb										= 1;
					$pdf->SetFont('', '', $default_font_size - 1);
					$pdf->MultiCell(0, 3, '');		// Set interline to 3
					$pdf->SetTextColor(0, 0, 0);
					// Define width and position of notes frames
					$this->larg_util_txt						= $this->page_largeur - ($this->marge_gauche + $this->marge_droite + ($this->Rounded_rect * 2) + 2);
					$this->larg_util_cadre						= $this->page_largeur - ($this->marge_gauche + $this->marge_droite);
					$this->posx_G_txt							= $this->marge_gauche + $this->Rounded_rect + 1;
					// Define width and position of main table columns
					$this->posxdesc								= $this->marge_gauche + 1;
					$this->larg_desc							= $this->page_largeur - $this->marge_gauche - $this->posxdesc; // Largeur variable suivant la place restante
					// Calculs de positions
					$this->tab_hl								= 4;
					$head										= $this->_pagehead($pdf, $object, 1, $outputlangs);
					$hauteurhead								= $head["totalhead"];
					$hauteurcadre								= $head["hauteurcadre"];
					$tab_top									= $hauteurhead + 5;
					$tab_top_newpage							= (empty($this->small_head2) ? $hauteurhead - $hauteurcadre : 17);
					$this->ht_top_table							= $this->Rounded_rect * 2 > $this->tab_hl ? ($this->Rounded_rect * 2) + 1 : $this->tab_hl;
					$this->ht_decal_round						= $this->Rounded_rect > 0 ? $this->Rounded_rect - 1 : 0;
					$heightforfooter							= $this->_pagefoot($pdf, $object, $outputlangs, 1);
					$bottomlasttab								= $this->page_hauteur - $heightforfooter - 1;
					// Affiche notes
					$height_note								= 0;
					$notetoshow									= empty($object->note) ? '' : $object->note;
					if ($notetoshow)
					{
						$substitutionarray	= pdf_getSubstitutionArray($outputlangs, null, $object);
						complete_substitutions_array($substitutionarray, $outputlangs, $object);
						$notetoshow			= make_substitutions($notetoshow, $substitutionarray, $outputlangs);
						$pdf->SetFont('', '', $default_font_size - 1);
						$pdf->startTransaction();
						$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top + $this->ht_top_table, dol_htmlentitiesbr($notetoshow), 0, 1);
						if ($pdf->getPage() > 1 || $pdf->GetY() > ($this->page_hauteur - $this->ht_top_table - $heightforfooter - 30)) // Notes need pagebreak or There is no space left for footer
						{
							$pdf->rollbackTransaction(true);
							$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top + $this->ht_top_table, dol_htmlentitiesbr($outputlangs->transnoentities("PDFInfrasNoteTooLong")), 0, 1);
						}	// if ($pdf->getPage() > 1 || $pdf->GetY() > ($this->page_hauteur - $heightforfooter))
						else									$pdf->commitTransaction();
						
						$curY									= $pdf->GetY();
						$height_note							= $this->Rounded_rect * 2 > $curY - $tab_top - $this->ht_top_table ? $this->Rounded_rect * 2 : $curY - $tab_top - $this->ht_top_table;
						$pdf->SetDrawColor(128, 128, 128);
						$pdf->RoundedRect($this->marge_gauche, $tab_top + $this->ht_top_table, $this->larg_util_cadre, $height_note + 2, $this->Rounded_rect, '1111');
					}	// if ($notetoshow)
					$curY										= $tab_top + $this->ht_top_table + $this->ht_decal_round + $height_note + 2;
					$pdf->SetFont('', '', $default_font_size - 1);
					$pdf->SetTextColor(0, 0, 0);
					if (! empty($this->with_picture))
					{
						include_once DOL_DOCUMENT_ROOT .'/core/lib/files.lib.php';
						include_once DOL_DOCUMENT_ROOT .'/core/lib/images.lib.php';

						$sortfield								= 'position_name';
						$sortorder								= 'asc';
						$posxpicture							= $curX;
						$posypicture							= $curY + 0.5;
						$this->wpicture							= ($this->larg_desc - 15) / 4;	// corrige la largeur maximal de l'image pour être au plus égale à 1/4 de la largeur colonne
						if (! empty($this->old_path_photo))		$pdir = get_exdir($this->id,2,0,0,$this,'product') . $this->id ."/photos/";
						else									$pdir = get_exdir(0, 0, 0, 0, $object, 'product').dol_sanitizeFileName($object->ref).'/';
						$dir = $conf->product->dir_output.'/'.$pdir;
						// Defined relative dir to DOL_DATA_ROOT
						$relativedir							= '';
						if ($dir)
						{
							$relativedir						= preg_replace('/^'.preg_quote(DOL_DATA_ROOT,'/').'/', '', $dir);
							$relativedir						= preg_replace('/^[\\/]/','',$relativedir);
							$relativedir						= preg_replace('/[\\/]$/','',$relativedir);
						}	// if ($dir)
						$filearray								= dol_dir_list($dir, "files", 0, '', '(\.meta|_preview.*\.png)$', $sortfield, (strtolower($sortorder)=='desc' ? SORT_DESC : SORT_ASC), 1);
						$filearrayindatabase					= dol_dir_list_in_database($relativedir, '', null, 'name', SORT_ASC);
						// Complete filearray with properties found into $filearrayindatabase
						foreach ($filearray as $key => $val)
						{
							$found								= 0;
							// Search if it exists into $filearrayindatabase
							foreach ($filearrayindatabase as $key2 => $val2)
							{
								if ($filearrayindatabase[$key2]['name'] == $filearray[$key]['name'])
								{
									$filearray[$key]['position_name']	= ($filearrayindatabase[$key2]['position'] ? $filearrayindatabase[$key2]['position'] : '0').'_'.$filearrayindatabase[$key2]['name'];
									$filearray[$key]['position']		= $filearrayindatabase[$key2]['position'];
									$filearray[$key]['cover']			= $filearrayindatabase[$key2]['cover'];
									$filearray[$key]['acl']				= $filearrayindatabase[$key2]['acl'];
									$filearray[$key]['rowid']			= $filearrayindatabase[$key2]['rowid'];
									$filearray[$key]['label']			= $filearrayindatabase[$key2]['label'];
									$found								= 1;
									break;
								}	// if ($filearrayindatabase[$key2]['name'] == $filearray[$key]['name'])
							}	// foreach ($filearrayindatabase as $key2 => $val2)
						}	// foreach ($filearray as $key => $val)
						if (count($filearray))
						{
							if ($sortfield && $sortorder)			$filearray	= dol_sort_array($filearray, $sortfield, $sortorder);
							foreach ($filearray as $key => $val)
							{
								$photo								= $val['name'];
								if (image_format_supported($photo) >= 0)
								{
									if (empty($this->cat_hq_image))		// If CAT_HIGH_QUALITY_IMAGES not defined, we use thumb if defined and then original photo
									{
										$vignette					= $dir.'thumbs/'.basename(getImageFileNameForSize($dir.$photo, '_small'));
										if (dol_is_file($vignette)) $realpath		= $vignette;
										else						$realpath		= $dir.$photo;
									}	// if (empty($this->cat_hq_image))
									else							$realpath		= $dir.$photo;
									$imglinesize					= array();
									if ($realpath)					$imglinesize	= pdf_InfraS_getSizeForImage($realpath, $this->wpicture, $this->hpicture);
									if (isset($imglinesize['width']) && isset($imglinesize['height']))
									{
										$pdf->Image($realpath, $posxpicture, $posypicture, $imglinesize['width'], $imglinesize['height'], '', '', '', 2, 300);	// Use 300 dpi
										$posxpicture				+= $this->wpicture + 5;	// $pdf->Image does not increase value return by getX, so we save it manually
										$posypictures				 = $posypictures < ($posypicture + $imglinesize['height']) ? $posypicture + $imglinesize['height'] : $posypictures;
									}	// if (isset($imglinesize['width']) && isset($imglinesize['height']))
								}	// if (image_format_supported($photo) >= 0)
							}	// foreach ($object->liste_photos($dir,1) as $key => $obj)
							$curY	= $posypictures ? $posypictures : $posypicture;	// $pdf->Image does not increase value return by getY, so we save it manually							
						}	// if (count($filearray))
					}	// if (! empty($this->with_picture))
					$pdf->writeHTMLCell(0, 0, $curX, $curY, dol_htmlentitiesbr($object->description), 0, 1, 0);
					$curY										= $pdf->GetY() + $this->tab_hl;
					if ($object->type != Product::TYPE_SERVICE)
					{
						$pdf->writeHTMLCell(0, 0, $curX, $curY, $langs->trans("Nature").' : ', 0, 1);
						$pdf->writeHTMLCell(0, 0, $curX + ($this->wpicture * 1.5), $curY, $object->getLibFinished(), 0, 1);
						$curY									= $pdf->GetY() + $this->tab_hl;
					}	// if ($object->type != Product::TYPE_SERVICE)
					if ($object->weight)
					{
						$txtWeight								= dol_htmlentitiesbr($object->weight).' '.measuring_units_string($object->weight_units, 'weight');
						$pdf->writeHTMLCell(0, 0, $curX, $curY, $langs->trans("Weight").' : ', 0, 1);
						$pdf->writeHTMLCell(0, 0, $curX + ($this->wpicture * 1.5), $curY, $txtWeight, 0, 1);
						$curY									= $pdf->GetY();
					}	// if ($object->weight)
					if ($object->length || $object->width || $object->height)
					{
						$txtDim									= '';
						$txtDim									.= ($object->length ? $langs->trans("Length") : '');
						$txtDim									.= ($object->length && ($object->width || $object->height) ? ' x ' : '');
						$txtDim									.= ($object->width ? $langs->trans("Width") : '');
						$txtDim									.= (($object->width && $object->height) ? ' x ' : '');
						$txtDim									.= ($object->height ? $langs->trans("Height") : '');
						$pdf->writeHTMLCell(0, 0, $curX, $curY, $txtDim.' : ', 0, 1);
						$txtDim									= ($object->length ? $object->length : '');
						$txtDim									.= ($object->length && ($object->width || $object->height) ? ' x ' : '');
						$txtDim									.= ($object->width ? $object->width : '');
						$txtDim									.= (($object->width && $object->height) ? ' x ' : '');
						$txtDim									.= ($object->height ? $object->height : '');
						$txtDim									.= ' '.measuring_units_string($object->length_units, 'size');
						$pdf->writeHTMLCell(0, 0, $curX + ($this->wpicture * 1.5), $curY, $txtDim, 0, 1);
						$curY									= $pdf->GetY();
					}	// if ($object->length || $object->width || $object->height)
					if ($object->surface)
					{
						$txtArea								= dol_htmlentitiesbr($object->surface).' '.measuring_units_string($object->surface_units, 'surface');
						$pdf->writeHTMLCell(0, 0, $curX, $curY, $langs->trans("Surface").' : ', 0, 1);
						$pdf->writeHTMLCell(0, 0, $curX + ($this->wpicture * 1.5), $curY, $txtArea, 0, 1);
						$curY									= $pdf->GetY();
					}	// if ($object->surface)
					if ($object->volume)
					{
						$txtVol									= dol_htmlentitiesbr($object->volume).' '.measuring_units_string($object->volume_units, 'volume');
						$pdf->writeHTMLCell(0, 0, $curX, $curY, $langs->trans("Volume").' : ', 0, 1);
						$pdf->writeHTMLCell(0, 0, $curX + ($this->wpicture * 1.5), $curY, $txtVol, 0, 1);
						$curY									= $pdf->GetY();
					}	// if ($object->volume)
					$curY										+= $this->tab_hl;
					if ($this->product_use_unit)
					{
						$pdf->writeHTMLCell(0, 0, $curX, $curY, $langs->trans("DefaultUnitToShow").' : ', 0, 1);
						$pdf->writeHTMLCell(0, 0, $curX + ($this->wpicture * 1.5), $curY, $langs->trans($object->getLabelOfUnit()), 0, 1);
						$curY									= $pdf->GetY();
					}	// if ($this->product_use_unit)
					$this->_tableau($pdf, $object, $tab_top, $height_note, $bottomlasttab - $tab_top, $outputlangs, $this->hide_top_table, 1, $pagenb);
					$pdf->SetTextColor(0, 0, 0);
					$this->_pagefoot($pdf, $object, $outputlangs, 0);
					if (method_exists($pdf, 'AliasNbPages'))	$pdf->AliasNbPages();
					$pdf->Close();
					$pdf->Output($file, 'F');
					// Add pdfgeneration hook
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters									= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook									= $hookmanager->executeHooks('afterPDFCreation',$parameters,$this,$action);
					if (! empty($this->main_umask))				@chmod($file, octdec($this->main_umask));
					$this->result								= array('fullpath' => $file);
					return 1;   // Pas d'erreur
				}	// if (file_exists($dir))
				else
				{
					$this->error=$langs->trans("ErrorCanNotCreateDir",$dir);
					return 0;
				}	// else	// if (file_exists($dir))
			}	// if ($conf->contrat->dir_output)
			else
			{
				$this->error=$langs->trans("ErrorConstantNotDefined","PRODUCT_OUTPUTDIR");
				return 0;
			}	// else	// if ($conf->contrat->dir_output)
		}	// function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)

		/********************************************
		*	Show top header of page.
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object     	Object to show
		*	@param		int	    	$showaddress    0=no, 1=yes
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		string		$titlekey		Translation key to show as title of document
		*	@return		array		$hauteurhead	'totalhead'		= hight of header
		*											'hauteurcadre	= hight of frame
		********************************************/
		function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "")
		{
			global $conf, $langs, $hookmanager;

			if((float)DOL_VERSION >= 8.0)	$outputlangs->loadLangs(array("main", "bills", "companies", "propal", "orders", "commercial"));
			else
			{
				$outputlangs->load("main");
				$outputlangs->load("bills");
				$outputlangs->load("companies");
				$outputlangs->load("propal");
				$outputlangs->load("orders");
				$outputlangs->load("commercial");
			}	// else	// if((float)DOL_VERSION >= 8.0)
		    if ($object->type == 1)	$titlekey	= 'ServiceSheet';
			else					$titlekey	= 'ProductSheet';

			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			pdf_pagehead($pdf, $outputlangs, $this->page_hauteur);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('', 'B', $default_font_size + 3);
			$w		= 100;
			$posy	= $this->marge_haute;
			$posx	= $this->page_largeur - $this->marge_droite - $w;
			$pdf->SetXY($this->marge_gauche, $posy);
			// Logo
			$logo	= $conf->mycompany->dir_output.'/logos/'.$this->emetteur->logo;
			if ($logo)
			{
				if (is_file($logo) && is_readable($logo))
				{
					$heightLogo	= pdf_getHeightForLogo($logo);
					$pdf->Image($logo, $this->marge_gauche, $posy, 0, $heightLogo);	// width=0 (auto)
				}	// if (is_file($logo) && is_readable($logo))
				else
				{
					$pdf->SetTextColor(200, 0, 0);
					$pdf->SetFont('', 'B', $default_font_size - 2);
					$pdf->MultiCell($w, $this->tab_hl, $outputlangs->transnoentities("ErrorLogoFileNotFound",$logo), 0, 'L');
					$pdf->MultiCell($w, $this->tab_hl, $outputlangs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
					$pdf->SetTextColor(0, 0, 0);
				}	// else	// if (is_file($logo) && is_readable($logo))
			}	// if ($logo)
			else
			{
				$text=$this->emetteur->name;
				$pdf->MultiCell($w, $this->tab_hl, $outputlangs->convToOutputCharset($text), 0, 'L');
				$heightLogo = $this->tab_hl;
			}	// else// if ($logo)
			$heightLogo	+= $posy + $this->tab_hl;
			$pdf->SetFont('', 'B', $default_font_size * 2);
			$title		= $outputlangs->transnoentities($titlekey);
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl * 2, $title, '', 'R');
			$pdf->SetFont('', 'B',$default_font_size);
			$posy		+= $this->tab_hl * 2;
			$txtref		= $outputlangs->transnoentities("Ref")." : ".$outputlangs->convToOutputCharset($object->ref);
			$pdf->SetXY($posx, $posy);
			$pdf->MultiCell($w, $this->tab_hl, $txtref, '', 'R');
			$pdf->SetFont('', '', $default_font_size - 1);
			$posy		+= $this->tab_hl + 1;
			// Show list of linked objects
			$posy		+= 1;
			$posy		= pdf_writeLinkedObjects($pdf, $object, $outputlangs, $posx, $posy, $w, $this->tab_hl, 'R', $default_font_size);
			$posy		+= 1;
			($heightLogo > $posy + $this->tab_hl ? $posycadre = $heightLogo : $posycadre = $posy + $this->tab_hl);
			$hauteurhead = array('totalhead'=>$posycadre + $hauteurcadre, 'hauteurcadre'=>$hauteurcadre);
			return $hauteurhead;
		}	// function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "")
		/********************************************
		*   Show table for lines
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param  	Object		$object     	Object to show
		*	@param		float		$tab_top		Top position of table
		
		*	@param		float		$tab_height		Height of table (rectangle)
		*	@param		Translate	$outputlangs	Langs object
		*	@param		int			$hidetop		1=Hide top bar of array and title, 0=Hide nothing, -1=Hide only title
		*	@param		int			$hidebottom		Hide bottom bar of array
		*	@return		void
		********************************************/
		function _tableau(&$pdf, $object, $tab_top, $height_note, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)
		{
			global $conf;

			// Force to disable hidetop and hidebottom
			$hidebottom			= 0;
			if ($hidetop)		$hidetop	= -1;
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$pdf->SetDrawColor(128, 128, 128);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('', '', $default_font_size - 2);
			// Output Rounded Rectangle
			if (empty($hidetop) || $pagenb == 1)
			{
				if (! empty($this->title_bg))
				{
					$bg_color	= explode(',', $this->bg_color);
					$pdf->SetDrawColor($bg_color[0], $bg_color[1], $bg_color[2]);
					$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111', 'DF', null, explode(',', $this->bg_color));
					$pdf->SetDrawColor(128, 128, 128);
				}	// if (! empty($this->title_bg))
				else	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111');
				$pdf->RoundedRect($this->marge_gauche, $tab_top + $this->ht_top_table, $this->larg_util_cadre, $tab_height - $this->ht_top_table, $this->Rounded_rect, '1111');
			}	// if (empty($hidetop) || $pagenb == 1)
			else	$pdf->RoundedRect($this->marge_gauche, $tab_top + $height_note, $this->larg_util_cadre, $tab_height, $this->Rounded_rect, '1111');
			// Show Folder mark
			if (! empty($this->fold_mark))
			{
				$pdf->Line(0, ($this->page_hauteur)/3, $this->fold_mark, ($this->page_hauteur)/3);
				$pdf->Line($this->page_largeur - $this->fold_mark, ($this->page_hauteur)/3, $this->page_largeur, ($this->page_hauteur)/3);
			}	// if (! empty($this->fold_mark))
			// Colonnes
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$this->title_bg ? $pdf->SetTextColor($this->txtcolor[0], $this->txtcolor[1], $this->txtcolor[2]) : $pdf->SetTextColor(0, 0, 0);
			if (empty($hidetop) || $pagenb == 1)
			{
				$pdf->SetXY($this->posxdesc, $tab_top);
				$pdf->writeHTMLCell($this->larg_util_cadre, 4, $this->posxdesc, $tab_top + (($this->ht_top_table - 4) / 2), dol_htmlentitiesbr($object->label), 0, 1, 0, 1, 'C');
				}	// if (empty($hidetop) || $pagenb == 1)
		}	// function _tableau(&$pdf, $object, $tab_top, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)

		/********************************************
		*	Show footer of page. Need this->emetteur object
		*
		*	@param		PDF			$pdf     		The PDF factory
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		Societe		$fromcompany	Object company
		*	@param		int			$marge_basse	Margin bottom we use for the autobreak
		*	@param		int			$marge_gauche	Margin left
		*	@param		int			$page_hauteur	Page height
		*	@param		Object		$object			Object shown in PDF
		*	@param		int			$showdetails	Show company details into footer. This param seems to not be used by standard version.
													(10=minimum, 11 = 1 + Logos de pied, 20 = Show address and managers, 21 = Show 2 + Logos de pied)
		*	@param		int			$hidesupline	Completly hide the line up to footer (for some edition with only table)
		*	@param		int			$calculseul		Arrête la fonction au calcul de hauteur nécessaire
		*	@return		int							Return height of bottom margin including footer text
		********************************************/
		function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
		{
			global $conf, $langs;
			
			$showdetails									= 10;
			if (! empty($this->type_foot))	$showdetails	= 20;
			if (! empty($this->pied))		$showdetails	+= 1;
			return pdf_InfraS_pagefoot($pdf, $outputlangs, $this->emetteur, $this->formatpage, $showdetails, 1, $calculseul, $this->pied, $this->maxsizeimgfoot, $this->hidepagenum);
		}	// function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
	}	// class pdf_InfraS_product extends ModelePDFProduct
?>
