--	/************************************************
--	* Copyright (C) 2016-2018	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
--	*
--	* This program is free software: you can redistribute it and/or modify
--	* it under the terms of the GNU General Public License as published by
--	* the Free Software Foundation, either version 3 of the License, or
--	* (at your option) any later version.
--	*
--	* This program is distributed in the hope that it will be useful,
--	* but WITHOUT ANY WARRANTY; without even the implied warranty of
--	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--	* GNU General Public License for more details.
--	*
--	* You should have received a copy of the GNU General Public License
--	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
--	************************************************/

--	/************************************************
--	* 	\file		../infraspack/sql/data.sql
--	* 	\ingroup	InfraS
--	* 	\brief		SQL data for module InfraS
--	************************************************/

SET FOREIGN_KEY_CHECKS = 0;
SET SQL_MODE = 'NO_AUTO_VALUE_ON_ZERO';
LOCK TABLES llx_document_model WRITE, llx_const WRITE;

-- Data for table llx_document_model
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_commande', '__ENTITY__', 'order', 'InfraS-C');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_contract', '__ENTITY__', 'contract', 'InfraS-CT');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_devis', '__ENTITY__', 'propal', 'InfraS-D');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_devis_st', '__ENTITY__', 'propal', 'InfraS-D-ST');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_expedition', '__ENTITY__', 'shipping', 'InfraS-BL');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_fichinter', '__ENTITY__', 'ficheinter', 'InfraS-FI');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_invoice', '__ENTITY__', 'invoice', 'InfraS-F');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_orderfab', '__ENTITY__', 'order', 'InfraS-OF');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_product', '__ENTITY__', 'product', 'InfraS-P');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_proforma', '__ENTITY__', 'order', 'InfraS-CP');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_supplier_invoice', '__ENTITY__', 'invoice_supplier', 'InfraS-FF');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_supplier_order', '__ENTITY__', 'order_supplier', 'InfraS-CF');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraS_supplier_proposal', '__ENTITY__', 'supplier_proposal', 'InfraS-DF');

-- Data for table llx_const
DELETE FROM llx_const WHERE name like 'COMMANDE_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'COMMANDE_SUPPLIER_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'CONTRACT_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'EXPEDITION_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'FACTURE_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'FICHEINTER_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'INVOICE_SUPPLIER_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'PRODUCT_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'PROPALE_ADDON_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name like 'SUPPLIER_PROPOSAL_ADDON_PDF' AND entity = '__ENTITY__';
INSERT INTO llx_const (name, entity, value, type) VALUES ('COMMANDE_ADDON_PDF', '__ENTITY__', 'InfraS_commande', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('COMMANDE_SUPPLIER_ADDON_PDF', '__ENTITY__', 'InfraS_supplier_order', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('CONTRACT_ADDON_PDF', '__ENTITY__', 'InfraS_contract', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('EXPEDITION_ADDON_PDF', '__ENTITY__', 'InfraS_expedition', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('FACTURE_ADDON_PDF', '__ENTITY__', 'InfraS_invoice', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('FICHEINTER_ADDON_PDF', '__ENTITY__', 'InfraS_fichinter', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_VALID_CORE_CHGT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_BACKGROUND_COLOR', '__ENTITY__', '109, 70, 140', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_COMMANDE_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_CGV_BY_DEFAULT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_FOLD_MARK', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_FONT', '__ENTITY__', 'Helvetica', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HIDE_COLS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HIDE_DISCOUNT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HIDE_ORDERED', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HIDE_PAGE_NUM', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HIDE_RECEP_FRAME', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HIDE_TOP_TABLE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HIDE_UP', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_HT_SIGN_AREA', '__ENTITY__', '8', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_I_WATERMARK_OPACITY', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_INTERVENTION_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_LABEL_BOLD', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_LARGCOL_DISC', '__ENTITY__', '14', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_LARGCOL_PROGRESS', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_LARGCOL_QTY', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_LARGCOL_TOTAL', '__ENTITY__', '24', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_LARGCOL_UNIT', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_LARGCOL_UP', '__ENTITY__', '22', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMBER_WORDS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_DESC', '__ENTITY__', '2', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_DISC', '__ENTITY__', '7', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_PROGRESS', '__ENTITY__', '9', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_QTY', '__ENTITY__', '3', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_REF', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_TOTAL', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_TVA', '__ENTITY__', '6', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_UNIT', '__ENTITY__', '4', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_UP', '__ENTITY__', '5', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_NUMCOL_UPD', '__ENTITY__', '8', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_PICTURE_FOOT_HEIGHT', '__ENTITY__', '4', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_PICTURE_FOOT_WIDTH', '__ENTITY__', '20', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_PICTURE_HEIGHT', '__ENTITY__', '32', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_PICTURE_WIDTH', '__ENTITY__', '16', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_PROPAL_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_PROPAL_ST_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_ROUNDED_REC', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_ADRESSE_LIVRAISON', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_ADRESSE_RECEPTION', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_DESC_DEV', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_LCR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_OUTSTDBILL', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_RECEP_DETAILS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_TOTAL_LOCAL_CUR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SHOW_UP_DISCOUNTED', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SMALL_HEAD_2', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_SUPPLIER_ORDER_WITH_PICTURE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_T_WATERMARK_OPACITY', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_TEXT_COLOR', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_TEXT_COLOR_AUTO', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_TITLE_BG', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_TTC_WITH_VAT_TOT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_TYPE_FOOT', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_WITH_PICTURE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_WITH_REF_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_WITH_SUPPLIER_REF_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_WITHOUT_VAT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_WITHOUT_VAT_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_X_PAGE_NUM', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRAS_PDF_Y_PAGE_NUM', '__ENTITY__', '285', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INVOICE_SUPPLIER_ADDON_PDF', '__ENTITY__', 'InfraS_supplier_invoice', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('PRODUCT_ADDON_PDF', '__ENTITY__', 'InfraS_product', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('PROPALE_ADDON_PDF', '__ENTITY__', 'InfraS_devis', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('SUPPLIER_PROPOSAL_ADDON_PDF', '__ENTITY__', 'InfraS_supplier_proposal', 'chaine');

ALTER TABLE llx_document_model ENABLE KEYS;
ALTER TABLE llx_const ENABLE KEYS;

UNLOCK TABLES;
SET FOREIGN_KEY_CHECKS = 1;
