--	/************************************************
--	* Copyright (C) 2017	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
--	*
--	* This program is free software: you can redistribute it and/or modify
--	* it under the terms of the GNU General Public License as published by
--	* the Free Software Foundation, either version 3 of the License, or
--	* (at your option) any later version.
--	*
--	* This program is distributed in the hope that it will be useful,
--	* but WITHOUT ANY WARRANTY; without even the implied warranty of
--	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--	* GNU General Public License for more details.
--	*
--	* You should have received a copy of the GNU General Public License
--	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
--	************************************************/

--	/************************************************
--	* 	\file		../infraspack/sql/llx_societe_address.sql
--	* 	\ingroup	InfraS
--	* 	\brief		Modifie SQL table for module InfraS
--	************************************************/

SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
LOCK TABLES `llx_societe_address` WRITE;

--	Create new field 'email' for societe address (ignore error if exist)
DROP PROCEDURE IF EXISTS `societe_address_email`;
DELIMITER //
CREATE PROCEDURE `societe_address_email`()
BEGIN
  DECLARE CONTINUE HANDLER FOR SQLEXCEPTION BEGIN END;
  ALTER TABLE `llx_societe_address` ADD COLUMN `email` varchar(128) NULL DEFAULT NULL;
  ALTER TABLE `llx_societe_address` ADD COLUMN `url` varchar(255) NULL DEFAULT NULL;
END //
DELIMITER ;
CALL `societe_address_email`();
DROP PROCEDURE `societe_address_email`;

UNLOCK TABLES;
SET FOREIGN_KEY_CHECKS=1;
