--	/************************************************
--	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
--	*
--	* This program is free software: you can redistribute it and/or modify
--	* it under the terms of the GNU General Public License as published by
--	* the Free Software Foundation, either version 3 of the License, or
--	* (at your option) any later version.
--	*
--	* This program is distributed in the hope that it will be useful,
--	* but WITHOUT ANY WARRANTY; without even the implied warranty of
--	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--	* GNU General Public License for more details.
--	*
--	* You should have received a copy of the GNU General Public License
--	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
--	************************************************/

--	/************************************************
--	* 	\file		../infraspackplus/sql/data.sql
--	* 	\ingroup	InfraS
--	* 	\brief		SQL data for module InfraS
--	************************************************/

SET FOREIGN_KEY_CHECKS = 0;
SET SQL_MODE = 'NO_AUTO_VALUE_ON_ZERO';
LOCK TABLES llx_document_model WRITE, llx_const WRITE, llx_c_infraspackplus_mention WRITE, llx_c_infraspackplus_note WRITE;

-- Data for table llx_document_model
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_C', '__ENTITY__', 'order', 'InfraSPlus_C');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_CT', '__ENTITY__', 'contract', 'InfraSPlus_CT');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_D', '__ENTITY__', 'propal', 'InfraSPlus_D');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_BL', '__ENTITY__', 'shipping', 'InfraSPlus_BL');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_FI', '__ENTITY__', 'ficheinter', 'InfraSPlus_FI');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_F', '__ENTITY__', 'invoice', 'InfraSPlus_F');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_PJ', '__ENTITY__', 'project', 'InfraSPlus_PJ');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_P', '__ENTITY__', 'product', 'InfraSPlus_P');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_FF', '__ENTITY__', 'invoice_supplier', 'InfraSPlus_FF');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_CF', '__ENTITY__', 'order_supplier', 'InfraSPlus_CF');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_DF', '__ENTITY__', 'supplier_proposal', 'InfraSPlus_DF');
INSERT INTO llx_document_model (nom, entity, type, libelle) VALUES ('InfraSPlus_NDF', '__ENTITY__', 'expensereport', 'InfraSPlus_NDF');

-- Data for table llx_const
DELETE FROM llx_const WHERE name LIKE 'COMMANDE\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'COMMANDE\_SUPPLIER\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'CONTRACT\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'EXPEDITION\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'EXPENSEREPORT\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'FACTURE\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'FICHEINTER\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'INVOICE\_SUPPLIER\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'PRODUCT\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'PROJECT\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'PROPALE\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'SUPPLIER\_PROPOSAL\_ADDON\_PDF' AND entity = '__ENTITY__';
DELETE FROM llx_const WHERE name LIKE 'EXPENSEREPORT\_ADDON\_PDF' AND entity = '__ENTITY__';
INSERT INTO llx_const (name, entity, value, type) VALUES ('COMMANDE_ADDON_PDF', '__ENTITY__', 'InfraSPlus_C', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('COMMANDE_SUPPLIER_ADDON_PDF', '__ENTITY__', 'InfraSPlus_CF', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('CONTRACT_ADDON_PDF', '__ENTITY__', 'InfraSPlus_CT', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('EXPEDITION_ADDON_PDF', '__ENTITY__', 'InfraSPlus_BL', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('EXPENSEREPORT_ADDON_PDF', '__ENTITY__', 'InfraSPlus_NDF', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('FACTURE_ADDON_PDF', '__ENTITY__', 'InfraSPlus_F', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('FICHEINTER_ADDON_PDF', '__ENTITY__', 'InfraSPlus_FI', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_ADRESSE_LIVRAISON_MIXTE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_BACKGROUND_COLOR', '__ENTITY__', '109, 70, 140', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_BL_WITH_BC_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_BODY_TEXT_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGA', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGA_BY_DEF_FOR_ORDERS', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGA_BY_DEF_FOR_PROPOSALS', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGI', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGV', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGV_BY_DEF_FOR_CONTRACTS', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGV_BY_DEF_FOR_INVOICES', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGV_BY_DEF_FOR_ORDERS', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGV_BY_DEF_FOR_PROPOSALS', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CGV_FROM_LANG', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_COMMANDE_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_COMMANDE_OF_SHOW_2_SIGNATURES', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CREATOR_IN_HEADER', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_CUSTOMER_SIGNING_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_DATES_BR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_DATES_BOLD', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_DEFAULT_ADDR_DELIV', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_DIM_C2D', '__ENTITY__', '15', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_C', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_CF', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_CT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_D', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_DF', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_E', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_F', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_FF', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_FI', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_PRE', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_C', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_CF', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_CT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_D', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_DF', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_E', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_F', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_FF', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_FI', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_PRE', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXPEDITION_SHOW_SIGNATURE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_EXTRADET_SECOND', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FACTURE_CODE_ADDR_FACT', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FACTURE_PAID_WATERMARK', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FACTURE_PARENT_ADDR_FACT', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FILES_FROM_PROJECT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FIRST_PAGE_EMPTY', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FIRST_SALES_REP_IN_NOTE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FOLD_MARK', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FONT', '__ENTITY__', 'Helvetica', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FOOTER_BOLD', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FREETEXTEND', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_BG_COLOR', '__ENTITY__', '109, 70, 140', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_LINE_COLOR', '__ENTITY__', '128,128,128', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_LINE_DASH', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_LINE_DASH_0', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_LINE_DASH_1', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_LINE_DASH_2', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_LINE_DASH_4', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_LINE_WIDTH', '__ENTITY__', '0.2', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_OPACITY', '__ENTITY__', '30', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_E_TEXT_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_LINE_COLOR', '__ENTITY__', '128,128,128', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_LINE_DASH', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_LINE_DASH_0', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_LINE_DASH_1', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_LINE_DASH_2', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_LINE_DASH_4', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_LINE_WIDTH', '__ENTITY__', '0.2', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_OPACITY', '__ENTITY__', '30', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_FRM_R_TEXT_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_GET_CUSTOMER_SIGNING', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HEADER_ALIGN_LEFT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HEADER_TEXT_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_COLS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_DISCOUNT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_LABEL', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_ORDERED', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_PAGE_NUM', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_QTY', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_RECEP_FRAME', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_SERVICE_DATES', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_TIME_SPENT_FI', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_TOP_TABLE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HIDE_UP', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HOR_LINE_COLOR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HT_BC', '__ENTITY__', '12', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_HT_SIGN_AREA', '__ENTITY__', '8', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_IMAGE_FOOT', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_IMAGE_WATERMARK', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE_EMET', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_INTERVENTION_SIGNATURE_FULL', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_I_WATERMARK_OPACITY', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LABEL_BOLD', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_DISC', '__ENTITY__', '14', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_PROGRESS', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_QTY', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_REF', '__ENTITY__', '20', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_TOTAL', '__ENTITY__', '24', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_TOTAL_TTC', '__ENTITY__', '24', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_TVA', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_UNIT', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_UP', '__ENTITY__', '22', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARGCOL_UPD', '__ENTITY__', '22', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LARG_BC', '__ENTITY__', '35', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LAST_NOTE_AS_TABLE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LINESEP_HIGHT', '__ENTITY__', '4', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_LINK_PICTURE_URL', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_MULTI_FILES', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMBER_WORDS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_DESC', '__ENTITY__', '2', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_DISC', '__ENTITY__', '7', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_PROGRESS', '__ENTITY__', '9', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_QTY', '__ENTITY__', '3', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_REF', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_TOTAL', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_TOTAL_TTC', '__ENTITY__', '11', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_TVA', '__ENTITY__', '6', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_UNIT', '__ENTITY__', '4', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_UP', '__ENTITY__', '5', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_NUMCOL_UPD', '__ENTITY__', '8', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_ONLY_HT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_ONLY_TTC', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PAY_SPEC', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT', '__ENTITY__', '4', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PICTURE_FOOT_WIDTH', '__ENTITY__', '20', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PICTURE_HEIGHT', '__ENTITY__', '32', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PICTURE_WIDTH', '__ENTITY__', '16', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PRJ_DATEO_IN_NOTE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROFID1_IN_SOURCE_ADDRESS', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROFID2_IN_SOURCE_ADDRESS', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROFID3_IN_SOURCE_ADDRESS', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROFID4_IN_SOURCE_ADDRESS', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROFID5_IN_SOURCE_ADDRESS', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROJECT_TIMESTAMP', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROPAL_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_PROPAL_ST_SHOW_SIGNATURE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_REFDATE_MERGE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_REFDATE_MERGE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_ROUNDED_REC', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SET_LOGO_EMET_TIERS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_ADRESSE_LIVRAISON', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_ADRESSE_RECEPTION', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_ADR_PROD', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_CUR_SYMB', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_DATES_HOURS_FI', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_DESC_DEV', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_DESC_PROJECT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_EMET_DETAILS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_E_SIGNING', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_LCR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_NUM_CLI', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_OUTSTDBILL', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_QTY_PROD_TOT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_RECEP_DETAILS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_REF_PROJECT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SENDER_ALIAS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_STATUS_WITH_NAME', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_COM', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_CT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_DEV', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_DEV_FOU', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_EXP', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FAC', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FI', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FOU', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_COM', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_CT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_DEV', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_DEV_FOU', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_EXP', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_FAC', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_FI', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_SYS_NT_BASE_FOU', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_TOTAL_LOCAL_CUR', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_TOT_DISCOUNT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_UP_DISCOUNTED', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SHOW_WVCC', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SIGN_LINE_COLOR', '__ENTITY__', '128,128,128', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SIGN_LINE_DASH', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SIGN_LINE_DASH_0', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SIGN_LINE_DASH_1', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SIGN_LINE_DASH_2', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SIGN_LINE_DASH_4', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SIGN_LINE_WIDTH', '__ENTITY__', '0.2', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SMALL_HEAD_2', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_SUPPLIER_ORDER_WITH_PICTURE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TBL_LINE_COLOR', '__ENTITY__', '128,128,128', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TBL_LINE_DASH', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TBL_LINE_DASH_0', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TBL_LINE_DASH_1', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TBL_LINE_DASH_2', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TBL_LINE_DASH_4', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TBL_LINE_WIDTH', '__ENTITY__', '0.2', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TEXT_COLOR', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TEXT_COLOR_AUTO', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TITLE_BG', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TITLE_SIZE', '__ENTITY__', '2', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TTC_WITH_VAT_TOT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TVAINTRA_IN_SOURCE_ADDRESS', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TYPE_FOOT', '__ENTITY__', '1020', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_TYPE_SOUS_TRAITANT', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_T_WATERMARK_OPACITY', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_VALID_CORE_CHGT', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WITHOUT_VAT_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WITH_NUM_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WITH_PICTURE', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WITH_REF_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WITH_SUPPLIER_REF_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WITH_TTC_COLUMN', '__ENTITY__', '0', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WVCC_BY_DEF_FOR_EXPEDITION', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WVCC_BY_DEF_FOR_INVOICES', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WVCC_BY_DEF_FOR_ORDERS', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_WVCC_BY_DEF_FOR_PROPOSALS', '__ENTITY__', '', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_X_PAGE_NUM', '__ENTITY__', '10', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INFRASPLUS_PDF_Y_PAGE_NUM', '__ENTITY__', '285', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('INVOICE_SUPPLIER_ADDON_PDF', '__ENTITY__', 'InfraSPlus_FF', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('MAIN_DISABLE_PDF_AUTOUPDATE', '__ENTITY__', '1', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('PRODUCT_ADDON_PDF', '__ENTITY__', 'InfraSPlus_P', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('PROJECT_ADDON_PDF', '__ENTITY__', 'InfraSPlus_PJ', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('PROPALE_ADDON_PDF', '__ENTITY__', 'InfraSPlus_D', 'chaine');
INSERT INTO llx_const (name, entity, value, type) VALUES ('SUPPLIER_PROPOSAL_ADDON_PDF', '__ENTITY__', 'InfraSPlus_DF', 'chaine');

-- Data for table llx_c_infraspackplus_mention
INSERT INTO llx_c_infraspackplus_mention (code, entity, pos, libelle, active) VALUES('BASE', '__ENTITY__', '10', 'Mention de base', 1);
INSERT INTO llx_c_infraspackplus_mention (code, entity, pos, libelle, active) VALUES('ASSDEC', '__ENTITY__', '20', 'Assurance decennale', 1);
INSERT INTO llx_c_infraspackplus_mention (code, entity, pos, libelle, active) VALUES('LIMPROP', '__ENTITY__', '30', 'Limite de propriété', 1);
INSERT INTO llx_c_infraspackplus_mention (code, entity, pos, libelle, active) VALUES('OTHER', '__ENTITY__', '40', 'Autre', 1);

-- Data for table llx_c_infraspackplus_note
INSERT INTO llx_c_infraspackplus_note (code, entity, pos, libelle, active) VALUES('BASE', '__ENTITY__', '10', 'Notes de base', 1);

ALTER TABLE llx_document_model ENABLE KEYS;
ALTER TABLE llx_const ENABLE KEYS;
ALTER TABLE llx_c_infraspackplus_mention ENABLE KEYS;
ALTER TABLE llx_c_infraspackplus_note ENABLE KEYS;

UNLOCK TABLES;
SET FOREIGN_KEY_CHECKS = 1;
