<?php
/* Copyright (C) 2015-2017		Charlie Benke	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file	   htdocs/management/class/actions_management.class.php
 * 	\ingroup	extrodt
 * 	\brief	  Fichier de la classe des actions/hooks de management (pour les agendas partags)
 */

class ActionsManagement // extends CommonObject 
{
	/** Overloading the doActions function : replacing the parent's function with the one below 
	 *  @param	  parameters  meta datas of the hook (context, etc...) 
	 *  @param	  object			 the object you want to process 
	 *  @param	  action			 current action (if set). Generally create or edit or null 
	 *  @return	   void 
	 */
	 
	function addMoreActionsButtons($parameters, $object, $action) 
	{
		global $conf, $langs, $db;
		global $user;

		if ($object->element  == 'fichinter') {
			if ($object->statut == 0 && $user->rights->ficheinter->creer && (count($object->lines) > 0)) {
				print '<div class="inline-block divButAction">';
				print '<a class="butAction" href="'.dol_buildpath('/management/fichinter/', 1);
				print 'fiche-rec.php?id='.$object->id.'&action=create"';
				print '>'.$langs->trans("ChangeIntoRepeatableInterventional").'</a></div>';
			}
		}
		

		if ($object->element  == 'propal' && $conf->global->MANAGEMENT_GENERATE_PROJECT_FROM_PROPOSAL) {
			// que pour propales accepte
			if ($object->statut == 2 && $user->rights->projet->creer && (count($object->lines) > 0 )) {
				print '<div class="inline-block divButAction"><a class="butAction" ';
				print 'href="'.$_SERVER['PHP_SELF'] . '?id=' . $object->id . '&amp;action=createproject"';
				print '>'.$langs->trans("CreateProjectFromProposal").'</a></div>';
			}
		}
		
	}

	// ca ne fonctionne pas  enlever ???
	function doActions($parameters, $object, $action) 
	{
		global $conf, $langs, $db, $user;

		if ($object->element  == 'fichinter') {
			$object->statuts[4]='StatusInterPartialClosed';
			$object->statuts[3]='StatusInterClosed';

			$object->statuts_short[4]='StatusInterPartialClosed';
			$object->statuts_short[3]='StatusInterClosed';

			$object->statuts_logo[4]='statut3';
			$object->statuts_logo[3]='statut4';
			$object->statuts_logo[2]='statut6';
		}

		if ($conf->global->MANAGEMENT_GENERATE_PROJECT_FROM_PROPOSAL) {
			if ($object->element == 'propal' && $action=="createproject") {
				require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
				require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';
				dol_include_once('/management/class/managementtask.class.php');
				$projectstatic = new Project($db);
	
				$defaultref='';
				$modele = empty($conf->global->PROJECT_ADDON)?'mod_project_simple':$conf->global->PROJECT_ADDON;
				
				// Search template files
				$file=''; $classname=''; $filefound=0;
				$dirmodels=array_merge(array('/'), (array) $conf->modules_parts['models']);
				foreach ($dirmodels as $reldir) {
					$file=dol_buildpath($reldir."core/modules/project/".$modele.'.php', 0);
					if (file_exists($file)) {
						$filefound=1;
						$classname = $modele;
						break;
					}
				}
				
				if ($filefound) {
					$result=dol_include_once($reldir."core/modules/project/".$modele.'.php');
					$modProject = new $classname;

					$defaultref = $modProject->getNextValue($object->thirdparty, $projectstatic);
				}
				
				if ($object->fk_project == "") {
					if ($conf->global->MANAGEMENT_ADDCODECLIENT_ON_NEW_PROJET) {
						$projectstatic->ref 		= str_replace("PJ", $object->thirdparty->code_client."-", $defaultref);
					} else
						$projectstatic->ref			= $defaultref;
					
					$projectstatic->title			= $object->ref; // Do not use 'alpha' here, we want field as it is
					$projectstatic->socid			= $object->socid;
					$projectstatic->description		= $object->ref_client; // Do not use 'alpha' here, we want field as it is
					$projectstatic->public			= 0;
					$projectstatic->datec=dol_now();
					$projectstatic->date_start		=$object->datep;
					$projectstatic->date_end		=$object->date_livraison;
					$projectstatic->statut			= $conf->global->MANAGEMENT_DEFAULT_STATUT_NEW_PROJET;
					$projectstatic->note_public		= $object->note_public; // Do not use 'alpha' here, we want field as it is
					$projectstatic->note_private	= $object->note_private; // Do not use 'alpha' here, we want field as it is
	
					$projectid= $projectstatic->create($user);
					if ($projectid > 0) {
						// on affecte le projet  la propal
						$object->setProject($projectid);
					} else {
						dol_print_error($db);
						exit;
					}
	
					// rcup des contacts au niveau de la propal? on propage comment au tache???
				}
				else
					$projectid = $object->fk_project;
	
				// on boucle sur la cration des taches
				foreach ($object->lines as $line) {
					// si c'est du service
					if ($line->product_type == 1) {
						$task = new Task($db);
			
						$defaultref='';
						$obj = empty($conf->global->PROJECT_TASK_ADDON)?'mod_task_simple':$conf->global->PROJECT_TASK_ADDON;
						if (! empty($conf->global->PROJECT_TASK_ADDON) 
							&& is_readable(DOL_DOCUMENT_ROOT ."/core/modules/project/task/".$conf->global->PROJECT_TASK_ADDON.".php")
						) {
							require_once DOL_DOCUMENT_ROOT ."/core/modules/project/task/".$conf->global->PROJECT_TASK_ADDON.'.php';
							$modTask = new $obj;
							$defaultref = $modTask->getNextValue($object->thirdparty, null);
							// on remplace le TK par la ref du service
							$defaultref = str_replace("TK", $line->product_ref, $defaultref);
						}

						$task->fk_project = $projectid;
						$task->ref = $defaultref;
						$task->label = ($line->label ? $line->label : $line->product_label);
						$task->description = $line->desc;

						// dtermination de la quantit d'heure
						$task->planned_workload = $line->qty*3600;
						$task->fk_task_parent 	= 0;
						$task->date_c 			= dol_now();
						$task->date_start 		= $line->date_start;
						$task->date_end 		= $line->date_end;
						$task->progress 		= 0;
	
						$taskid = $task->create($user);
						// si cela merdouille pour les tests
						if ($taskid <0)
							var_dump($task->error);
						else {
							// on rcupre les infos associ  la ligne de dtail
							// la ref produit mais aussi le montant, la tva et la remise
							$taskManagement = new ManagementTask($db);
							$taskManagement->fetch($taskid);
							$taskManagement->setproduct($line->fk_product, $line->tva_tx, $line->subprice);
						}
					}
				}
	
				if (! $error) {
					header("Location: ".dol_buildpath("/projet/", 1)."tasks.php?id=".$projectid);
					exit;
				}
			}
		}
	}
}