<?php
/*
 * Copyright (C) - 2018 Jean-François FERRY    <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Ticketsup substitution library
 */


/**
 *  Complete the $substitutionarray with more entries coming from external module that had set the "substitutions=1" into module_part array.
 *  In this case, method completesubstitutionarray provided by module is called.
 *
 *  @param  array       $substitutionarray      Array substitution old value => new value value
 *  @param  Translate   $outputlangs            Output language
 *  @param  Object      $object                 Source object
 *  @param  mixed       $parameters             Add more parameters (useful to pass product lines)
 *  @return void
 *  @see    make_substitutions
 */
function ticketsup_completesubstitutionarray(&$substitutionarray, $outputlangs, $object, $parameters)
{
    global $conf;

    if ($object->fk_soc > 0) {
        $object->fetch_thirdparty();
        $substitutionarray['__THIRDPARTY_NAME__'] = $object->thirdparty->name;
    }
   
    $userstat = new User($object->db);
    
    $substitutionarray['__SIGNATURE__'] = empty($conf->global->TICKETS_MESSAGE_MAIL_SIGNATURE) ? $user->signature : $conf->global->TICKETS_MESSAGE_MAIL_SIGNATURE;
    $substitutionarray['__TICKETSUP_TRACKID__'] = $object->track_id;
    $substitutionarray['__TICKETSUP_REF__'] = $object->ref;
    $substitutionarray['__TICKETSUP_ORIGIN_EMAIL__'] = $object->origin_email;
    $substitutionarray['__TICKETSUP_SUBJECT__'] = $object->subject;
    $substitutionarray['__TICKETSUP_TYPE__'] = $object->type_code;
    $substitutionarray['__TICKETSUP_CATEGORY__'] = $object->category_code;
    $substitutionarray['__TICKETSUP_SEVERITY__'] = $object->severity_code;
    $substitutionarray['__TICKETSUP_MESSAGE__'] = $object->message;
    $substitutionarray['__TICKETSUP_PROGRESSION__'] = $object->progress;
    if ($object->fk_user_assign > 0) {
        $userstat->fetch($object->fk_user_assign);
        $substitutionarray['__TICKETSUP_USER_ASSIGN__'] = dolGetFirstLastname($userstat->firstname, $userstat->lastname);
    }

    if ($object->fk_user_create > 0) {
        $userstat->fetch($object->fk_user_create);
        $substitutionarray['__TICKETSUP_USER_CREATE__'] = dolGetFirstLastname($userstat->firstname, $userstat->lastname);
    }
}
