<?php
/*
 * Copyright (C) - 2018 Jean-François FERRY    <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *     Messages of ticket
 *
 *    @package ticketsup
 */

$res = 0;
if (file_exists("../main.inc.php")) {
    $res = include "../main.inc.php"; // From htdocs directory
} elseif (!$res && file_exists("../../main.inc.php")) {
    $res = include "../../main.inc.php"; // From "custom" directory
} else {
    die("Include of main fails");
}
require_once 'class/actions_ticketsup.class.php';
require_once 'class/html.formticketsup.class.php';
require_once 'lib/ticketsup.lib.php';
require_once DOL_DOCUMENT_ROOT . "/core/lib/company.lib.php";
require_once DOL_DOCUMENT_ROOT . '/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/extrafields.class.php';

if (!class_exists('Contact')) {
    include DOL_DOCUMENT_ROOT . '/contact/class/contact.class.php';
}

// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("other");
$langs->load("ticketsup@ticketsup");

// Get parameters
$id = GETPOST('id', 'int');
$track_id = GETPOST('track_id', 'alpha', 3);
$ref = GETPOST('ref', 'alpha');
$action = GETPOST('action', 'alpha', 3);

// Security check
if (!$user->rights->ticketsup->read) {
    accessforbidden();
}

$object = new ActionsTicketsup($db);

$object->doActions($action);

$extrafields = new ExtraFields($db);
$extralabels = $extrafields->fetch_name_optionals_label($object->dao->table_element);

if (!$action) {
    $action = 'view';
}

/***************************************************
 * PAGE
 *
 * Put here all code to build page
 ****************************************************/

$help_url = 'FR:DocumentationModuleTicket';
$page_title = $object->getTitle($action);
llxHeader('', $page_title, $help_url);

$userstat = new User($db);
$form = new Form($db);
$formticket = new FormTicketsup($db);


$res = $object->fetch($id, $track_id, $ref);

if ($res > 0) {
    // restrict access for externals users
    if ($user->societe_id > 0 && ($object->dao->fk_soc != $user->societe_id)
    ) {
        accessforbidden('', 0);
    }
    // or for unauthorized internals users
    if (!$user->societe_id && ($conf->global->TICKETS_LIMIT_VIEW_ASSIGNED_ONLY && $object->dao->fk_user_assign != $user->id) && !$user->rights->ticketsup->manage) {
        accessforbidden('', 0);
    }

    if ($object->dao->fk_soc > 0) {
        $object->dao->fetch_thirdparty();
        $head = societe_prepare_head($object->dao->thirdparty);
        dol_fiche_head($head, 'ticketsup', $langs->trans("ThirdParty"), 0, 'company');
        dol_banner_tab($object->dao->thirdparty, 'socid', '', ($user->societe_id ? 0 : 1), 'rowid', 'nom');
        dol_fiche_end();
    }

    if (!$user->societe_id && $conf->global->TICKETS_LIMIT_VIEW_ASSIGNED_ONLY) {
        $object->next_prev_filter = "te.fk_user_assign = '" . $user->id . "'";
    } elseif ($user->societe_id > 0) {
        $object->next_prev_filter = "te.fk_soc = '" . $user->societe_id . "'";
    }
    $head = ticketsup_prepare_head($object->dao);
    dol_fiche_head($head, 'tabTicketMessages', $langs->trans("Ticket"), 0, 'ticketsup@ticketsup');
    $object->dao->label = $object->dao->ref;
    // Author
    if ($object->dao->fk_user_create > 0) {
        $object->dao->label .= ' - ' . $langs->trans("CreatedBy") . '  ';
        $langs->load("users");
        $fuser = new User($db);
        $fuser->fetch($object->dao->fk_user_create);
        $object->dao->label .= $fuser->getNomUrl(0);
    }
    $linkback = '<a href="' . dol_buildpath('/ticketsup/list.php', 1) . '"><strong>' . $langs->trans("BackToList") . '</strong></a> ';
    $object->dao->ticketsup_banner_tab('ref', '', ($user->societe_id ? 0 : 1), 'ref', 'subject', '', '', '', $morehtmlleft, $linkback);

    // View Original message
    $object->viewTicketOriginalMessage($user, $action);
    
    dol_fiche_end();

    /* ActionBar */
    print '<div class="tabsAction">';
    // Show link to add a message (if read and not closed)
    if ($object->dao->fk_statut < 8 && $action != "add_message") {
        print '<div class="inline-block divButAction"><a class="butAction" href="messages.php?ref=' . $object->dao->ref . '&action=add_message">' . $langs->trans('TicketAddMessage') . '</a></div>';
    }
    print '</div>';
    
    
    
    if ($action == 'view') {
        print '<div class="fichecenter">'
            . '<div class="">';
            
            //print '<div style="float: left; width:49%; margin-right: 1%;">';
            // Message list
            print load_fiche_titre($langs->trans('TicketMessagesList'), '', 'messages@ticketsup');
            $show_private_message = ($user->societe_id ? 0 : 1);
            $object->viewTicketTimelineMessages($show_private_message);
            
            print '</div><!-- fichehalfleft --> ';
            
            print '</div><!-- fichecenter -->';
            print '<br style="clear: both">';
    } elseif ($action == 'add_message') {
        $action='new_message';
        $modelmail='ticketsup_send';
        
        print '<div>';
        print load_fiche_titre($langs->trans('TicketAddMessage'), '', 'messages@ticketsup');
        
        // Define output language
        $outputlangs = $langs;
        $newlang = '';
        if ($conf->global->MAIN_MULTILANGS && empty($newlang) && ! empty($_REQUEST['lang_id'])) {
            $newlang = $_REQUEST['lang_id'];
        }
        if ($conf->global->MAIN_MULTILANGS && empty($newlang)) {
            $newlang = $object->default_lang;
        }
        
        $formticket = new FormTicketsup($db);
        
        $formticket->action = $action;
        $formticket->track_id = $object->dao->track_id;
        $formticket->id = $object->dao->id;
        
        $formticket->withfile = 2;
        $formticket->param = array('id' => $object->dao->id);
        $formticket->param['fk_user_create'] = $user->id;
        $formticket->param['langsmodels']=(empty($newlang)?$langs->defaultlang:$newlang);
        
        // Tableau des parametres complementaires du post
        $formticket->param['models']=$modelmail;
        $formticket->param['models_id']=GETPOST('modelmailselected', 'int');
        //$formticket->param['socid']=$object->dao->fk_soc;
        $formticket->param['returnurl']=$_SERVER["PHP_SELF"].'?ref='.$object->dao->ref;
        
        
        $formticket->withsubstit = 1;

        // Make substitution in email content
        $exclude = array('object', 'objectamount');
        $substitutionarray=getCommonSubstitutionArray($langs, 0, $exclude, $object->dao);
        $substitutionarray['__EMAIL__'] = $sendto;
        //$substitutionarray['__CHECK_READ__'] = (is_object($this->dao) && is_object($this->dao->thirdparty))?'<img src="'.DOL_MAIN_URL_ROOT.'/public/emailing/mailing-read.php?tag='.$this->dao->thirdparty->tag.'&securitykey='.urlencode($conf->global->MAILING_EMAIL_UNSUBSCRIBE_KEY).'" width="1" height="1" style="width:1px;height:1px" border="0"/>':'';

        $parameters=array('mode'=>'formemail');
        complete_substitutions_array($substitutionarray, $langs, $object->dao, $parameters);
        $formticket->substit = $substitutionarray;
    
        $formticket->showMessageForm('100%');
        print '</div>';
    }
    
    
    print '<br style="clear: both">';
}


// End of page
llxFooter('');
$db->close();
