<?php
/* Copyright (C) 2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) ---Put here your own copyright and developer email---
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       host_agenda.php
 *  \ingroup    hosting
 *  \brief      Page of Host events
 */

// Load Dolibarr environment
$res=0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (! $res && ! empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
    $res=@include($_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php");
}
// Try main.inc.php into web root detected using web root caluclated from SCRIPT_FILENAME
$tmp=empty($_SERVER['SCRIPT_FILENAME'])?'':$_SERVER['SCRIPT_FILENAME'];
$tmp2=realpath(__FILE__);
$i=strlen($tmp)-1;
$j=strlen($tmp2)-1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i]==$tmp2[$j]) {
    $i--;
    $j--;
}
if (! $res && $i > 0 && file_exists(substr($tmp, 0, ($i+1))."/main.inc.php")) {
    $res=@include(substr($tmp, 0, ($i+1))."/main.inc.php");
}
if (! $res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php")) {
    $res=@include(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php");
}
// Try main.inc.php using relative path
if (! $res && file_exists("../main.inc.php")) {
    $res=@include("../main.inc.php");
}
if (! $res && file_exists("../../main.inc.php")) {
    $res=@include("../../main.inc.php");
}
if (! $res && file_exists("../../../main.inc.php")) {
    $res=@include("../../../main.inc.php");
}
if (! $res) {
    die("Include of main fails");
}

require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once 'class/actions_ticketsup.class.php';
require_once 'class/html.formticketsup.class.php';
require_once 'lib/ticketsup.lib.php';
// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("other");
$langs->load("ticketsup@ticketsup");

// Get parameters
$id = GETPOST('id', 'int');
$track_id = GETPOST('track_id', 'alpha', 3);
$ref = GETPOST('ref', 'alpha');
$action = GETPOST('action', 'alpha', 3);
$cancel     = GETPOST('cancel', 'aZ09');
$backtopage = GETPOST('backtopage', 'alpha');

if (GETPOST('actioncode', 'array')) {
    $actioncode=GETPOST('actioncode', 'array', 3);
    if (! count($actioncode)) {
        $actioncode='0';
    }
} else {
    $actioncode=GETPOST("actioncode", "alpha", 3)?GETPOST("actioncode", "alpha", 3):(GETPOST("actioncode")=='0'?'0':(empty($conf->global->AGENDA_DEFAULT_FILTER_TYPE_FOR_OBJECT)?'':$conf->global->AGENDA_DEFAULT_FILTER_TYPE_FOR_OBJECT));
}
$search_agenda_label=GETPOST('search_agenda_label');

// Security check - Protection if external user
//if ($user->societe_id > 0) access_forbidden();
//if ($user->societe_id > 0) $socid = $user->societe_id;
//$result = restrictedArea($user, 'hosting', $id);

$limit = GETPOST('limit', 'int')?GETPOST('limit', 'int'):$conf->liste_limit;
$sortfield = GETPOST("sortfield", 'alpha');
$sortorder = GETPOST("sortorder", 'alpha');
$page = GETPOST("page", 'int');
if (empty($page) || $page == -1) {
    $page = 0;
}     // If $page is not defined, or '' or -1
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
if (! $sortfield) {
    $sortfield='a.datep,a.id';
}
if (! $sortorder) {
    $sortorder='DESC';
}

// Initialize technical objects
$object=new Ticketsup($db);
$extrafields = new ExtraFields($db);
$diroutputmassaction=$conf->ticketsup->dir_output . '/temp/massgeneration/'.$user->id;
$hookmanager->initHooks(array('ticketsupagenda'));     // Note that conf->hooks_modules contains array
// Fetch optionals attributes and labels
$extralabels = $extrafields->fetch_name_optionals_label('ticketsup');

// Load object
$res = $object->fetch($id, $track_id, $ref);
if ($id > 0 || ! empty($ref)) {
    $upload_dir = $conf->ticketsup->multidir_output[$object->entity] . "/" . $object->id;
}

// restrict access for externals users
if ($user->societe_id > 0 && ($object->fk_soc != $user->societe_id)) {
    accessforbidden('', 0);
}
// or for unauthorized internals users
if (!$user->societe_id && ($conf->global->TICKETS_LIMIT_VIEW_ASSIGNED_ONLY && $object->fk_user_assign != $user->id) && !$user->rights->ticketsup->manage) {
    accessforbidden('', 0);
}
    


/*
 *	Actions
 */

$parameters=array('id'=>$socid);
$reshook=$hookmanager->executeHooks('doActions', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
if ($reshook < 0) {
    setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');
}

if (empty($reshook)) {
    // Cancel
    if (GETPOST('cancel', 'alpha') && ! empty($backtopage)) {
        header("Location: ".$backtopage);
        exit;
    }

    // Purge search criteria
    if (GETPOST('button_removefilter_x', 'alpha') || GETPOST('button_removefilter.x', 'alpha') || GETPOST('button_removefilter', 'alpha')) { // All tests are required to be compatible with all browsers
        $actioncode='';
        $search_agenda_label='';
    }
}



/*
 *	View
 */

$contactstatic = new Contact($db);

$form = new Form($db);

if ($object->id > 0) {
	if (! empty($conf->notification->enabled)) {
        $langs->load("mails");
    }
    
    $title=$langs->trans("Agenda");
    //if (! empty($conf->global->MAIN_HTML_TITLE) && preg_match('/thirdpartynameonly/',$conf->global->MAIN_HTML_TITLE) && $object->name) $title=$object->name." - ".$title;
    $help_url = '';
    llxHeader('', $title, $help_url);
   
    if ($object->fk_soc > 0) {
        $object->fetch_thirdparty();
        $head = societe_prepare_head($object->thirdparty);
        dol_fiche_head($head, 'ticketsup', $langs->trans("ThirdParty"), 0, 'company');
        dol_banner_tab($object->thirdparty, 'socid', '', ($user->societe_id ? 0 : 1), 'rowid', 'nom');
        dol_fiche_end();
    }
    
    if (!$user->societe_id && $conf->global->TICKETS_LIMIT_VIEW_ASSIGNED_ONLY) {
        $object->next_prev_filter = "te.fk_user_assign = '" . $user->id . "'";
    } elseif ($user->societe_id > 0) {
        $object->next_prev_filter = "te.fk_soc = '" . $user->societe_id . "'";
    }
    $head = ticketsup_prepare_head($object);
    dol_fiche_head($head, 'tabTicketAgenda', $langs->trans("Ticket"), 0, 'ticketsup@ticketsup');
    $object->label = $object->ref;
    // Author
    if ($object->fk_user_create > 0) {
        $object->label .= ' - ' . $langs->trans("CreatedBy") . '  ';
        $langs->load("users");
        $fuser = new User($db);
        $fuser->fetch($object->fk_user_create);
        $object->label .= $fuser->getNomUrl(0);
    }
    $linkback = '<a href="' . dol_buildpath('/ticketsup/list.php', 1) . '?restore_lastsearch_values=1"><strong>' . $langs->trans("BackToList") . '</strong></a> ';
    $object->ticketsup_banner_tab('ref', '', ($user->societe_id ? 0 : 1), 'ref', 'subject', '', '', '', $morehtmlleft, $linkback);
    
    
    dol_fiche_end();


    if (! empty($conf->agenda->enabled) && (!empty($user->rights->agenda->myactions->read) || !empty($user->rights->agenda->allactions->read) )) {
        $param='&socid='.$socid;
        if (! empty($contextpage) && $contextpage != $_SERVER["PHP_SELF"]) {
            $param.='&contextpage='.$contextpage;
        }
        if ($limit > 0 && $limit != $conf->liste_limit) {
            $param.='&limit='.$limit;
        }


        $MAXEVENT = 0;
        // List of actions on element
        include_once DOL_DOCUMENT_ROOT . '/core/class/html.formactions.class.php';
        $formactions = new FormActions($db);
        
        $somethingshown = $formactions->showactions($object, 'ticketsup', $object->fk_soc, 1, '', $MAXEVENT, '', $morehtmlright);
    }
}


llxFooter();

$db->close();
