<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'infinite_page_builder_body_class');
	if( !function_exists('infinite_page_builder_body_class') ){
		function infinite_page_builder_body_class( $classes ) {
			return $classes . ' infinite-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'infinite_gdlr_core_sidebar_class');
	if( !function_exists('infinite_gdlr_core_sidebar_class') ){
		function infinite_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' infinite-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'infinite_goodlayers_core_setup');
	if( !function_exists( 'infinite_goodlayers_core_setup' ) ){
		function infinite_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'infinite_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'infinite_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'infinite_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'infinite_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'infinite_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'infinite_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'infinite_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_related', 'infinite_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'infinite_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'infinite_gdlr_core_portfolio_hover_icon_class');

			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'infinite_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('infinite_gdlr_core_privacy_settings') ){
		function infinite_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = infinite_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}

	// portfolio hover icon class
	if( !function_exists('infinite_gdlr_core_portfolio_hover_icon_class') ){
		function infinite_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return infinite_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return infinite_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return infinite_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('infinite_gdlr_core_enable_srcset') ){
		function infinite_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = infinite_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('infinite_gdlr_core_pagination_style') ){
		function infinite_gdlr_core_pagination_style( $style ) {
			return infinite_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('infinite_gdlr_core_pagination_align') ){
		function infinite_gdlr_core_pagination_align( $align ) {
			return infinite_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('infinite_gdlr_core_custom_post_slug') ){
		function infinite_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = infinite_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = infinite_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = infinite_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = infinite_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = infinite_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('infinite_gdlr_core_portfolio_single_nav') ){
		function infinite_gdlr_core_portfolio_single_nav( $check ) {
			return infinite_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('infinite_gdlr_core_portfolio_single_nav_same_term') ){
		function infinite_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return infinite_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('infinite_gdlr_core_portfolio_single_related') ){
		function infinite_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = infinite_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = infinite_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = infinite_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = infinite_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = infinite_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = infinite_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = infinite_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('infinite_gdlr_core_social_share_list') ){
		function infinite_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = infinite_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = infinite_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['google-plus'] = infinite_get_option('general', 'blog-social-google-plus', $social['google-plus']);
			$social['pinterest'] = infinite_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = infinite_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = infinite_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = infinite_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'infinite_register_custom_uploaded_font');
	if( !function_exists('infinite_register_custom_uploaded_font') ){
		function infinite_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = infinite_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$custom_fonts[$font_option['name']] = array(
						'eot' => $font_option['eot'],
						'ttf' => $font_option['ttf'],
					);
				}
			}		
			
			return $custom_fonts;
			
		} // infinite_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('infinite_gdlr_core_widget_title_nav') ){
		function infinite_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'infinite_gdlr_core_page_builder_post_type');
	if( !function_exists('infinite_gdlr_core_page_builder_post_type') ){
		function infinite_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'infinite_gdlr_core_lightbox_type');
	if( !function_exists('infinite_gdlr_core_lightbox_type') ){
		function infinite_gdlr_core_lightbox_type(){
			$lightbox_type = infinite_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = infinite_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'infinite_lightbox_body_class');
	if( !function_exists('infinite_lightbox_body_class') ){
		function infinite_lightbox_body_class($class){
			$link_to_lightbox = infinite_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}

	add_filter('gdlr_core_lightbox_video_autoplay', 'infinite_lightbox_video_autoplay');
	if( !function_exists('infinite_lightbox_video_autoplay') ){
		function infinite_lightbox_video_autoplay($autoplay){
			$video_autoplay = infinite_get_option('plugin', 'lightbox-video-autoplay', 'enable');
			return ($video_autoplay == 'enable')? true: false;
		}
	}
	
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'infinite_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'infinite_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('infinite_gdlr_core_page_builder_page_template_list') ){
		function infinite_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['home-main'] = array(
				'title' => esc_html__('Home - Main', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-main2'] = array(
				'title' => esc_html__('Home - Main 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-agency01'] = array(
				'title' => esc_html__('Home - Agency 01', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-aperture'] = array(
				'title' => esc_html__('Home - Aperture', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-appz'] = array(
				'title' => esc_html__('Home - Appz', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-architek'] = array(
				'title' => esc_html__('Home - Architek', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-big-corp'] = array(
				'title' => esc_html__('Home - Big Corp', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-breeze-biz'] = array(
				'title' => esc_html__('Home - Breeze Biz', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-conference'] = array(
				'title' => esc_html__('Home - Conference', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-designer'] = array(
				'title' => esc_html__('Home - Designer', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-emporium'] = array(
				'title' => esc_html__('Home - Emporium', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-finance'] = array(
				'title' => esc_html__('Home - Finance', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-fitness'] = array(
				'title' => esc_html__('Home - Fitness', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-gardener'] = array(
				'title' => esc_html__('Home - Gardener', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-half-box'] = array(
				'title' => esc_html__('Home - Half Box', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-high-rise'] = array(
				'title' => esc_html__('Home - High Rise', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-inagency'] = array(
				'title' => esc_html__('Home - Inagency', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-incorporate'] = array(
				'title' => esc_html__('Home - Incorporate', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-mechanic'] = array(
				'title' => esc_html__('Home - Mechanic', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-medical'] = array(
				'title' => esc_html__('Home - Medical', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-modernize'] = array(
				'title' => esc_html__('Home - Modernize', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-one-page'] = array(
				'title' => esc_html__('Home - One Page', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-yellow-black'] = array(
				'title' => esc_html__('Home - Yellow Black', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us'] = array(
				'title' => esc_html__('About Us', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us2'] = array(
				'title' => esc_html__('About Us 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us3'] = array(
				'title' => esc_html__('About Us 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us4'] = array(
				'title' => esc_html__('About Us 4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team'] = array(
				'title' => esc_html__('About Our Team', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team2'] = array(
				'title' => esc_html__('About Our Team 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team3'] = array(
				'title' => esc_html__('About Our Team 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team4'] = array(
				'title' => esc_html__('About Our Team 4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-me'] = array(
				'title' => esc_html__('About Me', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['service'] = array(
				'title' => esc_html__('Service', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['service2'] = array(
				'title' => esc_html__('Service 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['service3'] = array(
				'title' => esc_html__('Service 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['contact2'] = array(
				'title' => esc_html__('Contact 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['contact3'] = array(
				'title' => esc_html__('Contact 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['maintenance'] = array(
				'title' => esc_html__('Maintenance', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['coming-soom'] = array(
				'title' => esc_html__('Coming Soon', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom'] = array(
				'title' => esc_html__('Single Post Custom', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom2'] = array(
				'title' => esc_html__('Single Post Custom 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom3'] = array(
				'title' => esc_html__('Single Post Custom 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom4'] = array(
				'title' => esc_html__('Single Post Custom 4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-vertical-info'] = array(
				'title' => esc_html__('Single Port Vertical Info', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-horizontal-info'] = array(
				'title' => esc_html__('Single Port Horizontal Info', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-full-image'] = array(
				'title' => esc_html__('Single Port Full Image', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-full-image2'] = array(
				'title' => esc_html__('Single Port Full Image 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-service'] = array(
				'title' => esc_html__('Single Port Service', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-service2'] = array(
				'title' => esc_html__('Single Port Service 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-creative'] = array(
				'title' => esc_html__('Single Port Creative', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-creative2'] = array(
				'title' => esc_html__('Single Port Creative 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-half-box'] = array(
				'title' => esc_html__('Single Port Half Box', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-half-box2'] = array(
				'title' => esc_html__('Single Port Half Box', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-personnel'] = array(
				'title' => esc_html__('Single Personnel', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-personnel2'] = array(
				'title' => esc_html__('Single Personnel2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-personnel3'] = array(
				'title' => esc_html__('Single Personnel3', 'infinite'),
				'type' => 'wrapper',
			);
			return $templates;
		} // infinite_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('infinite_gdlr_core_page_builder_get_page_template') ){
		function infinite_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'home-main': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"The most powerful theme on earth","title":"Infinite WordPress Theme","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.","button-text":"","button-link":"#","button-link-target":"_self","text-align":"center","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"2156","icon":"fa fa-film","style":"dashed","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"80px"}},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_desktop","icon-style":"normal","image":"","title":"Free Sliders Included","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_genius","icon-style":"normal","image":"","title":"Super Powerful Admin Panel","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lifesaver","icon-style":"normal","image":"","title":"Awesome Support","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_cloud-download_alt","icon-style":"normal","image":"","title":"Google font library","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_heart_alt","icon-style":"normal","image":"","title":"Very easy to use","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2162","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"24","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"138px","right":"80px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"left","background-color":"#2d9bea","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.8","parallax-speed":"0.8","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SAVE A LOT OF YOUR TIME","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-comments-o","icon-style":"normal","image":"","title":"Friendly Support","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lock_alt","icon-style":"normal","image":"","title":"Very SECURE CODE","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"138px","right":"0px","bottom":"0px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue Divider White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"With Brand New  GoodLayers Page Builder","caption":"Sections and wrapper can be manage easily","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"137px","padding-bottom":"50px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p><p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn\'t listen. She packed her seven versalia, put her initial into the belt and made.</p>","text-align":"left","font-size":"","padding-bottom":"15px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"95px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":null,"tag":null,"num-fetch":"8","thumbnail-size":"Portfolio Thumbnail Portrait","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon-title-tag","column-size":"15","layout":"fitrows","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"Our Works ","caption":"Explore","read-more-text":"View More Works","read-more-link":"http://demo.goodlayers.com/infinite/portfolio","read-more-target":"_self","title-size":"43px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","portfolio-title-text-transform":"uppercase","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"2176","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2127","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"100px","bottom":"90px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue Divider","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Incredible Layouts","caption":"Limitless possibilities create","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px"}},{"template":"element","type":"icon-list","value":{"id":"","tabs":[{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"Full wrapper and sidebar wrapper"},{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"Columns wrappers"},{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"More than 40 element items"},{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"Many pre-built templates"}],"icon-size":"16px","content-size":"16px","list-bottom-margin":"7px","enable-divider":"disable","icon-background":"none","icon-color":"#9e9e9e","icon-background-color":"","content-color":"","border-color":"","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river.</p>","text-align":"left","font-size":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"155px","right":"100px","bottom":"130px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#2d9bea","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"icon_menu-circle_alt2","text-align":"left","icon-size":"60px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Power Elite Author","caption":"Be wise and choose","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>We are the top author of Themeforest, Power Elite Author. There are not much authors who hit power eilite level and with 5 years of expereinces. We know what exactly you want. We promise to deliver the best products with great after sales support and we won\'t let you down.</p>","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"400px","hide-this-wrapper-in":"mobile","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"2181","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"400px","hide-this-wrapper-in":"mobile","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"1877","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"185px","right":"100px","bottom":"155px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#232323","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Dark","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our New Framework","caption":"Are you ready to be amazed?","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>We had spent a lot of time to study, gather information and finally we come up with the best page builder in the world. It\'s the most powerful with many options and it has everything you need. You can push them into 3 modes, block mode, preview mode and live mode(frontend builder). Now with this tool, your imagination will be limitless.</p>","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2185","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","skin":"Blue Divider White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"%","divider":"enable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"588","suffix":"","divider":"enable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16800","suffix":"","divider":"enable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"enable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1200px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2187","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"mobile","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"2188","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2127","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_globe-2","icon-style":"normal","image":"","title":"Infinite Is Genius","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_globe","icon-style":"normal","image":"","title":"Your global business","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_piechart","icon-style":"normal","image":"","title":"Business Strategy","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_cloud-upload_alt","icon-style":"normal","image":"","title":"Showcase Your Works","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_like","icon-style":"normal","image":"","title":"Thumbs Up!","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"personnel","value":{"id":"","category":null,"num-fetch":"4","thumbnail-size":"Personnel Thumbnail 2","orderby":"date","disable-link":"disable","order":"desc","title-align":"left","title":"Meet the genius team","caption":"Who are we?","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"43px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"left","personnel-style":"grid-no-space","enable-position":"enable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"4","carousel":"disable","carousel-navigation":"navigation","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"850px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"125px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2193","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"John Smith","position":"Co-Founder","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.","image":"506","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-1.jpg"},{"title":"Sarah Lopez","position":"CFO, Apple","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.","image":"508","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-3.jpg"},{"title":"Robert Kim","position":"Customer","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.","image":"507","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-2.jpg"}],"column":"1","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"navigation","style":"center","title-size":"43px","caption-size":"16px","content-size":"18px","title-color":"","caption-color":"","quote-color":"#ffffff","content-color":"#c4c4c4","name-color":"","position-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1200px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#fafafa","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"Light Border","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"blog","value":{"id":"","category":["blog"],"tag":null,"num-fetch":"5","prepend-sticky":"disable","thumbnail-size":"Personnel Thumbnail","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-column-with-frame","blog-full-alignment":"left","show-thumbnail":"enable","column-size":"20","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"both","item-size":"small","excerpt":"specify-number","excerpt-number":"18","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"left","title":"Recent News","caption":"","read-more-text":"Read More","read-more-link":"http://demo.goodlayers.com/infinite/blog","read-more-target":"_self","title-size":"43px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","blog-title-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"gallery","value":{"id":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1889","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-1-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1890","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-2-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1891","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-3-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1892","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-4-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1893","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-5-150x150.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"670px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"165px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2202","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Get Contact","caption":"Keep In Touch","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"51px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1.5px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"8px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"80px"}},{"template":"element","type":"social-network","value":{"id":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","text-align":"center","icon-size":"20px","icon-color":"","with-text":"enable","text-size":"15px","icon-space":"40px","padding-bottom":"80px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"0px"}}]}]';
				case 'home-main2':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#3a34af","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"-80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2366","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Creative Web Design","caption":"Small Caption Here","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"12px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"14px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#394cc1","icon-color":"","text-hover-color":"#394cc1","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2367","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"User Friendly Tool","caption":"Small Caption Here","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"12px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"14px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#394cc1","icon-color":"","text-hover-color":"#394cc1","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2368","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"More Powerful Than Ever","caption":"Small Caption Here","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"12px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"14px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#394cc1","icon-color":"","text-hover-color":"#394cc1","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.2","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2369","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"180px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Infinite WordPress Theme","caption":"The most powerful theme on earth","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#2a2a38","title-link-hover-color":"","caption-color":"#656578","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"#86869d","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Explore More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"24px","bottom":"16px","left":"24px","settings":"unlink"},"border-radius":"3px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#3c39c1","background-hover-color":"","background-gradient-color":"#5754e1","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"12px","size":"22px","settings":"unlink"},"button-shadow-color":"#222b60","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"16px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1400px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"#ffffff","container-shadow-size":{"x":"","y":"","size":"150px","settings":"unlink"},"container-shadow-color":"#191919","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"inner-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"156px","settings":"unlink"},"background-shadow-color":"#212121","background-shadow-opacity":"0.08","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"-80px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2371","title":"Web Development","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#e0e0e0","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2372","title":"Excellent Support","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"24px","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2373","title":"Powerful Framework","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"25px","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2374","title":"Time Saving","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2377","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"gradient-v","background-extending":"left","background-color":"#0a0a0a","background-color-opacity":"0.7","background-gradient-color":"#0a0a0a","background-gradient-color-opacity":"0.2","background-image":"","background-image-style":"repeat-y","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"128px","right":"60px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple section 1"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2381","title":"Get Inspired","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","title-size":"20px","title-font-weight":"800","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"28px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2382","title":"Be Creative","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","title-size":"20px","title-font-weight":"800","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2383","title":"Be Socialized","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","title-size":"20px","title-font-weight":"800","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"34px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"153px","right":"0px","bottom":"0px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Divider White Text"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"GoodLayers Page Builder","caption":"Sections and wrapper can be manage easily","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"#bfbdff","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"","text-color":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Find More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"14px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2926b9","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#fcfcff","background-hover-color":"","background-gradient-color":"#bfc1f8","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"12px","size":"30px","settings":"unlink"},"button-shadow-color":"#202149","button-shadow-opacity":"0.3","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"800","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f4f4f4","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Portfolio"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Works","caption":"A wonderful serenity has taken possession of my entire soul, like these<br/> sweet mornings of spring which I enjoy with my whole.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"20px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"enable","view-all-works-text":"View All Works","view-all-works-link":"http://demo.goodlayers.com/infinite/homepages/main2/portfolio-3-columns-with-frame/","portfolio-style":"grid2","portfolio-grid-text-align":"center","portfolio-grid-style":"with-frame","portfolio-frame-opacity":"1","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon","column-size":"20","thumbnail-size":"Portfolio Thumbnail","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"carousel","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation","carousel-bullet-style":"default","excerpt":"none","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"none","portfolio-title-font-size":"18px","portfolio-title-font-weight":"800","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-tag-font-style":"default","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"0px","frame-shadow-color":"","frame-shadow-opacity":"0.2","overlay-color":"","overlay-opacity":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"View More Works","read-more-link":"http://demo.goodlayers.com/infinite/portfolio","read-more-target":"_self","title-size":"43px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2384","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"100px","bottom":"100px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Divider"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Incredible Layouts","caption":"Limitless possibilities create","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-angle-right","icon-hover":"","title":"Full wrapper and sidebar wrapper","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Columns wrappers","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"More than 40 element items","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Many pre-built templates","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#bab8f6","icon-background-color":"","content-color":"#bab8f6","border-color":"","icon-size":"16px","content-size":"16px","icon-right-margin":"","list-bottom-margin":"7px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"15px","text-color":"#ffffff","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"2391","background-image-style":"cover","background-image-position":"center-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"400px","hide-this-wrapper-in":"mobile","animation":"fadeInRight","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"2411","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"145px","right":"100px","bottom":"110px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Power Elite Author","caption":"Be wise and choose","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"#515151","caption-spaces":"5px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are the top author of Themeforest, Power Elite Author. There are not much authors who hit power eilite level and with 5 years of expereinces. We know what exactly you want. We promise to deliver the best products with great after sales support and we won’t let you down.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"15px","text-color":"#707070","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-angle-right","icon-hover":"","title":"Over 120,000 Sales","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"More than 50 WordPress Themes","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Dedicated Support Team","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#333333","icon-background-color":"","content-color":"#848484","border-color":"","icon-size":"16px","content-size":"16px","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-gradient-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","padding":{"top":"100px","right":"90px","bottom":"80px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are trusted by more than 5,000 clients","caption":"Did you know that","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"16px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Explore More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"24px","bottom":"16px","left":"24px","settings":"unlink"},"border-radius":"3px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#3c39c1","background-hover-color":"","background-gradient-color":"#5754e1","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"12px","size":"22px","settings":"unlink"},"button-shadow-color":"#222b60","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"16px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"enable","background-type":"html5-video","background-extending":"none","background-color":"#3740b0","background-image":"5496","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/video-bg.mp4","background-video-url-webm":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/video-bg.webm","background-video-url-ogg":"","background-video-image":"2458","background-pattern":"pattern-1","background-opacity":"0.7","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2399","background-image-style":"repeat-x","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What makes us the best?","caption":"among others","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"99","animation-time":"4000","suffix":"%","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Percent of customers who satisfy with our products.</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2395","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"187","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Projects we recently delivered to customers</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2396","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"24","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Hours we provide after sale supporter</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2397","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Offices in all region across the world</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2398","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2400","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInUp","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-80px","right":"0px","bottom":"-200px","left":"-300px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2401","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2127","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"160px","right":"90px","bottom":"100px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Infinite’s <br/>Admin Panel","caption":"Hundreds Options From","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"5px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"#d3d3d3","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-angle-right","icon-hover":"","title":"Select Header Styles","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Full/Boxes Layout","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Sidebar Width","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Social Media Sharing","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Font Selector","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Color Pickers","link-url":""}],"columns":"30","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"16px","content-size":"16px","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonial","caption":"What they say","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Jane Doe","position":"Jounalist","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"2402","image-img":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/testimonial-1.jpg","rating":""},{"title":"Anakin Sky","position":"First Pilot","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"2403","image-img":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/testimonial-2.jpg","rating":""},{"title":"John Smith","position":"Co-Founder","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"506","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-1.jpg","rating":""},{"title":"Sarah Lopez","position":"CFO, Apple","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"508","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-3.jpg","rating":""},{"title":"Robert Kim","position":"Customer","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"507","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-2.jpg","rating":""}],"style":"left-2","column":"3","thumbnail-size":"thumbnail","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"default","carousel-bullet-style":"cylinder","title-size":"43px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","caption-size":"16px","content-size":"16px","title-color":"","caption-color":"","quote-color":"#5d5bd0","content-color":"#5e5e5e","name-color":"","position-color":"#7a7a7a","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"gradient","background-color":"#3332b7","background-color-opacity":"1","background-gradient-color":"#4f4dc9","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Blog","caption":"New Stories From Us","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-gradient-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"8","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-image-no-space","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-1","blog-full-alignment":"left","blog-image-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"enable","blog-image-thumbnail-overlay":"opacity","blog-image-thumbnail-overlay-opacity":"0.4","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail Portrait 2","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"fitrows","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-bullet-style":"default","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-image-excerpt-number":"11","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","filterer-bottom-margin":"","blog-title-font-size":"24px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","frame-shadow-color":"","frame-shadow-opacity":"0.2","padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"enable","marquee-text":"CLIENTS<span style=\"font-weight: 900;\">CLIENTS</span>CLIENTS","marquee-position":"top","marquee-position-offset":"33px","marquee-speed":"20000","marquee-direction":"left","marquee-font-size":"175px","marquee-font-weight":"100","marquee-font-letter-spacing":"1px","marquee-text-color":"#f6f6f6","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"65px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"25px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"container-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"2410","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-1-3-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2412","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-2-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2413","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-3-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2414","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-4-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2415","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-5-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"gradient","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"#ededed","background-gradient-color-opacity":"1","background-image":"2416","background-image-style":"repeat-x","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet Awesome Team","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"3","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid-with-background","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"Personnel Thumbnail 2","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-navigation":"navigation","personnel-title-font-size":"21px","personnel-title-font-weight":"700","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"12px","personnel-position-font-weight":"","personnel-position-font-style":"normal","personnel-position-letter-spacing":"1px","personnel-position-text-transform":"uppercase","shadow-size":{"x":"","y":"","size":"80px","settings":"unlink"},"shadow-color":"#0a0a0a","shadow-opacity":"0.08","personnel-thumbnail-bottom-margin":"","personnel-title-bottom-margin":"","padding-bottom":"15px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"43px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Team","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/infinite/homepages/main2/about-our-team/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2926b9","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#fcfcff","background-hover-color":"","background-gradient-color":"#bfc1f8","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"button-shadow-color":"#0a0a0a","button-shadow-opacity":"0.08","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"800","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"670px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2417","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"165px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact Homepage"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get Contact","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"15px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"37px","padding-bottom":"50px","icon-color":"","divider-color":""}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"enable","text-size":"15px","icon-color":"#ffffff","icon-space":"40px","padding-bottom":"55px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"1319","padding-bottom":"60px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Purchase Infinite Now!","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"39px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"15px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Empower Your Business With Our Flagship WordPress Theme</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"#bcbcbc","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Purchase Now!","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://1.envato.market/c/300702/275988/4415?u=https%3A%2F%2Fthemeforest.net%2Fitem%2Finfinite-responsive-multipurpose-wordpress-theme%2F16869357%3Flicense%3Dregular%26open_purchase_for_item_id%3D16869357%26purchasable%3Dsource","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#7141f9","background-hover-color":"#363afd","background-gradient-color":"#363afd","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"16px","size":"57px","settings":"unlink"},"button-shadow-color":"#0a0a0a","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"800","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]';
				case 'home-agency01':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#2d2d2d","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"67px","right":"80px","bottom":"65px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#2d9bea","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light Blue","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_compass_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"34px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"7px","title-bottom-margin":"20px","caption-size":"17px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"67px","right":"80px","bottom":"65px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"Unlock Your Ideas","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"34px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"7px","title-bottom-margin":"20px","caption-size":"17px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"67px","right":"80px","bottom":"65px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#4b76e3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light Purple","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_cloud-upload_alt","icon-style":"normal","image":"","title":"Powerful Performance","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"34px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"7px","title-bottom-margin":"20px","caption-size":"17px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"95px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"326px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"22","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"7","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"accordion","value":{"id":"","tabs":[{"title":"A wonderful serenity has taken","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet.\n\n<a href=\"#\">Learn More</a>"},{"title":"I sink under the weight of the splendour","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet.\n\n<a href=\"#\">Learn More</a>"},{"title":"I throw myself down among the tall grass","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet.\n\n<a href=\"#\">Learn More</a>"},{"title":"Far far away, behind the word mountains","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. \n\n<a href=\"#\">Learn More</a>"}],"active":"1","style":"background-title-icon","align":"left","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light Purple","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SAVE A LOT OF YOUR TIME","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#4b76e3","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-comments-o","icon-style":"normal","image":"","title":"Best Support Ever","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#2d9bea","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lock_alt","icon-style":"normal","image":"","title":"Very Secure Code","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#4b59e3","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1288","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"65px","bottom":"60px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Light"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"Sections and wrapper can be manage easily","title":"With brand new <br/>GoodLayers page builder","content":"","button-text":"","button-link":"#","button-link-target":"_self","text-align":"left","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn\'t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back.</p>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"75px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":null,"tag":null,"num-fetch":"9","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"left","portfolio-grid-style":"with-frame","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","layout":"carousel","carousel-navigation":"navigation","excerpt":"none","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"Recent works","caption":"Explore","read-more-text":"View More Works","read-more-link":"#","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"65px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"588","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"14000","end-number":"16800","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"disable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"110px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1318","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Pricing plans","caption":"Go with your right one","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"37px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#c7e3ff","caption-spaces":"10px","padding-bottom":"55px"}},{"template":"element","type":"price-table","value":{"id":"","tabs":[{"icon":"icon_genius","image":"","image-img":"","title":"Standard Plan","caption":"Price default caption","price":"99","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"},{"icon":"fa fa-star-o","image":"","image-img":"","title":"professional plan","caption":"Price default caption","price":"129","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"enable"},{"icon":"icon_lightbulb_alt","image":"","image-img":"","title":"Enterprise plan","caption":"Price default caption","price":"299","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","padding-bottom":"30px","header-color":"","header-gradient-color":"","icon-color":"","title-color":"","caption-color":"","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"#404040","button-background-gradient-color":"#565656","a-header-color":"","a-header-gradient-color":"","a-icon-color":"","a-title-color":"","a-caption-color":"","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"#319dea","a-button-background-gradient-color":"#51aae9"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","thumbnail-size":"full","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-column-with-frame","show-thumbnail":"disable","column-size":"20","layout":"carousel","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"30","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"center","title":"Recent News","caption":"Get updates from us","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"37px","caption-size":"18px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"50px"}},{"template":"element","type":"button","value":{"id":"","button-text":"More News","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/infinite/blog","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"pulse","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#1a1a1a","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Where are we?","caption":"Come and see us","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"37px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#7a7a7a","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]}]';
				case 'home-aperture':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"60px","bottom":"40px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_film","icon-style":"normal","image":"","title":"MV/Ad Filming","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"37px","media-margin":{"top":"","right":"","bottom":"48px","left":""},"icon-color":"#121212","icon-background":"","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"35px","caption-size":"14px","caption-top-margin":"","content-size":"17px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#202020","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"60px","bottom":"40px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#2f2f2f","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_camera_alt","icon-style":"normal","image":"","title":"Photograph service","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"37px","media-margin":{"top":"","right":"","bottom":"48px","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"35px","caption-size":"14px","caption-top-margin":"","content-size":"17px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#353535","text-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"60px","bottom":"40px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_pencil","icon-style":"normal","image":"","title":"Re-touch service","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"37px","media-margin":{"top":"","right":"","bottom":"48px","left":""},"icon-color":"#121212","icon-background":"","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"35px","caption-size":"14px","caption-top-margin":"","content-size":"17px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#202020","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"620px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Dark","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"My Photos","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"45px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm","text-align":"center","font-size":"17px","padding-bottom":"40px"}}]},{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"12","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"text","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-icon-title-tag","column-size":"15","layout":"fitrows","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"820px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"110px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1369","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","skin":"light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"Jennifer Smith","position":"Photographer","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. ","image":"1370","image-img":"http://demo.goodlayers.com/infinite/homepages/aperture/wp-content/uploads/sites/14/2016/05/testimonial-1.jpg"},{"title":"John Doe","position":"Artist","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. ","image":"1371","image-img":"http://demo.goodlayers.com/infinite/homepages/aperture/wp-content/uploads/sites/14/2016/05/testimonial-2.jpg"}],"column":"1","carousel":"enable","carousel-navigation":"navigation","style":"center","title-size":"41px","caption-size":"16px","content-size":"19px","title-color":"","caption-color":"","quote-color":"#ffffff","content-color":"#bbbbbb","name-color":"","position-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"Blog","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"140px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#b2b2b2","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","title":"Get updates","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"35px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#313131","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1375","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","skin":"light","border-type":"inner-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"4","prepend-sticky":"enable","thumbnail-size":"full","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-list-center","show-thumbnail":"enable","column-size":"20","layout":"fitrows","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","meta-option":["date","author","category"],"show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"660px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1379","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"185px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1380","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"1321","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"circle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"I am <strong>Ricky Huston</strong>","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"40px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#020202\" margin-left=\"0px\" margin-right=\"12px\" ] 020 - 5534-5552 [gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"18px\" color=\"#020202\" margin-left=\"20px\" margin-right=\"12px\" ] infiniteHQ@goodlayers.com","text-align":"left","font-size":"17px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"social-network","value":{"id":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","text-align":"center","icon-size":"16px","icon-color":"","with-text":"disable","text-size":"15px","icon-space":"35px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","text-align":"center","font-size":"","padding-bottom":"30px"}}]}]}]';
				case 'home-appz':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"1436","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Service"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1437","title":"Sign up","caption":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Vestibulum id ligula porta felis euismod semper.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1438","title":"Create Profile","caption":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Vestibulum id ligula porta felis euismod semper.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1439","title":"Explore Musics","caption":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Vestibulum id ligula porta felis euismod semper.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1440","title":"Share Music","caption":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Vestibulum id ligula porta felis euismod semper.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"#1 App for Music in App Store and  Google Play ","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#3a3a3a","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cum sociis natoque penatibus et magnis dis parturient montes.","text-align":"left","apply-the-content-filter":"disable","font-size":"18px","text-color":"","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<a href=\"#\"><img src=\"https://demo.goodlayers.com/infinite/homepages/appz/wp-content/uploads/sites/24/2016/05/app-appstore.png\" alt=\"\" width=\"150\" height=\"45\" class=\"aligncenter size-full wp-image-1443\" style=\"display: inline-block;\"></a>    <a href=\"#\"><img src=\"https://demo.goodlayers.com/infinite/homepages/appz/wp-content/uploads/sites/24/2016/05/app-google.png\" alt=\"\" width=\"152\" height=\"46\" class=\"aligncenter size-full wp-image-1444\" style=\"display: inline-block;\"></a>","text-align":"left","apply-the-content-filter":"disable","font-size":"18px","text-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"1442","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"600px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"-65px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-160px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1449","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"175px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Save And Share Your playlist","caption":"Core Features","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Cras mattis consectetur purus sit amet fermentum. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.","text-align":"left","font-size":"16px","padding-bottom":"5px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2979ff","text-hover-color":"#5e99ff","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"160px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet New Friends","caption":"Core Features","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Cras mattis consectetur purus sit amet fermentum. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.","text-align":"left","font-size":"16px","padding-bottom":"5px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"8px","right":"20px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"#ffffff","background-color":"#37da65","background-hover-color":"#2eba5a","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"12px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1446","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-150px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1447","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Your Own Public Profile","caption":"Core Features","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Cras mattis consectetur purus sit amet fermentum. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"5px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2979ff","text-hover-color":"#5e99ff","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1448","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"1450","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"190px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"See how Appz works","caption":"Click to watch Appz video presentation","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"50px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"1451","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=_f1eah9B_do","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Black Service"},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"","title":"Best Music App","caption":"","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Integer posuere erat a ante venenatis.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"35px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"","title":"Over 200,000 Songs","caption":"","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Integer posuere erat a ante venenatis.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"35px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"","title":"Listen Offline","caption":"","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Integer posuere erat a ante venenatis.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"35px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"","title":"New Music Ideas","caption":"","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Integer posuere erat a ante venenatis.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"35px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"","title":"Follow Your Idol","caption":"","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Integer posuere erat a ante venenatis.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"35px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"","title":"Music Suggestion","caption":"","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Integer posuere erat a ante venenatis.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"35px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"","padding-bottom":"30px","icon-color":"","divider-color":"#f0f0f0"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"790px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get Start Now","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Nullam quis risus eget urna mollis ornare vel eu leo.","text-align":"center","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"5px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Download Now","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"8px","right":"20px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"#ffffff","background-color":"#37da65","background-hover-color":"#2eba5a","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"12px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"740px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f7f7f7","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Black Service"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Success Stories","title-left-icon":"","caption":"","tabs":[{"title":"John Doe","position":"Customer","content":"A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful.","image":"1453","image-img":"https://demo.goodlayers.com/infinite/homepages/appz/wp-content/uploads/sites/24/2016/05/testimonial-1.jpg","rating":""},{"title":"Rebecca Smith","position":"Reviewer","content":"A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful.","image":"1454","image-img":"https://demo.goodlayers.com/infinite/homepages/appz/wp-content/uploads/sites/24/2016/05/testimonial-2.jpg","rating":""}],"style":"center","column":"1","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-navigation":"navigation","carousel-nav-style":"gdlr-core-round-style","title-size":"28px","title-text-transform":"none","title-font-weight":"400","title-letter-spacing":"0px","caption-size":"16px","content-size":"19px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","title-wrap-bottom-margin":"35px","content-bottom-padding":"0px","padding-bottom":"30px"}}]}]';
				case 'home-architek':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#303030","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"135px","right":"50px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1327","title":"Project Planning","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Book.</p>","read-more-text":"Read More","read-more-link":"#","style":"left_icon-left","icon-size":"24px","title-size":"24px","title-font-weight":"300","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"68px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1328","title":"Execution","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Book.</p>","read-more-text":"Read More","read-more-link":"#","style":"left_icon-left","icon-size":"24px","title-size":"24px","title-font-weight":"300","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"68px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"110px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"1329","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"135px","right":"0px","bottom":"0px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1331","title":"Project Planning","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Book.</p>","read-more-text":"Read More","read-more-link":"#","style":"left_icon-left","icon-size":"24px","title-size":"24px","title-font-weight":"300","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"68px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1332","title":"Execution","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Book.</p>","read-more-text":"Read More","read-more-link":"#","style":"left_icon-left","icon-size":"24px","title-size":"24px","title-font-weight":"300","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"68px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"110px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Works","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"enable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"#cbcbcb","heading-tag":"h3","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"90px"}},{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-desc","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon","column-size":"20","thumbnail-size":"Portfolio Thumbnail 2","enable-badge":"disable","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"23","overlay-color":"#c24a4a","overlay-opacity":"0.9","portfolio-title-text-transform":"uppercase","padding-bottom":"70px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}},{"template":"element","type":"text-box","value":{"id":"","content":"<a href=\"http://demo.goodlayers.com/infinite/homepages/architek/portfolio/\"><b>VIEW ALL WORKS</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#111\" margin-left=\"23px\" margin-right=\"\" ]</a>","text-align":"center","font-size":"","padding-bottom":"50px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"1333","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","title":"We are the best architect firm  <br/>& Building Consultant","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"38px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"140px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"text-box","value":{"id":"","content":"<p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Lorem ipsum dolor sit amet, consectetur adipiscing elit<br /><br /></p><p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam quis risus eget urna mollis ornare vel eu leo. Cras mattis consectetur purus sit amet fermentum. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit avmet risus.</p>","text-align":"left","font-size":"16px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p><a href=\"#\"><b>LEARN MORE</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#fff\" margin-left=\"30px\" margin-right=\"\" ]</a></p>","text-align":"left","font-size":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#efefef","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey Orange"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-45px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"image","icon":"fa fa-android","image":"1409","title":"Innovative & Elegant","caption":"","content":"","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#191919","caption-color":"","content-color":"","icon-size":"35px","title-size":"23px","title-font-weight":"300","caption-size":"15px","content-size":"15px","content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"padding-bottom":"30px","sync-height":"","centering-sync-height-content":"enable","background-color":"#ffffff","background-image":"","background-opacity":"1","border-type":"outer","border-color":"#0a0a0a","border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-radius":"0px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-media-type":"image","b-icon":"fa fa-android","b-image":"1414","b-title":"Innovative & Elegant","b-caption":"","b-content":"","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"23px","b-title-font-weight":"300","b-caption-size":"15px","b-content-size":"15px","b-content-padding":{"top":"50px","right":"40px","bottom":"40px","left":"40px","settings":"unlink"},"b-background-color":"#282828","b-background-image":"","b-background-opacity":"1","b-border-type":"outer","b-border-color":"#0a0a0a","b-border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"b-border-radius":"0px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-45px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"image","icon":"fa fa-android","image":"1411","title":"Award Wining","caption":"","content":"","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#191919","caption-color":"","content-color":"","icon-size":"35px","title-size":"23px","title-font-weight":"300","caption-size":"15px","content-size":"15px","content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"padding-bottom":"30px","sync-height":"","centering-sync-height-content":"enable","background-color":"#ffffff","background-image":"","background-opacity":"1","border-type":"outer","border-color":"#0a0a0a","border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-radius":"0px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-media-type":"image","b-icon":"fa fa-android","b-image":"1415","b-title":"Award Wining","b-caption":"","b-content":"","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"23px","b-title-font-weight":"300","b-caption-size":"15px","b-content-size":"15px","b-content-padding":{"top":"50px","right":"40px","bottom":"40px","left":"40px","settings":"unlink"},"b-background-color":"#282828","b-background-image":"","b-background-opacity":"1","b-border-type":"outer","b-border-color":"#0a0a0a","b-border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"b-border-radius":"0px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-45px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"image","icon":"fa fa-android","image":"1413","title":"Genius Team","caption":"","content":"","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#191919","caption-color":"","content-color":"","icon-size":"35px","title-size":"23px","title-font-weight":"300","caption-size":"15px","content-size":"15px","content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"padding-bottom":"30px","sync-height":"","centering-sync-height-content":"enable","background-color":"#ffffff","background-image":"","background-opacity":"1","border-type":"outer","border-color":"#0a0a0a","border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-radius":"0px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-media-type":"image","b-icon":"fa fa-android","b-image":"1416","b-title":"Genius Team","b-caption":"","b-content":"","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"23px","b-title-font-weight":"300","b-caption-size":"15px","b-content-size":"15px","b-content-padding":{"top":"50px","right":"40px","bottom":"40px","left":"40px","settings":"unlink"},"b-background-color":"#282828","b-background-image":"","b-background-opacity":"1","b-border-type":"outer","b-border-color":"#0a0a0a","b-border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"b-border-radius":"0px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"1194","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.4","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"","title":"We pride ourselves on innovative.","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Seman tics, a large language ocean. Pointing has no control about the blind.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"27px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"text-box","value":{"id":"","content":"<a href=\"#\"><b>LEARN MORE</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#111\" margin-left=\"23px\" margin-right=\"\" ]</a>","text-align":"left","font-size":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"","title":"We won many awards.","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Seman tics, a large language ocean. Pointing has no control about the blind.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"27px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"text-box","value":{"id":"","content":"<a href=\"#\"><b>LEARN MORE</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#111\" margin-left=\"23px\" margin-right=\"\" ]</a>","text-align":"left","font-size":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"","title":"We are a team of genius people.","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Seman tics, a large language ocean. Pointing has no control about the blind.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"27px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"text-box","value":{"id":"","content":"<a href=\"#\"><b>LEARN MORE</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#111\" margin-left=\"23px\" margin-right=\"\" ]</a>","text-align":"left","font-size":"13px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"1334","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Clients","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"40px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"80px"}},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1336","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-1.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1337","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-2.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1338","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-3.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1339","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-4.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1340","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-5.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1341","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-6.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1342","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-7.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1343","thumbnail":"http://demo.goodlayers.com/infinite/homepages/architek/wp-content/uploads/sites/21/2016/05/banner-8.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"88px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"1333","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Black Divider"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"Feel free to give us a visit or <br/> just call us","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"38px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#1e1e1e","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"140px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"London","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>2334 Peterson Street Kingston UK London H14D<br />Phone : 1123-2234-21<br />Email : london@architekthemes.com</p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"44px","padding-bottom":"50px"}},{"template":"element","type":"title","value":{"id":"","title":"New York","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>11 Bedford St. New York City, N.Y. 100121<br />Phone : 345-3334-5533<br />Email : newyork@architekthemes.com</p>","text-align":"left","font-size":"16px","padding-bottom":"20px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"#","pinterest":"#","rss":"","skype":"","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"#","instagram":"#","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#3d3d3d","icon-space":"30px","padding-bottom":"0px"}}]}]';
				case 'home-big-corp':
					return '[{"template":"wrapper","type":"background","value":{"id":"home","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#303030","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"flipbox","value":{"id":"","icon":"","title":"Corporate Branding","caption":"","content":"","text-align":"center","icon-color":"","title-color":"","caption-color":"","content-color":"","icon-size":"51px","title-size":"18px","caption-size":"15px","content-size":"15px","content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-color":"","background-image":"1341","background-opacity":"1","border-type":"none","border-color":"","border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-icon":"","b-title":"Help create brand awareness","b-caption":"","b-content":"","b-text-align":"center","b-icon-color":"","b-title-color":"","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"18px","b-caption-size":"15px","b-content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"b-content-size":"15px","b-background-color":"","b-background-image":"1341","b-background-opacity":"1","b-border-type":"none","b-border-color":"","b-border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"flipbox","value":{"id":"","icon":"","title":"Corporate Identity","caption":"","content":"","text-align":"center","icon-color":"","title-color":"","caption-color":"","content-color":"","icon-size":"51px","title-size":"18px","caption-size":"15px","content-size":"15px","content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-color":"","background-image":"1342","background-opacity":"1","border-type":"none","border-color":"","border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-icon":"","b-title":"Logo & Identities design","b-caption":"","b-content":"","b-text-align":"center","b-icon-color":"","b-title-color":"","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"18px","b-caption-size":"15px","b-content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"b-content-size":"15px","b-background-color":"","b-background-image":"1342","b-background-opacity":"1","b-border-type":"none","b-border-color":"","b-border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"flipbox","value":{"id":"","icon":"","title":"Business Training","caption":"","content":"","text-align":"center","icon-color":"","title-color":"","caption-color":"","content-color":"","icon-size":"51px","title-size":"18px","caption-size":"15px","content-size":"15px","content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-color":"","background-image":"1343","background-opacity":"1","border-type":"none","border-color":"","border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-icon":"","b-title":"Teach how to run business","b-caption":"","b-content":"","b-text-align":"center","b-icon-color":"","b-title-color":"","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"18px","b-caption-size":"15px","b-content-padding":{"top":"100px","right":"40px","bottom":"100px","left":"40px","settings":"unlink"},"b-content-size":"15px","b-background-color":"","b-background-image":"1343","b-background-opacity":"1","b-border-type":"none","b-border-color":"","b-border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#2e2e2e","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_desktop","icon-style":"normal","image":"","title":"Free Sliders Included","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_genius","icon-style":"normal","image":"","title":"Super Powerful Admin Panel","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-support","icon-style":"normal","image":"","title":"Awesome Support","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_cloud-download_alt","icon-style":"normal","image":"","title":"Google font library","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_heart_alt","icon-style":"normal","image":"","title":"Very easy to use","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"about","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"skill-bar","value":{"id":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Photography","icon":"","percent":"80","bar-text":""},{"heading-text":"coding","icon":"","percent":"100","bar-text":""},{"heading-text":"Branding","icon":"","percent":"85","bar-text":""},{"heading-text":"Social Media","icon":"","percent":"90","bar-text":""}],"heading-text-color":"","icon-color":"","percent-color":"","bar-filled-color":"#585858","bar-background-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Great Story","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"35px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"600","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"4px","divider-width":"40px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>We had spent a lot of time to study, gather information and finally we come up with the best page builder in the world. It\'s the most powerful with many options and it has everything you need. You can push them into 3 modes, block mode, preview mode and live mode(frontend builder). Now with this tool, your imagination will be limitless.</p>\n<p><a href=\"#\" style=\"text-transform: uppercase; letter-spacing: 1px; font-weight: 700; font-size: 13px;\">Read More Story</a></p>\n","text-align":"left","font-size":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"portfolio","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f8f8f8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Works","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"30px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"600","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"4px","divider-width":"40px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia<br />\nthere live the blind texts. Separated they</p>\n","text-align":"center","font-size":"","padding-bottom":"50px"}},{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"6","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-tag","column-size":"20","layout":"fitrows","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"588","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16800","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"disable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"840px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1367","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"","caption":"","tabs":[{"title":"Paul Smith","position":"CEO, Apple","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"1368","image-img":"http://demo.goodlayers.com/infinite/homepages/bigcorp/wp-content/uploads/sites/9/2016/05/personnel-sq-2.jpg"}],"column":"1","carousel":"disable","carousel-navigation":"navigation","style":"center","title-size":"28px","caption-size":"16px","content-size":"18px","title-color":"#ffffff","caption-color":"","quote-color":"#ffffff","content-color":"#ffffff","name-color":"#ffffff","position-color":"#ffffff","padding-bottom":"10px"}}]},{"template":"wrapper","type":"background","value":{"id":"blog","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Recent News","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"30px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"600","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"4px","divider-width":"40px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia<br />\nthere live the blind texts. Separated they</p>\n","text-align":"center","font-size":"","padding-bottom":"5px"}},{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","thumbnail-size":"Blog Thumnnail","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-column","show-thumbnail":"enable","column-size":"20","layout":"carousel","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"29","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"65px"}},{"template":"element","type":"button","value":{"id":"","button-text":"More News","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/infinite/blog","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"#ffffff","background-color":"#2eb0d1","background-hover-color":"#59b9d1","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"40px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f8f8f8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Happy Clients","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"30px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"600","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"gallery","value":{"id":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1380","thumbnail":"http://demo.goodlayers.com/infinite/homepages/bigcorp/wp-content/uploads/sites/9/2016/05/banner-1-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1381","thumbnail":"http://demo.goodlayers.com/infinite/homepages/bigcorp/wp-content/uploads/sites/9/2016/05/banner-2-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1382","thumbnail":"http://demo.goodlayers.com/infinite/homepages/bigcorp/wp-content/uploads/sites/9/2016/05/banner-3-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1383","thumbnail":"http://demo.goodlayers.com/infinite/homepages/bigcorp/wp-content/uploads/sites/9/2016/05/banner-4-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1384","thumbnail":"http://demo.goodlayers.com/infinite/homepages/bigcorp/wp-content/uploads/sites/9/2016/05/banner-5-150x150.png"}],"style":"grid","overlay":"none","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","grid-slider-navigation":"bullet","thumbnail-size":"full","padding-bottom":"25px"}}]},{"template":"wrapper","type":"background","value":{"id":"contact","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]}]';
				case 'home-breeze-biz':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"60px","bottom":"60px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Green Divider","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"With Brand New  Goodlayers Page Builder","caption":"Sections and wrapper can be manage easily","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"47px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. ","text-align":"left","font-size":"19px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Discover More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"18px","right":"35px","bottom":"18px","left":"35px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#4acea9","background-hover-color":"#4acea9","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","padding":{"top":"80px","right":"0px","bottom":"80px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1343","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.6","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1342","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"1328","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"right","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"45px","bottom":"30px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#4acea9","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1352","title":"Ligula Aenean  Consecte","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","media-margin":{"top":"","right":"","bottom":"40px","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"45px","bottom":"30px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#4ec19d","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1353","title":"Porta Ridiculus  Vestibu","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","media-margin":{"top":"","right":"","bottom":"40px","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"45px","bottom":"30px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#4cbb98","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1354","title":"Amet Adipiscing  Peesq","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","media-margin":{"top":"","right":"","bottom":"40px","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"45px","bottom":"30px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#49b291","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1355","title":"Sollicitudin Dolor  Tellus","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","media-margin":{"top":"","right":"","bottom":"40px","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"45px","bottom":"30px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#47aa8b","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1356","title":"Tellus Inceptos  Tristique","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","media-margin":{"top":"","right":"","bottom":"40px","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1363","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Works","caption":"Explore recent works","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#2b2b2b","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"9","thumbnail-size":"full","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"metro-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon-title-tag","column-size":"15","layout":"fitrows","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#2b2b2b","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"18px","right":"35px","bottom":"18px","left":"35px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#4acea9","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1393","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Meet The Team","caption":"Great people are with us","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"70px"}},{"template":"element","type":"personnel","value":{"id":"","category":"","num-fetch":"3","thumbnail-size":"Personnel Thumbnail","orderby":"date","disable-link":"disable","order":"desc","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"left","personnel-style":"modern","enable-position":"enable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"3","carousel":"disable","carousel-navigation":"navigation","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"110px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1395","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1396","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"1328","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Accordion","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"accordion","value":{"id":"","tabs":[{"title":" A small river named Jazz","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. Duden flows by their place and supplies."},{"title":"A wonderful serenity has taken","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. Duden flows by their place and supplies."},{"title":"I am so happy, my dear friend","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. Duden flows by their place and supplies."},{"title":"I often think with longing","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. Duden flows by their place and supplies."}],"active":"1","style":"box-icon","align":"left","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"20px","bottom":"220px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1401","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","skin":"Services","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"What We Do?","caption":"Here are some of them","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"90px"}},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"35px","bottom":"0px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_menu-circle_alt2","icon-style":"normal","image":"","title":"Briefing","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"60px","media-margin":{"top":"","right":"","bottom":"30px","left":""},"icon-color":"#4acea9","icon-background":"","title-size":"21px","title-font-weight":"800","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"20px","caption-size":"14px","caption-top-margin":"","content-size":"18px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"35px","bottom":"0px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_document_alt","icon-style":"normal","image":"","title":"Managing Data","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"60px","media-margin":{"top":"","right":"","bottom":"30px","left":""},"icon-color":"#4acea9","icon-background":"","title-size":"21px","title-font-weight":"800","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"20px","caption-size":"14px","caption-top-margin":"","content-size":"18px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"35px","bottom":"0px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"New Ideas","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"60px","media-margin":{"top":"","right":"","bottom":"30px","left":""},"icon-color":"#4acea9","icon-background":"","title-size":"21px","title-font-weight":"800","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"20px","caption-size":"14px","caption-top-margin":"","content-size":"18px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"35px","bottom":"0px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_piechart","icon-style":"normal","image":"","title":"Risk Management","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"60px","media-margin":{"top":"","right":"","bottom":"30px","left":""},"icon-color":"#4acea9","icon-background":"","title-size":"21px","title-font-weight":"800","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"20px","caption-size":"14px","caption-top-margin":"","content-size":"18px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"35px","bottom":"0px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_key_alt","icon-style":"normal","image":"","title":"Key to Success","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"60px","media-margin":{"top":"","right":"","bottom":"30px","left":""},"icon-color":"#4acea9","icon-background":"","title-size":"21px","title-font-weight":"800","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"20px","caption-size":"14px","caption-top-margin":"","content-size":"18px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"pulse","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#2b2b2b","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"Call to action","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","title":"Dedicated Support Team","caption":" Not only great theme but we also provide the best support.","button-text":"Learn More","button-link":"#","button-link-target":"_self","style":"left-align-right-button","button-style":"transparent","title-size":"36px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"What We Do?","caption":"Here are some of them","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"20px"}},{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","thumbnail-size":"full","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-column-with-frame","show-thumbnail":"disable","column-size":"20","layout":"carousel","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"23","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"30px"}}]}]';
				case 'home-conference':
					return '[{"template":"wrapper","type":"background","value":{"id":"home","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"about","class":"","content-layout":"full","max-width":"","enable-space":"enable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"box-1-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#8e2525","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"50px","bottom":"90px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Red Service Box"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Info","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>+1-2435-3452-2<br /> contact@infiniteconference.com</p>","text-align":"left","font-size":"17px","padding-bottom":"5px"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"#","pinterest":"#","rss":"","skype":"","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"18px","with-text":"disable","text-size":"15px","icon-color":"","icon-space":"20px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"box-1-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"11","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"50px","bottom":"90px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Red Service Box"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"October 09-12, 2017","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>234 Infinite Place<br />\n4th Avenue, Nwe York City<br />\nH4454 NY</p>\n","text-align":"left","font-size":"17px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"box-1-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#1f1f1f","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"10px","bottom":"90px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Conference Will Start in","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"5px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"300px","padding-bottom":"30px","icon-color":"","divider-color":"#686868"}},{"template":"element","type":"countdown","value":{"id":"","class":"","date":"2017-12-31","alignment":"center","number-font-size":"59px","number-font-weight":"700","text-font-size":"18px","text-font-weight":"500","number-font-color":"#ffffff","text-font-color":"#9b9b9b","space-between-counter":"24px","space-between-text":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-box-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"14","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-box-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"16","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"100px","bottom":"110px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About The Conference","caption":"Morbi leo risus, porta ac consectetur ","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nullam id dolor id nibh ultricies vehicula ut id elit. Donec ullamcorper nulla non metus auctor fringilla. Maecenas faucibus mollis.</p>\n<p>nascetur ridiculus mus. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.</p>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"17","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Red Service Box"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"18","title":"Time Schedule","caption":"","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself trans formed in his bed into a horrible vermin. ready to.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"24px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"40px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Red Service Box"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"19","title":"Conference Day","caption":"","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself trans formed in his bed into a horrible vermin. ready to.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"24px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"36px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Red Service Box"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"20","title":"Get New Friends","caption":"","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself trans formed in his bed into a horrible vermin. ready to.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"24px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"40px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"speakers","class":"","content-layout":"custom","max-width":"850px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"21","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet Our Speakers","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"65px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"20px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the.","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":null,"num-fetch":"4","orderby":"date","order":"desc","text-align":"left","personnel-style":"modern-no-space","enable-position":"enable","disable-link":"disable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"4","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"disable","carousel-navigation":"navigation","padding-bottom":"0px","title-align":"left","title":"","caption":"","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"37px","caption-size":"17px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"schedule","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-time","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"22","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"100px","bottom":"120px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Prepare your mind","caption":"Day 1 , October 10, 2017","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px","icon-color":"","divider-color":"#dddddd"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et.","text-align":"left","font-size":"","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Schedule","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">10:00 - 12:00</span><span style=\" color:#fff;\">Presentation</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">12:00 - 13:00</span><span style=\" color:#fff;\">Lunch</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">13:00 - 15:00</span><span style=\" color:#fff;\">Strategy Session</span></div>\n<div style=\"margin-bottom: 20x;\"><span style=\"margin-right: 35px;\">15:00 - 17:00</span><span style=\" color:#fff;\">Workshop</span></div>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-time","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"100px","bottom":"120px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Marketing Strategy","caption":"Day 2 , October 11, 2017","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px","icon-color":"","divider-color":"#dddddd"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et.","text-align":"left","font-size":"","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Schedule","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">10:00 - 12:00</span><span style=\" color:#222;\">Presentation</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">12:00 - 13:00</span><span style=\" color:#222;\">Lunch</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">13:00 - 15:00</span><span style=\" color:#222;\">Strategy Session</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">15:00 - 17:00</span><span style=\" color:#222;\">Workshop</span></div>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-time","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"100px","bottom":"120px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Advertise Smartly","caption":"Day 3 , October 11, 2017","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px","icon-color":"","divider-color":"#dddddd"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et.","text-align":"left","font-size":"","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Schedule","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">10:00 - 12:00</span><span style=\" color:#222;\">Presentation</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">12:00 - 13:00</span><span style=\" color:#222;\">Lunch</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">13:00 - 15:00</span><span style=\" color:#222;\">Strategy Session</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">15:00 - 17:00</span><span style=\" color:#222;\">Workshop</span></div>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-time","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"23","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"100px","bottom":"120px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Workshop Day","caption":"Day 4 , October 12, 2017","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px","icon-color":"","divider-color":"#dddddd"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et.","text-align":"left","font-size":"","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Schedule","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">10:00 - 12:00</span><span style=\" color:#fff;\">Presentation</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">12:00 - 13:00</span><span style=\" color:#fff;\">Lunch</span></div>\n<div style=\"margin-bottom: 20px;\"><span style=\"margin-right: 35px;\">13:00 - 15:00</span><span style=\" color:#fff;\">Strategy Session</span></div>\n<div style=\"margin-bottom: 20x;\"><span style=\"margin-right: 35px;\">15:00 - 17:00</span><span style=\" color:#fff;\">Workshop</span></div>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"testimonial","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-testimonial","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"24","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"100px","bottom":"120px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Testimonial","caption":"","tabs":[{"title":"Jennifer Gordon","position":"CEO Of PhotoUS","content":"Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Lorem ips um dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. ","image":"25","image-img":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/testimonial-1.jpg"},{"title":"James Smith","position":"Online Marketer","content":"Curabitur blandit tempus porttitor. Maecenas sed diam eget risus varius blandit sit amet non magna. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas faucibus mollis interdum. Duis mollis, est non commodo luctus, nisi erat porttitor ligul.","image":"26","image-img":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/testimonial-2.jpg"}],"style":"left","column":"1","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-navigation":"navigation","title-size":"25px","title-text-transform":"none","title-letter-spacing":"","caption-size":"16px","content-size":"18px","title-color":"","caption-color":"","quote-color":"#ffffff","content-color":"#f6c8c8","name-color":"","position-color":"#6ce0c7","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-testimonial","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"100px","bottom":"120px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Newsletter Form"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get update from us","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean eu leo quam. Pellentesque ornare sem lacinia quam.","text-align":"left","font-size":"","padding-bottom":"25px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"sponsors","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"27","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-1-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"28","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-2-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"29","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-3-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"30","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-4-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"31","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-5-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"32","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-6-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"33","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-7-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"34","thumbnail":"http://demo.goodlayers.com/infinite/homepages/conference/wp-content/uploads/sites/23/2017/05/banner-8-150x150.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"ticket","class":"","content-layout":"custom","max-width":"1340px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"35","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"price-height","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Tickets"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Buy Tickets","caption":"Be hurry! Last years tickets was sold  out in just one week.","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"64px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"20px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"41px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Nullam id dolor id nibh ultricies vehicula ut id elit. Sed posuere consectetur est at lobortis. Lorem ipsum dolor sit amet, consectetur.","text-align":"center","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"price-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-table","value":{"id":"","class":"","tabs":[{"icon":"fa fa-star-o","image":"","image-img":"","title":"All 4 Days","caption":"Best Value!","price":"250","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Coffee Break</li>\n<li>Books & Documentation</li>\n<li>Tips From Speaker</li>\n</ul>[/gdlr_core_price_list]","button-text":"Buy Ticket","button-link":"#","button-link-target":"_self","feature-price":"enable"},{"icon":"icon_lightbulb_alt","image":"","image-img":"","title":"One Day Pass","caption":"Pick What You Like","price":"99","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Coffee Break</li>\n<li>Books & Documentation</li>\n<li>Tips From Speaker</li>\n</ul>[/gdlr_core_price_list]","button-text":"Buy Ticket","button-link":"#","button-link-target":"_self","feature-price":"disable"}],"price-prefix":"$","price-suffix":"","header-color":"","header-gradient-color":"","icon-color":"","title-color":"","caption-color":"","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"","button-background-gradient-color":"","a-header-color":"","a-header-gradient-color":"","a-icon-color":"","a-title-color":"","a-caption-color":"","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"","a-button-background-gradient-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"contact","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Venue"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"36","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"10px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Venue","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"65px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>234 Infinite Place 4th Avenue, Nwe York City H4454 NY<br />\n<a href=\"#\">+1-2435-3452-2</a>    <a href=\"#\">contact@infiniteconference.com</a></p>\n","text-align":"center","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"1","wpgmap2-id":null,"padding-bottom":"0px"}}]}]';
				case 'home-designer':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"82px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Heading","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Hey, I Am","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"75px","title-font-weight":"100","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#7f7f7f","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","title":"John Smith","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"125px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#3b3b3b","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"4px","divider-width":"52px","padding-bottom":"55px"}},{"template":"element","type":"text-box","value":{"id":"","content":"I am a graphic designer, London based. I have more than 10 years of experiences.","text-align":"center","font-size":"20px","padding-bottom":"55px"}},{"template":"element","type":"social-network","value":{"id":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"http://facebook.com/goodlayers","flickr":"","google-plus":"","lastfm":"","linkedin":"#","pinterest":"","rss":"","skype":"","stumbleupon":"","tumblr":"","twitter":"http://twitter.com/goodlayers","vimeo":"","youtube":"","dribbble":"#","behance":"#","text-align":"center","icon-size":"25px","icon-color":"#2f2f2f","with-text":"disable","text-size":"15px","icon-space":"30px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"12","thumbnail-size":"full","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"load-more","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"15","layout":"masonry","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"65px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"7000","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"59","suffix":"","divider":"disable","bottom-text":"Designers","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"950","suffix":"","divider":"disable","bottom-text":"Awesome Works","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"120","suffix":"","divider":"disable","bottom-text":"Happy Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"disable","bottom-text":"Cups of coffee","top-icon-size":"30px","top-text-size":"16px","number-size":"32px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1364","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Get In Touch","caption":"Don not hesitate to ask anything","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"37px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"60px","bottom":"80px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#353535","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"fa fa-envelope-o","text-align":"center","icon-size":"27px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Contact@Goodlyds.com","text-align":"center","font-size":"18px","padding-bottom":"27px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"60px","bottom":"80px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#2d2d2d","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"fa fa-map-o","text-align":"center","icon-size":"27px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>66 kingsteer 6thavenue<br />\nPowell London 22345 uk</p>\n","text-align":"center","font-size":"18px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"60px","bottom":"80px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#252525","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"fa fa-mobile","text-align":"center","icon-size":"36px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"+44-7322-57687","text-align":"center","font-size":"18px","padding-bottom":"27px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"670px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"95px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Or Drop Us A Message","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"33px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"40px","padding-bottom":"30px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"30px"}}]}]';
				case 'home-emporium':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"enable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"1336","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Living Room","caption":"","caption-position":"top","title-link":"#","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"29px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"186px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"1337","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Sale Items","caption":"","caption-position":"top","title-link":"#","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"29px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"157px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"1338","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Clothes","caption":"","caption-position":"top","title-link":"#","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"29px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"116px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","items":[{"template":"element","type":"title","value":{"id":"","title":"Recent Products","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"80px"}},{"template":"element","type":"product"}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"1340","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"280px","right":"0px","bottom":"280px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Discover Thousands Of Great Products","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"40px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","text-size":"13px","icon-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"enable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"Hot Fashion Products","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"product","value":{"id":"","category":["fashion"],"tag":"","num-fetch":"9","orderby":"date","order":"asc","thumbnail-size":"Portfolio Thumbnail","column-size":"15","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"bullet","pagination":"none","pagination-style":"default","pagination-align":"default","product-title-text-transform":"none","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"enable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height-2","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f3f3f3","background-image":"1336","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"70px","bottom":"85px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"Grey"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"fa fa-check-circle-o","text-align":"center","icon-size":"39px","icon-color":"#303030","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","title":"Trsuted By 10,000+ Customers","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"16px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.","text-align":"center","font-size":"17px","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"#303030","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","text-size":"13px","icon-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height-2","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#bd584e","background-image":"1336","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"70px","bottom":"85px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"White Text"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"fa fa-paper-plane","text-align":"center","icon-size":"39px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","title":"Very Fast Shipping","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"16px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.","text-align":"center","font-size":"17px","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","text-size":"13px","icon-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height-2","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f3f3f3","background-image":"1336","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"70px","bottom":"85px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"Grey"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"fa fa-check-circle-o","text-align":"center","icon-size":"39px","icon-color":"#303030","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","title":"Trsuted By 10,000+ Customers","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"16px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.","text-align":"center","font-size":"17px","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"#303030","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","text-size":"13px","icon-size":"","padding-bottom":"0px"}}]}]}]';
				case 'home-finance':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#ea6b2d","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"enable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"35px","bottom":"20px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SAVE A LOT OF YOUR TIME","caption":"","content":"<p>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_comment_alt","icon-style":"normal","image":"","title":"Best Support Ever","caption":"","content":"<p>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lock_alt","icon-style":"normal","image":"","title":"Very SECURE CODE","caption":"","content":"<p>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"55px","bottom":"60px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"12","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","skin":"Dark","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"Sections and wrapper can be manage easily","title":"With brand new <br/> goodlayers page builder","content":"","button-text":"","button-link":"#","button-link-target":"_self","text-align":"left","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me.</p>","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"18px","right":"40px","bottom":"18px","left":"40px","settings":"unlink"},"border-radius":"44px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"9","thumbnail-size":"full","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","portfolio-style":"grid","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon","column-size":"20","layout":"carousel","carousel-navigation":"navigation","excerpt":"none","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"Recent Works","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"150px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1184","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"fa fa-line-chart","text-align":"center","icon-size":"90px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","title":"We are the best in financial industry","caption":" Not only great theme but we also provide the best support.","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#ea6b2d","caption-spaces":"25px","padding-bottom":"55px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"17px","right":"36px","bottom":"17px","left":"36px","settings":"unlink"},"border-radius":"29px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#494949","text-hover-color":"#494949","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey Orange","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"99","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"35px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"599","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"35px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16800","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"35px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"disable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"35px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1194","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.4","overflow":"visible","skin":"Dark","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_desktop","icon-style":"normal","image":"","title":"Free Sliders Included","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_genius","icon-style":"normal","image":"","title":"Super Powerful Admin Panel","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_compass_alt","icon-style":"normal","image":"","title":"MAJOR BROWSERS SUPPORTED","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_star","icon-style":"normal","image":"","title":"CUSTOMERS LOVE US","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SUPERIOR SUPPORTS","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ea6b2d","icon-background":"","title-size":"15px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"15px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"40px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"40px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"Thomas Rhudus","position":"9-5 Worker","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite.","image":"1196","image-img":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/testimonial-1.jpg"},{"title":"Jennet Coles","position":"Business Owner","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy.","image":"1198","image-img":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/testimonial-3.jpg"},{"title":"Roberto Carlos","position":"Investor","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite.","image":"1197","image-img":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/testimonial-2.jpg"}],"column":"1","carousel":"enable","carousel-navigation":"navigation","style":"left","title-size":"28px","caption-size":"16px","content-size":"15px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"400px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"image","background-extending":"right","background-color":"","background-image":"1201","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","thumbnail-size":"full","orderby":"date","order":"desc","pagination":"none","blog-style":"blog-column-with-frame","show-thumbnail":"disable","column-size":"20","layout":"carousel","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"30","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"center","title":"Recent News","caption":"Get updates from us","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"18px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"60px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Read More","button-link":"http://demo.goodlayers.com/infinite/blog","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"18px","right":"42px","bottom":"18px","left":"42px","settings":"unlink"},"border-radius":"31px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#ea8654","background-hover-color":"","background-gradient-color":"#ea6b2d","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Dark Orange","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1224","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"65px","bottom":"65px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Dark Orange","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"Are you ready to be amazed?","title":"Our new framework","content":"","button-text":"","button-link":"#","button-link-target":"_self","text-align":"center","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","type":"small-center","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>We had spent a lot of time to study, gather information and finally we come up with the best page builder in the world. It\'s the most powerful with many options and it has everything you need. You can push them into 3 modes, block mode, preview mode and live mode(frontend builder). Now with this tool, your imagination will be limitless.</p>","text-align":"center","font-size":"15px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1540px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"15px","right":"30px","bottom":"30px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"gallery","value":{"id":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1228","thumbnail":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/banner-1-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1229","thumbnail":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/banner-2-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1230","thumbnail":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/banner-3-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1231","thumbnail":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/banner-4-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1232","thumbnail":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/banner-5-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1233","thumbnail":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/banner-6-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1234","thumbnail":"http://demo.goodlayers.com/infinite/homepages/finance/wp-content/uploads/sites/3/2016/05/banner-7-150x150.jpg"}],"style":"grid","overlay":"none","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"bullet","grid-slider-navigation":"bullet","thumbnail-size":"full","padding-bottom":"30px"}}]}]';
				case 'home-fitness':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#232323","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"30px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"left","background-color":"#e54444","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"12","title":"You have to expect things of yourself before<br/> you can do them.","caption":"","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly.","read-more-text":"","read-more-link":"#","style":"left_icon-left-title","icon-size":"30px","media-margin":{"top":"13px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"19px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"25px","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"12px","right":"25px","bottom":"12px","left":"25px","settings":"unlink"},"border-radius":"0px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"right","background-color":"#e54444","background-image":"16","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.3","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-bolt","icon-style":"normal","image":"12","title":"If you train hard, you\'ll not only be hard, you\'ll<br/>be hard to beats.","caption":"","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly.","read-more-text":"","read-more-link":"#","style":"left_icon-left-title","icon-size":"42px","media-margin":{"top":"13px","right":"7px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"19px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"25px","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"12px","right":"25px","bottom":"12px","left":"25px","settings":"unlink"},"border-radius":"0px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Red Divider","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"Are you ready to be amazed?","title":"Our new framework","content":"We had spent a lot of time to study, gather information and finally we come up with the best page builder in the world. It\'s the most powerful with many options and it has everything you need. You can push them into 3 modes, block mode, preview mode and live mode(frontend builder). Now with this tool, your imagination will be limitless.","button-text":"","button-link":"#","button-link-target":"_self","text-align":"center","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"20","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"270px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"flipbox","value":{"id":"","icon":"","title":"","caption":"","content":"","text-align":"center","icon-color":"","title-color":"","caption-color":"","content-color":"","icon-size":"35px","title-size":"22px","caption-size":"15px","content-size":"15px","content-padding":{"top":"220px","right":"40px","bottom":"0px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-color":"#0a0a0a","background-image":"21","background-opacity":"1","border-type":"none","border-color":"","border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-icon":"","b-title":"WORLD OF FITNESS","b-caption":"","b-content":"far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgro.","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-caption-color":"","b-content-color":"#cecece","b-icon-size":"35px","b-title-size":"18px","b-caption-size":"13px","b-content-padding":{"top":"10px","right":"40px","bottom":"35px","left":"40px","settings":"unlink"},"b-content-size":"13px","b-background-color":"#0a0a0a","b-background-image":"21","b-background-opacity":"0.4","b-border-type":"none","b-border-color":"","b-border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"flipbox","value":{"id":"","icon":"","title":"","caption":"","content":"","text-align":"center","icon-color":"","title-color":"","caption-color":"","content-color":"","icon-size":"35px","title-size":"22px","caption-size":"15px","content-size":"15px","content-padding":{"top":"220px","right":"40px","bottom":"0px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-color":"#0a0a0a","background-image":"23","background-opacity":"1","border-type":"none","border-color":"","border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-icon":"","b-title":"100 MACHINES","b-caption":"","b-content":"far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgro.","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-caption-color":"","b-content-color":"#cecece","b-icon-size":"35px","b-title-size":"18px","b-caption-size":"13px","b-content-padding":{"top":"10px","right":"40px","bottom":"35px","left":"40px","settings":"unlink"},"b-content-size":"13px","b-background-color":"#0a0a0a","b-background-image":"23","b-background-opacity":"0.4","b-border-type":"none","b-border-color":"","b-border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"flipbox","value":{"id":"","icon":"","title":"","caption":"","content":"","text-align":"center","icon-color":"","title-color":"","caption-color":"","content-color":"","icon-size":"35px","title-size":"22px","caption-size":"15px","content-size":"15px","content-padding":{"top":"220px","right":"40px","bottom":"0px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-color":"#0a0a0a","background-image":"22","background-opacity":"1","border-type":"none","border-color":"","border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-icon":"","b-title":"BEST TRAINERS","b-caption":"","b-content":"far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgro.","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-caption-color":"","b-content-color":"#cecece","b-icon-size":"35px","b-title-size":"18px","b-caption-size":"13px","b-content-padding":{"top":"10px","right":"40px","bottom":"35px","left":"40px","settings":"unlink"},"b-content-size":"13px","b-background-color":"#0a0a0a","b-background-image":"22","b-background-opacity":"0.4","b-border-type":"none","b-border-color":"","b-border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"45px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Red Divider","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"20","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"270px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"#222222","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"White Text","border-type":"outer-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#424141","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"29","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"3000","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"7px"}},{"template":"element","type":"title","value":{"id":"","title":"SQM.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"14px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#e54444","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"White Text","border-type":"outer-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#424141","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"30","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"320+","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"7px"}},{"template":"element","type":"title","value":{"id":"","title":"Machines","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"14px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#e54444","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"White Text","border-type":"outer-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#424141","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"31","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"32","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"7px"}},{"template":"element","type":"title","value":{"id":"","title":"Trainers","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"14px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#e54444","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"White Text","border-type":"outer-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#424141","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"32","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"50","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"7px"}},{"template":"element","type":"title","value":{"id":"","title":"Metres Pool","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"14px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#e54444","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#424141","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"33","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"100","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"7px"}},{"template":"element","type":"title","value":{"id":"","title":"M. Track","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"14px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#e54444","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"300px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"image","background-color":"","background-image":"39","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Dark Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Get out of your","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"right","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"57px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","title":"Comfort Zone","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"right","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"99px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#e54444","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Hey, no one ever said getting an awesome, healthy body was easy.<br />\nthat\'s why the word work is in working out.</p>\n","text-align":"right","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"image","background-color":"","background-image":"44","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"1","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":null,"tag":null,"num-fetch":"7","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"15","layout":"carousel","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"center","title":"Opening courses","caption":"","read-more-text":"More Courses","read-more-link":"#","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"#e54444","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"image","background-color":"","background-image":"44","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"1","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"video","value":{"id":"","video-type":"vimeo","video-url":"https://vimeo.com/130966725","video-url-mp4":"","video-url-webm":"","video-url-ogg":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"Are you ready to be amazed?","title":"Video introduction","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarks grove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with.","button-text":"","button-link":"#","button-link-target":"_self","text-align":"left","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#e54444","border-hover-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"#e54444","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"White Text 2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SAVE A LOT OF YOUR TIME","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"23px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#e54444","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-comments-o","icon-style":"normal","image":"","title":"Great Community","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"23px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#cf3d3d","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-comments-o","icon-style":"normal","image":"1172","title":"Personal Trainer","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"23px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#af3131","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"90px","bottom":"50px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#202020","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"White Text 2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"At infinite fitness, we provide you<br/> the best sport environment","caption":"Sections and wrapper can be manage easily","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"41px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"50px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.</p>\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn\'t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove.</p>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","title":"Meet our trainers","caption":"Our trainers are the best of the best. They have over ten years of experiences in this field.","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"43px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"3px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"20px","padding-bottom":"60px"}},{"template":"element","type":"personnel","value":{"id":"","category":null,"num-fetch":"9","thumbnail-size":"full","orderby":"date","disable-link":"enable","order":"desc","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"center","personnel-style":"grid","enable-position":"enable","enable-divider":"enable","enable-excerpt":"disable","enable-social-shortcode":"enable","column-size":"3","carousel":"disable","carousel-navigation":"navigation","padding-bottom":"40px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1195","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Pricing plans","caption":"Go with your right one","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"48px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"70px"}}]},{"template":"element","type":"price-table","value":{"id":"","tabs":[{"icon":"fa fa-star-o","image":"1304","image-img":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/price-icon-1.png","title":"Professional plan","caption":"Price default caption","price":"299","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"},{"icon":"fa fa-star-o","image":"1305","image-img":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/price-icon-2.png","title":"Sporter plan","caption":"Price default caption","price":"129","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"enable"},{"icon":"fa fa-star-o","image":"1306","image-img":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/price-icon-3.png","title":"Basic plan","caption":"Price default caption","price":"99","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","padding-bottom":"30px","header-color":"","header-gradient-color":"","icon-color":"","title-color":"","caption-color":"","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"","button-background-gradient-color":"","a-header-color":"#e54747","a-header-gradient-color":"#e56464","a-icon-color":"","a-title-color":"","a-caption-color":"#e5c7c7","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"#e54747","a-button-background-gradient-color":"#e55959"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"700px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"html5-video","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/fitness-video-bg.mp4","background-video-url-webm":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/fitness-video-bg.webm","background-video-url-ogg":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/fitness-video-bg.ogg","background-video-image":"1207","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"John Smith","position":"9-5 Worker","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","image":"1214","image-img":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/testimonial-1.jpg"},{"title":"Jennet Cole","position":"Fashionist","content":"Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no con.","image":"1213","image-img":"http://demo.goodlayers.com/infinite/homepages/fitness/wp-content/uploads/sites/4/2016/05/testimonial-2.jpg"}],"column":"1","carousel":"enable","carousel-navigation":"navigation","style":"center","title-size":"41px","caption-size":"16px","content-size":"19px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","padding-bottom":"30px"}}]}]';
				case 'home-gardener':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"65px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1336","thumbnail-size":"Service Thumbnail","link-to":"none","custom-image":"","video-url":"","page-id":"1323","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Garden Design","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"23px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>\n<p><a href=\"#\">Read More</a></p>\n","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"65px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1338","thumbnail-size":"Service Thumbnail","link-to":"none","custom-image":"","video-url":"","page-id":"1323","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Havesting","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"23px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>\n<p><a href=\"#\">Read More</a></p>\n","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"65px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1337","thumbnail-size":"Service Thumbnail","link-to":"none","custom-image":"","video-url":"","page-id":"1323","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Lawn & Garden Care","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"23px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone.</p>\n<p><a href=\"#\">Read More</a></p>\n","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"65px","right":"0px","bottom":"35px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"right","background-color":"#f7f7f7","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Working Time","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"30px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"opening-hours"}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1342","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-21","pattern-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Story About Us","caption":"Are you ready to be amazed?","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"47px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"column-service","value":{"id":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"","title":"","caption":"","content":"We had spent a lot of time to study, gather information and finally we come up with the best page builder in the world. It\'s the most powerful with many options and it has everything you need. You can push them into 3 modes, block mode, preview mode and live mode(frontend builder). Now with this tool, your imagination will be limitless. Vestibulum id ligula porta felis euismod semper. Donec sed odio dui. Etiam porta sem malesuada magna mollis euismod.","read-more-text":"More About Us","read-more-link":"#","style":"left_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","image":"1344","thumbnail-size":"About Thumbnail","link-to":"none","custom-image":"","video-url":"","page-id":"1323","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","image":"1345","thumbnail-size":"About Thumbnail","link-to":"none","custom-image":"","video-url":"","page-id":"1323","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"garden-counter","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1351","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","skin":"Counter","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"49px","bottom-text-size":"25px","bottom-text-transform":"none","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"588","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"49px","bottom-text-size":"25px","bottom-text-transform":"none","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16800","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"49px","bottom-text-size":"25px","bottom-text-transform":"none","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"disable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"49px","bottom-text-size":"25px","bottom-text-transform":"none","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"75px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"Green Divider","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Works","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"40px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"80px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet<br />\nmornings of spring which I enjoy with my whole heart.</p>\n","text-align":"center","font-size":"16px","padding-bottom":"5px"}},{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"6","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon","column-size":"20","layout":"carousel","carousel-navigation":"bullet","excerpt":"specify-number","excerpt-number":"29","show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"enable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"450px","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"60px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Why Choose Us","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"46px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"78px","padding-bottom":"80px"}},{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1365","title":"Founded by real gardener","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"23px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1366","title":"High labor skills","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"23px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"1371","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","skin":"","border-type":"inner-border","border-pre-spaces":{"top":"30px","right":"30px","bottom":"30px","left":"30px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"880px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Green Divider","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Testimonial","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"40px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"80px","padding-bottom":"60px"}},{"template":"element","type":"testimonial","value":{"id":"","title":"","caption":"","tabs":[{"title":"Sarah Taylor ","position":"House Wife","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence.","image":"1375","image-img":"http://demo.goodlayers.com/infinite/homepages/gardener/wp-content/uploads/sites/10/2016/05/testimonail-1.jpg"},{"title":"John Doe","position":"Gardener","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence.","image":"1376","image-img":"http://demo.goodlayers.com/infinite/homepages/gardener/wp-content/uploads/sites/10/2016/05/testimonial-2.jpg"}],"column":"1","carousel":"enable","carousel-navigation":"bullet","style":"center","title-size":"28px","caption-size":"16px","content-size":"17px","title-color":"","caption-color":"","quote-color":"#abce2d","content-color":"","name-color":"","position-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"144px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"30px","left":"30px","settings":"unlink"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1395","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Recent News","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"52px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"42px"}},{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","thumbnail-size":"Blog Thumbnail","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-column-with-frame","show-thumbnail":"enable","column-size":"20","layout":"carousel","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"28","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"#","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"620px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1379","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Leave us your info ","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"56px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"32px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"0px","padding-bottom":"10px"}},{"template":"element","type":"title","value":{"id":"","title":"and we will get back to you.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#accf2f","title-link-hover-color":"","caption-font-size":"32px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"50px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]}]';
				case 'home-half-box':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#e8e8e8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"410px","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"210px","right":"0px","bottom":"210px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"0px","settings":"unlink"},"skin":"grey"},"items":[{"template":"element","type":"title","value":{"id":"","title":"01.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"140px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#b2b2b2","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"title","value":{"id":"","title":"New Framework","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#313131","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"1303","icon":"fa fa-film","style":"dashed","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1310","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"22px","right":"22px","bottom":"22px","left":"22px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#309cea","border-style":"solid","padding":{"top":"80px","right":"90px","bottom":"80px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"light"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"Sections and wrapper can be manage easily","title":"With brand new  framework","content":"","button-text":"","button-link":"#","button-link-target":"_self","text-align":"center","caption-position":"above-title","title-size":"44px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.","text-align":"center","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1311","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"inner-border","border-pre-spaces":{"top":"22px","right":"22px","bottom":"22px","left":"22px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#309cea","border-style":"solid","padding":{"top":"80px","right":"90px","bottom":"80px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"0px","settings":"unlink"},"skin":"light"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"We include so many options in new framework","title":"changing color is easy","content":"","button-text":"","button-link":"#","button-link-target":"_self","text-align":"center","caption-position":"above-title","title-size":"44px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.","text-align":"center","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"410px","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"210px","right":"0px","bottom":"210px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"grey"},"items":[{"template":"element","type":"title","value":{"id":"","title":"02.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"140px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#b2b2b2","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"title","value":{"id":"","title":"Huge Options","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#313131","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"1303","icon":"fa fa-film","style":"dashed","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"410px","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"210px","right":"0px","bottom":"210px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"30px","left":"0px","settings":"unlink"},"skin":"grey"},"items":[{"template":"element","type":"title","value":{"id":"","title":"03.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"140px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#b2b2b2","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"title","value":{"id":"","title":"Easy To Manage","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#313131","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"1303","icon":"fa fa-film","style":"dashed","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1312","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"22px","right":"22px","bottom":"22px","left":"22px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#309cea","border-style":"solid","padding":{"top":"80px","right":"90px","bottom":"80px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"15px","settings":"unlink"},"skin":"light"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"We create whole new structure","title":"To make it the easiest to use","content":"","button-text":"","button-link":"#","button-link-target":"_self","text-align":"center","caption-position":"above-title","title-size":"44px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.","text-align":"center","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":null,"tag":null,"num-fetch":"9","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","layout":"carousel","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"center","title":"Recent works","caption":" What we\'ve done","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"30px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"588","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16800","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"disable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"105px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1331","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"light","border-type":"inner-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SAVE A LOT OF YOUR TIME","caption":"Question Marks and deviou.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"35px","media-margin":{"top":"5px","right":"35px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"14px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_check_alt2","icon-style":"normal","image":"","title":"Choose the right theme","caption":"Question Marks and deviou.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"35px","media-margin":{"top":"5px","right":"35px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"14px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_genius","icon-style":"normal","image":"","title":"Wise And Genius","caption":"Question Marks and deviou.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"35px","media-margin":{"top":"5px","right":"35px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"14px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lock-open_alt","icon-style":"normal","image":"","title":"Unlock your creativities","caption":"Question Marks and deviou.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"35px","media-margin":{"top":"5px","right":"35px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"14px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_mobile","icon-style":"normal","image":"","title":"Fully Responsive","caption":"Question Marks and deviou.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"35px","media-margin":{"top":"5px","right":"35px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"14px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-comments-o","icon-style":"normal","image":"","title":"Dedicated Support","caption":"Question Marks and deviou.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"35px","media-margin":{"top":"5px","right":"35px","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"2px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"14px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"110px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"personnel","value":{"id":"","category":null,"num-fetch":"9","thumbnail-size":"full","orderby":"date","disable-link":"enable","order":"desc","title-align":"center","title":"Meet Our Team","caption":"We have many people with great design skills","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"center","enable-position":"enable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"3","carousel":"disable","carousel-navigation":"navigation","padding-bottom":"10px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"20px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"90px","bottom":"50px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"18px","bottom":"36px","left":"0px","settings":"unlink"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-4","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1341","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"light","border-type":"inner-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"4","prepend-sticky":"enable","thumbnail-size":"full","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-list-center","show-thumbnail":"enable","column-size":"20","layout":"fitrows","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","meta-option":["date","author","category"],"show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"19px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"410px","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-4","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"210px","right":"0px","bottom":"210px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"36px","left":"18px","settings":"unlink"},"skin":"grey"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Blog","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"140px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#b2b2b2","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","title":"Get updates","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"#313131","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"890px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"40px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"John Doe","position":"CEO, Apple","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly ","image":"1347","image-img":"http://demo.goodlayers.com/infinite/homepages/halfbox/wp-content/uploads/sites/8/2016/05/personnel-sq-2.jpg"},{"title":"Ricardo Smith","position":"CTO, Yahoo Co.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly ","image":"1348","image-img":"http://demo.goodlayers.com/infinite/homepages/halfbox/wp-content/uploads/sites/8/2016/05/personnel-sq-3.jpg"},{"title":"Paul Manny","position":"Senior Engineer","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly ","image":"1349","image-img":"http://demo.goodlayers.com/infinite/homepages/halfbox/wp-content/uploads/sites/8/2016/05/personnel-sq-4.jpg"}],"column":"1","carousel":"enable","carousel-navigation":"navigation","style":"center","title-size":"41px","caption-size":"16px","content-size":"17px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","padding-bottom":"30px"}}]}]';
				case 'home-high-rise': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1358","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.4","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"1360","background-image-style":"repeat-x","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"300px","hide-this-wrapper-in":"mobile","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1337","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.15","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"60px","bottom":"10px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1352","title":"Convenience with public transport","caption":"","content":"De North is designed espicially for living in the middle of downtown. Vestibulum id ligula porta felis euismod semper. Nulla vitae elit libero, a pharetra augue. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Vivamus sagittis lacus vel augue laoreet rutrum.","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"22px","title-font-weight":"","title-letter-spacing":"1.5px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"16px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"60px","bottom":"10px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1354","title":"SURROUNDED BY FAMOUS RESTAURANTS","caption":"","content":"De North is designed espicially for living in the middle of downtown. Vestibulum id ligula porta felis euismod semper. Nulla vitae elit libero, a pharetra augue. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Vivamus sagittis lacus vel augue laoreet rutrum.","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"22px","title-font-weight":"","title-letter-spacing":"1.5px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"16px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"300px","hide-this-wrapper-in":"mobile","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1348","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.15","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"300px","hide-this-wrapper-in":"mobile","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1366","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"60px","bottom":"10px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1354","title":"Shopping places are next to you","caption":"","content":"De North is designed espicially for living in the middle of downtown. Vestibulum id ligula porta felis euismod semper. Nulla vitae elit libero, a pharetra augue. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Vivamus sagittis lacus vel augue laoreet rutrum.","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"22px","title-font-weight":"","title-letter-spacing":"1.5px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"16px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"75px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1437","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Floor plans","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"30px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#b1886a","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"0px","padding-bottom":"40px"}},{"template":"element","type":"tab","value":{"id":"","tabs":[{"title":"Type A","content":"<p> </p>\n[gdlr_core_row]\n\n[gdlr_core_column size=\"1/2\"]\n[gallery ids=\"1440,1444,1446\" orderby=\"date\" source=\"gdlr-core\" style=\"slider\" slider-navigation=\"bullet\"][/gdlr_core_column]\n\n[gdlr_core_column size=\"1/2\"]\n[gdlr_core_title title=\"Room Detail\" caption=\"\" title-font-size=\"21px\" title-color=\"#b1886a\"  padding-bottom=\"5px\"]\n[gdlr_core_port_info2]\n[gdlr_core_tab title=\"Size\" ]50 sqm.[/gdlr_core_tab]\n[gdlr_core_tab title=\"Outdoor Space\" ]1.4 sqm.[/gdlr_core_tab]\n[gdlr_core_tab title=\"Bed Room\" ]1[/gdlr_core_tab]\n[gdlr_core_tab title=\"Rest Room\" ]1[/gdlr_core_tab]\n[/gdlr_core_port_info2] [gdlr_core_space height=\"30px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Maecenas faucibus mollis interdum. Praesent commodo cursus magvna, vel scelerisque nisl consectetur et. Maecenas faucibus mollis interdum. \n\n[/gdlr_core_column]\n\n[/gdlr_core_row]"},{"title":"Type B","content":"<p> </p>\n[gdlr_core_row]\n\n[gdlr_core_column size=\"1/2\"]\n[gallery ids=\"1441,1445,1447\" orderby=\"date\" source=\"gdlr-core\" style=\"slider\" slider-navigation=\"bullet\"][/gdlr_core_column]\n\n[gdlr_core_column size=\"1/2\"]\n[gdlr_core_title title=\"Room Detail\" caption=\"\" title-font-size=\"21px\" title-color=\"#b1886a\"  padding-bottom=\"5px\"]\n[gdlr_core_port_info2]\n[gdlr_core_tab title=\"Size\" ]80 sqm.[/gdlr_core_tab]\n[gdlr_core_tab title=\"Outdoor Space\" ]3 sqm.[/gdlr_core_tab]\n[gdlr_core_tab title=\"Bed Rooms\" ]2[/gdlr_core_tab]\n[gdlr_core_tab title=\"Rest Room\" ]1[/gdlr_core_tab]\n[/gdlr_core_port_info2] [gdlr_core_space height=\"30px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Maecenas faucibus mollis interdum. Praesent commodo cursus magvna, vel scelerisque nisl consectetur et. Maecenas faucibus mollis interdum. \n\n[/gdlr_core_column]\n\n[/gdlr_core_row]"},{"title":"Type C","content":"<p> </p>\n[gdlr_core_row]\n\n[gdlr_core_column size=\"1/2\"]\n[gallery ids=\"1442,1443,1446\" orderby=\"date\" source=\"gdlr-core\" style=\"slider\" slider-navigation=\"bullet\"][/gdlr_core_column]\n\n[gdlr_core_column size=\"1/2\"]\n[gdlr_core_title title=\"Room Detail\" caption=\"\" title-font-size=\"21px\" title-color=\"#b1886a\"  padding-bottom=\"5px\"]\n[gdlr_core_port_info2]\n[gdlr_core_tab title=\"Size\" ]135 sqm.[/gdlr_core_tab]\n[gdlr_core_tab title=\"Outdoor Space\" ]2 sqm.[/gdlr_core_tab]\n[gdlr_core_tab title=\"Bed Rooms\" ]3[/gdlr_core_tab]\n[gdlr_core_tab title=\"Rest Room\" ]2[/gdlr_core_tab]\n[/gdlr_core_port_info2] [gdlr_core_space height=\"30px\"]  Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Maecenas faucibus mollis interdum. Praesent commodo cursus magvna, vel scelerisque nisl consectetur et. Maecenas faucibus mollis interdum. \n\n[/gdlr_core_column]\n\n[/gdlr_core_row]"}],"style":"style2-horizontal","align":"left","tab-title-color":"","tab-title-active-color":"","tab-title-background-color":"","tab-title-active-background-color":"","tab-title-border-color":"","tab-title-border-active-color":"","tab-content-color":"","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1370","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Project Gallery","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#b1886a","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"0px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"1372","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"190px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"gallery","value":{"id":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1341","thumbnail":"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/photodune-6012115-interior-of-luxury-lounge-room-m-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1340","thumbnail":"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/photodune-5878856-modern-bedroom-m-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1343","thumbnail":"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/photodune-9518092-ondominium-m-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1344","thumbnail":"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/photodune-13973003-penthouse-apartment-m-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"1247","custom-url":"","custom-link-target":"_self","id":"1342","thumbnail":"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/photodune-8148064-illuminated-concrete-wall-m-150x150.jpg"}],"pagination":"none","show-amount":"","pagination-style":"default","pagination-align":"default","style":"thumbnail","max-slider-height":"","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"3","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"inside-slider","grid-slider-navigation":"navigation","thumbnail-size":"Gallery Large","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1384","background-image-style":"cover","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Video Gallery","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#b1886a","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"0px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"1372","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"190px","padding-bottom":"90px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"feature-box","value":{"id":"","icon":"fa fa-file-movie-o","title":"","caption":"","content":"","link-to":"lb-video","custom-image":"","video-url":"https://vimeo.com/156097461","link-url":"#","link-target":"_self","text-align":"center","icon-color":"#ffffff","title-color":"","caption-color":"","content-color":"","icon-size":"35px","title-size":"22px","caption-size":"15px","content-size":"15px","content-padding":{"top":"95px","right":"40px","bottom":"45px","left":"40px","settings":"unlink"},"padding-bottom":"30px","sync-height":"height-2","centering-sync-height-content":"enable","background-color":"#262626","background-image":"1347","background-opacity":"0.8","border-type":"none","border-color":"","border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"feature-box","value":{"id":"","icon":"fa fa-file-movie-o","title":"","caption":"","content":"","link-to":"lb-video","custom-image":"","video-url":"https://vimeo.com/156097461","link-url":"#","link-target":"_self","text-align":"center","icon-color":"#ffffff","title-color":"","caption-color":"","content-color":"","icon-size":"35px","title-size":"22px","caption-size":"15px","content-size":"15px","content-padding":{"top":"95px","right":"40px","bottom":"45px","left":"40px","settings":"unlink"},"padding-bottom":"30px","sync-height":"height-2","centering-sync-height-content":"enable","background-color":"#262626","background-image":"1343","background-opacity":"0.8","border-type":"none","border-color":"","border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"feature-box","value":{"id":"","icon":"fa fa-file-movie-o","title":"","caption":"","content":"","link-to":"lb-video","custom-image":"","video-url":"https://vimeo.com/156097461","link-url":"#","link-target":"_self","text-align":"center","icon-color":"#ffffff","title-color":"","caption-color":"","content-color":"","icon-size":"35px","title-size":"22px","caption-size":"15px","content-size":"15px","content-padding":{"top":"95px","right":"40px","bottom":"45px","left":"40px","settings":"unlink"},"padding-bottom":"30px","sync-height":"height-2","centering-sync-height-content":"enable","background-color":"#262626","background-image":"1346","background-opacity":"0.8","border-type":"none","border-color":"","border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"button","value":{"id":"","button-text":"More Videos","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"18px","right":"35px","bottom":"18px","left":"35px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#b1886a","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1240px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1431","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"65px","bottom":"40px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"40px","bottom":"0px","left":"40px","settings":"unlink"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"1433","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"inner-border","border-pre-spaces":{"top":"29px","right":"29px","bottom":"29px","left":"29px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#b1825f","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Resort Facilities","caption":"De North is designed to make sure that you will have great qulity of life.","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#a58161","title-link-hover-color":"","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#a58161","caption-spaces":"0px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"1372","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"190px","padding-bottom":"90px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_row]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-1.png\" title=\"25M Swimming pool\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-2.png\" title=\"Fully Equipped Gym\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[/gdlr_core_row]</p>\n","text-align":"left","font-size":"","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_row]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-3.png\" title=\"Sunbath Area\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-4.png\" title=\"Pool Table\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[/gdlr_core_row]</p>\n","text-align":"left","font-size":"","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_row]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-5.png\" title=\"Luxury entrance Lobby\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-6.png\" title=\"rooftop Lounge\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[/gdlr_core_row]</p>\n","text-align":"left","font-size":"","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_row]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-7.png\" title=\"Shuttle service\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[gdlr_core_column size=\"1/2\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/highrise/wp-content/uploads/sites/13/2016/05/faci-icon-8.png\" title=\"Parking Lots\" title-size=\"18px\" style=\"left_icon-left\" title-letter-spacing=\"1px\"] Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Integer posuere erat a ante venenatis dapibus.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[/gdlr_core_row]</p>\n","text-align":"left","font-size":"","padding-bottom":"10px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"600px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1397","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Contact & Location","caption":"De North is right in the middle of downtown.","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#a58161","caption-spaces":"0px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"1372","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"190px","padding-bottom":"90px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-160px","right":"30px","bottom":"30px","left":"30px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"70px","bottom":"50px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#232937","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Brown Button","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Leave us your info ","caption":"and we will get back to you.","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#b1886a","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1411","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"15px","right":"40px","bottom":"1px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","sync-height":"height-location","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#586780","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Infinite Headquarter","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_icon icon=\"icon_pin_alt\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\"] 12 Main Street Pt. London  UK 92359</p>\n<p>[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\" ] 020 - 5534-5552</p>\n<p>[gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\" ] infiniteHQ@goodlayers.com</p>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"15px","right":"40px","bottom":"1px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-location","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#586780","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"De North Condomenium","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_icon icon=\"icon_pin_alt\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\"] 34 King Street Palace AVenger. London<br />\nUK 92359</p>\n<p>[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\" ] 020 - 5534-5533</p>\n<p>[gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\" ] DeNorthContact@goodlayers.com</p>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"15px","right":"40px","bottom":"1px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-location","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"0px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#586780","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"De North Sales Office","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_icon icon=\"icon_pin_alt\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\"] 543 Groven Area, Thombson Place Esplasio London UK 443343</p>\n<p>[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\" ] 020 - 5534-5563</p>\n<p>[gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"16px\" color=\"#d97a35\" margin-left=\"0px\" margin-right=\"12px\" ] DeNorthSales@goodlayers.com</p>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#242b37","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"social-network","value":{"id":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","text-align":"center","icon-size":"17px","icon-color":"#ffffff","with-text":"enable","text-size":"14px","icon-space":"43px","padding-bottom":"0px"}}]}]}]';
				case 'home-inagency':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"82px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Pink Divider"},"items":[{"template":"element","type":"title","value":{"id":"","title":"We are an award winning","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"37px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#232323","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","title":"Creative Agency","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"86px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#3b3b3b","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"80px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"1180px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"text","filterer-align":"left","pagination":"load-more","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","thumbnail-size":"Portfolio Thumbnail","layout":"masonry","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","overlay-color":"","overlay-opacity":"","portfolio-title-text-transform":"uppercase","padding-bottom":"0px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"790px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Pink Divider"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Clients","caption":"","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"28px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"82px","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f8f8f8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1466","thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-1-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1467","thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-2-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1468","thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-3-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1469","thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-4-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":1470,"thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-5-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":1471,"thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-6-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":1472,"thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-7-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":1473,"thumbnail":"http://demo.goodlayers.com/infinite/homepages/inagency/wp-content/uploads/sites/20/2016/05/banner-8-150x150.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"790px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Pink Divider"},"items":[{"template":"element","type":"title","value":{"id":"","title":"ABOUT US","caption":"","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"28px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"65px","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#2d2d2d","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"64px","right":"60px","bottom":"64px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Light"},"items":[{"template":"element","type":"text-box","value":{"id":"","content":"<p>45 Main Street Kington Ave. PH130 London UK<br />+45-2342-3452-33 <a href=\"_wp_link_placeholder\">IN@goodlayers.com</a></p>","text-align":"center","font-size":"15px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#353535","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"64px","right":"60px","bottom":"20px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Light"},"items":[{"template":"element","type":"social-network","value":{"id":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","text-align":"center","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#ffffff","icon-space":"28px","padding-bottom":"0px"}}]}]}]';
				case 'home-incorporate':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1371","title":"Very Secure Code","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"15px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"35px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1372","title":"SAVE A LOT OF YOUR TIME","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"15px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"35px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1373","title":"BEST SUPPORT EVER","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"15px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"35px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1374","title":"High quality System","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"15px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"35px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"540px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Works","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings.","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"20px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":null,"tag":null,"num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"15","thumbnail-size":"Frame Portfolio","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"17px","portfolio-hover-title-font-weight":"300","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","padding-bottom":"0px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1200px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"1385","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"70px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Light Purple"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1390","title":"Team Work Come First","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with mty whole heart.","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"18px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"45px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1391","title":"Great Logical Process","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with mty whole heart.","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"18px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"45px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1392","title":"Social Media","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with mty whole heart.","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"18px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"45px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"enable","background-type":"color","background-extending":"right","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"50px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1393","title":"Why Customers Love Us?","caption":"","content":"","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"30px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil.","text-align":"left","font-size":"18px","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"19px","right":"41px","bottom":"22px","left":"41px","settings":"unlink"},"border-radius":"29px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","border2-radius":"25px","button2-background":"gradient","button2-border":"disable","text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"11px","icon-size":"","button2-left-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"540px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet The Team","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings.","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"20px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":null,"num-fetch":"9","orderby":"date","order":"desc","text-align":"left","personnel-style":"modern-no-space","enable-position":"enable","disable-link":"disable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"4","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-navigation":"navigation","padding-bottom":"0px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"1411","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"5px","bottom":"50px","left":"105px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1394","title":"What We Can Do","caption":"","content":"","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"30px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-circle-o","icon-hover":"","title":"Far far away, behind the word moun","link-url":"","link-target":"_self"},{"icon":"fa fa-circle-o","icon-hover":"","title":"It is a paradisematic country, in which","link-url":"","link-target":"_self"},{"icon":"fa fa-circle-o","icon-hover":"","title":" Pityful a rethoric question ran","link-url":"","link-target":"_self"},{"icon":"fa fa-circle-o","icon-hover":"","title":"When she reached the first","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#b3b3f5","icon-background-color":"","content-color":"#b3b3f5","border-color":"","icon-size":"18px","content-size":"18px","list-bottom-margin":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.  Pityful a rethoric question ran over.","text-align":"left","font-size":"18px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"19px","right":"41px","bottom":"22px","left":"41px","settings":"unlink"},"border-radius":"29px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","text-size":"11px","icon-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"1416","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"750px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#232323","background-image":"1417","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1386","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"4000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"30px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1387","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"25","animation-time":"4000","suffix":"%","divider":"disable","bottom-text":"Anually Growth","top-icon-size":"30px","top-text-size":"16px","number-size":"30px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1388","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"2000","animation-time":"4000","suffix":"+","divider":"disable","bottom-text":"Employees","top-icon-size":"30px","top-text-size":"16px","number-size":"30px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"1389","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"5350","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Happy Customers","top-icon-size":"30px","top-text-size":"16px","number-size":"30px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"750px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"88px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"What Client Say","caption":"","tabs":[{"title":"Jeniffer Gordon","position":"Graphic Designer","content":"A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful.","image":"1419","image-img":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/testimonial-1.jpg"},{"title":"John Smith","position":"Maketer","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.","image":"1420","image-img":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/testimonial-2.jpg"}],"style":"center","column":"1","enable-quote":"disable","carousel":"enable","carousel-autoslide":"disable","carousel-navigation":"navigation","title-size":"32px","title-text-transform":"none","title-letter-spacing":"0px","caption-size":"16px","content-size":"21px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","content-bottom-padding":"5px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1361","thumbnail":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/banner-1-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1362","thumbnail":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/banner-2-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1421","thumbnail":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/banner-6-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1363","thumbnail":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/banner-3-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1364","thumbnail":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/banner-4-150x150.jpg"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":"1365","thumbnail":"http://demo.goodlayers.com/infinite/homepages/incorporate/wp-content/uploads/sites/22/2016/05/banner-5-150x150.jpg"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"disable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"540px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent News","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings.","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"20px","padding-bottom":"30px"}}]},{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-alignment":"left","blog-list-with-frame":"disable","show-thumbnail":"enable","thumbnail-size":"Frame Blog","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"none","item-size":"small","excerpt":"specify-number","excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","author","category"],"show-read-more":"enable","blog-title-font-size":"20px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","padding-bottom":"60px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View The Blog","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/infinite/blog","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"19px","right":"41px","bottom":"22px","left":"41px","settings":"unlink"},"border-radius":"29px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","border2-radius":"25px","button2-background":"gradient","button2-border":"disable","text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"11px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]}]';
				case 'home-mechanic': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"70px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1299","title":"Best Mechanics","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1300","title":"Time Reliable","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"1301","title":"High Quality","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"1px","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"47px","right":"0px","bottom":"36px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f7c02e","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Yellow","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","title":"Are you interested in our services now?","caption":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","title-size":"23px","title-font-weight":"","title-letter-spacing":"1px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"75px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1305","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Services","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"enable","side-border-size":"3px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"#2b5176","heading-tag":"h3","title-font-size":"40px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light Service","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"9","thumbnail-size":"full","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","enable-portfolio-tag":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-icon","column-size":"20","layout":"fitrows","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"28","show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Yellow","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"button","value":{"id":"","button-text":"More Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"fa fa-automobile","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"17px","right":"35px","bottom":"17px","left":"35px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#333333","text-hover-color":"#333333","background-color":"#f7c02e","background-hover-color":"#f7c02e","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"mechanic-counter","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1326","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Get your car checked","caption":"Before it\'s too late","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"1429","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"44px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#f7c02e","title-link-hover-color":"","caption-font-size":"44px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"9200","suffix":"","divider":"disable","bottom-text":"Cars Checked","top-icon-size":"30px","top-text-size":"16px","number-size":"60px","bottom-text-size":"17px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"30","suffix":"","divider":"disable","bottom-text":"Mechanics","top-icon-size":"30px","top-text-size":"16px","number-size":"60px","bottom-text-size":"17px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16800","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"60px","bottom-text-size":"17px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"99","suffix":"%","divider":"disable","bottom-text":"Satisfactions","top-icon-size":"30px","top-text-size":"16px","number-size":"60px","bottom-text-size":"17px","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"85px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Recent News","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#002e5b","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"3","prepend-sticky":"enable","thumbnail-size":"full","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-widget","show-thumbnail":"enable","column-size":"20","layout":"fitrows","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","meta-option":["date","author","category"],"show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"28px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"Paul Smith","position":"Writer, Car Mags","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country.","image":"1331","image-img":"http://demo.goodlayers.com/infinite/homepages/mechanic/wp-content/uploads/sites/7/2016/05/personnel-sq-2.jpg"},{"title":"Ricardo Johnson","position":"Car Designer","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country.","image":"1332","image-img":"http://demo.goodlayers.com/infinite/homepages/mechanic/wp-content/uploads/sites/7/2016/05/personnel-sq-3.jpg"}],"column":"1","carousel":"enable","carousel-navigation":"navigation","style":"left","title-size":"28px","caption-size":"16px","content-size":"17px","title-color":"#002e5b","caption-color":"","quote-color":"#f7c02e","content-color":"#747474","name-color":"#002e5b","position-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"45px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"gallery","value":{"id":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","id":"1352","thumbnail":"http://demo.goodlayers.com/infinite/homepages/mechanic/wp-content/uploads/sites/7/2016/05/banner-1-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","id":"1353","thumbnail":"http://demo.goodlayers.com/infinite/homepages/mechanic/wp-content/uploads/sites/7/2016/05/banner-2-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","id":"1354","thumbnail":"http://demo.goodlayers.com/infinite/homepages/mechanic/wp-content/uploads/sites/7/2016/05/banner-3-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","id":"1355","thumbnail":"http://demo.goodlayers.com/infinite/homepages/mechanic/wp-content/uploads/sites/7/2016/05/banner-4-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self","id":"1356","thumbnail":"http://demo.goodlayers.com/infinite/homepages/mechanic/wp-content/uploads/sites/7/2016/05/banner-5-150x150.png"}],"style":"grid","overlay":"none","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","grid-slider-navigation":"bullet","thumbnail-size":"full","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"125px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1360","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Garage Have With Only Skilful Guys.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"41px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","title":"You can 100% trust in us.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"39px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#f7c02e","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"Team","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Team","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"41px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#002e5b","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","type":"small-center","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"60px"}},{"template":"element","type":"personnel","value":{"id":"","category":"","num-fetch":"3","thumbnail-size":"Personnel Thumbnaul","orderby":"date","disable-link":"enable","order":"desc","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"left","enable-position":"enable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"3","carousel":"disable","carousel-navigation":"navigation","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"40px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"left","background-color":"#002e5b","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Head Quater - London","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"23px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"0px\" margin-right=\"12px\" ] 12 Main Street Pt. London  UK 92359<br />\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"12px\" ] 020 - 5534-5552 [gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"12px\" ] London@MechanicGDL.com</p>\n","text-align":"left","font-size":"","padding-bottom":"10px"}},{"template":"element","type":"divider"},{"template":"element","type":"title","value":{"id":"","title":"Liverpool","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"23px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"0px\" margin-right=\"12px\" ] 4 apt. Flawing Street. The Grand Avenue. Liverpool, UK 33342<br />\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"12px\" ] 020 - 5534-5563 [gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"12px\" ] Liverpool@MechanicGDL.com</p>\n","text-align":"left","font-size":"","padding-bottom":"10px"}},{"template":"element","type":"divider"},{"template":"element","type":"title","value":{"id":"","title":"Manchester","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"23px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"0px\" margin-right=\"12px\" ] 78 Anderson Park, Western Street Manchester UK 22352<br />\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"12px\" ] 020 - 5534-5552 [gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"12px\" ] Manchester@MechanicGDL.com</p>\n","text-align":"left","font-size":"","padding-bottom":"10px"}},{"template":"element","type":"divider"}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"right","background-color":"","background-image":"1383","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"70px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Leave us your info ","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"title","value":{"id":"","title":"and we will get back to you.","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#f7c02e","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1385","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]}]';
				case 'home-medical':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"52px","right":"35px","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#1080d0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"icon_error-circle_alt","text-align":"left","icon-size":"27px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Emergency Service","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"23px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","content":"[gdlr_core_icon icon=\"fa fa-phone\" size=\"22px\" color=\"#c5e7ff\" margin-left=\"\" margin-right=\"15px\" ] 11-2363-3456-2","text-align":"left","font-size":"25px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"12px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"#ffffff","background-color":"#202020","background-hover-color":"#202020","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"52px","right":"35px","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#1177c0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"icon_phone","text-align":"left","icon-size":"27px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Appointment","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"23px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"22px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic.","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Make an appointment","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"12px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"#ffffff","background-color":"#202020","background-hover-color":"#202020","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"35px","bottom":"45px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#0f6eb3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"icon_clock_alt","text-align":"left","icon-size":"27px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Opening hours","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"23px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"22px"}},{"template":"element","type":"text-box","value":{"id":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"opening-hours","value":{"id":"","tabs":[{"title":"Mon - Fri","time":"08:00 - 21:00","open":"enable"},{"title":"Sat - Sun","time":"09:00 - 20:00","open":"enable"}],"divider-style":"solid","day-text-color":"#ffffff","time-color":"#ffffff","close-color":"#ffffff","icon-color":"#ffffff","divider-color":"#74a0c1","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"1351","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}},{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"75px","right":"0px","bottom":"50px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"right","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Welcome to <span style=\"color: #1080d0;\">Infinite</span>","caption":"Medical Center","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"44px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#1f1f1f","title-link-hover-color":"","caption-font-size":"28px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#1080d0","caption-spaces":"0px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite.","text-align":"left","font-size":"","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","tabs":[{"icon":"fa fa-caret-right","icon-hover":"fa fa-medkit","title":"A wonderful serenity has taken possession"},{"icon":"fa fa-caret-right","icon-hover":"fa fa-medkit","title":"I throw myself down among the tall grass"},{"icon":"fa fa-caret-right","icon-hover":"fa fa-medkit","title":"I should be incapable of drawing "}],"icon-size":"16px","content-size":"15px","enable-divider":"disable","icon-background":"none","icon-color":"#1080d0","icon-background-color":"","content-color":"#1080d0","border-color":"","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"40px","bottom":"20px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Column Service","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"text-box","value":{"id":"","content":"<p>[gdlr_core_row]</p>\n<p>[gdlr_core_column size=\"1/4\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-1.png\" title=\"Cancer\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-5.png\" title=\"Children\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[gdlr_core_column size=\"1/4\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-2.png\" title=\"Heart\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-6.png\" title=\"Brain\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[gdlr_core_column size=\"1/4\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-3.png\" title=\"Surgery\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-7.png\" title=\"Bone\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[gdlr_core_column size=\"1/4\"]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-4.png\" title=\"Chest\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[gdlr_core_column_service media-type=\"image\" image=\"http://demo.goodlayers.com/infinite/homepages/medical/wp-content/uploads/sites/16/2016/06/service-icon-8.png\" media-margin=\"0px 0px 46px\" title=\"Eye Ent\" title-size=\"18px\" title-font-weight=\"800\" title-text-transform=\"none\" style=\"center_icon-top\" title-letter-spacing=\"0px\" padding=\"0px 30px;\" ] Maecenas fauci bus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum.<br />\n[/gdlr_core_column_service]<br />\n[/gdlr_core_column]</p>\n<p>[/gdlr_core_row]</p>\n","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"55px","bottom":"25px","left":"55px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1360","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","skin":"Blue Light2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1361","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"1326","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","title":"Departments","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"39px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"270px","padding-bottom":"10px"}},{"template":"element","type":"column-service","value":{"id":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"","title":"","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy.","read-more-text":"Read More","read-more-link":"#","style":"left_icon-top","icon-size":"30px","icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1378","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","skin":"Blue Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Important <span style=\"color: #30a8fe;\">Static</span>","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"45px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring<br />\nwhich I enjoy with my whole heart. I am alone</p>\n","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Counter","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"icon","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"2000","suffix":"K","divider":"disable","bottom-text":"Patients","top-icon-size":"50px","top-text-size":"16px","number-size":"49px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Counter","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"icon","top-icon":"fa fa-bed","top-text":"","prefix":"","start-number":"0","end-number":"320","suffix":"","divider":"disable","bottom-text":"Hospital beds","top-icon-size":"50px","top-text-size":"16px","number-size":"49px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Counter","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"icon","top-icon":"fa fa-stethoscope","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"","divider":"disable","bottom-text":"Doctors","top-icon-size":"50px","top-text-size":"16px","number-size":"49px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Counter","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"1382","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"1326","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"35px"}},{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"45","suffix":"","divider":"disable","bottom-text":"Machines","top-icon-size":"50px","top-text-size":"16px","number-size":"49px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"10px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Personnel","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"personnel","value":{"id":"","category":"","num-fetch":"9","thumbnail-size":"Personnel Thumb","orderby":"date","disable-link":"disable","order":"desc","title-align":"left","title":"Meet <span style=\"color: #1080d0 ;\">Doctors</span>","caption":"Who works with us?","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"45px","caption-size":"19px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"left","personnel-style":"grid-no-space","enable-position":"enable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"3","carousel":"enable","carousel-navigation":"navigation","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"70px","right":"65px","bottom":"70px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-4","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1385","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","skin":"Blue Light2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Video Tour On Medical Center ","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"33px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"530px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend.","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"12px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"#ffffff","background-color":"#202020","background-hover-color":"#202020","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-4","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#212121","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","b