<?php
require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

class BtpDelivery extends NXdb{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
       /**
	 * @var string Id to identify managed objects
	 */
	public $element = 'btp_delivery';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'btp_delivery';
	
	public $fk_const_site;
	public $fk_user;
	public $tva;
	public $dl_date;
	public $bc_num;
	public $bl_num;
	public $observation;
	public $fk_createdby;
	public $rows = array();
	public $now;
    public $rowid;
    public $id;
    public $libelle;
    public $type;

	
public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}
	public function create()
	{
 		dol_syslog(__METHOD__, LOG_DEBUG);
		// Clean parameters
		$this->fk_createdby 	    = $this->fk_createdby ? $this->db->escape($this->fk_createdby): null;
		$this->fk_user				= $this->fk_user ? $this->db->escape($this->fk_user): null;
		$this->bc_num 			    = $this->bc_num ? $this->db->escape($this->bc_num): null;
		$this->fk_const_site 	    = $this->fk_const_site ? $this->db->escape($this->fk_const_site): null;
		$this->bl_num			    = $this->bl_num ? $this->db->escape($this->bl_num): null;
		$this->dl_date 			    = $this->dl_date ? $this->db->escape($this->dl_date): null;
		$this->nbr_ref 			    = $this->nbr_ref ? $this->db->escape($this->nbr_ref): null;
		$this->tva 			        = $this->tva ? $this->db->escape($this->tva): 0;
		$this->observation 			= $this->observation ? $this->db->escape($this->observation): null;
		$this->type 			    = $this->type ? $this->db->escape($this->type): null;
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_createdby,fk_user,fk_const_site,bc_num,dl_date,bl_num,tva,observation,type,nbr_ref,created_at,updated_at) VALUES (';
		$sql .= ''.$this->fk_createdby.', '.$this->fk_user.','.$this->fk_const_site.',
		"'.$this->bc_num.'","'.$this->dl_date.'","'.$this->bl_num.'","'.$this->tva.'","'.$this->observation.'","'.$this->type.'","'.$this->nbr_ref.'","'.$this->now.'","'.$this->now.'")';
		$this->db->begin();
		$resql = $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			return -1;
		} else {
			$this->db->commit();
return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
		$obj 					 = $this->db->fetch_object($resql);
		$this->rowid 				 = $obj->rowid;
		$this->fk_createdby 			    = $obj->fk_createdby;
		$this->fk_user				= $obj->fk_user;
		$this->dl_date 			    = $obj->dl_date ;
		$this->fk_const_site 			    = $obj->fk_const_site ;
		$this->bc_num			= $obj->bc_num ;
		$this->bl_num			    = $obj->bl_num;
		$this->nbr_ref			    = $obj->nbr_ref ;
		$this->tva 			    = $obj->tva ;
		$this->type 			    = $obj->type ;$this->observation 			    = $obj->observation ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
		
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;
        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;
        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/achat/btp_delivery/index.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';
        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }

	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql.=',updated_at="'.$this->now.'"';
		$sql .= ' WHERE  rowid = ' . $id;
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	//search
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $id = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element;
		

		if (!empty($filter)) {
		$sql .= ' WHERE '. substr($filter, 4);
		}
	if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		$this->lines = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
     	$line->rowid 				 = $obj->rowid;
				$line->fk_user 			 = $obj->fk_user;
				$line->nbr_ref		 = $obj->nbr_ref;
				$line->fk_const_site	 = $obj->fk_const_site;
				$line->bl_num			 = $obj->bl_num;
				$line->dl_date			 = $obj->dl_date;
				$line->bc_num			 = $obj->bc_num;
				$line->tva			     = $obj->tva;
				$line->observation		 = $obj->observation;
				$line->fk_createdby 	 = $obj->fk_createdby;
				$line->type			     = $obj->type;
				$this->rows[] 		     = $line;
			}

			$this->db->free($resql);

			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
}
