<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/achat/btp_sales/class/BtpSales.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

$form     = new Form($db);
$sale 	  = new BtpSales($db);
$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$search_ref      		= GETPOST('search_ref');
$search_user      	    = GETPOST('search_user');
$search_supplier      	= GETPOST('search_supplier');
$action  = GETPOST('action', 'alpha');
$id 	                = GETPOST('id','int');
$search_const_site      = GETPOST('search_const_site');
$search_paidby      	= GETPOST('search_paidby');
$search_quote_num      	= GETPOST('search_quote_num');
$search_tva      	    = GETPOST('search_tva');
$search_obs      	    = GETPOST('search_obs');
$search_sdate           =GETPOST('search_sdate');
/////date
if (GETPOST('search_sdate')) {
        $search_sdate  =Tools::convertDateTo(GETPOST('search_sdate'), 'sql');}
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_user     			="";
	$search_supplier      		= "";
	$search_const_site    		= "";
	$search_paidby      		= "";
	$search_sdate 				= "";	
	$search_tva      			= "";
	$search_obs      			= "";
	$search_quote_num    		= "";
}
?>
<style type="text/css">
	#nomer,#s2id_search_supplier{    max-width: 160px;}
</style>
<?php
///verification des champs de recherche
$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = '". $db->escape((int)$search_ref) ."'\n" : "";
$filter .= (!empty($search_user) && $search_user!= -1) ? " AND fk_user = '".$db->escape((int)$search_user)."'\n" : "";
$filter .= (!empty($search_supplier) && $search_supplier != -1) ? " and  fk_supplier = '". $db->escape((int)$search_supplier) ."'\n" : "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND fk_const_site = '".$db->escape((int)$search_const_site)."'\n" : "";
$filter .= (!empty($search_paidby) && $search_paidby != -1) ? " and  paidby = '". $db->escape((int)$search_paidby) ."'\n" : "";
$filter .= (!empty($search_sdate) && $search_sdate != -1) ? " AND sdate = '".$db->escape($search_sdate)."'\n" : "";
$filter .= (!empty($search_quote_num) && $search_quote_num != -1) ? " and  quote_num = '". $db->escape($search_quote_num) ."'\n" : "";
$filter .= (!empty($search_tva) && $search_tva != -1) ? " AND tva = '".$db->escape((float)$search_tva)."'\n" : "";
$filter .= (!empty($search_obs) && $search_obs!= -1) ? " and  observation = '". $db->escape($search_obs) ."'\n" : "";
$getMarketList=$sale->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($getMarketList)  && $action == "xsl" ) {
$filename="Liste_Ventes.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/achat/btp_sales/tpl/vente_xsl.php';
 die();
 
}
?>
<style type="text/css">
	.fiche>table:first-child td, .fiche>table[summary] td{vertical-align: middle !important;}
</style>
<?php
$morecss = array();
$morejs  = array("/btp/js/btp.js");
llxHeader(array(), $langs->trans('ListOfsale'),'','','','',$morejs,$morecss,0,0);

if ($id > 0) {
	print_barre_liste($langs->trans("det_sale"), '', '', '', '', '', "", "", "", DOL_MAIN_URL_ROOT.'/btp/img/folder_icon.png',1);
	dol_fiche_head('', 'det_sale', $langs->trans("det_sale"), 0, '');

/////modification
	$sale->fetch($id);
	print '<table class="border" width="100%">';
	//ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
	print '<td colspan="2">'. $sale->rowid .'</td></tr>';
	//utilisateur
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("User").'</td>';
 	$fuser = new User($db);
	$fuser->fetch($sale->fk_user); 
	print '<td colspan="2">'; 
	print $fuser->getNomUrl(1,$sale->fk_user,$fuser->lastname.'  '.$fuser->firstname) ;
	print'</td></tr>';
	//chantier de construction
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site").'</td>';
	   $chantier=new ConstructionSite($db);
       $chantier->fetch($sale->fk_const_site);
	print '<td colspan="2">'. $chantier->getNomUrl(1,$sale->fk_const_site,$chantier->name,$chantier->market_id) .'</td></tr>';
    //fournisseur  
     $fourn = new Societe($db);
     $fourn->fetch($sale->fk_supplier);
   	 print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Supply").'</td>';
		print '<td colspan="2">'.$fourn->getNomUrl(1,$sale->fk_supplier,$fourn->name).'</td></tr>';
    	/////mode de paiement
		print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("paidby").'</td>';
		print '<td colspan="2">';
      $ptype  = new BtpSales($db);
      $labtype= $ptype->getPaymentType($sale->paidby); 
	        print $labtype;
	print '</td></tr>'; 
	//date   
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'.dol_print_date($sale->sdate,'day').'</td></tr>'; 
	//Numero devis
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("quote_num").'</td>';
	print '<td colspan="2">'.$sale->quote_num.'</td></tr>';   
	//TVA
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tva").'</td>';
	print '<td colspan="2">'.$sale->tva.'</td></tr>';
	//Observation     
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("obser").'</td>';
	print '<td colspan="2">'.$sale->observation.'</td></tr>';   
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';

		print '<a href="./index.php?action=delete&id='.  $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
			print '</div>';
	if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeletesup"),$langs->trans("ConfirmDeletesup"),"confirm_delete", '', 0, 1);
                }
}
else {
print_fiche_titre($langs->trans('ListOfsale'));
	$card="card.php";
	print '<div style="float: right; margin-bottom: 6px;">';
	print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('vente').'</a>';
	print '</div>';
	print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_user" value="'. $search_user .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_supplier" value="'. $search_supplier .'" type="hidden" />';
print '<input name="search_const_site" value="'. $search_const_site .'" type="hidden" />';
print '<input name="search_paidby" value="'. $search_paidby .'" type="hidden" />';
print '<input name="search_quote_num" value="'. $search_quote_num .'" type="hidden" />';
print '<input name="search_tva" value="'. $search_tva .'" type="hidden" />';
print '<input name="search_obs" value="'. $search_obs .'" type="hidden" />';
print '<input name="search_sdate" value="'. $search_sdate .'" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	///les zone de recherche
	print_liste_field_titre($langs->trans("Refe"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("User"),$_SERVER["PHP_SELF"],"fk_user", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("const_site"), $_SERVER["PHP_SELF"], 'fk_const_site', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("supplier"),$_SERVER["PHP_SELF"], 'fk_supplier', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("paidby"),$_SERVER["PHP_SELF"], "paidby", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Date"),$_SERVER["PHP_SELF"],"name", 'sdate','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("quote_num"), $_SERVER["PHP_SELF"], 'quote_num', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tva"),$_SERVER["PHP_SELF"], 'tva', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("obser"),$_SERVER["PHP_SELF"],"observation",'','','',$sortfield,$sortorder);
	print_liste_field_titre('', $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	//recherche id
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	//utilisateur
	print '<td class="liste_titre" align="left" width="50">';    
    print $form->select_dolusers($search_user,"search_user",1);
 	print '</td>';	
 	//champ recherche  d'un  chantier
	print '<td class="liste_titre" colspan="1" align="center">';
	 print '<select name="search_const_site"     id="nomer"/>';
      $pselect="";
      $cht=new ConstructionSite($db);
      $cht->fetchAll();

      print '<option value=""></option>';
        if (count($cht->rows)) {
         foreach($cht->rows as $line) {
        	if($search_const_site){
            	if($line->id==$search_const_site){
       		   $pselect="selected=selected";
            	}
           }
       print '<option  value="'.$line->id.'" '.$pselect.'>'.$line->name.'</option>';
      $pselect="";
        }
    }
    print '</select>';
	print '</td>';
	// Fournisseur
    print '<td class="liste_titre" align="left" width="50">';    
    print  $form->select_thirdparty($search_supplier,"search_supplier",'s.fournisseur=1'); 
 	print '</td>';	
    //Mode de paiement 
    print '<td class="liste_titre" align="left" width="50">';
   $form->select_types_paiements($search_paidby, "search_paidby", '', 0, 1, 1);
    print '</td>';
     //Date
     print '<td class="liste_titre" align="left" width="50">';
     print '<input type="text" class="datepicker" autocomplete="off"  id="datepe" name="search_sdate" value="'.dol_print_date($search_sdate,'day').'" href="javascript:;">';
        print '</td>';
        //numero devis
    print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_quote_num" value="'.$search_quote_num.'">';
	print '</td>';
	//TVA
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_tva" value="'.$search_tva.'">';
	//Observation
	print '</td>';print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_obs" value="'.$search_obs.'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";
	// Lines
	if (count($sale->rows)) {
			foreach($sale->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$suser 		        = $line->fk_user;
			$supplier           =  $line->fk_supplier;
			$const              =  $line->fk_const_site;
			$paidby             =  $line->paidby;
			$sdate				=	$line->sdate;
			$quote_num          =  $line->quote_num;
			$tva       			=	$line->tva;
			$obs				=	$line->observation;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $sale->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			//:utilisateur
			$user_u   = new User($db);
          $user_u->fetch($line->fk_user);  
          $nom=  $user_u->lastname.' ' .$user_u->firstname; 
			print '<td align="center">'.$user_u->getNomUrl(1, $line->fk_user, $nom) .'</td>';
            //chantier de construction
			 $chant=new ConstructionSite($db);
             $chant->fetch($const);

	print '<td align="center">'.$chant->getNomUrl(1,$const,$chant->name,$chant->market_id)  .'</td>';
		    //fournisseur  
			$for = new Societe($db);
            $for->fetch($line->fk_supplier);
            print '<td align="center">'. $for->getNomUrl(1,$line->fk_supplier,$for->name).'</td>';
            //mode de paiement
			$paidtype  = new BtpSales($db);
             print '<td align="center">';
	       $labeltype= $paidtype->getPaymentType($line->paidby); 
	        print $labeltype;
	        print "</td>\n"; 
	        //date
		    print '<td align="center">'.dol_print_date($line->sdate,'day').'</td>';
		    //numero devis
		    print '<td align="center">'.$quote_num.'</td>';
             //tva
		    print '<td align="center">'.$tva.'</td>';
		    //tva
		     print '<td align="center">'.$obs.'</td>';

		    print '<td><div style="float: right; margin-top: 8px;">';
			print '</td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	
}
llxFooter();
$db->close();
?>