<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/index.php
 * \ingroup    market
 * \brief      List of markets
 */

/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/bail/index.php
 * \ingroup    list
 * \brief      List of bails related to given attach_id
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_metres/class/work_metres.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/metre_headers/class/metre_headers.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/attachment_header/class/attachment_header.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/attachments/class/attachments.class.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/ccountry.class.php';
$langs->load('btp');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$attach_id 	 = GETPOST('attach_id', 'int');
$id 	 = GETPOST('id', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$attach_id)
	die('ID attachement n\'existe pas!');

$object = new AttachmentHeader($db);
$attachment = new Attachments($db);
$market = new Market($db);
$form   = new FormChild($db);
$works   = new MarketWorks($db);
$metre = new  MarketWorkMetres($db);
$user = new  User($db);

/**
 * Actions
 */

// None

/**
 * View
 */

llxHeader(array(), $langs->trans('Headers'),'','','','',array('/btp/js/btp.js'));

// Récupération de l'ID de l'utilisateur
$getHeaders = $object->fetchAll($attach_id, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, '');

// Si erreur SQL
if ($getHeaders == '-1') {
    print_fiche_titre($langs->trans('Headers'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}
if (($id || $attach_id) && $getHeaders) {
	$object->fetch(null,$attach_id);

	$attachment->fetch($attach_id);
	$metre->fetch($attachment->fk_metre);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);

	print_barre_liste($langs->trans("Headers"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu1');

	$Attachments  = market_works_metre_prepare_head($metre);
		dol_fiche_head($Attachments,'attachments', $langs->trans("Attachments"), 0, 'submunu2');
	
	$attach_Head  = market_works_metre_attachment_prepare_head($attachment);
		dol_fiche_head($attach_Head,'attachment_header', $langs->trans("Headers"), 0, 'submunu3');

	$sign  	= $object->signatories ? $object->signatories : '';
	$diverse 			= $object->diverse ? $object->diverse : '';
	$country			= $object->fk_country ? $object->fk_country : '';
	$third_party	= $object->fk_third_party ? $object->fk_third_party : '';
		$societe=new Societe($db);
		$societe->fetch($third_party);
	    $countrie=new Ccountry($db);
		$countrie->fetch($country);
	print '<table class="border" width="100%">';
        print '<tbody>';
       
          print '<tr><td class="fieldrequired">'.$langs->trans("Country").'</td><td>' . $countrie->label .'</td></tr>';
         print '<tr><td class="fieldrequired">'.$langs->trans("Company").'</td><td>'. $societe->getNomUrl(1) .'</td></tr>';
        print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Diverse").'</td><td>' .$diverse .'</td></tr>';
       print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Signatorie").'</td><td>' .$sign .'</td></tr>';
      
      	 print '</tbody>';
		print '</table><br />';

	print '<div class="tabsAction">';
        // Boutons d'actions
		print '<a href="./card.php?action=edit&attach_id='. $attach_id .'&id='. $object->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        print '</div>';
	

	 }

if (!$getHeaders) {
	$title = $langs->trans("Headers");
	$attachment->fetch($attach_id);
	$metre->fetch($attachment->fk_metre);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);

	print_barre_liste($langs->trans("Headers"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu1');

	$Attachments  = market_works_metre_prepare_head($metre);
		dol_fiche_head($Attachments,'attachments', $langs->trans("Attachments"), 0, 'submunu2');
	
	$attach_Head  = market_works_metre_attachment_prepare_head($attachment);
		dol_fiche_head($attach_Head,'attachment_header', $langs->trans("AttachmentHeaders"), 0, 'submunu3');
	

	
	print '<br>';
	print '<div style="text-align: center; margin-top: 8px;">';
	print '<a href="./card.php?action=add&attach_id='. $attach_id .'" class="butAction">'.$langs->trans('AddHeader').'</a>';
	print '</div>';
}

llxFooter();

$db->close();

?>