<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/marekt/construction_site_arrangement/construction_site_arrangement.class.php
 * \ingroup btp
 * \brief   This file is construction_site_arrangement CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

class ConstructionArrangementAffect extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  	public $designation;
  	public $ref;
  	public $qty;
  	public $price;
  	public $product_id ;
  	public $unit_type_id;
  	public $const_disposal_id;
  	public $created_by;
  	public $created_at;
  	public $updated_at;
  	public $rows = array();

  	public $table_element = 'const_diposals_affect';
	public $element 	  = 'const_diposals_affect';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d');
	  	$this->updated_at= $this->now;
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0, $id = null, $ref = null, $caid)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/construction_disposal_affect/index.php?id='. $id .'&caid='. $caid .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'btp@btp';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->designation= $this->designation ? $this->db->escape($this->designation): null;
	  $this->ref = $this->ref ? $this->db->escape($this->ref): null;
	  $this->qty = $this->qty ? $this->db->escape($this->qty): null;
	  $this->price = $this->price ? $this->db->escape($this->price): null;
	  $this->product_id = $this->product_id ? $this->db->escape($this->product_id): null;
	  $this->unit_type_id = $this->unit_type_id ? $this->db->escape($this->unit_type_id): null;
	  $this->const_disposal_id	= $this->const_disposal_id ? $this->db->escape($this->const_disposal_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'const_diposals_affect' . ' (designation,ref,price,qty,';
	$sql .= 'product_id,unit_type_id,const_disposal_id,created_by,created_at,updated_at) ';
	$sql .= 'VALUES ("'.$this->designation.'","'.$this->ref.'", '. $this->price.',';
	$sql .=	 $this->qty.','.$this->product_id.', '.$this->unit_type_id.', ';
	$sql .=	 $this->const_disposal_id.', '.$this->created_by.',"'.$this->created_at.'","'.$this->updated_at.'")';
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error const_diposals_affect ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			
			return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'const_diposals_affect';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$refrows = $this->db->num_rows($resql);
			if ($refrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->designation 	= $obj->designation ;
			  $this->ref 			= $obj->ref ;
			  $this->id 			= $obj->rowid ;
			  $this->qty            = $obj->qty ;
			  $this->price          = $obj->price ;
			  $this->product_id   	= $obj->product_id ;
			  $this->unit_type_id 	= $obj->unit_type_id ;
			  $this->const_disposal_id= $obj->const_disposal_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($refrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($caid, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '')
	{
		if ($caid <= 0)
			die('Id de chantier n\'existe pas.');

		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'const_diposals_affect WHERE const_disposal_id = '. (int)$caid;

		if (!empty($filter)) {
			$sql .= $filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$ref = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->const_disposal_id= $obj->const_disposal_id;
				  $line->product_id 	= $obj->product_id;
				  $line->designation 	= $obj->designation;
				  $line->ref 			= $obj->ref;
				  $line->qty            = $obj->qty;
				  $line->price          = $obj->price;
				  $line->unit_type_id 	= $obj->unit_type_id;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $ref;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'const_diposals_affect' . ' SET updated_at = "'. $this->now .'",';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . (int)$id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		if ($id <= 0)
			die('Id arragement n\'existe pas');

		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql = 'DELETE FROM ' . MAIN_DB_PREFIX . 'const_diposals_affect' .' WHERE rowid = ' . (int)$id;

		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
}

?>