<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/imputationchantier/class/imputationchantier.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$fuser   = new User($db);
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$mid     = GETPOST('mid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
    die('ID marché n\'existe pas!');

$now 	= new \DateTime('now');
$now    = $now->format('Y-m-d');
$form   = new Form($db);
$error 	= false;
$constructionSite = new ConstructionSite($db);
$market           = new Market($db);
$imputationchantier= new imputationchantier($db);

if ($action == 'create' && $request_method === 'POST' && !empty($_POST['market_id_'])) {
    $name          = trim(GETPOST('name_'));
    $adress        = trim(GETPOST('adress_'));
    $amount        = (float)trim(GETPOST('amount_'));
    $nmbrjourchantier        = (float)trim(GETPOST('nmbrjourchantier_'));
    $couthorairechantier        = (float)trim(GETPOST('couthorairechantier_'));
    $nmbrkmentrechantierdepot        = (float)trim(GETPOST('nmbrkmentrechantierdepot_'));
    $tel           = trim(GETPOST('tel_'));
    $head_site_id  = (int)trim(GETPOST('head_site_id_'));
    $pointer_id    = (int)trim(GETPOST('pointer_id_'));
    $market_id     = (int)trim(GETPOST('market_id_'));

    if (empty($name) || empty($adress) || empty($amount) || empty($tel) || $head_site_id <= 0  || $pointer_id <= 0) {
        header("Location: card.php?action=add&mid=".$market_id."&msg=Remplir tous les champs");
        die();
    }

    if (!$error) {
        $constructionSite->name          = $name;
        $constructionSite->adress        = $adress;
        $constructionSite->amount        = $amount;
        $constructionSite->tel           = $tel;
        $constructionSite->market_id     = $market_id;
        $constructionSite->head_site_id  = $head_site_id;
        $constructionSite->pointer_id    = $pointer_id;
        $constructionSite->created_by    = $user->id;
        $constructionSite->nmbrjourchantier    = $nmbrjourchantier;
        $constructionSite->couthorairechantier    = $couthorairechantier;
        $constructionSite->nmbrkmentrechantierdepot    = $nmbrkmentrechantierdepot;

        $constructionSiteID = $constructionSite->create();
    
        // If no SQL error we redirect to the request card
        if ($constructionSiteID > 0) {
            //header('Location: index.php?id='.$getMarcheID);
            header('Location: index.php?id='.$constructionSiteID.'&mid='.$market_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: card.php?action=request&error=SQL_Create&msg='.$constructionSite->error);
            exit;
        }
    }
}

if ($action == 'update' && $request_method === 'POST' && (!empty($_POST['id']) && !empty($_POST['market_id_']))) {
    // If no right to modify a request
    /*if (!$fuser->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $name          = trim(GETPOST('name_'));
    $adress        = trim(GETPOST('adress_'));
    $amount        = (float)trim(GETPOST('amount_'));
    $tel           = trim(GETPOST('tel_'));
    $head_site_id  = (int)trim(GETPOST('head_site_id_'));
    $nmbrjourchantier  = (float)trim(GETPOST('nmbrjourchantier_'));
    $couthorairechantier  = (float)trim(GETPOST('couthorairechantier_'));
    $nmbrkmentrechantierdepot  = (float)trim(GETPOST('nmbrkmentrechantierdepot_'));
    $pointer_id    = (int)trim(GETPOST('pointer_id_'));
    $market_id     = (int)trim(GETPOST('market_id_'));
    $id            = (int)trim(GETPOST('id'));

    if ($id <= 0 || empty($name) || empty($adress) || empty($amount) || empty($tel) || $head_site_id <= 0  || $pointer_id <= 0) {
        header("Location: index.php?mid=".$market_id);
        die();
    }

    // If this is the requestor or has read/write rights
    $data = array(
      'name'        => $name,
      'adress'      => $adress,
      'amount'      => $amount,
      'tel'         => $tel,
      'head_site_id'=> $head_site_id,
      'nmbrjourchantier'=> $nmbrjourchantier,
      'couthorairechantier'=> $couthorairechantier,
      'nmbrkmentrechantierdepot'=> $nmbrkmentrechantierdepot,
      'pointer_id'  => $pointer_id,
    );

	$getConstructionSiteID = $constructionSite->update($id, $data);
    
    if ($getConstructionSiteID > 0) {
        header('Location: ./index.php?id='.$id.'&mid='.$market_id);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: ./card.php?id='. $id .'&action=edit&error=SQL_Create&msg='.$constructionSite->error);
        exit;
    } 
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	//$canedit = ($fuser->rights->marches->write_all || $fuser->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$constructionSite->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
        header('Location: index.php?mid='.$mid);
        exit;
	}
}

/*
 * View
 */
$market->fetch($mid);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/ConstructionSite.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('ConstructionSite'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($fuser->rights->marches->write) || empty($fuser->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('AddConstructionSite'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        $head  = market_prepare_head($market);
        dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

        echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="market_id_" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

       //nom
        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Name").'</td><td>';
        print '<input type="text" value="" name="name_" required="required" />';
        print '</td></tr>';

        //amount
        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").'</td><td>';
        print '<input type="text" value="" name="amount_" required="required" />';
        print '</td></tr>';

        //adress
        print '<tr><td class="fieldrequired">'.$langs->trans("Adress").'</td><td>';
        print '<input type="text" value="" name="adress_" required="required" />';
        print '</td></tr>';

       //tel 
        print '<tr><td class="fieldrequired">'.$langs->trans("ContactTel").'</td><td>';
        print '<input type="text" value="" name="tel_" required="required" />';
        print '</td></tr>';


        //Chef chantier 
        print '<tr><td>'.$langs->trans("head_site").'</td><td>'; 
        print $form->select_dolusers(null,'head_site_id_');
        print '</td></tr>';

        //pointer 
        print '<tr><td>'.$langs->trans("pointer").'</td><td>'; 
        print $form->select_dolusers(null,'pointer_id_');
        print '</td></tr>';

        //cout horaire moyen
        print '<tr><td class="fieldrequired">'.$langs->trans("Côut horaire moyen").'</td><td>';
        print '<input type="number" min="0" step="0.1" autocomplete="off"  name="couthorairechantier_"/> ';
        print '</td></tr>';

        //Nombre de jours sur chantier
        print '<tr><td class="fieldrequired">'.$langs->trans("Nombre de jours sur chantier").'</td><td>';
        print '<input type="number" min="0" step="0.01" autocomplete="off"  name="nmbrjourchantier_"/> ';
        print '</td></tr>';

        //Nombre de km entre dépôt et chantier
        print '<tr><td class="fieldrequired">'.$langs->trans("Nombre de km entre dépôt et chantier").'</td><td>';
        print '<input type="number" min="0" step="0.1" autocomplete="off"  name="nmbrkmentrechantierdepot_"/> ';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("CreateConstructionSite") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $constructionSite->fetch($id);

			//$canedit = ($fuser->rights->marches->delete || $fuser->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndnameP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
        $constructionSite->fetch($id);
        $head  = market_prepare_head($market);
        dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

        echo $market->getMarketHeader();

        if ($action == 'edit') {
            $edit = true;
            print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
            print '<input type="hidden" name="action" value="update" />'."\n";
            print '<input type="hidden" name="id" value="'.$id.'" />'."\n";
            print '<input type="hidden" name="market_id_" value="'. $mid .'" />'."\n";

            print '<table class="border" width="100%">';
            print '<tbody>';

            //date
            print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("name").'</td><td>';
            print '<input type="text" value="'.$constructionSite->name.'" name="name_" required="required" />';
            print '</td></tr>';

            //adress
            print '<tr><td class="fieldrequired">'.$langs->trans("adress").'</td><td>';
            print '<input type="text" value="'.$constructionSite->adress.'" name="adress_" required="required" />';
            print '</td></tr>';

            //amountéro
            print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
            print '<input type="text" value="'.$constructionSite->amount.'" name="amount_" required="required" />';
            print '</td></tr>';

           //tel 
            print '<tr><td class="fieldrequired">'.$langs->trans("tel").'</td><td>';
            print '<input type="text" value="'.$constructionSite->tel.'" name="tel_" required="required" />';
            print '</td></tr>';

            //chef Chantier 
            print '<tr><td>'.$langs->trans("head_site").'</td><td>'; 
            print $form->select_dolusers($constructionSite->head_site_id,'head_site_id_');
            print '</td></tr>';

            //pointer 
            print '<tr><td>'.$langs->trans("pointer").'</td><td>'; 
            print $form->select_dolusers($constructionSite->pointer_id,'pointer_id_');
            print '</td></tr>';

            //heures main<br> d\'œuvre chantier
            print '<tr><td width="25%" class="fieldrequired" style="white-space:nowrap;">'.$langs->trans("Heures main d'œuvre chantier").'</td>';
            print '<td colspan="2">'. $imputationchantier->getSommeImputationsHeures($constructionSite->id).'</td></tr>';

            //Côut horaire moyen
            print '<tr><td class="fieldrequired">'.$langs->trans("Côut horaire moyen").'</td><td>';
            print '<input type="number" min="0" step="0.1" value="'.$constructionSite->couthorairechantier.'"  autocomplete="off"  name="couthorairechantier_" /> ';
            print '</td></tr>';

            //Nombre de jours sur chantier
            print '<tr><td class="fieldrequired">'.$langs->trans("Nombre de jours sur chantier").'</td><td>';
            print '<input type="number" min="0" step="0.01" value="'.$constructionSite->nmbrjourchantier.'"  autocomplete="off"  name="nmbrjourchantier_" /> ';
            print '</td></tr>';

            //Nombre de km entre dépôt et chantier
            print '<tr><td class="fieldrequired">'.$langs->trans("Nombre de km entre dépôt et chantier").'</td><td>';
            print '<input type="number" min="0" step="0.1" value="'.$constructionSite->nmbrkmentrechantierdepot.'"  autocomplete="off"  name="nmbrkmentrechantierdepot_" /> ';
            print '</td></tr>';

            print '</tbody>';
            print '</table>';

            print '<div class="center">';
            print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
            print '&nbsp; &nbsp; ';
            print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
            print '</div>';
            print '</table>';
        }

        dol_fiche_end();

        if (!$edit) {
            print '<div class="tabsAction">';

            // Boutons d'actions
            //if ($canedit) {
                print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
            //}

            // If draft
           // if ($fuser->rights->marches->delete)	{
            	print '<a href="index.php?id='.$id.'&mid='. $mid .'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
           // }

            print '</div>';
        }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>