<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       btp/market/construction_site_arrangement/card.php
 *		\ingroup    card
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site_arrangement/class/construction_site_arrangement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$action  = GETPOST('action', 'alpha');
$cid     = GETPOST('cid', 'int');
$id      = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$cid)
    die('ID chantier n\'existe pas!');

$form                        = new Form($db);
$constructionSiteArrangement = new ConstructionSiteArrangement($db);
$constructionSite            = new ConstructionSite($db);
$market                      = new Market($db);
$error 	= false;

// Fetch both market and construction site
$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);

if ($action == 'create' && $request_method === 'POST' && (isset($_POST['cid']) && !empty($_POST['cid']))) {

    $datec = trim($_POST['datec_']);
    $num   = trim($_POST['num_']);
    $const_site_destin_id = (int)trim($_POST['const_site_destin_id_']);
    $cid   = (int)trim($_POST['cid']);

    if ($cid <= 0 || empty($num) || empty($datec) || $const_site_destin_id <= 0) {
        header("Location: card.php?action=add&cid=".$cid."&msg=Remplir tous les champs");
        die();
    }

    $constructionSiteArrangement->datec = Tools::convertDateTo($datec, 'sql');
    $constructionSiteArrangement->num   = trim(GETPOST('num_'));
    $constructionSiteArrangement->const_site_destin_id = trim(GETPOST('const_site_destin_id_'));
    $constructionSiteArrangement->const_site_sender_id  = $cid;
    $constructionSiteArrangement->created_by     = $user->id;

    $constructionSiteArrangementID = $constructionSiteArrangement->create();

    // If no SQL error we redirect to the request card
    if ($constructionSiteArrangementID > 0) {
        header('Location: index.php?cid='.$cid.'&id='.$constructionSiteArrangementID);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: card.php?action=request&error=SQL_Create&msg='.$constructionSiteArrangement->error);
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST' && (isset($_POST['cid']) && !empty($_POST['cid']))) {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/
   
   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 

    // If this is the requestor or has read/write rights
    if ($canedit) {
        $datec = trim($_POST['datec_']);
        $num   = trim($_POST['num_']);
        $const_site_destin_id = (int)trim($_POST['const_site_destin_id_']);
        $cid   = (int)trim($_POST['cid']);
        $id    = (int)trim($_POST['id']);

        if ($cid <= 0 || $id <= 0 || empty($num) || empty($datec) 
            || $const_site_destin_id <= 0) {
            header("Location: index.php?&cid=".$cid);
            die();
        }

        $data = array(
          'datec'  => Tools::convertDateTo($datec, 'sql'),
          'num'    =>trim(GETPOST('num_')),
          'const_site_destin_id' =>trim(GETPOST('const_site_destin_id_')),
        );

		$getconst_site_diposalsID = $constructionSiteArrangement->update($id, $data);
        
        if ($getconst_site_diposalsID > 0) {
            header('Location: ./index.php?id='.$id.'&cid='.$cid);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='.$id.'&cid='.$cid.'&action=edit&error=SQL_Create&msg='.$constructionSiteArrangement->error);
            exit;
        } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;

    if ($id <= 0 || $cid <= 0)
        return false;

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$constructionSiteArrangement->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php?cid='.$cid);
		exit;
	}
	else {
        header('Location: index.php?cid='.$cid);
        exit;
	}
}

/*
 * View
 */
$morejs  = array("/btp/js/btp.js");
$morecss = array();

llxHeader(array(), $langs->trans('const_site_diposals'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        $head = market_prepare_head($market);
        dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

        $head = market_construction_site_prepare_head($constructionSite);
        dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu');

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="cid" value="'. $cid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="number" min="1" value="" name="num_" required="required" />';
        print '</td></tr>';

       //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';
        
        //Chantier 
        print '<tr><td>'.$langs->trans("const_site_destin").'</td><td>'; 
        $const_sites = $constructionSite->getNames($constructionSite->market_id, $cid);
        print $form->selectarray('const_site_destin_id_', $const_sites,(GETPOST('const_site_destin_id_') ? GETPOST('const_site_destin_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createconst_site_diposals") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $constructionSiteArrangement->fetch($id);

            $head = market_prepare_head($market);
            dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

            $head = market_construction_site_prepare_head($constructionSite);
            dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu1');

		//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'datefin' :
                    $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                    break;
                case 'Valideur' :
                    $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                    break;
                case 'nodatefin' :
                    $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                    break;
                case 'DureeHoliday' :
                    $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                    break;
                case 'NoMotifRefuse' :
                    $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                    break;
                case 'mail' :
                    $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                    break;
            }

            setEventMessage($errors, 'errors');
        }

        if ($action == 'edit') {
            $edit = true;
            print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
            print '<input type="hidden" name="action" value="update" />'."\n";
            print '<input type="hidden" name="cid" value="'.$cid.'" />'."\n";
            print '<input type="hidden" name="id" value="'.$id.'" />'."\n";

            print '<table class="border" width="100%">';
            print '<tbody>';

            //date
            print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
            print '<input type="text" value="'.dol_print_date($constructionSiteArrangement->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
            print '</td></tr>';

            //Numéro
            print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
            print '<input type="number" min="1" value="'.$constructionSiteArrangement->num.'" name="num_" required="required" />';
            print '</td></tr>';

            //Engin 
            print '<tr><td>'.$langs->trans("const_site_destin").'</td><td>'; 
            $const_sites = $constructionSite->getNames($constructionSite->market_id, $cid);
            print $form->selectarray('const_site_destin_id_', $const_sites,(GETPOST('const_site_destin_id_') ? GETPOST('const_site_destin_id_') : $constructionSiteArrangement->const_site_destin_id), 0, 0, 0, 'required="required"');
            print '</td></tr>';

            print '</tbody>';
            print '</table>';

            print '<div class="center">';
            print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
            print '&nbsp; &nbsp; ';
            print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
            print '</div>';
            print '</table>';
        }

        dol_fiche_end();

        if (!$edit) {
            print '<div class="tabsAction">';

            // Boutons d'actions
            //if ($canedit) {
                print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
            //}

            // If draft
           // if ($user->rights->marches->delete)	{
            	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
           // }

            print '</div>';
        }
    } else { 
        print '<div class="tabBar">';
        print $langs->trans('ErrorUserViewSC');
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
  }
}

// End of page
llxFooter();

if (is_object($db)) $db->close();
?>