<?php
/* Copyright (C) 2016   Yassine Belkaid     y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/po_managementpackingslip/po_managementpackingslip.class.php
 * \ingroup marches
 * \brief   This file is marches CRUD class file
 *
 */
require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class marches
 *
 * Management packing slip class
 */
class btp_contract extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'btp_contract';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'btp_contract';

	/**
	 * @var int ID
	 */
	public $rowid;
	public $fk_created_by;
	public $fk_user;
	public $fk_third_party;
	public $fk_princ_third_party;
	public $avance;
	public $entity;
	public $created_at;
	public $updated_at;
   public $fk_sous_traitance;
	public $now;
	public $assume;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		$this->statut 	= 0;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_user	  = $this->fk_user ?: null;
		$this->fk_third_party	  = $this->fk_third_party ?: null;
		$this->fk_princ_third_party	  = $this->fk_princ_third_party ?: null;
		$this->fk_created_by  = $this->fk_created_by ?: null;
		$this->avance 		  = $this->avance ? (float)$this->db->escape($this->avance) : 0.00;
		$this->fk_sous_traitance 		  = $this->fk_sous_traitance ? (int)$this->db->escape($this->fk_sous_traitance) : null;

		

		$this->created_at 	  = $this->now;
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_user, fk_created_by, fk_third_party, fk_princ_third_party,fk_sous_traitance,created_at,updated_at, avance,entity,assume) VALUES (';		
		$sql .= $this->fk_user.', '.$this->fk_created_by.', NULL, NULL,'.$this->fk_sous_traitance.', "'.$this->created_at.'", "'.$this->updated_at .'", '. $this->avance .', '. (int)$conf->entity .','.$this->assume.')';
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error Packing slip ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function selectcontac($id, $cont_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT rowid, lastname ,firstname FROM ' . MAIN_DB_PREFIX . 'socpeople' ;

			$sql .= ' WHERE  fk_soc = ' . (int)$id;
		


		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->rowid 		  	  = $obj->rowid;

				$this->lastname 		  	  = $obj->lastname;
				$this->firstname  = $obj->firstname;
				
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
	public function fetch($id, $cont_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT  * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		if (null !== $cont_id) {
			$sql .= ' WHERE fk_sous_traitance = ' . (int)$cont_id;
		} else {
			$sql .= ' WHERE  rowid = ' . (int)$id;
		}


		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->rowid 		  	  = $obj->rowid;
				$this->assume 		  	  = $obj->assume;
				$this->fk_created_by  = $obj->fk_created_by;
				$this->fk_user 	  = $obj->fk_user;
				$this->fk_third_party	  	  = $obj->fk_third_party;
				$this->fk_princ_third_party 	  = $obj->fk_princ_third_party;
				$this->fk_sous_traitance 	  = $obj->fk_sous_traitance;
				$this->avance	  	  = $obj->avance;
				$this->updated_at 	  = $this->db->jdate($obj->updated_at);
				$this->created_at 	  = $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sous_tr, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		if (!empty($filter)) {
			$sql .=' WHERE '. substr($filter, 4) .' AND fk_sous_traitance = '. $sous_tr;
		}else {
			$sql .= ' WHERE fk_sous_traitance = '. $sous_tr;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);
		$num 		= 0;
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->rowid 		  	  = $obj->rowid;
				$line->assume 		  	  = $obj->assume;
				$line->fk_created_by  = $obj->fk_created_by;
				$line->fk_user 	  = $obj->fk_user;
				$line->fk_third_party 	  = $obj->fk_third_party;
				$line->fk_sous_traitance 	  = $obj->fk_sous_traitance;
				$line->fk_princ_third_party 	  = $obj->fk_princ_third_party;
				$line->avance	  	  = $obj->avance;
				$line->updated_at 	  = $this->db->jdate($obj->updated_at);
				$line->created_at 	  = $this->db->jdate($obj->created_at);
				$this->lines[] 	  	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data = array())
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0 || !count($data))
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $this->db->escape(trim($val)) ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int) $id;
		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			die($this->error);
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . (int) $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0, $id, $poid)
    {
        global $langs;

        $result	= '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/nc_under_modules/marches/po_managementpackingslip/index.php?id='. $id .'&poid='. $poid .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

}
