<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       btp/market/count_advance/card.php
 *		\ingroup    card
 *		\brief      count_advance
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/count_advance/class/count_advance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$httpReq = $_SERVER['REQUEST_METHOD'];

if (!$mid && $httpReq !== 'POST')
	die('ID du marché n\'existe pas!');


$error 	  	   = false;
$count_advance = new CountAdvance($db);

if ($_POST['action'] == 'create' && !empty($_POST['mid']) && $httpReq === 'POST') {

    // If no right to create a request
   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }*/
    $mid 	  	= (int)trim($_POST['mid']);
    $ref 		= trim($_POST['ref']);
    $amount_ttc = trim($_POST['amount_ttc']);
    $bank_ 		= (int)trim($_POST['bank_']);
    $date_start = trim($_POST['date_start']);

    if (!$mid || !$amount_ttc || !$ref || $bank_ < 0 || !$date_start) {
		header('Location: ./card.php?action=add&mid='.$mid);
    	die();
    }

    $settlement_date = isset($_POST['date_end']) && !empty($_POST['date_end']) ? trim($_POST['date_end']) : '';
    $observation = isset($_POST['observation']) && !empty($_POST['observation']) ? trim($_POST['observation']) : '';
    $type  = isset($_POST['type']) && !empty($_POST['type']) ? trim($_POST['type']) : '';
    $stage = isset($_POST['stage']) && !empty($_POST['stage']) ? trim($_POST['stage']) : '';

    $count_advance->fk_createdby  	= $user->id;
    $count_advance->fk_market 	 	= $mid;
    $count_advance->fk_bank 	 	= $bank_;
    $count_advance->amount_ttc 		= (float)$amount_ttc;
    $count_advance->date_start 	 	= Tools::convertDateTo($date_start, 'sql');
    $count_advance->settlement_date = Tools::convertDateTo($settlement_date, 'sql');
    $count_advance->num 			= $ref;
    $count_advance->type 			= $type;
    $count_advance->stage 			= $stage;
    $count_advance->observation 	= $observation;

	$getId = $count_advance->create();

	if ($getId)
	    header('Location: ./index.php?mid='.$mid.'&id='.$getId);
	else
	    header('Location: ./index.php?mid='.$mid);

    die();
}

if ($_POST['action'] == 'update' && ($_POST['id'] && $_POST['mid']) && $httpReq === 'POST') {

	// If no right to create a request
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {*/
		$id 	  	= (int)trim($_POST['id']);
		$mid 	  	= (int)trim($_POST['mid']);
	    $ref 		= trim($_POST['ref']);
	    $amount_ttc = trim($_POST['amount_ttc']);
	    $bank_ 		= (int)trim($_POST['bank_']);
	    $date_start = trim($_POST['date_start']);

	    if (!$amount_ttc || !$ref || !$bank_ || !$date_start) {

			header('Location: ./index.php?mid='.$mid);
	    	die();
	    }

	    $settlement_date = isset($_POST['date_end']) && !empty($_POST['date_end']) ? trim($_POST['date_end']) : '';
	    $observation = isset($_POST['observation']) && !empty($_POST['observation']) ? trim($_POST['observation']) : '';
	    $type  = isset($_POST['type']) && !empty($_POST['type']) ? trim($_POST['type']) : '';
	    $stage = isset($_POST['stage']) && !empty($_POST['stage']) ? trim($_POST['stage']) : '';

	    $data = array(
		    'fk_bank' 	 		=> $bank_,
		    'amount_ttc' 		=> (float)$amount_ttc,
		    'date_start' 	 	=> Tools::convertDateTo($date_start, 'sql'),
		    'settlement_date' 	=> Tools::convertDateTo($settlement_date, 'sql'),
		    'num' 				=> $ref,
		    'type' 				=> $type,
		    'stage' 			=> $stage,
		    'observation' 		=> $observation,
	    );

		$count_advance->update($id, $data);

    	header('Location: ./index.php?mid='.$mid.'&id='.$id);
        die();
	// }
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->btp->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$count_advance->delete((int) $id);

	header('Location: ./index.php?mid='.$mid);
    exit;
}

$form 	= new Form($db);
$market = new Market($db);
$morejs  = array("/btp/js/btp.js");
$morecss = array();
$mainTitle = $langs->trans('DCount').'/'.$langs->trans('Advance');

llxHeader(array(), $mainTitle,'','','','',$morejs,$morecss,0,0);

if (!empty($mid) && ($action == 'add' || $action == 'request' || $action == 'create')) {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
        // Formulaire de concurrents
		$market->fetch($mid);
		$head = market_prepare_head($market);
		dol_fiche_head($head, 'count_advance', $langs->trans('AddCountAdvance'), 0, '');

		echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td><td>';
        print '<input type="text" class="" value="" name="ref" required="required" />';
        print '</td></tr>';

         // Bank
        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
        print $form->select_comptes((GETPOST('bank_') ? GETPOST('bank_') : ''), 'bank_',0,'',1,'required="required"') . "<span class='bank_number'></span>";
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' TTC </td><td>';
        print '<input type="text" class="" value="" name="amount_ttc" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'. $langs->trans("ReleaseDate") .'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_start" required="required" />';
        print '</td></tr>';

        print '<tr><td>'. $langs->trans("SettlementDate") .'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_end" />';
        print '</td></tr>';

        print '<tr><td>'. $langs->trans("Type") .'</td><td><input type="text" class="" value="" name="type" /></td></tr>';
        print '<tr><td>'. $langs->trans("Stage") .'</td><td><input type="text" class="" value="" name="stage" /></td></tr>';
        print '<tr><td valign="top">'. $langs->trans("Observation") .'</td><td><textarea rows="10" class="" cols="60" name="observation"></textarea></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center" style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateCountAdvance") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id && $mid) {
		$count_advance->fetch($id, $mid);
		$market->fetch($mid);
		$head    = market_prepare_head($market);
		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                // if($user->rights->btp->delete) {
                    print $form->formconfirm("./index.php?mid=".$mid."&id=".$id, $langs->trans("DeleteCountAdvance"),$langs->trans("ConfirmDeleteCountAdvance"),"confirm_delete", '', 0, 1);
                // }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'count_advance', $mainTitle, 0, '');

				echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$ref	  	= $count_advance->num ? $count_advance->num : '';
				$type	  	= $count_advance->type ? $count_advance->type : '';
				$stage	  	= $count_advance->stage ? $count_advance->stage : '';
				$fk_bank 	= $count_advance->fk_bank ? $count_advance->fk_bank : '';
				$observation= $count_advance->observation ? $count_advance->observation : '';
				$amount_ttc	= $count_advance->amount_ttc ? $count_advance->amount_ttc : '';
		      	$date_start = $count_advance->date_start ? dol_print_date($count_advance->date_start, 'day'): '';
		      	$settlement_date = $count_advance->settlement_date ? dol_print_date($count_advance->settlement_date, 'day'): '';

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td><td>';
		        print '<input type="text" class="" value="'. $ref .'" name="ref" required="required" />';
		        print '</td></tr>';

		         // Bank
		        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
		        print $form->select_comptes((GETPOST('bank_') ? GETPOST('bank_') : $fk_bank), 'bank_',0,'',1,'required="required"') . "<span class='bank_number'></span>";
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' TTC </td><td>';
		        print '<input type="text" class="" value="'. $amount_ttc .'" name="amount_ttc" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'. $langs->trans("ReleaseDate") .'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_start .'" name="date_start" required="required" />';
		        print '</td></tr>';

		        print '<tr><td>'. $langs->trans("SettlementDate") .'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $settlement_date .'" name="date_end" />';
		        print '</td></tr>';

		        print '<tr><td>'. $langs->trans("Type") .'</td><td><input type="text" class="" value="'. $type .'" name="type" /></td></tr>';
		        print '<tr><td>'. $langs->trans("Stage") .'</td><td><input type="text" class="" value="'. $stage .'" name="stage" /></td></tr>';
		        print '<tr><td valign="top">'. $langs->trans("Observation") .'</td><td><textarea rows="10" class="" cols="60" name="observation">'. $observation .'</textarea></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>