<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/marekt/count_advance/count_advance.class.php
 * \ingroup btp
 * \brief   This file is release CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class btp
 *
 * Contract Management class
 */
class CountAdvance extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see btp::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'td_count_advance';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'td_count_advance';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_createdby;
	public $fk_market;
	public $fk_bank;
	public $amount_ttc;
	public $date_start;
	public $settlement_date;
	public $type;
	public $ref;
	public $stage;
	public $observation;
	public $statut;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		  = $db;
		$this->now 		  = new \DateTime("now");
		$this->now 		  = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_market 	= $this->fk_market ? $this->db->escape((int)$this->fk_market) : null;
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape((int)$this->fk_createdby) : null;
		$this->fk_bank  	= $this->fk_bank ? $this->db->escape((int)$this->fk_bank): null;
		$this->amount_ttc 	= $this->amount_ttc ? $this->db->escape((float)$this->amount_ttc): null;
		$this->stage 		= $this->stage ? $this->db->escape($this->stage): null;
		$this->observation 	= $this->observation ? $this->db->escape($this->observation): null;
		$this->statut 		= $this->statut ? $this->db->escape((int)$this->statut): 0;
		$this->ref 			= $this->num ? $this->db->escape($this->num): null;
		$this->type 		= $this->type ? $this->db->escape($this->type): null;
		$this->date_start 	= $this->date_start ? $this->db->escape($this->date_start) : null;
		$this->settlement_date= $this->settlement_date ? $this->db->escape($this->settlement_date) : null;
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_market, fk_createdby, fk_bank, amount_ttc, date_start, created_at, updated_at, stage, observation, statut, num, type, settlement_date) VALUES (';
		$sql .= $this->fk_market.', '.$this->fk_createdby.', '. $this->fk_bank .', '. $this->amount_ttc .', "'. $this->date_start .'", "'. $this->created_at .'", "'. $this->updated_at .'", "'. $this->stage .'", "'. $this->observation .'", '. $this->statut .', "'. $this->ref .'", "'. $this->type .'", "'. $this->settlement_date .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error Concurrents ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
die();
			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id   Id object
	 * @param int    $m_id market id
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $m_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element. ' WHERE rowid = ' . (int)$id;

		if (null !== $m_id)
			$sql .= ' AND fk_market = '. (int)$m_id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->id 		  	  = $obj->rowid;
				$this->fk_createdby   = $obj->fk_createdby;
				$this->fk_market 	  = $obj->fk_market;
				$this->fk_bank 		  = $obj->fk_bank;
				$this->amount_ttc 	  = $obj->amount_ttc;
				$this->date_start 	  = $this->db->jdate($obj->date_start);
				$this->settlement_date= $this->db->jdate($obj->settlement_date);
				$this->num 	  			= $obj->num;
				$this->type 	  		= $obj->type;
				$this->stage 	  		= $obj->stage;
				$this->observation 	  	= nl2br($obj->observation);
				$this->statut 	  		= $obj->statut;
				$this->updated_at 	  = $this->db->jdate($obj->updated_at);
				$this->created_at 	  = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($m_id = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false) 
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id)
			$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element . ' WHERE fk_market ='. (int) $m_id;
		else
			$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= $filter;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		  	  	= $obj->rowid;
				$line->fk_createdby  	= $obj->fk_createdby;
				$line->fk_market 		= $obj->fk_market;
				$line->fk_bank 			= $obj->fk_bank;
				$line->amount_ttc 		= $obj->amount_ttc;
				$line->date_start 		= $this->db->jdate($obj->date_start);
				$line->settlement_date	= $this->db->jdate($obj->settlement_date);
				$line->num 				= $obj->num;
				$line->type 			= $obj->type;
				$line->stage 			= $obj->stage;
				$line->observation 		= nl2br($obj->observation);
				$line->statut 			= $obj->statut;
				$line->updated_at 	  	= $this->db->jdate($obj->updated_at);
				$line->created_at 	  	= $this->db->jdate($obj->created_at);
				$this->lines[] 	  	  	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $this->db->escape($val) ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int)$id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0, $id, $mid, $ref = null)
    {
        global $langs;

        if (!$id || !$mid) return false;

        $result	= '';
        $num = (null !== $ref) ? $ref : '';
        $label  = $langs->trans("Show").': '. $num;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/count_advance/index.php?mid='. $mid .'&id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$num.$linkend;
        return $result;
    }

    public function getCountsAdv($mark)
    {
    	$this->fetchAll($mark);

    	$arr = array();

    	foreach ($this->lines as $key => $row) {
    		$arr[$row->id] = $row->num;
    	}

    	return $arr;
    }

    public function getStatData($market_id = false)
    {
    	global $langs;
    	$this->fetchAll(($market_id ?: null), '', '', 0, 0, '', ($market_id ? false : true));
    	$countAmount = 0;

    	foreach ($this->lines as $key => $obj)
    		$countAmount += $obj->amount_ttc;

    	$object 		= new stdClass();
    	$object->number = count($this->lines);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('DCount/Advance'). ' (TTC)';
    	$object->url 	= (int)$market_id ? DOL_URL_ROOT.'/btp/market/count_advance/index.php?mid='.(int)$market_id : '';

    	return $object;
    }
}
