<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/demandes/index.php
 * \ingroup    demandes
 * \brief      List of demandes
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/demandes/class/demandes.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$type 	 = GETPOST('type', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$types	=[1=>'provisional',2=>'final',3=>'backGrante'];

if (!$mid && $request_method !== 'POST')
	die('ID marche n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new Demande($db);
$marche = new Market($db);
$appeloffre = new tender($db);
if($type==1)
	$appeloffre->fetch($mid);
else
	$marche->fetch($mid);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
    	$type 	 = GETPOST('type', 'int');
    	if (empty($type)) {
	        $type = 1;
	    }
	    $dates= '';
	    $datec	= trim($_POST['datec']);
	    $observation	= trim($_POST['observation']);
	    $dateret	= trim($_POST['dateret']);
	    $amount 	= trim($_POST['amount']);
	    $compte_id 	= trim($_POST['compte_id']);
	    $fk_created_for= trim($_POST['fk_created_for']);
	    $mid 		= trim(GETPOST('mid', 'int'));

	    if (!$mid || !$datec || !$amount || !$compte_id)
			return;

		if (isset($datec) && !empty($datec)) {
	        list($etd, $etm, $ety) = explode("/", $datec);
	        $datec = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($dateret) && !empty($dateret)) {
	        list($etd, $etm, $ety) = explode("/", $dateret);
	        $dateret = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['dates']) && !empty($_POST['dates'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['dates']);
	        $dates = $ety.'-'.$etm.'-'.$etd;
	    }
	   
	    $object->fk_created_by 	= $user->id;
	    $object->fk_marche  	= $mid;
	    $object->datec 		= $datec;
	    $object->observation 		= $observation;
	    $object->dateret 		= $dateret;
	    $object->amount 		= $amount;
	    $object->compte_id 		= $compte_id;
	    $object->fk_created_for	= $fk_created_for;
	    $object->type  	= $type;
	    $object->dates	= $dates;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&mid='.$mid.'&type='. $type);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid.'&type='. $type);
		    die();
		}
    //}
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	/* if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $dates= '';
	    $datec	= trim($_POST['datec']);
	    $dateret	= trim($_POST['dateret']);
	    $observation	= trim($_POST['observation']);
	    $amount 	= trim($_POST['amount']);
	    $mid 		= trim(GETPOST('mid', 'int'));
	    $id 		= trim(GETPOST('id', 'int'));
	    $compte_id 	= trim($_POST['compte_id']);

	    if (!$mid || !$id || !$datec || !$amount || !$compte_id)
			return;

		if (isset($datec) && !empty($datec)) {
	        list($etd, $etm, $ety) = explode("/", $datec);
	        $datec = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($dateret) && !empty($dateret)) {
	        list($etd, $etm, $ety) = explode("/", $dateret);
	        $dateret = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['dates']) && !empty($_POST['dates'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['dates']);
	        $dates = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
	    	'datec'  => $datec,
	    	'dateret'  => $dateret,
	    	'observation'  => $observation,
	    	'amount' 	 => $amount,
		    'compte_id' 	 => $compte_id,
		    'dates' => $dates
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid.'&type='. $type );
	    die();
	//}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->marches->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = true;/* ($user->rights->marches->write_all || $user->rights->marches->delete);*/

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?leftmenu=btp&mid='.$mid.'&type='. $type );
	exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('demandes'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);

if($type==1)
	{
		$head_btm = tender_prepare_head($appeloffre);
		dol_fiche_head($head_btm, 'demandes', $langs->trans("demandesList"), 0, '');
		$head_demande = tender_demandes_prepare_head($appeloffre);
		dol_fiche_head($head_demande, $types[$type], $langs->trans($types[$type]), 0, 'submunu');
	}
	else
	{
	$head  = market_prepare_head($marche);
	dol_fiche_head($head, 'notifications', $langs->trans("NotificationsPhase"), 0, 'submunu1');

	$head_btm = phase_notification_prepare_head($market);
	dol_fiche_head($head_btm, 'demandes', $langs->trans('demandes'), 0, 'submunu2');
	
	$head_demande = phase_notification_demandes_prepare_head($marche);
	dol_fiche_head($head_demande, $types[$type], $langs->trans($types[$type]), 0, 'submunu3');
	
		echo $marche->getMarketHeader($mid, true);
	}

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	/*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
		

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?type='. $type .'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';


        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("dateta").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="datec" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (TTC)</td><td>';
        print '<input type="number" min="0" step="0.01" class="" value="" name="amount" required="required" /></td></tr>';


       print '<tr><td class="fieldrequired">'.$langs->trans("Account").'</td><td>';
        print $form->select_comptes('',"compte_id");
        		print '</td></tr>';
        		
        if($type == 3)
       { print '<tr><td class="fieldrequired">'.$langs->trans("dateBackGrante").'</td><td>';
           print '<input type="text" class="datepicker" autocomplete="off"  value="" name="dates" /></td></tr>';}
if($type == 1)
       {  print '<tr><td width="25%">'.$langs->trans("dateret").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="dateret"  />';
        print '</td></tr>';
        print '<tr><td  width="25%">'.$langs->trans("observation").'</td><td>';
        print '<textarea  name="observation"  /></textarea>';
        print '</td></tr>';}



        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateDemande") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    //}
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		
		$canedit = true;/*($user->rights->marches->delete || $user->rights->marches->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                //if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?mid=".$mid."&id=".$id."&type=". $type, $langs->trans("TitleDeleteDemendeM"),$langs->trans("ConfirmDeleteDemendeM"),"confirm_delete", '', 0, 1);
                //}
            }

			if ($action == 'edit' || $action == 'delete') {

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?type='. $type .'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$datec	 = $object->datec ? dol_print_date($object->datec,'day') : '';
				$dateret	 = $object->dateret ? dol_print_date($object->dateret,'day') : '';
				$observation		 = $object->observation ? $object->observation : '';
				$amount		 = $object->amount ? $object->amount : '';
				$dates= $object->dates ? dol_print_date($object->dates,'day') : '';
				$compte_id = $object->compte_id;
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';


		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("dateta").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $datec .'" name="datec" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (TTC)</td><td>';
		        print '<input type="number" min="0" step="0.01" class="" value="'. $amount .'" name="amount" required="required" /></td></tr>';

		      
		        print '<tr><td class="fieldrequired">'.$langs->trans("Account").'</td><td>';
        		print $form->select_comptes($compte_id,"compte_id");
        		print '</td></tr>';
        		
		       if($type == 3)
		       { print '<tr><td class="fieldrequired">'.$langs->trans("dateBackGrante").'</td><td>';
   		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $dates .'" name="dates" /></td></tr>';}
   		        if($type == 1)
       {  print '<tr><td width="25%">'.$langs->trans("dateret").'</td><td>';
        print '<input type="text" value="'. $dateret .'" class="datepicker" autocomplete="off"  value="" name="dateret"  />';
        print '</td></tr>';
    	print '<tr><td  width="25%">'.$langs->trans("observation").'</td><td>';
        print '<textarea  name="observation"  />'.$observation.'</textarea>';
        print '</td></tr>';}
		        
		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
