<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/demande/class/demande.class.php
 * \ingroup demande
 * \brief   This file is demande CRUD class file
 *
 */
require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class marches
 *
 * Contract Management class
 */
class Demande extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_demandes';
	/**
	 * @var string Name of table without pref_marcheix where object is stored
	 */
	public $table_element 	 = 'm_demandes';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_created_by;
	public $fk_marche;
	public $compte_id;
	public $datec;
	public $dateret;
	public $observation;
	public $amount;
	public $dates;
	public $type;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_created_by= $this->fk_created_by ?: null;
		$this->fk_marche 	= $this->fk_marche ?: null;
		$this->datec	= $this->datec ? $this->db->escape($this->datec) : null;
		$this->dateret	= $this->dateret ? $this->db->escape($this->dateret) : null;
		$this->observation	= $this->observation ? $this->db->escape($this->observation) : null;
		$this->amount = $this->amount ? $this->db->escape($this->amount) : null;
		$this->compte_id = $this->compte_id ? $this->db->escape($this->compte_id) : null;
		$this->dates	= $this->dates ? $this->db->escape($this->dates) : null;
		$this->type	= $this->type ? $this->db->escape($this->type) : null;
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_created_by, fk_marche, created_at, updated_at, datec,dateret,observation, amount,compte_id, dates,type) VALUES (';
		$sql .= $this->fk_created_by.', '.$this->fk_marche.', "'.$this->created_at.'", "'.$this->updated_at .'", "'.$this->datec.'","'.$this->dateret.'","'.$this->observation.'", '. $this->amount .', '. $this->compte_id .', "'. $this->dates .'", '.$this->type.')';
		//die($sql);

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error demande ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_marche = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $fk_marche) {
			$sql .= ' WHERE fk_marche = ' . $fk_marche;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_created_by = $obj->fk_created_by;
				$this->fk_marche 	 = $obj->fk_marche;
				$this->datec  	 = $this->db->jdate($obj->datec);
				$this->dateret  	 = $this->db->jdate($obj->dateret);
				$this->observation		 = $obj->observation;
				$this->amount		 = $obj->amount;
				$this->compte_id		 = $obj->compte_id;
				$this->dates	 = $this->db->jdate($obj->dates);
				$this->type  		 = $obj->type;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_marche = '. $mid;
		} else {
			$sql .= ' WHERE fk_marche = '. $mid;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		
		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_created_by = $obj->fk_created_by;
				$line->fk_marche 	 = $obj->fk_marche;
				$line->datec  	 = $this->db->jdate($obj->datec);
				$line->dateret  	 = $this->db->jdate($obj->dateret);
				$line->observation		 = $obj->observation;
				$line->amount		 = $obj->amount;
				$line->compte_id		 = $obj->compte_id;
				$line->dates	 = $this->db->jdate($obj->dates);
				$line->type 		 = $obj->type;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $ref = null, $mid = null,$type)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $ref = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $id;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/demandes/index.php?id='. $id .'&mid='. $mid .'&type='. $type .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }
}
