<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/declaration/index.php
 * \ingroup    declaration
 * \brief      List of declaration
 */
require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/demandes/declaration/class/declaration.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID appel offre n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new Declaration($db);
$appeloffre = new tender($db);
	$appeloffre->fetch($mid);
if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
    	
	    $dates= $_POST['dates'];
	    $fk_created_by= trim($_POST['fk_created_by']);
	    $compte_id= trim($_POST['compte_id']);
	    $other= trim($_POST['other']);
	    $mid 		= trim(GETPOST('mid', 'int'));
	    $objet = 0;

	    if (!$mid || !$dates || !$fk_created_by || !$compte_id )
			return;


	    if (isset($_POST['dates']) && !empty($_POST['dates'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['dates']);
	        $dates = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['objet']) && !empty($_POST['objet'])) {
	    	$objet = 1;
	    }
	   
	    $object->fk_created_by 	= $fk_created_by;
	    $object->fk_marche  	= $mid;
	   	$object->compte_id  	= $compte_id;
	   	$object->objet  	= $objet;
	   	$object->other  	= $other;
	   	$object->dates	= $dates;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    //}
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	/* if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $dates= trim($_POST['dates']);
	    $other= trim($_POST['other']);
	    $mid 		= trim(GETPOST('mid', 'int'));
	    $objet = 0;
	    $id 		= trim(GETPOST('id', 'int'));
	    $fk_created_by= trim($_POST['fk_created_by']);
		$compte_id= trim($_POST['compte_id']);

	    if (!$mid || !$id || !$dates || !$fk_created_by|| !$compte_id)
			return;


	    if (isset($_POST['dates']) && !empty($_POST['dates'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['dates']);
	        $dates = $ety.'-'.$etm.'-'.$etd;
	    }

	     if (isset($_POST['objet']) && !empty($_POST['objet'])) {
	    	$objet = 1;
	    }

	    $data = array(
	    	'fk_created_by' => $fk_created_by,
	    	'objet'  	=> $objet,
	   		'other'  	=> $other,
		    'compte_id'  =>  $compte_id,
		    'dates' => $dates
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid );
	    die();
	//}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->marches->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = true;/* ($user->rights->marches->write_all || $user->rights->marches->delete);*/

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?leftmenu=btp&mid='.$mid);
	exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('declaration'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);
print_fiche_titre($langs->trans('declaration'), '', 'title_project.png'); 
$head_btm = tender_prepare_head($appeloffre);
		dol_fiche_head($head_btm, 'demandes', $langs->trans("demandesList"), 0, '');
		$head_demande = tender_demandes_prepare_head($appeloffre);
		dol_fiche_head($head_demande, 'declaration', $langs->trans("declarationDetail"), 0, '');
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	/*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
		

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        
        print '<tr><td class="fieldrequired">'.$langs->trans("CreatedBy").'</td><td>';
        print $form->select_users('',"fk_created_by",0);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Account").'</td><td>';
        print $form->select_comptes('',"compte_id");
        		print '</td></tr>';
	
        print '<tr><td class="fieldrequired">'.$langs->trans("dates").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="dates" /></td></tr>';

        print '<tr><td >'.$langs->trans("objetdeclar").'
        <input type="checkbox" name="objet" />
        </td>';
        print'<td align="left" > 
			<p >
	1- m\'engager à couvrir, dans les limites fixées dans le cahier des charges, par une police d\'assurance, les risques découlant de mon activité peofessionnelle.<br />
	2- que je replie les conditions prévues à l\'article 24 du décret 2-12-349 du Joumada I 1434 (20/03/2013) relatif aux marchés publics.<br />
	3- m\'engager, si j\'envisage de recourir à la sous traitante:<br />
	&nbsp;&nbsp;- à m\'assurer que les sous traitants remplissnet les conditions prévues pa r l\'article 24 du Décret n°2-12-349 précite.<br />
	&nbsp;&nbsp;- que celle-ci ne dépasser 50% du montant du marché; ni porter sur le lot corps d\'état principal du marché.<br />
	4- m\'engager à ne pas recourir par moi-même ou par personne interposée à des pratique de fraude ou de corruption de personnes qui interviennet à quelque titre que ce soit dans les différentes procédures de passation, de gestion et d\'éxécution du présent marché.<br />
	5- m\'engager à ne faire pas, par moi-même ou par personnes interposées, des promesses, des dons ou des présents en vue d\'influer sur les différentes procédures de conclusion du présent marché.<br />
	6- que je ne suis pas en situation de conflit d\'intérêt.<br />
	Je certifie l\'axactitude des renseignements contenus dans la presente déclaration sur l\'honneur et dans le pièces fournies dans mon dossier de condidature.<br />
			</p>
		</td></tr>';
		  print '<tr><td >'.$langs->trans("other").'</td><td>';
         print ' <textarea cols="49" rows="8" name="other"></textarea>';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateDemande") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    //}
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		
		$canedit = true;/*($user->rights->marches->delete || $user->rights->marches->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                //if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeleteDemendeM"),$langs->trans("ConfirmDeleteDemendeM"),"confirm_delete", '', 0, 1);
                //}
            }

			if ($action == 'edit' || $action == 'delete') {

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$fk_created_by = $object->fk_created_by ;
				$compte_id = $object->compte_id ;
				$dates= $object->dates ? dol_print_date($object->dates,'day') : '';
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

			   	 

		         print '<tr><td class="fieldrequired">'.$langs->trans("CreatedBy").'</td><td>';
        		print $form->select_users($fk_created_by,"fk_created_by",0);
        		print '</td></tr>';

        		 print '<tr><td class="fieldrequired">'.$langs->trans("Account").'</td><td>';
        		print $form->select_comptes($compte_id,"compte_id");
        		print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("dates").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $dates .'" name="dates" /></td></tr>';
		        $checked ='';
		        if($object->objet)
		        	$checked ='checked';
		         print '<tr><td >'.$langs->trans("objetdeclar").'
        <input type="checkbox" name="objet" '.$checked.' />
        </td>';
        print'<td align="left" > 
			<p >
		1- m\'engager à couvrir, dans les limites fixées dans le cahier des charges, par une police d\'assurance, les risques découlant de mon activité peofessionnelle.<br />
		2- que je replie les conditions prévues à l\'article 24 du décret 2-12-349 du Joumada I 1434 (20/03/2013) relatif aux marchés publics.<br />
		3- m\'engager, si j\'envisage de recourir à la sous traitante:<br />
		&nbsp;&nbsp;- à m\'assurer que les sous traitants remplissnet les conditions prévues pa r l\'article 24 du Décret n°2-12-349 précite.<br />
		&nbsp;&nbsp;- que celle-ci ne dépasser 50% du montant du marché; ni porter sur le lot corps d\'état principal du marché.<br />
		4- m\'engager à ne pas recourir par moi-même ou par personne interposée à des pratique de fraude ou de corruption de personnes qui interviennet à quelque titre que ce soit dans les différentes procédures de passation, de gestion et d\'éxécution du présent marché.<br />
		5- m\'engager à ne faire pas, par moi-même ou par personnes interposées, des promesses, des dons ou des présents en vue d\'influer sur les différentes procédures de conclusion du présent marché.<br />
		6- que je ne suis pas en situation de conflit d\'intérêt.<br />
		Je certifie l\'axactitude des renseignements contenus dans la presente déclaration sur l\'honneur et dans le pièces fournies dans mon dossier de condidature.<br />
				</p>
			</td></tr>';
			  print '<tr><td >'.$langs->trans("other").'</td><td>';
	         print ' <textarea cols="49" rows="8" name="other">'.$object->other.'</textarea>';
	        print '</td></tr>';
		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
