<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/engagement/index.php
 * \ingroup    list
 * \brief      List of delays
 */
require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');

require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/notifications/class/notification.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/demandes/engagement/class/engagement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT . '/compta/bank/class/account.class.php';

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) $socid=$user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
/*
$confirm  = GETPOST('confirm', 'alpha');*/

if (!$mid)
	die("ID appel offre n'existe pas!");


$search_ref      	= GETPOST('search_ref');
$search_created_by  =  GETPOST('search_created_by');
$search_compte   = GETPOST('search_compte');
$search_amount		= GETPOST('search_amount');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   		= "";
	$search_created_by 	= "";
    $search_compte  	= "";
	$search_amount		= "";
}


$object  = new Engagement($db);
$socstatic 	= new Societe($db);
$fuser 	 = new User($db);
$form 	 = new FormChild($db);
$account = new Account($db);
$appeloffre = new tender($db);
	$appeloffre->fetch($mid);


// Filter
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND rowid = '". $db->escape($search_ref) ."'\n" : "";

$filter .= (!empty($search_amount)) ? " AND amount = '". $db->escape($search_amount) ."'\n" : "";
$filter .= (!empty($search_compte) && $search_compte != -1) ? " AND compte_id = '". $db->escape($search_compte) ."'\n" : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ". (int)$db->escape($search_created_by) : "";


/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id = $user->id;
$getengagement = $object->fetchAll($mid, 'ASC', 'rowid', $conf->liste_limit + 1, $offset, $filter);

if ($action == 'pdf' && $mid && $id) {
	ob_get_clean();
	$object->fetch($id);
	$title = "Acte d'engagement";
	$mtop ="20";
	require_once DOL_DOCUMENT_ROOT.'/btp/market/pdf/pdf-no-header.lib.php';
    $logo = DOL_URL_ROOT .'/documents/next-concept.png';
	$pdf->SetFont('times', '', 11, '', true);
	$pdf->AddPage();

	require_once dirname(__FILE__) ."/tpl/engagement.tpl.php";
	//die($html);
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
	$sit_file .= "Acte d'engagement ".$appeloffre->ref.'-'. $appeloffre->id .'.pdf';
	ob_end_clean();
	$pdf->Output($sit_file, 'I');
	die();
}

llxHeader(array(), $langs->trans('engagement'), '', '', '', '', array('/btp/js/marches.js', '/btp/js/payment.js'));
print_fiche_titre($langs->trans('engagement'), '', 'title_project.png'); 


// Si erreur SQL
if ($getengagement == '-1') {
    print_fiche_titre($langs->trans('engagement'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);

if ($id > 0) {
	$object->fetch($id);
	$head_btm = tender_prepare_head($appeloffre);
		dol_fiche_head($head_btm, 'demandes', $langs->trans("demandesList"), 0, '');
		$head_demande = tender_demandes_prepare_head($appeloffre);
		dol_fiche_head($head_demande, 'engagement', $langs->trans("engagementDetail"), 0, '');


	$fuser->fetch($object->fk_created_by);
	$account->fetch($object->compte_id);
	$amount		 = $object->amount ? $object->amount : '';
	$tva  		= $object->tva ? $object->tva : 0;
	$created_at  = $object->created_at ? dol_print_date($object->created_at,'dayhoursec') : '';
	
	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';
	
    print '<tr><td width="25%">'.$langs->trans("Account").'</td>';
	print '<td colspan="2">'. $account->getNomUrl('1') .'</td></tr>';

	print '<tr><td width="25%">'.$langs->trans("AmountTTC").'</td>';
	print '<td colspan="2">'. number_format($amount, 2).' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	print '<tr><td width="25%">'.$langs->trans("tva").'</td>';
	print '<td colspan="2">'. $tva .'%</td></tr>';

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	//if ($user->id && $user->rights->marches->write_all) {
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
		//if ($user->rights->marches->delete)	{
    	print '<a href="./card.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    //}
	//}
	print '</div>';

}
else {
	$head_btm = tender_prepare_head($appeloffre);
		dol_fiche_head($head_btm, 'demandes', $langs->trans("demandesList"), 0, '');
		$head_demande = tender_demandes_prepare_head($appeloffre);
		dol_fiche_head($head_demande, 'engagement', $langs->trans("engagementDetail"), 0, '');

	

   	$moreparam = 'mid='.$mid;
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	$display_non = 'style="display:none;"';
	print_liste_field_titre($langs->trans("Num"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Account"),$_SERVER["PHP_SELF"],"compte_id", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("AmountTTC"),$_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_ttc_col ');
	print_liste_field_titre($langs->trans("tva"),$_SERVER["PHP_SELF"], 'tva', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_ttc_col ');

	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center"></td>';

	// UTILISATEUR
	//if ($user->rights->marches->write_all) {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_users($search_created_by,"search_created_by",1);
	    print '</td>';

	    print '<td class="liste_titre" align="center">';
	    print $form->select_comptes($search_compte,"search_compte",'',1,1);
	print '</td>';
	

	print '<td class="liste_titre" align="center"><input  type="number" step="0.01" min="0" size="10" name="search_amount" value="'.$search_amount.'" /></td>';

	print '<td class="liste_titre" align="center"></td>';


	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {


		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_created_by));
			$account->fetch($db->escape($line->compte_id));
			$amount		= $line->amount ;
			$tva		= $line->tva ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="170px">';
			print $object->getNomUrl(1,  $line->id, $line->id, $mid);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl('1') .'</td>';
			print '<td align="center">'. $account->getNomUrl('1') .'</td>';
			print '<td align="center">'. number_format($amount, 2).' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center">'. $tva .'%</td>';
			print '<td align="right" width="70px">';
			print '<a target="_blank" href="./index.php?action=pdf&mid='. $mid .'&id='.$line->id.'" >'. img_mime('test.pdf','Générer PDF').'</a>';
			print '</td>';
			print '</tr>'."\n";
			$entrance++;
		}
	} else {
		print '<tr>';
	    print '<td colspan="5" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	if ($user->id /*&& $user->rights->marches->write*/) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('Add').'</a>';
		print '</div>';
	}
}

llxFooter();

$db->close();

?>