<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/couverture/index.php
 * \ingroup    list
 * \brief      List of delays
 */
require_once('../../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');

require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/groupement/class/groupement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/lib/btpgroupement.lib.php';

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) $socid=$user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$gid 	  = GETPOST('gid','int');
$type 	  = GETPOST('type','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$types	=[1=>'pli',2=>'administratif',3=>'financier'];
/*
$confirm  = GETPOST('confirm', 'alpha');*/

if (!$gid)
	die("ID marche n'existe pas!");


$search_ref      	= GETPOST('search_ref');
$search_created_by  = (int) GETPOST('search_created_by');
$search_dates   = GETPOST('search_dates');
$search_amount		= GETPOST('search_amount');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   		= "";
	$search_created_by 	= "";
    $search_dates  	= "";
	$search_amount		= "";
}


$marche  = new Market($db);
$form 	 = new FormChild($db);
$groupement = new groupement($db);
$groupement->fetchgroup($gid);
$marche->fetch($groupement->idmarche);


// Récupération de l'ID de l'utilisateur

if ($action == 'pdf' && $gid && $type) {
	ob_get_clean();
	$title = 'Couverture '.$langs->trans($types[$type]);
	require_once dirname(__FILE__) .'/tpl/pdf-no-header.lib.php';
	$pdf->SetFont('times', '', 11, '', true);
	$pdf->AddPage();

	require_once dirname(__FILE__) ."/tpl/".$types[$type].".tpl.php";
	//die($html);
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
	$sit_file .= 'Couverture '.$langs->trans($types[$type]).$marche->code.'-'. $marche->id .'.pdf';
	ob_end_clean();
	$pdf->Output($sit_file, 'I');
	die();
}

llxHeader(array(), $langs->trans('couverture'), '', '', '', '', array('/btp/js/marches.js', '/btp/js/payment.js'));
print_fiche_titre($langs->trans('couverture'), '', 'title_project.png'); 


// Si erreur SQL
if ($getcouverture == '-1') {
    print_fiche_titre($langs->trans('couverture'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;


	$head  = groupement_prepare_head($groupement);
	dol_fiche_head($head, 'demandes', $langs->trans("demandes"), 0, '');

	$head_demande = groupement_demandes_prepare_head($groupement);

		dol_fiche_head($head_demande, 'couverture', $langs->trans("couvertureList"), 0, '');
	//echo $marche->getMarketHeader($gid, true);

	

   	$moreparam = 'gid='.$gid;
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="gid" value="'. $gid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print '<th class="liste_titre" width="90%"> '.$langs->trans("couverture").'</th>';
	print '<th class="liste_titre"> '.$langs->trans("generiate").'</th>';
	print "</tr>\n";

	// Lines
			print '<tr '.$bc[$var].'>';
			print '<td align="left" ><strong>Couverture de Pli</strong></td><td>';
			print '<a target="_blank" href="./index.php?action=pdf&gid='. $gid .'&type=1" >'. img_mime('test.pdf').'</a>';
			print '</td>';
			print '</tr>'."\n";
			print '<tr '.$bc[$var].'>';
			print '<td align="left" ><strong>Couverture de Dossiers administratif, technique</strong></td><td>';
			print '<a target="_blank" href="./index.php?action=pdf&gid='. $gid .'&type=2" >'. img_mime('test.pdf').'</a>';
			print '</td>';
			print '</tr>'."\n";
			print '<tr '.$bc[$var].'>';
			print '<td align="left" ><strong>Couverture d\'offre financiere</strong></td><td>';
			print '<a target="_blank" href="./index.php?action=pdf&gid='. $gid .'&type=3" >'. img_mime('test.pdf').'</a>';
			print '</td>';
			print '</tr>'."\n";
			

	print '</table>';
	print '</form>';

	


llxFooter();

$db->close();

?>