<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/engagement/index.php
 * \ingroup    engagement
 * \brief      List of engagement
 */
require_once('../../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/groupement/class/groupement.class.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/groupement/demandes/engagement/class/engagement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btpgroupement.lib.php';

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$gid 	 = GETPOST('gid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

/*if (!$gid && $request_method !== 'POST')
	die('ID marche n\'existe pas!');
*/
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new Engagement($db);
$marche = new Market($db);
$groupement = new groupement($db);
$groupement->fetchgroup($gid);
if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
    	
        $fk_created_by= trim($_POST['fk_created_by']);
	    $amount= trim($_POST['amount']);
	    $tva= trim($_POST['tva']);
	    $gid 		= trim(GETPOST('gid', 'int'));

	    if (!$gid  || !$fk_created_by || !$amount  )
			return;


	   
	    $object->fk_created_by 	= $fk_created_by;
	    $object->fk_groupement  	= $gid;
	   	$object->amount  	= $amount;
	   	$object->tva  	= $tva;
	   	
		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&gid='.$gid);
		    die();
		} else {
			header('Location: ./index.php?gid='.$gid);
		    die();
		}
    //}
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['gid'] > 0 && $request_method === 'POST') {

	/* if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $gid 		= trim(GETPOST('gid', 'int'));
	    $id 		= trim(GETPOST('id', 'int'));
	    $amount 		= trim(GETPOST('amount'));
	    $tva 		= trim(GETPOST('tva'));
	    $fk_created_by= trim($_POST['fk_created_by']);
		
	    if (!$gid || !$id || !$amount || !$fk_created_by)
			return;


	    $data = array(
	    	'fk_created_by' => $fk_created_by,
		    'amount' => $amount,
		    'tva' => $tva
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&gid='.$gid );
	    die();
	//}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->marches->delete*/) {
	$error = 0;
	$gid = GETPOST('gid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$gid || !$id)
		return;

	$db->begin();

	$canedit = true;/* ($user->rights->marches->write_all || $user->rights->marches->delete);*/

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?leftmenu=btp&gid='.$gid);
	exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('engagement'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);
$marche->fetch($groupement->idmarche);
$head  = groupement_prepare_head($groupement);
	dol_fiche_head($head, 'demandes', $langs->trans("demandes"), 0, '');

	$head_demande = groupement_demandes_prepare_head($groupement);
	dol_fiche_head($head_demande, 'engagement', $langs->trans("engagementDetail"), 0, '');

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	/*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
		
		//echo $marche->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="gid" value="'. $gid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        
        print '<tr><td class="fieldrequired">'.$langs->trans("CreatedBy").'</td><td>';
        print $form->select_users('',"fk_created_by",1);
        print '</td></tr>';


       	 print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (HT)</td><td>';
        print '<input type="number" min="0" step="0.01" class="" value="" name="amount" required="required" /></td></tr>';

         print '<tr><td class="fieldrequired">'.$langs->trans("tva").' (HT)</td><td>';
        print '<input type="number" min="0" class="" value="" name="tva" required="required" />%</td></tr>';
	

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateDemande") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    //}
} else {
	if ($id > 0 && $gid > 0) {
		$object->fetch($id);
		
		$canedit = true;/*($user->rights->marches->delete || $user->rights->marches->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                //if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?gid=".$gid."&id=".$id, $langs->trans("TitleDeleteDemendeM"),$langs->trans("ConfirmDeleteDemendeM"),"confirm_delete", '', 0, 1);
                //}
            }

			if ($action == 'edit' || $action == 'delete') {
				echo $marche->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="gid" value="'. $gid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$fk_created_by = $object->fk_created_by ;
				$amount = $object->amount ;
				$tva = $object->tva ;
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';


		         print '<tr><td class="fieldrequired">'.$langs->trans("CreatedBy").'</td><td>';
        		print $form->select_users($fk_created_by,"fk_created_by",1);
        		print '</td></tr>';


		        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (HT)</td><td>';
		        print '<input type="number" min="0" step="0.01" class="" value="'. $amount .'" name="amount" required="required" /></td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("tva").' (HT)</td><td>';
		        print '<input type="number" min="0"  class="" value="'. $tva .'" name="tva" required="required" /></td></tr>';


		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
