<?php

require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT . '/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/companybankaccount.class.php';

$datec = dol_print_date($object->datec,'day');
$dates = dol_print_date($object->created_at,'day');

$appeloffre = new tender($db);
$user = new User($db);
$bankaccount = new CompanyBankAccount($db);
$contact = new Contact($db);
$account = new Account($db);
$soc  = new Societe($db);
$rib = '';
$bank = '';
$companies ='';
$sociétes = $groupement->fetchsocgroups();
foreach ($sociétes as $line) {
	$soc->fetch($line->fk_idsoc);
	$contact->fetch($line->contact);
	$cfullname= $contact->getFullName($langs);
	$companies.='Et <br>
Je soussigné <b>'.$cfullname.', '.$contact->poste.' </b> agissant au nom et pour le compte de Société <b>'.$soc->name.'</b> au capital de <b>'.$soc->capital.' '.$langs->getCurrencySymbol($conf->currency).'</b> adresse du siège social de la société <b>'.$soc->address.'</b> adresse du domicile élu <b>'.$soc->address.'</b> affilée a la CNSS sous le n°<b>'.$soc->idprof4.'</b> inscrite au registre du commerce <b>'.$soc->town.'</b> sous le n°<b>'.$soc->idprof1.'  </b>.<br>';
}
$companies .='</p>';
$socName  = ucwords($conf->global->MAIN_INFO_SOCIETE_NOM);
$lastligne ='';
if(count($sociétes)){
	$i==1;
	$lastligne ='<tr><td align="left"><b>Ste : '.$socName.'</b></td>';
	foreach ($sociétes as $line) {
		$soc->fetch($line->fk_idsoc);
		if($i%2==0 && $i!=0){
			$lastligne .='</tr><tr>';
			$lastligne .='<td align="left"><b>Ste : '.$soc->name.'</b></td>';
		}
		else
			$lastligne .='<td align="right"><b>Ste : '.$soc->name.'</b></td>';
		$i++;
	}
	$lastligne .='</tr>';
}

if($groupement->fetchSocChef()){	
	$bankaccount->fetch(0,$groupement->fetchSocChef());
	$rib = $bankaccount->number;
	$bank = $bankaccount->bank;
	}
else{
	$account->fetch($groupement->idcompte);
	$rib = $account->number;
	$bank = $account->bank;
}

$user->fetch($object->fk_created_by);
$appeloffre->fetch($marche->fk_tender);
$soc->fetch($appeloffre->fk_third_party);
list($date_bid_open, $date_bid_open_time) = explode(" ", dol_print_date($appeloffre->date_bid_open,'dayhoursec'));

$fullname = $user->getFullName($langs,'','');

$socAdress  = ucwords($conf->global->MAIN_INFO_SOCIETE_ADDRESS);
$socTel  = $conf->global->MAIN_INFO_SOCIETE_TEL;
$socFax  = $conf->global->MAIN_INFO_SOCIETE_FAX;
$socMail  = $conf->global->MAIN_INFO_SOCIETE_MAIL;
$socCapital  = number_format($conf->global->MAIN_INFO_CAPITAL, 2).' '.$langs->getCurrencySymbol($conf->currency);
$socCNCSS  = $conf->global->MAIN_INFO_RCS;
$socRC  = $conf->global->MAIN_INFO_SIREN;
//$rib = $account->number;
$province = !empty($conf->global->MAIN_INFO_SOCIETE_STATE) ? ucwords($conf->global->MAIN_INFO_SOCIETE_STATE) : ucwords($conf->global->MAIN_INFO_SOCIETE_TOWN);
$city 	  = ucwords($conf->global->MAIN_INFO_SOCIETE_TOWN);
$marche_ref = $marche->ref;
$amount_lettre = Tools::chifre_en_lettre($object->amount);
$amount_cheffre =  number_format($object->amount, 2).' '.$langs->getCurrencySymbol($conf->currency);
$tva_lettre = Tools::chifre_en_lettre($object->tva, '%');
$amountttc = Tools::getTva($object->amount,$object->tva)['amount_ttc'];
$amountttc_cheffre =  number_format($amountttc, 2).' '.$langs->getCurrencySymbol($conf->currency);
$amountttc_lettre = Tools::chifre_en_lettre($amountttc);
$html = <<<EOD
<table width="100%" style="border: none;" cellpadding="0" cellspacing="0">
<tr><td align="center"><div style="font-size:20px;"><strong><u>ACTE D'ENGAGEMENT DU GROUPEMENT</u></strong></div></td></tr>
</table>
<br />
<br />
<br />
<table width="100%" style="border: none;" cellpadding="0" cellspacing="0">
<tr>
<td align="center" ><b><u>A- Partie réservée à l'Administration</u></b>.<br></td>
</tr>
<tr>
<td align="left" >Appel d'offres ouvert au rabais ou à majoration n°<b>$appeloffre->ref</b> du <b>$date_bid_open à $date_bid_open_time</b></td>
</tr>
<tr>
<td align="center" ><b>$appeloffre->subject</b></td>
</tr>
</table>
<br />
<table  width="100%" style="border: none;" cellpadding="0" cellspacing="0">
	<tr><td align="left">
		<p style="font-size:9px;">
		Passé par Appel d'Offres Ouvert au "rabais ou à majoration", séance publique, en application de l'alinéa 2, paragraphe 1 de l'article 16, paragraphe 1 de l'article 17 et l'alinéa 2, paragraphe 3 de l'article 17 du èglement de passation des marchès du Groupe Al Omrane du 15 Novembre 2015, fixant les conditions et les formes dans lesquelles sont passés les marchés de travaux de fournitures et de services.
		</p>
		</td>
	</tr>
</table>
<br />
<table width="100%" style="border: none;" cellpadding="0" cellspacing="0">
<tr>
<td align="center" ><b><u>A- Partie réservée à concurrent</u></b>.<br></td>
</tr>
<tr>
<td align="left" ><b><u>b) Pour les personnes morales: </u></b></td>
</tr>
<tr>
<td align="left">
<p >
Je soussigné <b>$fullname, $user->job </b> agissant au nom et pour le compte de Société <b>$socName</b> au capital de <b>$socCapital</b> adresse du siège social de la société <b>$socAdress</b> adresse du domicile élu <b>$socAdress</b> affilée a la CNSS sous le n°<b>$socCNCSS</b> inscrite au registre du commerce <b style=" text-transform: uppercase;">$city</b> sous le n°<b>$socRC</b>.<br>
	$companies
		</td>
	</tr>
</table>
<table width="100%" cellspacing="0" cellpadding="0" style="border: none;">
	<tr>
		<td align="left" > 
			<p style="font-size:9px;">
	En vertu des pouvoirs qui me sont conférés:<br />
	Après avoir pris connaissance du dossier d'appel d'offres concernant les prestations précisées en objet de la partie A ci-dessus;<br />
	Après avoir apprécié à notre point de vue et sous notre responsabilité la nature et les difficultés que comportent ces prestations:<br />
	&nbsp;&nbsp;1) Remettons, revêtus de nos signatures un bordereau de prix et un détail estimatif établis conformément aux modèles figurant au dossier d'appel d'offres.<br />
	&nbsp;&nbsp;2) Nous engageons à éxécuter lesdites prestations conformément au cahier des prescriptions spéciales et moyennant les prix que nous avons établi nous-mêmes pour chaque unité, lesquels font ressortir à la somme de:
			</p>
		</td>
	</tr>
</table>
<table width="100%" border="1"  cellpadding="0" cellspacing="0">
<tr>
<th align="center" >EN CHIFFRES </th>
<th align="center">EN LETTRES</th>
</tr>
<tr>
<td align="left" >TOTAL HT : $amount_cheffre </td>
<td align="left" >$amount_lettre</td>
</tr>
<tr>
<td align="left" >TVA : $object->tva % </td>
<td align="left" > </td>
</tr>
<tr>
<td align="left" >TOTAL TTC : $amountttc_cheffre </td>
<td align="left" > $amountttc_lettre</td>
</tr>
</table><br />
<table width="100%" cellspacing="0" cellpadding="0" style="border: none;">
	<tr>
		<td align="left" > 
			<p>
<b>$soc->name</b> se libérera des sommes dues par lui en faisant donner crédit au compte bancaire ouvert au nom de <b>$socName N° $rib $city à </b><b style=" text-transform: uppercase;">$bank .</b> 
			</p>
		</td>
	</tr>
	<tr><td align="right">Fait à <b style=" text-transform: uppercase;">$city</b>, Le $dates <br></td></tr>
</table>
<table width="100%" cellspacing="0" cellpadding="0" style="border: none;">
	$lastligne
</table>
EOD;

?>