<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/market.class.php
 * \ingroup market
 * \brief   This file is market CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

/**
 * Class market
 *
 * Contract Management class
 */
class Market extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see market::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'market';
	/**
	 * @var string Name of table without pref_marketix where object is stored
	 */
	public $table_element = 'market';

	/**
	 * @var int ID
	 */
	public $id;
	public $ref;
	public $fk_createdby;
	public $traveau;
	public $montant_mandate;
	public $fk_tender;
	public $subject;
	public $decompte;
	public $date_start;
	public $fk_third_party;
	public $date_offer;
	public $date_bid_open;
	public $date_approved;
	public $date_service_order;
	public $code;
	public $init_amount;
	public $final_amount;
	public $completion_time;
	public $completion_days;
	public $bank_collateral;
	public $tva;
	public $note;
	public $entity;
	public $statut; /* 0 = active, 1 = archived from OA, 3 => archived from Recap */
	public $created_at;
	public $updated_at;
	public $idmark;
	public $workrest;
    public $reste;
	public $now;
	public $lines = array();
	public $tender = array();
	public $approval = array();
	public $winner = array();
 	public $fk_product;
 	public $label;
 	public $value;
 	public $somme;
 	public $name;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby = $this->fk_createdby ?: null;
		$this->fk_tender 	= $this->fk_tender ?: null;
		$this->created_at 	= $this->now;
		$this->subject		= $this->subject ? $this->db->escape($this->subject) : '';
		$this->code			= $this->code ? $this->db->escape($this->code) : '';
		$this->init_amount	= $this->init_amount ? $this->db->escape($this->init_amount) : 0;
		$this->final_amount	= $this->final_amount ? $this->db->escape($this->final_amount) : 0;
		$this->completion_time= $this->completion_time ? $this->db->escape($this->completion_time) : 0;
		$this->completion_days= $this->completion_days ? $this->db->escape($this->completion_days) : 0;
		$this->bank_collateral= $this->bank_collateral ? $this->db->escape($this->bank_collateral) : '';
		$this->tva 			= $this->tva ? $this->db->escape($this->tva) : 0;
		$this->note 		= $this->note ? $this->db->escape($this->note) : '';
		$this->date_offer 	= $this->date_offer ? $this->db->escape($this->date_offer): null;
		$this->date_start	= $this->date_start ? $this->db->escape($this->date_start) : null;
		$this->date_bid_open= $this->date_bid_open ? $this->db->escape($this->date_bid_open) : null;
		$this->date_approved= $this->date_approved ? $this->db->escape($this->date_approved) : null;
		$this->date_service_order= $this->date_service_order ? $this->db->escape($this->date_service_order) : null;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (date_offer, fk_createdby, fk_tender, created_at, updated_at, subject, init_amount, date_start, date_bid_open, date_approved, date_service_order, code, final_amount, completion_time,completion_days, bank_collateral, tva, note) VALUES (';		
		$sql .= '"'.$this->now.'", '.$this->fk_createdby.', '.$this->fk_tender.', "'.$this->created_at.'", "'.$this->updated_at.'", "'.$this->subject.'", '.$this->init_amount.', "'.$this->date_start.'", "'.$this->date_bid_open.'", "'.$this->now.'", "'.$this->date_service_order.'", "'.$this->code.'", '.$this->final_amount.', '.$this->completion_time.','.$this->completion_days.', "'.$this->bank_collateral.'", '.$this->tva.', "'.$this->note.'")';

		$this->db->begin();
		
		$resql = $this->db->query($sql);
   
		if (!$resql) {
			$this->db->rollback();

			$this->error = 'Error market ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id          Id object
	 * @param string $fk_tender   Tender ID
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_tender = null)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);
		// $extras = 'm.*';
		// $fields = (null === $fk_tender ? $extras : '*');

		$sql = 'SELECT m.*, t.ref as tender_ref FROM ' . MAIN_DB_PREFIX . $this->table_element .' m, '. MAIN_DB_PREFIX .'tender t';

		if (null !== $fk_tender) {
			$sql .= ' WHERE m.fk_tender = ' . (int)$fk_tender;
		} else {
			$sql .= ' WHERE m.rowid = ' . (int)$id;
		}

		$sql .= " AND m.fk_tender = t.rowid ";
        
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->id 				 = $obj->rowid;
				$this->fk_createdby 	 = $obj->fk_createdby;
				$this->fk_tender 		 = $obj->fk_tender;
				$this->tender_ref		 = $obj->tender_ref;
				$this->code 			 = $obj->code;
				$this->tva 				 = $obj->tva;
				$this->subject			 = $obj->subject;
				$this->note				 = nl2br($obj->note);
				$this->completion_time	 = $obj->completion_time;
				$this->completion_days	 = $obj->completion_days;
				$this->bank_collateral	 = $obj->bank_collateral;
				$this->init_amount 		 = (float) $obj->init_amount;
				$this->final_amount		 = (float) $obj->final_amount;
				$this->montant_mandate		 = (float) $obj->montant_mandate;
				$this->date_start  		 = $this->db->jdate($obj->date_start);
				$this->date_offer		 = $this->db->jdate($obj->date_offer);
				$this->date_bid_open	 = $this->db->jdate($obj->date_bid_open);
				$this->date_approved	 = $this->db->jdate($obj->date_approved);
				$this->date_service_order= $this->db->jdate($obj->date_service_order);
				$this->statut  		 	 = $obj->statut;
				$this->updated_at 		 = $this->db->jdate($obj->updated_at);
				$this->created_at 		 = $this->db->jdate($obj->created_at);
			}
         //    die($sql);
			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $tender_id = 0)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if ($filter) {
			$sql .= ' WHERE '. substr($filter, 4);
			
			if ($tender_id) {
				$sql .= ' AND fk_tender = '. (int)$tender_id;
			}

		} else {
			if ($tender_id) {
				$sql .= ' WHERE fk_tender = '. (int)$tender_id;
			} 
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			$sql .= $this->db->plimit($limit);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 	 = $obj->rowid;
				$line->fk_createdby 	 = $obj->fk_createdby;
				$line->fk_tender 		 = $obj->fk_tender;
				$line->subject 			 = $obj->subject;
				$line->code 			 = $obj->code;
				$line->tva 				 = $obj->tva;
				$line->note				 = nl2br($obj->note);
				$line->completion_time	 = $obj->completion_time;
				$line->completion_days	 = $obj->completion_days;
				$line->bank_collateral	 = $obj->bank_collateral;
				$line->init_amount 		 = (float) $obj->init_amount;
				$line->final_amount		 = (float) $obj->final_amount;
				$line->date_start  		 = $this->db->jdate($obj->date_start);
				$line->date_offer		 = $this->db->jdate($obj->date_offer);
				$line->date_bid_open	 = $this->db->jdate($obj->date_bid_open);
				$line->date_approved	 = $this->db->jdate($obj->date_approved);
				$line->date_service_order= $this->db->jdate($obj->date_service_order);
				$line->statut 		 = $obj->statut;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function countmarket($id=0)
	{
		global $conf;

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		if($id)
		$sql .= ' WHERE fk_tender = ' . $this->getAoId($id) ;

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$ids = array();

				while ($obj = $this->db->fetch_object($resql))
					$ids[] = $obj;
				
				return $ids;
			}

			$this->db->free($resql);

			return 0;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getAoId($id)
	{
		global $conf;

		$sql = 'SELECT fk_tender FROM ' . MAIN_DB_PREFIX . $this->table_element;
		$sql .= ' WHERE rowid = ' . $id ;

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				
				return $obj->fk_tender;
			}

			$this->db->free($resql);

			return 0;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function ismarketCadre($id)
	{
		global $conf;

		$sql = 'SELECT a.type as atype FROM ' . MAIN_DB_PREFIX . $this->table_element .' as m INNER JOIN '. MAIN_DB_PREFIX .'tender as a ON (a.rowid = m.fk_tender) WHERE m.rowid = '. $id .' AND a.type = 2 ';

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				
				return true;
			}

			$this->db->free($resql);

			return false;
		} else {
			return false;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . (int)$id;
            
			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id = null, $ref_market = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $setRef = (null !== $ref_market) ? $ref_market : '';
        $id  	= ($id  ?: '');
        $subject  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/market/index.php?id='. $id .'" title="'.dol_escape_htmltag($subject, 1).'" class="classfortooltip nowrap_cls">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($subject, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        $result = $link."<div class='icon-market mainvmenu'></div>  ".$setRef.$linkend;
        return $result;
    }

    public function getMarketHeader($mid = null, $start_date_market = false)
    {
    	global $langs;

		// echo $this->marketDropDown($this->id);
    	$amount = $this->final_amount ?: $this->init_amount;
    	$amount = Tools::getTva($amount,$this->tva)['amount_ttc'];
    	$html = '<table class="border" width="100%">';
		$html .= '<tr><td width="25%">'.$langs->trans("Refe").'</td>';
		$html .= '<td colspan="2">'. $this->code .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
		$html .= '<td colspan="2">'. $this->subject .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("MarketDate").'</td>';
		$html .= '<td colspan="2">'. dol_print_date($this->date_start, 'day') .'</td></tr>';
		$html .= '<tr><td width="25%" class="fieldrequired">'.$langs->trans("MarketAmount").' TTC</td>';
		$html .= '<td colspan="2">'. number_format($amount, 2) .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
		$html .= '</table><br />';

		return $html;
    }

    public function marketDropDown($id)
    {
    	global $langs;

    	if (!$id)
    		return false;

    	$html = '';

    	if (false !== $this->ismarketCadre($id)) {
    		$id 	 = (int)$id;
    		$market = $this->countmarket($id);

    		if (count($market)) {
    			$html .= '<div class="pull-right" style="float:right;margin-bottom:10px;"><div>';
    			$html .= "<span>". $langs->trans('SelectMarketRange') .":</span> ";
    			  $html .= '<select id="market_cadres">';

	    			foreach ($market as $key => $market) {
	    				$selected = ($market->rowid == $id ? ' selected="selected"' : '');
	    				$subject 	  = Tools::trunc_words($market->subject);
	    				$ref_market= (!empty($market->ref_market) ? (strlen($market->ref_market) > 20 ? substr(trim(ucfirst($market->ref_market)), 0, 20) .'...' : trim(ucfirst($market->ref_market))) : '');
	    		  		$html .= '<option value="'. $market->rowid .'"'. $selected .'>'. ucfirst($ref_market) .' - '. $subject .'</option>';
	    			}

	    		  $html .= '</select></div>';
	    		$html .= "<div style='float: right;margin-right: 0px;margin-top: 10px;'><a class='button' href='". DOL_URL_ROOT ."/btp/market/card.php?mid=". $id ."&action=clone_market'>". $langs->trans('CreateMarketRange') ."</a></div>";
	    		$html .= '</div>';
	    		$html .= '<script type="text/javascript">
	    		  var marchObj = document.getElementById("market_cadres");
	    		  marchObj.addEventListener("change", function() {
	    		  	var marketId = this.options[marchObj.selectedIndex].value;
	    		  	document.location.href = "'. DOL_URL_ROOT .'/btp/market/index.php?id="+marketId;
	    		  });
	    		</script>';
    		}
    	}

    	return $html;
    }

    public function clonemarket($id, $user)
	{
		global $conf;

		if (!$id)
			return false;

		$sql = 'SELECT a.ref as cloned_ref, a.subject as cloned_subject, m.fk_tender as cloned_ao, p.signature_date as cloned_signature_date, c.amount as cloned_amount_ht FROM '. MAIN_DB_PREFIX .'market as m INNER JOIN '. MAIN_DB_PREFIX .'tender as a INNER JOIN '. MAIN_DB_PREFIX .'m_approval as p INNER JOIN '. MAIN_DB_PREFIX .'m_competitors as c WHERE m.rowid = 1 AND (a.rowid = m.fk_tender AND a.rowid = p.fk_tender AND c.fk_tender = a.rowid) AND c.winner = 1';

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				
				return $obj;
			}

			$this->db->free($resql);

			return false;
		} else {
			return false;
		}
	}

    public function statusLevel($statut)
	{
		global $langs;
		$status = '';
		
		switch ($statut) {
			case 0:
				return $langs->trans('Still').' '.img_picto($langs->trans('Still'), 'statut0');
				break;
			case 3:
				return $langs->trans('Archived').' '.img_picto($langs->trans('Archived'), 'statut5');
				break;
		}

		return false;
    }

    public function load_state_board()
	{
		global $conf, $user;

		$this->nb=array();

		$sql = "SELECT count(m.rowid) as nb";
		$sql.= " FROM ".MAIN_DB_PREFIX. $this->table_element ." as m";

		$resql=$this->db->query($sql);
		
		if ($resql) {
			while ($obj=$this->db->fetch_object($resql)) {
				$this->nb["markets"]=$obj->nb;
			}
            $this->db->free($resql);
			return 1;
		}
		else {
			dol_print_error($this->db);
			$this->error=$this->db->error();
			return -1;
		}
	}

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
    public function load_board($tender_id = false, $market_id = false)
    {
        global $conf, $user, $langs;

		require_once DOL_DOCUMENT_ROOT . '/btp/market/construction_site/class/construction_site.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/works/class/works.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/delays/class/delays.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/payments/class/payments.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/count_advance/class/count_advance.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/stakeholders/class/stakeholders.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/social_charges/class/social_charges.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/bail/class/bail.class.php';
		require_once DOL_DOCUMENT_ROOT.'/btp/market/notifications/class/notification.class.php';
		require_once DOL_DOCUMENT_ROOT.'/btp/market/executions/class/execution.class.php';

        $constructionSite = new ConstructionSite($this->db);
        $works 			  = new MarketWorks($this->db);
        $notificate       = new Notifications_two($this->db);
		require_once DOL_DOCUMENT_ROOT.'/btp/market/documentmanagement/class/documentmanagement.class.php';
		require_once DOL_DOCUMENT_ROOT.'/btp/market/recap/class/recap.class.php';
		require_once DOL_DOCUMENT_ROOT.'/btp/market/managementpackingslip/class/managementpackingslip.class.php';
		require_once DOL_DOCUMENT_ROOT.'/btp/market/entrees/class/entrees.class.php';


		$management       = new ManagementPackingSlip($this->db);
		$recap            = new Recap($this->db);
        $delays			  = new MarketDelays($this->db);
        $payments		  = new MarketPayments($this->db);
        $countAdv		  = new CountAdvance($this->db);
        $stakeholders	  = new MarketStakeholders($this->db);
        $socialCharges	  = new MarketChargeSociales($this->db);
        $execution        = new Executions($this->db);
        $bail	  		  =  new Bail($this->db);
        $Document         =   new DocumentManagement($this->db);
        $entrees 	      =  new entrees($this->db);

        $marketId = false;

        if ($market_id) {
        	$marketId = $market_id;
        } elseif ($tender_id) {
        	$this->fetch(0, (int)$tender_id);
        	$marketId = $this->id;
        }

        return array(
        	$constructionSite->getStatData($marketId),
    	 	$works->getStatData($marketId),
        	$notificate->getStatData($marketId),
        	// '',
        	$execution->getStatData($marketId),
        	$Document->getStatData($marketId),
        	$recap->getStatData($marketId),
        	$management->getStatData($marketId),
        	$stakeholders->getStatData($marketId),
        	$entrees->getStatData($marketId)
        );
    }

    public function getNames($tender_id = false)
    {
    	if (!$tender_id)
    		return false;

    	$this->fetchAll('', '', 0, 0, '', $tender_id);
    	$names = array();

    	if (count($this->lines))
    	foreach ($this->lines as $key => $line) {
			$names[$line->id] = $line->code;
    	}

    	return $names;
    }
        public function getNames2($showsubject=false)
    {

    	$filter =	" AND archived = 0";
    	$this->fetchAll('', '', 0, 0, $filter);
    	$names = array();
    	$t = "";
    	if (count($this->lines))
    	foreach ($this->lines as $key => $line) {
    		if ($showsubject)
    			$t = " : ".$line->subject;
    		
			$names[$line->id] = $line->code.$t;
    	}

    	return $names;
    }
//releve des situation des marché
    public function fetchStatus($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $tender_id = 0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$sql = 'SELECT DISTINCT td.rowid,m.rowid as idm,m.date_service_order as startdate,m.montant_mandate,m.code, m.subject, t.fk_third_party, COALESCE( SUM( DISTINCT td.amount  ) , 0 ) as traveau, COALESCE( SUM( DISTINCT w.price * w.qty ) , 0 ) as decompte,
(COALESCE( SUM( DISTINCT w.price * w.qty ) , 0 )-COALESCE( SUM( DISTINCT td.amount  ) , 0 )) as workrest,COALESCE( SUM( DISTINCT td.amount  ) , 0 )-m.montant_mandate as reste
 FROM ' . MAIN_DB_PREFIX .'tender as t,'. MAIN_DB_PREFIX .'market as m LEFT JOIN '. MAIN_DB_PREFIX .'m_paymentmanagement AS td ON m.rowid = td.fk_marche
LEFT JOIN '. MAIN_DB_PREFIX .'td_works AS w ON w.fk_market = m.rowid 
WHERE t.rowid = m.fk_tender';
		if ($filter) {
			$sql .= ' and'. substr($filter, 4);
		
}
		$sql .= " GROUP BY m.rowid, m.subject, t.fk_third_party";

		if (!empty($sortfield)) {
			$sql .= $this->db->order("m.rowid", $sortorder);
		}
		if (!empty($limit)) {
			$sql .= $this->db->plimit($limit, $offset);
		}
		$this->lines = array();
//die($sql);
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		 = $obj->rowid;
				$line->idmark 		 = $obj->idm;
				$line->traveau 	 = $obj->traveau;
				$line->fk_third_party  = $obj->fk_third_party;
				$line->subject 		   = $obj->subject;
				$line->code 		   = $obj->code;
				$line->decompte 	   = $obj->decompte;
				$line->montant_mandate=$obj->montant_mandate;
				$line->workrest=$obj->workrest;
				$line->reste=$obj->reste;
				$line->startdate=$obj->startdate;

				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
	//stock market

	public function Stock_market($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $market_code= '',$chant_code='')
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT rowid,fk_product,inventorycode,sum(ABS(value))as somme,label FROM ' . MAIN_DB_PREFIX . "stock_mouvement  ";
	//$sql.= MAIN_DB_PREFIX ."construction_site c" ;

		if ($filter) {
			$sql .= ' WHERE '. substr($filter, 4);
			
			if ($market_code) {

				$sql .= '  and inventorycode ="'.$market_code.'-'.$chant_code.'" ';
			}


		} else {
			if ($market_code) {
			$sql .= ' WHERE inventorycode ="'.$market_code.'-'.$chant_code.'" ';
				}
		}
       
        $sql.=" group by fk_product";
		/*if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
*/
		if (!empty($limit)) {
			$sql .= $this->db->plimit($limit);
		}
		
		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_product 	 = $obj->fk_product;
				$line->label 		 = $obj->label;
				$line->value 		 = $obj->value;
				$line->name 		 = $obj->name;
				$line->somme 		 = $obj->somme;
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
	
	public function Stock_market_product($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $market_code= '',$codeproduct='')
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . "stock_mouvement  ";
	//$sql.= MAIN_DB_PREFIX ."construction_site c" ;

		if ($filter) {
			$sql .= ' WHERE '. substr($filter, 4);
		} 
       
		if (!$codeproduct) {
			return -1;
		}

		if (!empty($limit)) {
			$sql .= $this->db->plimit($limit);
		}
		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_product 	 = $obj->fk_product;
				$line->datem 		 = $this->db->jdate($obj->datem);
				$line->value 		 = $obj->value;
				$line->inventorycode 		 = $obj->inventorycode;
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function StockBydateProduct($fk_product, $date_start, $date_end)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

	$sql = 'SELECT * FROM `llx_stock_mouvement` WHERE `fk_product` ='.$fk_product ;
	$sql .=" AND `datem` BETWEEN '".$date_start."' AND '".$date_end."'";

	$sql .="ORDER BY `datem` ASC";
	/*$sql .=" AND (`inventorycode` IS NULL";
if (count($markets) && is_array($markets)) {
			foreach ($markets as  $val) {
			$sql .=" OR `inventorycode` LIKE '%".$val."-%'";
		}
		$sql .=")";
}*/
	//$sql.= MAIN_DB_PREFIX ."construction_site c" ;

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_product 	 = $obj->fk_product;
				$line->datem 		 = $this->db->jdate($obj->datem);
				$line->value 		 = $obj->value;
				$line->inventorycode 		 = $obj->inventorycode;
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

}
