<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market_commandes/class/market_commandes.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.commande.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/imputationchantier/class/imputationchantier.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';

// Protection if external user
if (!$user) accessforbidden();

$var 		= false;
$filter 	= '';
$sortfield 	= GETPOST("sortfield",'alpha');
$sortorder 	= GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action	 = GETPOST('action');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id','int');

if (!$mid)
	die('ID marché n\'existe pas!');


$commande 		  = new Commande($db);
$commande_f = new CommandeFournisseur($db);

$marketCommandes = new MarketCommandes($db);
$market 		  = new Market($db);
$fuser 			  = new User($db);
$form 			  = new Form($db);
$imputationchantier= new imputationchantier($db);

$search_commande      	= GETPOST('search_commande');
$search_amount      = GETPOST('search_amount');
$search_adress    	= GETPOST('search_adress');
$search_tel    		= GETPOST('search_tel');
$search_market    	= GETPOST('search_market');
$search_head_site   = GETPOST('search_head_site');
$search_pointer    	= GETPOST('search_pointer');

$type_cmnd    	= GETPOST('type_cmnd');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_commande      	= '';
	$filter      	= '';
}

if (empty($type_cmnd))
	$type_cmnd = "Clients";

$filter .= (!empty($search_commande) && $search_commande != -1) ? " AND commande_id = '". $db->escape($search_commande)."'\n" : "";
$filter .= " AND commande_type = '". $db->escape($type_cmnd)."'\n";

// echo $filter;
$getmarket_commandess = $marketCommandes->fetchAll($mid, $sortorder, $sortfield, "", $offset, $filter,"","",$type_cmnd);


// Si erreur SQL
if ($getmarket_commandess == '-1') {
    print_fiche_titre($langs->trans('ListOfmarket_commandes'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$marketCommandes->error);
    exit();
}

llxHeader('', $langs->trans('market_commandes'));
$market->fetch($mid);

if ($id > 0) {
	$marketCommandes->fetch($id);

	print_barre_liste($langs->trans("market_commandes"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'Commandes', $langs->trans("Commandes"), 0, '');

	// $head = market_market_commandes_prepare_head($marketCommandes);
	// dol_fiche_head($head, '', $langs->trans("const_site_diposals"), 0, '');

	echo $market->getMarketHeader();

	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="">'.$langs->trans("Réf.").'</td>';
	print '<td colspan="2">';
	print $marketCommandes->id;
	print '</td></tr>';
	// Commande
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Commande").' '.$type_cmnd.'</td>';
	print '<td colspan="2">';
	if ($marketCommandes->commande_type == "Fournisseurs"){
		$commande_f->fetch($marketCommandes->commande_id);
		$object_c = $commande_f;
	}
	else{
		$commande->fetch($marketCommandes->commande_id);
		$object_c = $commande;
	}
	print $object_c->getNomUrl(1,  $marketCommandes->commande_id,"","","");
	print '</td></tr>';
	
	print '</table>';
	// print '<br>';
	print '<div style="text-align: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'&type_cmnd='. $type_cmnd .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a class="butAction" href="./index.php?action=delete&id='. $id .'&mid='. $mid .'">'.$langs->trans('Delete').'</a>';

	print '</div>';

    if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("market_commandes"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'Commandes', $langs->trans("Commandes"), 0, '');

	dol_fiche_head('', 'Commandes', $langs->trans(""), 1, 'submunu');

	echo $market->getMarketHeader($mid);
	$moreparam = '&mid='.$mid;

	print '<br>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
		print '<input type="hidden" name="mid" value="'. $mid .'" />';
		print 'Choisir le type des commandes : ';
		print '<select id="type_commandes" name="type_cmnd">';
		$cmnc = "selected";
		$cmnf = "";
		if ($type_cmnd == "Fournisseurs"){
			$cmnf = "selected";
			$cmnc = "";
		}
		print '<option '.$cmnc.' value="Clients">Commande clients</option>';
		print '<option '.$cmnf.' value="Fournisseurs">Commandes fournisseurs</option>';
		print '</select>';
	print '</form>';
	?>
	<script type="text/javascript">
	jQuery(document).ready(function() {
		$('#type_commandes').change(function(){
			 $(this).closest('form').trigger('submit');
		});
		});
	</script>
	<?php
	// print '<br>';
	print '<br>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<input type="hidden" name="type_cmnd" value="'. $type_cmnd .'" />';
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Réf."),$_SERVER["PHP_SELF"],"rowid", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Commande ").$type_cmnd,"","", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Montant TTC"),$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';

	// rowid
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';

	// nom commande
	print '<td class="liste_titre" colspan="1" align="center">';
	print $marketCommandes->select_with_filter($search_commande,'search_commande',1,"rowid","ref","","",true,$type_cmnd);
	print '</td>';

	// Montant TTC
	print '<td class="liste_titre" colspan="1" align="left">';
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($marketCommandes->rows)) {
		//$createdBy = new User($db);
		$tot_ttc = 0;
		// print_r($marketCommandes->rows);
		// echo $marketCommandes->rows[8]->commande_id;
		// die();
		foreach($marketCommandes->rows as $obj) {
			print '<tr '.$bc[$var].'>';
			print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
				print $marketCommandes->getNomUrl(1, $obj->id, $obj->id, $obj->market_id,$obj->commande_type);
			print '</td>';
			if ($obj->commande_type == "Fournisseurs"){
				$commande_f->fetch($obj->commande_id);
				$object_c = $commande_f;
			}
			else{
				$commande->fetch($obj->commande_id);
				$object_c = $commande;
			}
			print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
			print $object_c->getNomUrl(1, $obj->commande_id, "", "", "");
			print '</td>';
			print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
			print number_format($object_c->total_ttc,2,","," ");
			$tot_ttc += $object_c->total_ttc;
			print '</td>';
			print '<td><div style="float: right; margin-top: 8px;">';
			// print '<a href="./index.php?action=delete&id='. $obj->id .'&mid='. $obj->market_id .'">'.$langs->trans('Delete').'</a>';
			print '</div></td>';

			print '</tr>'."\n";

		}
		print '<tr class="liste_titre ">';
		print '<td align="center" colspan="2">';
		print "<b>Total</b>";
		print '</td>';
		print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
		print "<b>".number_format($tot_ttc,2,","," ")."</b>";
		print '</td>';
		print '<td><div style="float: right; margin-top: 8px;">';
		// print '<a href="./index.php?action=delete&id='. $obj->id .'&mid='. $obj->market_id .'">'.$langs->trans('Delete').'</a>';
		print '</div></td>';

		print '</tr>'."\n";
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	// print '<br>';
	print '<div style="text-align: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&mid='. $mid .'&type_cmnd='. $type_cmnd .'" class="butAction">'.$langs->trans('AddMarketCommandes').'</a>';
	print '</div>';
}

llxFooter();

$db->close();


?>