<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/index.php
 * \ingroup    market
 * \brief      List of markets
 */

/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/bail/index.php
 * \ingroup    list
 * \brief      List of bails related to given mid
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_metres/class/work_metres.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/metre_headers/class/metre_headers.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';

//$langs->load('btp');

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$mid 	 = GETPOST('metre_id', 'int');
$id 	 = GETPOST('id', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$mid)
	die('ID metre n\'existe pas!');

$object = new MetreHeaders($db);
$market = new Market($db);
$form   = new FormChild($db);
$works   = new MarketWorks($db);
$metre = new  MarketWorkMetres($db);
$user = new  User($db);

/**
 * Actions
 */

// None

/**
 * View
 */

llxHeader(array(), $langs->trans('Headers'),'','','','',array('/btp/js/btp.js'));

// Récupération de l'ID de l'utilisateur
$getHeaders = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, '');

// Si erreur SQL
if ($getHeaders == '-1') {
    print_fiche_titre($langs->trans('DefinitiveHeader'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}
if (($id || $mid) && $getHeaders) {
	$object->fetch('',$mid);
	$metre->fetch($mid);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);

	print_barre_liste($langs->trans("Headers"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
	
	$work_Head  = market_works_metre_prepare_head($metre);
		dol_fiche_head($work_Head,'metre_headers', $langs->trans("Headers"), 0, 'submunu1');
	$operation  	= $object->operation ? $object->operation : '';
	$block 			= $object->block ? $object->block : '';
	$level 			= $object->level ? $object->level : '';
	$fk_createdby	= $object->fk_createdby ? $object->fk_createdby : '';
	$user->fetch($fk_createdby);
	print '<table class="border" width="100%">';
        print '<tbody>';
        print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td><td>'. 
        $user->getNomUrl('1') .'</td></tr>';
          print '<tr><td class="fieldrequired">'.$langs->trans("Niveau").'</td><td>' . $level .'</td></tr>';
         print '<tr><td class="fieldrequired">'.$langs->trans("Operation").'</td><td>'. $operation .'</td></tr>';
        print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Bloc").'</td><td>' .$block .'</td></tr>';
      
      	 print '</tbody>';
		print '</table><br />';

	print '<div class="tabsAction">';
        // Boutons d'actions
		print '<a href="./card.php?action=edit&metre_id='. $mid .'&id='. $object->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        print '</div>';
	

	 }

if (!$getHeaders) {
	$title = $langs->trans("Headers");	
	$metre->fetch($mid);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);

	print_barre_liste($langs->trans("Headers"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
	
	$work_Head  = market_works_metre_prepare_head($metre);
		dol_fiche_head($work_Head,'metre_headers', $langs->trans("Headers"), 0, 'submunu1');
	print '<br>';
	print '<div style="text-align: center; margin-top: 8px;">';
	print '<a href="./card.php?action=add&metre_id='. $mid .'" class="butAction">'.$langs->trans('AddHeader').'</a>';
	print '</div>';
}

llxFooter();

$db->close();

?>