<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       market/market/card.php
 * \ingroup    market
 * \brief      markets CRUD
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_metres/class/work_metres.class.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/metre_workparts/class/metre_workparts.class.php';

// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$metre_id     = GETPOST('metre_id', 'int');

$error 	= false;
$workpart = new MetreWorkParts($db);
$metre=new MarketWorkMetres($db);
$works=new MarketWorks($db);
$market=new Market($db);

$request_method = $_SERVER['REQUEST_METHOD'];

if ($action == 'create' && $request_method === 'POST') {
    $fk_createdby     = $user->id;
    $num        = trim($_POST['num']);
    $length           = trim($_POST['length']);
    $width           = trim($_POST['width']);
    $height           = trim($_POST['height']);
    $depth           = trim($_POST['depth']);
    $thickness           = trim($_POST['thickness']);
    $metreid           = trim($_POST['metreid']);
    $task=trim($_POST['task']);

    if (!$error) {
       
            $workpart->fk_createdby  = $user->id;
            $workpart->fk_metre     = $metreid;
            $workpart->num  = $num;
            $workpart->length  = $length;
            $workpart->height  = $height;
            $workpart->width  = $width;
            $workpart->depth  = $depth;
            $workpart->thickness  = $thickness;
            $workpart->task = trim($_POST['task']);
                   if (!$metreid || $num=="" || $depth<=0 || $task=="" || $thickness<=0) {
            header('Location:./card.php?action=add&metre_id='. $metreid);
            return;
        }
        $created = $workpart->create();
        
        if ($created) {
          header('Location: ./index.php?metre_id='.$metreid.'&id='.$created);
           die();
          } else {
            header("Location: ./index.php?error=SQL_Create&msg=". $workpart->error);
             die();
        }
        
       
    }
}

if ($action == 'update' && $request_method === 'POST') {
    $metre_id     = (int)$_POST['metre_id'];
    $workpart_id     = (int)$_POST['workpart_id'];
    $thick=(int)$_POST['thickness'];
    $task=$_POST['task'];
    $nume= $_POST['num'];
    
    if (!$error) {
        $data = array(
    		"fk_metre"     => $metre_id,
            "num"          => $nume,
            "length"       =>(int)$_POST['metre_id'],
            "height"           =>(int)$_POST['height'],
            "depth"           =>(int)$_POST['depth'],
            "width"           =>(int)$_POST['width'],
            "thickness"         =>$thick,
            "task"           =>$task,
        );  
         if (!$metre_id || !$workpart_id || $task==""   || $thick<=0 || $nume=="") {
              header('Location: ./index.php?metre_id='.$metre_id.'&id='.$workpart_id);
            return;
        }

    	$upated = $workpart->update($workpart_id, $data);
    	
    	if ($upated) {
	    	  header('Location: ./index.php?metre_id='.$metre_id.'&id='.$workpart_id);
      die();
    	} else {
    		header("Location: ./index.php?metre_id=".$metre_id."&id=". $hworkpart_id."&error=SQL_Create&msg=". $workpart->error);
	    	die();
    	}
    }
}

if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' /*&& $user->rights->btp->delete*/) {
    $error=0;

    $db->begin();

    $canDelete = true;/*($user->rights->btp->write_all || $user->rights->btp->delete);*/
     if ($canDelete) {
        $workpart->delete((int)$id);
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    header('Location: index.php?metre_id='.$metre_id);
    
    if (!$error) {
        $db->commit();
        exit;
    }
    else {
        $db->rollback();
        header('Location: index.php?leftmenu=btp');
        exit;
    }
}

/*
 * View
 */

$form    = new Form($db);
$morejs  = array("/btp/js/btp.js");
$morecss = array();
$tender = new Tender($db);
$metre = new MarketWorkMetres($db);

llxHeader(array(), $langs->trans('ListOfMarkets'),'','','','',$morejs,$morecss,0,0);

if ($action == 'add' || $action == 'create') {
   
$metre->fetch($metre_id);
$works->fetch($metre->fk_td_work);
$market->fetch($works->fk_market);

$head  = market_prepare_head($market);
    dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

    $work_metresHead  = market_works_prepare_head($works);
    dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
    
    $work_Head  = market_works_metre_prepare_head($metre);
        dol_fiche_head($work_Head,'metre_workparts', $langs->trans("Workparts"), 0, 'submunu1');

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="action" value="create" />';
         print '<input type="hidden" name="metreid" value="'.$metre_id.'" />';

        print '<table class="border" width="100%">';
        print '<tbody>';

        print '<tr><td>'.$langs->trans("task").'</td><td>';
        print '<input type="text" class="flat" name="task"  required ="required" /></td></tr>';

        print '<tr><td>'.$langs->trans("num").'</td><td>';
        print '<input type="text" class="flat" name="num" required ="required"/></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("lenght").'</td><td>';
        print '<input type="number" class="flat" name="length"  min="1" /></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("width").'</td><td>';
        print '<input type="number" class="flat" name="width"  min="1"/></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("height").'</td><td>';
        print '<input type="number" class="flat" name="height"  min="1"/></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("thickness").'</td><td>';
        print '<input type="number" class="flat" name="thickness" required ="required" min="1" /></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("depth").'</td><td>';
        print '<input type="number" class="flat" name="depth" required ="required" min="1" /></td></tr>';
        print '</tbody>';
        print '</table><br />';

        print '<div align="right">';
        // Boutons d'actions
        print '<input type="submit" class="butAction" value="'. $langs->trans('AddWorkpart') .'">';
        print '</div>';

        dol_fiche_end();
    // }
}
else if ($id || $action == 'edit' || $action == 'update') {
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'cantDelete' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'markerN' :
                    $errors[] = $langs->trans('MarketNError');
                    break;
                case 'markerL' :
                    $errors[] = $langs->trans('MarketLError');
                    break;
                case 'markerD' :
                    $errors[] = $langs->trans('MarketDError');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

		$canedit = true;
        if ($canedit) {
$obj=new MetreWorkParts($db);
$metre->fetch($metre_id);
$works->fetch($metre->fk_td_work);
$market->fetch($works->fk_market);
$obj->fetch($id);
$head  = market_prepare_head($market);
    dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

    $work_metresHead  = market_works_prepare_head($works);
    dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
    
    $work_Head  = market_works_metre_prepare_head($metre);
        dol_fiche_head($work_Head,'metre_workparts', $langs->trans("Workparts"), 0, 'submunu1');

            if ($action == 'edit') {
                $edit = true;
                print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
                print '<input type="hidden" name="action" value="update" />';
                print '<input type="hidden" name="metre_id" value="'.$metre_id.'" />';  
                print '<input type="hidden" name="workpart_id" value="'.$id.'" />';

                print '<table class="border" width="100%">';
                print '<tbody>';
        print '<tr><td>'.$langs->trans("Tâche").'</td><td>';
        print '<input type="text" class="flat" name="task" value="'. $obj->task .'" required ="required" /></td></tr>';

        print '<tr><td>'.$langs->trans("Numero").'</td><td>';
        print '<input type="text" class="flat" name="num" value="'. $obj->num .'" required ="required"/></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Longeur").'</td><td>';
        print '<input type="number" class="flat" name="length" value="'. $obj->length .'" min="1" /></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Largeur").'</td><td>';
        print '<input type="number" class="flat" name="width"  value="'. $obj->width .'"  min="1" /></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Haut").'</td><td>';
        print '<input type="number" class="flat" name="height" value="'. $obj->height .'"  min="1" /></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Epaisseur").'</td><td>';
        print '<input type="number" class="flat" name="thickness" value="'. $obj->thickness .'"  min="1" required ="required"/></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Profondeur").'</td><td>';
        print '<input type="number" class="flat" name="depth"   value="'. $obj->depth .'"  min="1" required ="required"/></td></tr>';

                print '</tbody>';
                print '</table><br />';






















                print '<div class="center">';
                // Boutons d'actions
                print '<input type="submit" class="butAction" value="'. $langs->trans('Modify') .'">';

                print '</div>';
            }

            dol_fiche_end();

        }
    // }
}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>
