<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/market.class.php
 * \ingroup market
 * \brief   This file is market CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';
// require_once DOL_DOCUMENT_ROOT.'/btp/executions/class/execution.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


/**
 * Class market
 *
 * Contract Management class
 */
class MetreWorkParts extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see market::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'metres_workparts';
	/**
	 * @var string Name of table without pref_marketix where object is stored
	 */
	public $table_element = 'metres_workparts';

	/**
	 * @var int ID
	 */
	public $id;
	public $num;
	public $fk_createdby;
	public $length;
	public $width;
	public $height;
	public $depth;
	public $thickness;
	public $statut;
	public $task;
	public $fk_metre;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		
	

		$this->fk_createdby = $this->fk_createdby ?: null;
		$this->fk_metre 	= $this->fk_metre ?: null;
		$this->created_at 	= $this->now;
		$this->updated_at 	= $this->now;
		$this->length		= $this->length ? $this->db->escape($this->length) : 0;
		$this->height		= $this->height ? $this->db->escape($this->height) : 0;
		$this->depth		= $this->depth ? $this->db->escape($this->depth) : 0;
		$this->num		= $this->num ? $this->db->escape($this->num) : '';
		$this->status	= $this->status ? $this->db->escape($this->status) : 0;
		$this->width	= $this->width ? $this->db->escape($this->width) : 0;
		$this->task	= $this->task ? $this->db->escape($this->task) : '';
		$this->thickness	= $this->thickness ? $this->db->escape($this->thickness) : 0;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_metre,fk_createdby,width,length,height,depth,thickness,num,task,created_at, updated_at) VALUES (';		
		$sql .= '"'.$this->fk_metre.'", '.$this->fk_createdby.', "'.$this->width.'","'.$this->length.'","'.$this->height.'","'.$this->depth.'","'.$this->thickness.'","'.$this->num.'","'.$this->task.'","'.$this->created_at.'", "'.$this->updated_at.'")';
       
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error = 'Error header ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id          Id object
	 * @param string $fk_tender   Tender ID
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id=null, $fk_metre = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		// $extras = 'm.*';
		// $fields = (null === $fk_tender ? $extras : '*');

		$sql = 'SELECT  * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		if (null !== $fk_metre) {
			$sql .= ' WHERE fk_metre = ' . (int)$fk_metre;
		} else {
			$sql .= ' WHERE  rowid = ' . (int)$id;
		}

		

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
		$obj 					 = $this->db->fetch_object($resql);
		$this->id=$obj->rowid;
		$this->fk_createdby = $obj->fk_createdby;
		$this->fk_metre 	= $obj->fk_metre;
	
		$this->length		= $obj->length;
		$this->height		= $obj->height;
		$this->depth		= $obj->depth ;
		$this->num		= $obj->num ;
		$this->status	= $obj->status;
		$this->width	= $obj->width ;
		$this->thickness	= $obj->thickness ;
		$this->task	= $obj->task ;
		
					}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid,$sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		
		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_metre = '. $mid;
		} else {
			$sql .= ' WHERE fk_metre = '. $mid;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		$this->lines = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
		
		$line = new stdClass;
		$line->id           = $obj->rowid;
		$line->fk_createdby = $obj->fk_createdby;
		$line->fk_metre 	= $obj->fk_metre;
		$line->length		= $obj->length;
		$line->height		= $obj->height;
		$line->depth		= $obj->depth ;
		$line->num		    = $obj->num ;
		$line->status   	= $obj->status;
		$line->width	    = $obj->width ;
		$line->thickness	= $obj->thickness ;
		$line->task	        = $obj->task ;
		$line->updated_at 	 = $this->db->jdate($obj->updated_at);
		$line->created_at 	 = $this->db->jdate($obj->created_at);
		$this->lines[] 		 = $line;
			}
			$this->db->free($resql);
		  
			return $num;

		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . (int)$id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	
	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
        public function getNomUrl($withpicto=0,  $id, $wid = null)
    {
        global $langs;

        $result	= '';
        $settransport	= '';

        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/metre_workparts/index.php?id='. $id .'&metre_id='. $wid .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }
    	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

}
