<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/paymentmanagement/class/paymentmanagement.class.php
 * \ingroup paymentmanagement
 * \brief   This file is paymentmanagement CRUD class file
 *
 */
require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class marches
 *
 * Contract Management class
 */
class PaymentManagement extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_paymentmanagement';
	/**
	 * @var string Name of table without pref_marcheix where object is stored
	 */
	public $table_element 	 = 'm_paymentmanagement';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_created_by;
	public $fk_marche;
	public $ref;
	public $paid_date;
	public $amount;
	public $pen_amount;
	public $rev_amount;
	public $billing_num;
	public $billing_date;
	public $statut;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_created_by= $this->fk_created_by ?: null;
		$this->fk_marche 	= $this->fk_marche ?: null;
		$this->ref 			= $this->ref ? $this->db->escape($this->ref) : null;
		$this->paid_date	= $this->paid_date ? $this->db->escape($this->paid_date) : null;
		$this->amount 		= $this->amount ? $this->db->escape($this->amount) : null;
		$this->pen_amount 	= $this->pen_amount ? $this->db->escape($this->pen_amount) : 0;
		$this->rev_amount 	= $this->rev_amount ? $this->db->escape($this->rev_amount) : 0;
		$this->billing_num 	= $this->billing_num ? $this->db->escape($this->billing_num) : null;
		$this->billing_date	= $this->billing_date ? $this->db->escape($this->billing_date) : null;
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_created_by, fk_marche, ref, created_at, updated_at, paid_date, amount, pen_amount, rev_amount, billing_num, billing_date) VALUES (';
		$sql .= $this->fk_created_by.', '.$this->fk_marche.', "'.$this->ref.'", "'.$this->created_at.'", "'.$this->updated_at .'", "'.$this->paid_date.'", '. $this->amount .', '. $this->pen_amount .', '. $this->rev_amount .', "'. $this->billing_num .'", "'. $this->billing_date .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error paymentmanagement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_marche = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $fk_marche) {
			$sql .= ' WHERE fk_marche = ' . $fk_marche;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_created_by = $obj->fk_created_by;
				$this->fk_marche 	 = $obj->fk_marche;
				$this->ref 			 = $obj->ref;
				$this->paid_date  	 = $this->db->jdate($obj->paid_date);
				$this->amount		 = $obj->amount;
				$this->pen_amount	 = $obj->pen_amount;
				$this->rev_amount	 = $obj->rev_amount;
				$this->billing_num	 = $obj->billing_num;
				$this->billing_date	 = $this->db->jdate($obj->billing_date);
				$this->statut  		 = $obj->statut;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_marche = '. $mid;
		} else {
			$sql .= ' WHERE fk_marche = '. $mid;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_created_by = $obj->fk_created_by;
				$line->fk_marche 	 = $obj->fk_marche;
				$line->ref			 = $obj->ref;
				$line->paid_date  	 = $this->db->jdate($obj->paid_date);
				$line->amount		 = $obj->amount;
				$line->pen_amount	 = $obj->pen_amount;
				$line->rev_amount	 = $obj->rev_amount;
				$line->billing_num	 = $obj->billing_num;
				$line->billing_date	 = $this->db->jdate($obj->billing_date);
				$line->statut 		 = $obj->statut;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $ref = null, $mid = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $ref = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("AttachNum").' '. $ref;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/paymentmanagement/index.php?id='. $id .'&mid='. $mid .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }
}
