<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/card.php
 * \ingroup    market
 * \brief      markets CRUD
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formsocialcontrib.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/social_charges/class/social_charges.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/compta/sociales/class/chargesociales.class.php';

$langs->load('btp');

// Protection if external user
if (!$user)  accessforbidden();

// Get parameters
$myparam    = GETPOST("myparam");
$action     = GETPOST('action', 'alpha');
$confirm    = GETPOST('confirm', 'alpha');
$id         = GETPOST('id', 'int');
$mid 	    = GETPOST('mid', 'int');
$error 	    = false;
$request_method = $_SERVER['REQUEST_METHOD'];

$social_charges     = new MarketChargeSociales($db);
$formsocialcontrib  = new FormSocialContrib($db);
$market             = new Market($db);
$form               = new Form($db);

if ($action == 'create' && $request_method === 'POST') {
    // If no right to update a request
   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $error = true;
        setEventMessage($langs->trans('CantCreate'));
        $action='edit';
    } else {*/

        if (!count($_POST['cs']))
            die('cs is empty');

        $mid = GETPOST('mid', 'int');

        foreach ($_POST['cs'] as $key => $val) {
            $cs_id = (int) $val;

            if (!empty($cs_id)) {
                $social_charges->fk_market         = $mid;
                $social_charges->fk_createdby      = $user->id;
                $social_charges->fk_social_charge  = $cs_id;
                $social_charges->create();
            }
        }
    
        header("Location: ./index.php?mid=". $mid);
        die();
    // }
}

if ($action == 'update' && $request_method === 'POST') {
	die('update');
}

if ($action == 'confirm_delete' and $confirm == 'yes') {
    if ($id /*&& $user->rights->btp->delete*/) {
        $deleted = $social_charges->delete($id);

        if ($deleted)
            header("Location: ./index.php?mid=". $mid);
            die();
    }
}

/*
 * View
 */
$morejs  = array();
$morecss = array();

llxHeader(array(), $langs->trans('ListOfMarkets'),'','','','',$morejs,$morecss,0,0);

if ($id || $action == 'edit' || $action == 'update') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {
		$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);
        
        if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?id=".$id, $langs->trans("TitleDeleteCert"),$langs->trans("ConfirmDeleteCert"),"confirm_delete", '', 0, 1);
                }
            }

            $market->fetch($mid);
            $social_charges->fetch($id);
            $head = btp_prepare_head($market);
            dol_fiche_head($head, 'social_charges', $langs->trans("social_charges"), 0, '');

            if ($action == 'edit') {
                $edit = true;
                print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
                print '<input type="hidden" name="action" value="update" />';
                print '<input type="hidden" name="mid" value="'.$mid.'" />';
                print '<input type="hidden" name="id" value="'.$id.'" />';

                print '<table class="border" width="100%">';
                print '<tbody>';

                // Label
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketRef").'</td><td>';
                print '<input type="text" value="'. $market->ref_market .'" name="ref_market" required="required" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketLabel").'</td><td>';
                print '<input type="text" value="'. $market->label .'" name="label" required="required" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketDate").'</td><td>';
                print '<input type="text" class="datepicker" autocomplete="off"  value="'. dol_print_date($market->sig_date, 'day') .'" name="sig_date" required="required" readonly="readonly" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketAmount").'</td><td>';
                print '<input type="text" value="'. $market->budget .'" name="budget" required="required" /></td></tr>';

                print '</tbody>';
                print '</table><br />';

                print '<div class="center">';
                // Boutons d'actions
                print '<input type="submit" class="butAction" value="'. $langs->trans('Modify') .'">';

                // If draft
                if ($user->rights->btp->delete)	{
                	print '<a href="./card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                }
                print '</div>';
            }

            dol_fiche_end();

        }
    }
}


// End of page
llxFooter();

if (is_object($db)) $db->close();

?>
