<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/stock_const/class/stock_const.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

;
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';


// Protection if external user
if (!$user) accessforbidden();

$var = false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id  = GETPOST('id','int');
$cid = GETPOST('cid','int');
$action= GETPOST('action');

if (!$cid)
	die('ID chantier n\'existe pas!');

$search_num      	= GETPOST('search_num');
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_product    	= GETPOST('search_product');
$search_qty    		= GETPOST('search_qty');
$search_unit_type   = GETPOST('search_unit_type');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_num      	= '';
	$search_datec      	= '';
	$search_product    	= '';
	$search_qty    		= '';
}



$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datem Like '%". $db->escape($search_datec)."%'\n" : "";

$filter .= (!empty($search_product) && $search_product != -1) ? " AND fk_product= ".$db->escape($search_product): "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND value= -".$db->escape($search_qty): "";


$form      			  = new FormChild($db);
$constructionSite 	  = new ConstructionSite($db);
$market   		 	  = new Market($db);
$product   			  = new product($db);
$stock_const   		  = new stock_const($db);

$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);


$getstock_consts = $stock_const->fetchAll($cid,$constructionSite->market_id.'-'.$cid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getstock_consts == '-1') {
    print_fiche_titre($langs->trans('ListOfstock_const'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$stock_const->error);
    exit();
}

$morejs  = array("/btp/js/btp.js");
$morecss = array();
llxHeader('', $langs->trans('stock_const'),'','','','',$morejs,$morecss,0,0);

// Fetch both market and construction site

if ($id > 0) {
	$stock_const->fetch($id);
	
	print_barre_liste($langs->trans("stock_const"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'stock_const', $langs->trans("stock_const"), 0, 'submunu');

	$product->fetch($stock_const->fk_product);

	print '<table class="border" width="100%">';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($stock_const->datem,'day').'</td></tr>';
	// produit
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Product").'</td>';
	
	print '<td colspan="2">'. $product->getNomUrl(1) .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. (-1*$stock_const->value) .'</td></tr>';
	
	
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?cid='.$cid.'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'&cid='.$cid.'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./index.php?action=delete&id='. $id .'&cid='.$cid.'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&cid=".$cid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("stock_const"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'stock_const', $langs->trans("stock_const"), 0, 'submunu');
	$moreparam = '&cid='.$cid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="cid" value="'. $cid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datem', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Product"), $_SERVER["PHP_SELF"], 'fk_product', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "value", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("PU"), $_SERVER["PHP_SELF"], 'pu', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("total"), $_SERVER["PHP_SELF"], 'total', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	
	//datec
	print '<td class="liste_titre" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec" readonly="readonly" /> ';
    print '</td>';
	// product
	print '<td class="liste_titre" align="center">';
	print $form->select_produits($search_product,'search_product', 0, 30, 0, 0, 0, '',1);
    print '</td>';
    // qty
	print '<td class="liste_titre" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="1" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" align="center">';
	print '</td>';
	print '<td class="liste_titre" align="center">';
	//print $form->selectarray('search_unit_type', $unitType->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($stock_const->rows)) {
		$total =0;
		foreach($stock_const->rows as $obj) {
			  $inventorycode 				= $obj->inventorycode ;
			  $datec 			= dol_print_date($obj->datem,'day') ;
			  $product->fetch($obj->fk_product);
			  $qty 	   		    = -1*$obj->value ;
			  

			print '<tr '.$bc[$var].'>';
			 
			print '<td align="center">'. $stock_const->getNomUrl(0,$obj->id,$datec,$cid) .'</td>';
			print '<td align="center">'. $product->getNomUrl(1) .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. price($product->pmp) .'</td>';
			$t = $product->pmp * $qty;
			$total+=$t;
			print '<td align="center">'. price($t) .'</td>';
			
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
		}
		print '<tr '.$bc[$var].'>';
		print '<td align="center" colspan="4"><strong>Totat</strong></td>';
		print '<td align="center"><strong>'. price($total) .'</strong></td>';
		print '</tr>'."\n";
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&cid='.$cid.'" class="butAction">'.$langs->trans('Addstock_const').'</a>';
	if (count($stock_const->rows)) {
	print '<a href="./card.php?action=pdf&cid='.$cid.'" class="butAction">Générer Le pdf </a>';
}
	print '</div>';
}

llxFooter();

$db->close();


?>
