<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_coefficients/index.php
 * \ingroup    list
 * \brief      CRUD of work_coefficients
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_coefficients/class/work_coefficients.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$wid 	 = GETPOST('wid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$wid && $request_method !== 'POST')
	die('ID travaux n\'existe pas!');

$error 	= false;
$object  = new MarketWorkCoefficients($db);
$works   = new MarketWorks($db);
$market  = new Market($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    // 	$error++;
    // 	setEventMessage($langs->trans('CantCreate'));
    // } else {
	    $wid 		= (int)trim($_POST['wid']);
	    $supply_fee	= trim($_POST['supply_fee']);
	    $general_fee= trim($_POST['general_fee']);

	    if ($wid <= 0 || !$general_fee) {
			header('Location: ./card.php?action=add&wid='.$wid);
			die();
	    }

	    $object->fk_createdby 	= $user->id;
	    $object->fk_td_work  	= $wid;
	    $object->supply_fee 	= $supply_fee;
	    $object->general_fee	= $general_fee;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&wid='.$wid);
		    die();
		} else {
			header('Location: ./index.php?wid='.$wid);
		    die();
		}
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['wid'] > 0 && $request_method === 'POST') {

	 // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
  //   	$error++;
  //   	setEventMessage($langs->trans('CantCreate'));
  //   } else {
	    $id 		= (int)trim($_POST['id']);
	    $wid 		= (int)trim($_POST['wid']);
	    $supply_fee = trim($_POST['supply_fee']);
	    $general_fee= trim($_POST['general_fee']);

	    if ($id <= 0 || $wid <= 0 || !$general_fee) {
			header('Location: ./index.php?wid='.$wid);
			die();
	    }

	    $data = array(
	    	'supply_fee' => $supply_fee,
		    'general_fee'=> $general_fee,
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&wid='.$wid);
	    die();
	// }

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes'/* && $user->rights->btp->delete*/) {
	$error = 0;
	$wid = GETPOST('wid', 'int');
	$id  = (int) GETPOST('id', 'int');
	
	if (!$wid || !$id)
		return;

	$db->begin();

	$canedit = true/*($user->rights->btp->write_all || $user->rights->btp->delete)*/;

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?wid='.$wid);
	exit;
}

$form = new FormChild($db);
// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

llxHeader(array(), $langs->trans('work_coefficients'),'','','','',array('/btp/js/btp.js'),array(),0,0);
$market->fetch($wid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
 //        $errors[] = $langs->trans('CantCreate');
 //    } else {
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_coefficientsHead  = market_works_prepare_head($works);
		dol_fiche_head($work_coefficientsHead, 'work_coefficients', $langs->trans("supply_fees"), 0, 'submunu');

		// echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired">'.$langs->trans("GeneralFee").'</td><td>';
        print '<input type="text" class="flat" name="general_fee"  required="required" /> '.$langs->getCurrencySymbol($conf->currency).'';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("SupplyFee").'</td><td>';
        print '<input type="text" class="flat" name="supply_fee" /> '.$langs->getCurrencySymbol($conf->currency).'';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateCoefficients") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $wid > 0) {
		$object->fetch($id);
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_coefficientsHead  = market_works_prepare_head($works);
		dol_fiche_head($work_coefficientsHead, 'work_coefficients', $langs->trans("supply_fees"), 0, 'submunu');

		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
			if ($action == 'edit') {
				// echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$supply_fee 	= $object->supply_fee ? $object->supply_fee : '';
				$general_fee= $object->general_fee ? $object->general_fee : '';

				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("GeneralFee").'</td><td>';
		        print '<input type="text" class="flat" name="general_fee" required="required" value="'. $general_fee .'" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("SupplyFee").'</td><td>';
		        print '<input type="text" class="flat" name="supply_fee" value="'. $supply_fee .'" />';
		        print '</td></tr>';
				
		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
