<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/work_equipments/class/work_equipments.class.php
 * \ingroup work_equipments
 * \brief   This file is work_equipments CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class btp
 *
 * MarketWorkEquipments Management class
 */
class MarketWorkEquipments extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see btp::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'td_equipments';
	/**
	 * @var string Name of table without pamortization_marcheix where object is stored
	 */
	public $table_element = 'td_equipments';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_createdby;
	public $fk_td_work;
	public $fk_machine_cat;
	public $fk_unit_type;
	public $equip_num;
	public $unit_cost;
	public $qty;
	public $amortization;
	public $maintenance;
	public $expendable;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape($this->fk_createdby) : 0;
		$this->fk_td_work 	= $this->fk_td_work ? $this->db->escape((int)$this->fk_td_work) : 0;
		$this->fk_machine_cat= $this->fk_machine_cat ? $this->db->escape((int)$this->fk_machine_cat) : 0;
		$this->fk_unit_type	= $this->fk_unit_type ? $this->db->escape((int)$this->fk_unit_type) : 0;
		$this->qty			= $this->qty ? $this->db->escape((int)$this->qty) : 0;
		$this->equip_num 	= $this->equip_num ? $this->db->escape($this->equip_num) : null;
		$this->amortization	= $this->amortization ? $this->db->escape($this->amortization) : null;
		$this->maintenance 	= $this->maintenance ? $this->db->escape($this->maintenance) : null;
		$this->expendable 	= $this->expendable ? $this->db->escape($this->expendable) : null;
		$this->unit_cost	= $this->unit_cost ? $this->db->escape((float)$this->unit_cost) : 0;
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (qty, fk_createdby, fk_td_work, fk_unit_type, created_at, updated_at, fk_machine_cat, equip_num, amortization, maintenance, expendable, unit_cost) VALUES (';
		$sql .= $this->qty .",".$this->fk_createdby.", ".$this->fk_td_work.", ".$this->fk_unit_type.", '".$this->created_at."', '".$this->updated_at ."', ".$this->fk_machine_cat.", '". $this->equip_num ."', '". $this->amortization."', '". $this->maintenance."', '". $this->expendable ."', ". $this->unit_cost .")";

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error work_equipments ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $amortization amortization
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_td_work = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $fk_td_work) {
			$sql .= ' WHERE fk_td_work = ' . $fk_td_work;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_createdby  = $obj->fk_createdby;
				$this->fk_td_work 	 = $obj->fk_td_work;
				$this->fk_machine_cat= $obj->fk_machine_cat;
				$this->fk_unit_type	 = $obj->fk_unit_type;
				$this->equip_num  	 = $obj->equip_num;
				$this->qty   		 = $obj->qty;
				$this->amortization  = $obj->amortization;
				$this->maintenance   = $obj->maintenance;
				$this->expendable  	 = $obj->expendable;
				$this->unit_cost 	 = $obj->unit_cost;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($wid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_td_work = '. $wid;
		} else {
			if (!$ignore_id)
				$sql .= ' WHERE fk_td_work = '. $wid;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			= $obj->rowid;
				$line->fk_createdby = $obj->fk_createdby;
				$line->fk_td_work 	= $obj->fk_td_work;
				$line->fk_machine_cat= $obj->fk_machine_cat;
				$line->fk_unit_type	= $obj->fk_unit_type;
				$line->equip_num 	= $obj->equip_num;
				$line->qty 			= $obj->qty;
				$line->amortization = $obj->amortization;
				$line->maintenance 	= $obj->maintenance;
				$line->expendable 	= $obj->expendable;
				$line->unit_cost	= $obj->unit_cost;
				$line->updated_at 	= $this->db->jdate($obj->updated_at);
				$line->created_at 	= $this->db->jdate($obj->created_at);
				$this->lines[] 		= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $wid = null)
    {
        global $langs;

        $result	= '';
        $setamortization	= '';

        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/work_equipments/index.php?id='. $id .'&wid='. $wid .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

    public function getStatData($wid = false, $market_id = 0)
    {
    	global $langs;
    	$this->fetchAll(($wid ?: null), '', '', 0, 0, '', ($wid ? false : true));
    	$countAmount = 0;

    	foreach ($this->lines as $key => $obj)
    		$countAmount += ($obj->unit_cost*$obj->qty)+$obj->maintenance+$obj->expendable;

    	$object 		= new stdClass();
    	$object->number = (!$wid && $market_id ? 0 : count($this->lines));
    	$object->cost 	= (!$wid && $market_id ? 0 : $countAmount);
    	$object->label 	= $langs->trans('Equipments');
    	$object->url 	= (int)$wid ? DOL_URL_ROOT.'/btp/market/work_equipments/index.php?wid='.$wid.'&mid='. $market_id : '';

    	return $object;
    }
}
