<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_equipments/index.php
 * \ingroup    list
 * \brief      List of work_equipments
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_equipments/class/work_equipments.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_categories/class/MachineCategories.class.php';

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$wid 	  = GETPOST('wid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$wid)
	die("ID de travaux n'existe pas!");

$search_ref       	= GETPOST('search_ref');
$search_machine_cat = GETPOST('search_machine_cat');
$search_unit_type   = GETPOST('search_unit_type');
$search_qty      	= GETPOST('search_qty');
$search_equip_num 	= GETPOST('search_equip_num');
$search_unit_cost 	= GETPOST('search_unit_cost');
$search_amortization= GETPOST('search_amortization');
$search_maintenance	= GETPOST('search_maintenance');
$search_expendable 	= GETPOST('search_expendable');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   	 	= "";
	$search_unit_type   = "";
	$search_machine_cat = "";
    $search_qty 		= "";
	$search_equip_num 	= "";
	$search_unit_cost	= "";
	$search_amortization= "";
	$search_maintenance = "";
	$search_expendable  = "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketWorkEquipments($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$fuser 	 = new User($db);
$unitType= new unitType($db);
$machineCat= new MachineCategories($db);

llxHeader(array(), $langs->trans('Equipments'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";
$filter .= (!empty($search_machine_cat) && $search_machine_cat != -1) ? " AND fk_machine_cat = ". $db->escape((int)$search_machine_cat) : "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND fk_unit_type = ". $db->escape((int)$search_unit_type) : "";
$filter .= !empty($search_qty) ? " AND qty = ". $db->escape((int)$search_qty) : '';
$filter .= !empty($search_equip_num) ? " AND equip_num = '". $db->escape($search_equip_num) ."'" : '';
$filter .= !empty($search_unit_cost) ? " AND unit_cost = ". $db->escape((float)$search_unit_cost) : "";
$filter .= (!empty($search_amortization)) ? " AND amortization = '". $db->escape($search_amortization) ."'" : "";
$filter .= (!empty($search_maintenance)) ? " AND maintenance = '". $db->escape($search_maintenance) ."'" : "";
$filter .= (!empty($search_expendable)) ? " AND expendable = '". $db->escape($search_expendable) ."'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getwork_equipments = $object->fetchAll($wid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_equipments == '-1') {
    print_fiche_titre($langs->trans('Equipments'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

if ($id > 0) {
	$object->fetch($id);
	$head  = market_prepare_head($market);

	print_barre_liste($langs->trans("Equipments"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_equipmentsHead  = market_works_prepare_head($works);
	dol_fiche_head($work_equipmentsHead, 'work_equipments', $langs->trans("Equipments"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$machineCat->fetch($object->fk_machine_cat);
	$unitType->fetch($object->fk_unit_type);
	$qty 		= $object->qty ? $object->qty : '';
	$unit_cost 	= $object->unit_cost ? number_format($object->unit_cost, 2) : '';
	$equip_num 	= $object->equip_num ? $object->equip_num : '';
	$amortization= $object->amortization ? $object->amortization : '';
	$maintenance = $object->maintenance ? $object->maintenance : '';
	$expendable  = $object->expendable ? $object->expendable : '';

	print '<table class="border" width="100%">';
	// User
	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("MachineCategory").'</td>';
	print '<td colspan="2">'. $machineCat->getNomUrl('1', $machineCat->rowid, $machineCat->name) .'</td></tr>';

	// Unit type
	print '<tr><td class="fieldrequired">'.$langs->trans("UnitType").'</td>';
	print '<td colspan="2">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("UnitCost").'</td>';
	print '<td colspan="2">'. $unit_cost .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
	print '<td colspan="2">'. $qty .'</td></tr>';

	// Equip num
	print '<tr><td class="">'.$langs->trans("EquipmentNum").'</td>';
	print '<td colspan="2">'. $equip_num .'</td></tr>';

	// amortization
	print '<tr><td class="">'.$langs->trans("Amortization").'</td>';
	print '<td colspan="2">'. $amortization .'</td></tr>';

	print '<tr><td class="">'.$langs->trans("Maintenance").'</td>';
	print '<td colspan="2">'. $maintenance .'</td></tr>';

	print '<tr><td class="">'.$langs->trans("Expendable").'</td>';
	print '<td colspan="2">'. $expendable .'</td></tr>';

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?wid='. $wid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&wid='. $wid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?wid=".$wid."&id=".$id, $langs->trans("TitleDeleteEquipment"), $langs->trans("ConfirmDeleteEquipment"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("Equipments"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_equipmentsHead  = market_works_prepare_head($works);
	dol_fiche_head($work_equipmentsHead, 'work_equipments', $langs->trans("Equipments"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$moreparam = '&wid='.$wid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="wid" value="'. $wid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("MachineCategory"),$_SERVER["PHP_SELF"], "fk_machine_cat", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("UnitType"), $_SERVER["PHP_SELF"], 'fk_unit_type', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("EquipmentNum"),$_SERVER["PHP_SELF"], 'equip_num', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("UnitCost"), $_SERVER["PHP_SELF"],'unit_cost','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Quantity"), $_SERVER["PHP_SELF"],'qty','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Amortization"), $_SERVER["PHP_SELF"],'amortization','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Maintenance"), $_SERVER["PHP_SELF"],'maintenance','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Expendable"), $_SERVER["PHP_SELF"],'expendable','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center" width="120px">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

    print '<td class="liste_titre" align="center">';
	print $form->selectarray("search_machine_cat", $machineCat->getNames(), $search_machine_cat,1);
    print '</td>';

	print '<td class="liste_titre" align="center">';
    print $form->selectarray("search_unit_type", $unitType->getNames(), $search_unit_type, 1);
	print '</td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_equip_num" value="'.$search_equip_num.'" /></td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="20" name="search_unit_cost" value="'.$search_unit_cost.'"></td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="number" size="14" name="search_qty" value="'.$search_qty.'" min="1" /></td>';

	print '<td class="liste_titre" align="center"><input class=" center" type="text" size="20" name="search_amortization" value="'.$search_amortization.'"></td>';
	
	print '<td class="liste_titre" align="center"><input class=" center" type="text" size="20" name="search_maintenance" value="'.$search_maintenance.'"></td>';
	
	print '<td class="liste_titre" align="center"><input class=" center" type="text" size="20" name="search_expendable" value="'.$search_expendable.'"></td>';
	
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$machineCat->fetch($db->escape($line->fk_machine_cat));
			$unitType->fetch($line->fk_unit_type);
			
			$equip_num	 = $line->equip_num ? $line->equip_num : '';
			$unit_cost	 = $line->unit_cost ? number_format($line->unit_cost, 2) : '';
			$qty 		 = $line->qty ? $line->qty : '';
			$amortization= $line->amortization ? $line->amortization : '';
			$maintenance = $line->maintenance ? $line->maintenance : '';
			$expendable  = $line->expendable ? $line->expendable : '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $object->getNomUrl(1,  $line->id, $line->fk_td_work);
			print '</td>';
			print '<td align="center">';
				print $machineCat->getNomUrl('1', $machineCat->rowid, $machineCat->name);
			print '</td>';
			print '<td align="center">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td>';
			print '<td align="center">'. $equip_num .'</td>';
			print '<td align="center">'. $unit_cost .' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $amortization .'</td>';
			print '<td align="center">'. $maintenance .'</td>';
			print '<td align="center">'. $expendable .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="10" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="10" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&wid='. $wid .'" class="butAction">'.$langs->trans('AddEquipment').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>