<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_supplies/index.php
 * \ingroup    list
 * \brief      CRUD of work_supplies
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_supplies/class/work_supplies.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$wid 	 = GETPOST('wid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$wid && $request_method !== 'POST')
	die('ID travaux n\'existe pas!');

$error 	= false;
$object  = new MarketWorkSupplies($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$productObj = new Product($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    // 	$error++;
    // 	setEventMessage($langs->trans('CantCreate'));
    // } else {

	    $handling		 	= trim($_POST['handling']);
	    $product 			= trim($_POST['product_supply']);
	    $wid 				= (int)trim($_POST['wid']);
    	$transport			= trim($_POST['transport']);
    	$qty_product		= (int)trim($_POST['qty_product']);
    	$charge_supplment	= (float)trim($_POST['charge_supplment']);

	    if ($wid <= 0 || $product <= 0 || $qty_product <= 0) {
			header('Location: ./card.php?action=add&wid='.$wid);
			die();
	    }

	    $object->fk_createdby 		= $user->id;
	    $object->fk_td_work  		= $wid;
	    $object->fk_product			= $product;
	    $object->transport 			= $transport;
	    $object->handling 			= $handling;
	    $object->qty_product 		= $qty_product;
	    $object->charges_supplement	= $charge_supplment;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&wid='.$wid);
		    die();
		} else {
			header('Location: ./index.php?wid='.$wid);
		    die();
		}
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['wid'] > 0 && $request_method === 'POST') {

	 // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
  //   	$error++;
  //   	setEventMessage($langs->trans('CantCreate'));
  //   } else {
	    $id 				= (int)trim($_POST['id']);
	    $wid 				= (int)trim($_POST['wid']);
	    $handling		 	= trim($_POST['handling']);
	    $product 			= trim($_POST['product_supply']);
    	$transport			= trim($_POST['transport']);
    	$qty_product		= (int)trim($_POST['qty_product']);
    	$charge_supplment	= (float)trim($_POST['charge_supplment']);

	    if ($wid <= 0 || $id <= 0 || $product <= 0 || $qty_product <= 0) {
			header('Location: ./index.php?wid='.$wid);
			die();
	    }

	    $data = array(
		    'fk_product'		 => $product,
		    'transport' 		 => $transport,
		    'handling' 			 => $handling,
		    'qty_product' 		 => $qty_product,
		    'charges_supplement' => $charge_supplment,
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&wid='.$wid);
	    die();
	// }

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes'/* && $user->rights->btp->delete*/) {
	$error = 0;
	$wid = GETPOST('wid', 'int');
	$id  = (int) GETPOST('id', 'int');
	
	if (!$wid || !$id)
		return;

	$db->begin();

	$canedit = true/*($user->rights->btp->write_all || $user->rights->btp->delete)*/;

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?wid='.$wid);
	exit;
}

$form = new FormChild($db);
// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

llxHeader(array(), $langs->trans('work_supplies'),'','','','',array('/btp/js/btp.js'),array(),0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
 //        $errors[] = $langs->trans('CantCreate');
 //    } else {
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_suppliesHead  = market_works_prepare_head($works);
		dol_fiche_head($work_suppliesHead, 'work_supplies', $langs->trans("Supplies"), 0, 'submunu');

		// echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Supply").'</td><td>';

    	print $form->select_produits_list('', "product_supply", 0, 30, 0, '', 0, 2);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
        print '<input type="number" class="flat" name="qty_product" min="1" />';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("Transport").'</td><td>';
        print '<input type="text" class="flat" name="transport" />';
        print '</tr>';

        print '<tr><td class="">'.$langs->trans("Handling").'</td><td>';
        print '<input type="text" class="flat" name="handling" />';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("ChargesSupplement").'</td><td>';
        print '<input type="text" class="flat" name="charge_supplment" /> '.$langs->getCurrencySymbol($conf->currency);
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateSupply") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $wid > 0) {
		$object->fetch($id);
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_suppliesHead  = market_works_prepare_head($works);
		dol_fiche_head($work_suppliesHead, 'work_supplies', $langs->trans("Supplies"), 0, 'submunu');

		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
			if ($action == 'edit') {
				// echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$handling	= $object->handling ? $object->handling : '';
				$qty_product= $object->qty_product ? $object->qty_product : '';
				$transport	= $object->transport ? $object->transport : '';
				$charge_supplment	= $object->charges_supplement ? $object->charges_supplement : '';
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

				print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Supply").'</td><td>';
		    	print $form->select_produits_list($object->fk_product, "product_supply", 0, 30, 0, '', 0, 2);
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
		        print '<input type="number" class="flat" name="qty_product" min="1" value="'. $qty_product .'" />';
		        print '</td></tr>';

		        print '<tr><td class="">'.$langs->trans("Transport").'</td><td>';
		        print '<input type="text" class="flat" name="transport" value="'. $transport .'" />';
		        print '</tr>';

		        print '<tr><td class="">'.$langs->trans("Handling").'</td><td>';
		        print '<input type="text" class="flat" name="handling" value="'. $handling .'" />';
		        print '</td></tr>';

		        print '<tr><td class="">'.$langs->trans("ChargesSupplement").'</td><td>';
		        print '<input type="text" class="flat" name="charge_supplment" value="'. $charge_supplment .'" /> '.$langs->getCurrencySymbol($conf->currency);

		        print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
