<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/works/index.php
 * \ingroup    list
 * \brief      CRUD of works
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marché n\'existe pas!');


$error 	= false;
$object = new Marketworks($db);
$market = new Market($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    // 	$error++;
    // 	setEventMessage($langs->trans('CantCreate'));
    // } else {

	    $task		 = trim($_POST['task']);
	    $unit_type = trim($_POST['unit_type']);
	    $mid 			 = (int)trim($_POST['mid']);
    	$price		 	 = (float)trim($_POST['price']);
    	$qty		 	 = (int)trim($_POST['qty']);

	    if (!$mid || !$task || $unit_type < 0 || !$price || !$qty) {
			header('Location: ./card.php?action=add&mid='.$mid);
			die();
	    }

	    $object->fk_createdby 	= $user->id;
	    $object->fk_market  	= $mid;
	    $object->fk_unit_type	= $unit_type;
	    $object->price 			= $price;
	    $object->task 			= $task;
	    $object->qty 			= $qty;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	 // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
  //   	$error++;
  //   	setEventMessage($langs->trans('CantCreate'));
  //   } else {
	    $task		= trim($_POST['task']);
	    $unit_type 	= trim($_POST['unit_type']);
	    $mid 		= (int)trim($_POST['mid']);
    	$price		= (float)trim($_POST['price']);
    	$qty		= (int)trim($_POST['qty']);

	    if (!$task || $unit_type < 0 || !$price || !$qty) {
			header('Location: ./index.php?mid='.$mid);
			return;
	    }

	    $data = array(
	    	'fk_unit_type'=> $unit_type,
		    'price' 	  => $price,
		    'task' 		  => $task,
		    'qty' 		  => $qty,
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid);
	    die();
	// }

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes'/* && $user->rights->btp->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = true/*($user->rights->btp->write_all || $user->rights->btp->delete)*/;

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?mid='.$mid);
	exit;
}

$form = new Form($db);
$unitType= new unitType($db);

llxHeader(array(), $langs->trans('works'),'','','','',array('/btp/js/btp.js'),array(),0,0);
$market->fetch($mid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
 //        $errors[] = $langs->trans('CantCreate');
 //    } else {
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Task").'</td><td>';
        print '<input type="text" class="" value="" name="task" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("UnitType").'</td><td>';
    	print $form->selectarray("unit_type", $unitType->getNames(), '', 1);
        print '</tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Price").'</td><td>';
        print '<input type="text" class="flat" name="price" /> '.$langs->getCurrencySymbol($conf->currency);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
        print '<input type="number" class="flat" name="qty" min="1" />';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateWork") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("works"), 0, '');

		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
			if ($action == 'edit') {
				echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$unit_type  = $object->fk_unit_type ?: 0;
				$task	 	= $object->task ?: '';
				$price		= $object->price ?: '';
				$qty		= $object->qty ?: '';
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

				print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Task").'</td><td>';
		        print '<input type="text" class="" value="'. $task .'" name="task" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("UnitType").'</td><td>';
		    	print $form->selectarray("unit_type", $unitType->getNames(), $unit_type, 1);
		        print '</tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Price").'</td><td>';
		        print '<input type="text" class="flat" value="'. $price .'" name="price" /> '.$langs->getCurrencySymbol($conf->currency);
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
		        print '<input type="number" class="flat" value="'. $qty .'" name="qty" min="1" />';
		        print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
