<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/constraction_site/class/constraction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
// Get parameters
$machines = array(1 => 'marché 1', 2 => 'marché 2');
$User = new User($db);
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$constraction_site = new constraction_site($db);

    if (!$error) {
          $constraction_site->name           = trim(GETPOST('name_'));
          $constraction_site->adress           = trim(GETPOST('adress_'));
          $constraction_site->amount            = trim(GETPOST('amount_'));
          $constraction_site->tel           = trim(GETPOST('tel_'));
          $constraction_site->market_id     = trim(GETPOST('market_id_'));
          $constraction_site->head_site_id  = trim(GETPOST('head_site_id_'));
          $constraction_site->pointer_id  = trim(GETPOST('pointer_id_'));
          $constraction_site->created_by     = $user->id;
            //if(!$constraction_site->check_mat($constraction_site->mat)){
                    $constraction_siteID = $constraction_site->create();
            
                    // If no SQL error we redirect to the request card
                    if ($constraction_siteID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$constraction_site->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$constraction_site->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $constraction_site_id = (int) GETPOST('constraction_site_id', 'int');

    if (!$constraction_site_id || $constraction_site_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $constraction_site = new constraction_site($db);
    $constraction_site->fetch($constraction_site_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $data = array(
          'name'      =>trim(GETPOST('name_')),
          'adress'    =>trim(GETPOST('adress_')),
          'amount'    =>trim(GETPOST('amount_')),
          'tel'      =>trim(GETPOST('tel_')),
          'market_id' =>trim(GETPOST('market_id_')),
          'head_site_id'  =>trim(GETPOST('head_site_id_')),
          'pointer_id'  =>trim(GETPOST('pointer_id_')),
          'updated_at'    =>$now
        );

		$getconstraction_siteID = $constraction_site->update($constraction_site_id, $data);
        
                if ($getconstraction_siteID > 0) {
                    header('Location: ./index.php?id='.$constraction_site_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $constraction_site_id .'&action=edit&error=SQL_Create&msg='.$constraction_site->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new constraction_site($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$constraction_site     = new constraction_site($db);
$market     = new Market($db);


$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/constraction_site.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('constraction_site'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addconstraction_site'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';


       //nom
        print '<tr><td class="fieldrequired">'.$langs->trans("name").'</td><td>';
        print '<input type="text" value="" name="name_" required="required" />';
        print '</td></tr>';

        //amount
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="text" value="" name="amount_" required="required" />';
        print '</td></tr>';

        //adress
        print '<tr><td class="fieldrequired">'.$langs->trans("adress").'</td><td>';
        print '<input type="text" value="" name="adress_" required="required" />';
        print '</td></tr>';

        
        //Engin 
        print '<tr><td>'.$langs->trans("market").'</td><td>'; 
        print $form->selectarray('market_id_', $market->getNames(),(GETPOST('market_id_') ? GETPOST('market_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       //tel 
        print '<tr><td class="fieldrequired">'.$langs->trans("tel").'</td><td>';
        print '<input type="text" value="" name="tel_" required="required" />';
        print '</td></tr>';


        //Chef chantier 
        print '<tr><td>'.$langs->trans("head_site").'</td><td>'; 
        print $form->select_dolusers(null,'head_site_id_');
        print '</td></tr>';

        //pointer 
        print '<tr><td>'.$langs->trans("pointer").'</td><td>'; 
        print $form->select_dolusers(null,'pointer_id_');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createconstraction_site") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $constraction_site->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndnameP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
                if ($action == 'delete') {
                    $constraction_site->fetch($id);
    print_fiche_titre($langs->trans("constraction_site"));

print '<table class="border" width="100%">';
    // amount
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
    print '<td colspan="2">'. $constraction_site->amount .'</td></tr>';
    // date
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("name").'</td>';
    print '<td colspan="2">'. $constraction_site->name .'</td></tr>';
    // compteur
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("adress").'</td>';
    print '<td colspan="2">'. $constraction_site->adress .'</td></tr>';
    // quantité
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tel").'</td>';
    print '<td colspan="2">'. $constraction_site->tel .'</td></tr>';
    // Engin
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("market").'</td>';
    $market->fetch($constraction_site->market_id);
    print '<td colspan="2">'. $market->getNomUrl(1,$market->id,$market->code) .'</td></tr>';
    // chef chantier 
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("head_site").'</td>';
    $User->fetch($constraction_site->head_site_id);
    print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
    // pointeur 
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("pointer").'</td>';
    $User->fetch($constraction_site->pointer_id);
    print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
    
    print '</table>';
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'constraction_sites', $langs->trans("constraction_site"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="constraction_site_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';



        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("name").'</td><td>';
        print '<input type="text" value="'.$constraction_site->name.'" name="name_" required="required" />';
        print '</td></tr>';

        //adress
        print '<tr><td class="fieldrequired">'.$langs->trans("adress").'</td><td>';
        print '<input type="text" value="'.$constraction_site->adress.'" name="adress_" required="required" />';
        print '</td></tr>';

        //amountéro
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="text" value="'.$constraction_site->amount.'" name="amount_" required="required" />';
        print '</td></tr>';

        //marché 
        print '<tr><td>'.$langs->trans("market").'</td><td>'; 
        print $form->selectarray('market_id_', $market->getNames(),(GETPOST('market_id_') ? GETPOST('market_id_') : $constraction_site->market_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       //tel 
        print '<tr><td class="fieldrequired">'.$langs->trans("tel").'</td><td>';
        print '<input type="text" value="'.$constraction_site->tel.'" name="tel_" required="required" />';
        print '</td></tr>';

        //chef Chantier 
        print '<tr><td>'.$langs->trans("head_site").'</td><td>'; 
        print $form->select_dolusers($constraction_site->head_site_id,'head_site_id_');
        print '</td></tr>';

        //pointer 
        print '<tr><td>'.$langs->trans("pointer").'</td><td>'; 
        print $form->select_dolusers($constraction_site->pointer_id,'pointer_id_');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>