<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/constraction_site/class/constraction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';


$form 		= new Form($db);
$market     = new Market($db);
$constraction_site   = new constraction_site($db);
$User = new User($db);

$var = false;
$filter = '';
$machines = array(1 => 'marché 1', 2 => 'marché 2');
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$search_name      		= GETPOST('search_name');
$search_amount      		= GETPOST('search_amount');
$search_adress    		= GETPOST('search_adress');
$search_tel    		= GETPOST('search_tel');
$search_market    		= GETPOST('search_market');
$search_head_site    		= GETPOST('search_head_site');
$search_pointer    		= GETPOST('search_pointer');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_name      		= '';
$search_amount      		= '';
$search_adress    		= '';
$search_tel    		= '';
$search_market    		= '';
$search_head_site    		= '';
$search_pointer    		= '';
}
$filter .= (!empty($search_name) && $search_name != -1) ? " AND name = '". $db->escape($search_name)."'\n" : "";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " AND amount = ".$db->escape($search_amount):"";
$filter .= (!empty($search_adress) && $search_adress != -1) ? " AND adress = '".$db->escape($search_adress)."'\n" : "";
$filter .= (!empty($search_tel) && $search_tel != -1) ? " AND tel = '".$db->escape($search_tel)."'\n" : "";
$filter .= (!empty($search_market) && $search_market != -1) ? " AND market_id = '".$db->escape($search_market)."'\n" : "";
$filter .= (!empty($search_head_site) && $search_head_site != -1) ? " AND head_site_id = '".$db->escape($search_head_site)."'\n" : "";
$filter .= (!empty($search_pointer) && $search_pointer != -1) ? " AND pointer_id = '".$db->escape($search_pointer)."'\n" : "";


$getconstraction_sites = $constraction_site->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconstraction_sites == '-1') {
    print_fiche_titre($langs->trans('ListOfconstraction_site'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$constraction_site->error);
    exit();
}
if ($id > 0) {
	$constraction_site->fetch($id);
	llxHeader('', $langs->trans('constraction_site'));
	print_fiche_titre($langs->trans("constraction_site"));


	print '<table class="border" width="100%">';
	// amount
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
	print '<td colspan="2">'. $constraction_site->amount .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("name").'</td>';
	print '<td colspan="2">'. $constraction_site->name .'</td></tr>';
	// compteur
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("adress").'</td>';
	print '<td colspan="2">'. $constraction_site->adress .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tel").'</td>';
	print '<td colspan="2">'. $constraction_site->tel .'</td></tr>';
	// Engin
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("market").'</td>';
	$market->fetch($constraction_site->market_id);
	print '<td colspan="2">'. $market->getNomUrl(1,$market->id,$market->code) .'</td></tr>';
	// chef chantier 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("head_site").'</td>';
	$User->fetch($constraction_site->head_site_id);
	print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
	// pointeur 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("pointer").'</td>';
	$User->fetch($constraction_site->pointer_id);
	print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '</div>';
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('constraction_site'));
print_fiche_titre($langs->trans("ListOfconstraction_site"));


	dol_fiche_head('', 'constraction_site', $langs->trans("ListOfconstraction_site"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("name"),$_SERVER["PHP_SELF"],"name", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("amount"), $_SERVER["PHP_SELF"], 'amount', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("adress"), $_SERVER["PHP_SELF"], 'adress', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tel"),$_SERVER["PHP_SELF"], "tel", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("market"), $_SERVER["PHP_SELF"], 'market_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("head_site"), $_SERVER["PHP_SELF"], 'head_site_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("pointer"), $_SERVER["PHP_SELF"], 'pointer_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="10" name="search_name" value="'.$search_name.'">';
	print '</td>';
	// amount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// adress
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" type="text" size="10" name="search_adress" value="'.$search_adress.'">';
	print '</td>';
	// tel
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" type="text" size="10" name="search_tel" value="'.$search_tel.'">';
	print '</td>';
	// marché
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_market', $market->getNames(), $search_market, 1, 0, 0, 'required="required"');
	print '</td>';
	// head_site
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_head_site,'search_head_site');
    print '</td>';
    // pointer
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_pointer,'search_pointer');
    print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($constraction_site->rows)) {
		//$createdBy = new User($db);
		foreach($constraction_site->rows as $obj) {
			  $amount 		    = $obj->amount ;
			  $name 			= $obj->name ;
			  $adress 			= $obj->adress ;
			  $tel 	   	        = $obj->tel ;
			  $market->fetch($obj->market_id) ;
			  $head_site = $User->firstname.' '.$User->lastname;
			  $pointer = $User->firstname.' '.$User->lastname;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $constraction_site->getNomUrl(1,  $obj->id, $name);
			print '</td>';
			 
			print '<td align="center">'. $amount .'</td>';
			print '<td align="center">'. $adress .'</td>';
			print '<td align="center">'. $tel .'</td>';
			print '<td align="center">'. $market->getNomUrl(1, $market->id,$market->code) .'</td>';
			$User->fetch($obj->head_site_id);
			print '<td align="center">'. $User->getNomUrl(1) .'</td>';
			$User->fetch($obj->pointer_id);
			print '<td align="center">'. $User->getNomUrl(1) .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '<a href="./card.php?action=delete&id='. $obj->id .'" >'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addconstraction_site').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>