<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/tools_type/class/ToolsType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/defect_machine/class/defect_machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/defects/class/Defects.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/defects_claims/class/DefectsClaims.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';

$form 		= new Form($db);
$defect_clm 	  = new DefectsClaims($db);
$machine = new machine($db);
$defect_machine = new defect_machine($db);
$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_machine     = GETPOST('search_machine');
$search_ref     	= GETPOST('search_ref');
$search_defect     	= GETPOST('search_defect');
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$did 	  = GETPOST('did','int');

$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= " AND defect_machine_id = ".$did;
$filter .= (!empty($search_defect) && $search_defect != -1) ? " AND defect_id= '".$db->escape($search_defect)."'\n" : "";
$defect_clm->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if ($id > 0) {
	//$event->fetch($id);
	llxHeader('', $langs->trans('event'));
	//dol_fiche_head('', 'events', $langs->trans("event"), 0, '');
	
	$defect_clm->fetch($id);

	$defect_machine->fetch($did);
	$machine->fetch($defect_machine->machine_id);
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'defect_machine', $langs->trans('defect_machine'), 0, '');
	$defect  = defect_prepare_head($defect_machine);
	dol_fiche_head($defect, 'defects_claims', $langs->trans("defects_claims"), 0, '');
	
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
	print '<td colspan="2">'. $defect_clm->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("defects").'</td>';
	$def= new Defects($db);
	$def->fetch($defect_clm->defect_id);
	print '<td colspan="2">'. $def->getNomUrl('1',$def->id,$did) .'</td></tr>';
   /* print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Defect Machine").'</td>';
    $machine=new defect_machine($db);
              $machine->fetch($defect_clm->defect_machine_id); 
			
	print '<td colspan="2">'. $machine->getNomUrl('1') .'</td></tr>';*/

	// date de pointage

	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?did='. $did .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&did='.$did.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&did='.$did.'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id."&did=".$did, $langs->trans("TitleDeleteT"),$langs->trans("ConfirmDeleteT"),"confirm_delete", '', 0, 1);
                }

	
}
else {

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_machine      			= "";
	$search_defect     	= "";
	$search_ref     	= "";

}

llxHeader('', $langs->trans('list_claim_defect'));
//$listevents = $event->findAll();
	$defect_machine->fetch($did);
	$machine->fetch($defect_machine->machine_id);
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'defect_machine', $langs->trans('defect_machine'), 0, '');
	$defect  = defect_prepare_head($defect_machine);
	dol_fiche_head($defect, 'defects_claims', $langs->trans("defects_claims"), 0, '');
	$moreparam = '&did='.$did;
   	

	
	$card="card.php";

	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="did" value="'. $did .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Refe"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("defect"),$_SERVER["PHP_SELF"],"name", '',$moreparam,'align="center"',$sortfield,$sortorder);
	//print_liste_field_titre($langs->trans("Defect Machine"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"], '', $moreparam, '', 'align="center"', $sortfield, $sortorder);
	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	// défaut
	print '<td class="liste_titre" colspan="1" align="center">';
	$deft= new Defects($db);
   print '<select name="search_defect"     id="nomer"/>';
	    $pe='';
        $deft->fetchall(); 
         print '<option></option>';
        if (count($deft->rows)) {
        foreach($deft->rows as $line) {
        	if ($search_defect) {
  	 if ($line->rowid==$search_defect){ $pe=' selected="selected"';
  }}
       print '<option  value="'.$line->rowid.'"'.$pe.'>'.$line->name.'</option>';
      $pe='';
        }
    }
    print '</select>';
	print '</td>';

	// Date
	/*print '<td class="liste_titre" align="left" width="50">';    
        print '<select name="search_machine"     id="nomer"/>';
        $pa='';
        $evt   = new defect_machine($db);
        $evt->fetchall();  print '<option></option>';
        if (count($evt->rows)) {
      
        foreach($evt->rows as $line) {
        	if ($search_machine) {
  	 if ($line->id==$search_machine){ $pa='selected="selected"';
  }}
       print '<option  value="'.$line->id.'"'.$pa.'>'.$line->description.'</option>';
      $pa='';
        }
    }
   print '</select>';
	
	print '</td>';*/
	
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";
	// Lines
	if (count($defect_clm->rows)) {
		foreach($defect_clm->rows as $line) {
			$var = !$var;
			$subject = '';
			$fullSubject = '';
			$rowid=$line->rowid;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $defect_clm->getNomUrl(1,$line->rowid,$did, $rowid);
			print '</td>';
			// desfect
			$def= new Defects($db);
			$def->fetch($line->defect_id); 
			print '<td align="center">'.$def->getNomUrl('1',$def->id,$did).'</td>';
				//$machines= new defect_machine($db);
			    //$machines->fetch($line->defect_machine_id); 
			

			//print '<td align="center">'.$machines->getNomUrl('1').'</td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&did='.$did.'" class="butAction">'.$langs->trans('ajoutdefect').'</a>';
		print '</div>';


}
print '</table>';
	print '</form>';































llxFooter();

$db->close();


?>
