<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/exit_spares/class/exit_spares.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
include_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';


$societe     = new Societe($db);
$produit   = new product($db);

// Get parameters
$action  = GETPOST('action', 'alpha');
$mid      = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$exit_spares = new exit_spares($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $exit_spares->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
          $exit_spares->qty            = trim(GETPOST('qty_'));
          $exit_spares->designation            = trim(GETPOST('designation_'));
          $exit_spares->machine_id            = (int)$mid;
          $exit_spares->ref     = trim(GETPOST('ref_'));
          $exit_spares->price     = trim(GETPOST('price_'));
          $exit_spares->supplier_id  = trim(GETPOST('supplier_id_'));
          $exit_spares->product_id  = trim(GETPOST('product_id_'));
          $exit_spares->const_site_id  = trim(GETPOST('const_site_id_'));
          $exit_spares->created_by     = $user->id;
            //if(!$exit_spares->check_mat($exit_spares->mat)){
                    $exit_sparesID = $exit_spares->create();
            
                    // If no SQL error we redirect to the request card
                    if ($exit_sparesID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?mid='.$mid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$exit_spares->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$exit_spares->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $exit_spares_id = (int) GETPOST('exit_spares_id', 'int');

    if (!$exit_spares_id || $exit_spares_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $exit_spares = new exit_spares($db);
    $exit_spares->fetch($exit_spares_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $datec = '';
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'datec'  =>$datec,
          'qty'    =>trim(GETPOST('qty_')),
          'designation'    =>trim(GETPOST('designation_')),
          'machine_id'    =>(int)$mid,
          'ref' =>trim(GETPOST('ref_')),
          'price' =>trim(GETPOST('price_')),
          'supplier_id'  =>trim(GETPOST('supplier_id_')),
          'const_site_id'  =>trim(GETPOST('const_site_id_')),
          'product_id'  =>trim(GETPOST('product_id_'))
        );

		$getexit_sparesID = $exit_spares->update($exit_spares_id, $data);
        
                if ($getexit_sparesID > 0) {
                    header('Location: ./index.php?id='.$exit_spares_id.'&mid='.$mid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $exit_spares_id .'&action=edit&error=SQL_Create&msg='.$exit_spares->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new exit_spares($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$exit_spares     = new exit_spares($db);
$machine     = new machine($db);
$ConstructionSite     = new ConstructionSite($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('exit_spares'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("exit_spares"));
    $machine->fetch($mid);
        $head = material_prepare_head($machine);
        dol_fiche_head($head, 'exit_spares', $langs->trans('exit_spares'), 0, '');
         $html .= '<table class="border" width="100%">';    
        $html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addexit_spares'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?mid='.$mid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //reference 
        print '<tr><td>'.$langs->trans("ref").'</td><td>'; 
        print '<input type="text" value="" name="ref_" required="required" />';
        print '</td></tr>';

       //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //qty
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="" name="qty_" required="required" />';
        print '</td></tr>';

        //designation
        print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
        print '<input type="text" value="" name="designation_" required="required" />';
        print '</td></tr>';

        //engin
        /*print '<tr><td class="fieldrequired">'.$langs->trans("machine").'</td><td>';
         $machines = $machine->getMats();
        print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

         //prix 
        print '<tr><td>'.$langs->trans("price").'</td><td>'; 
        print '<input type="number" step="0.01" min="0" value="" name="price_" required="required" />';
        print '</td></tr>';
        
         //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits_list(null,'product_id_', 0, 30, 0, '', 0, 2);
        print '</td></tr>';

        //fournisseur 
        print '<tr><td>'.$langs->trans("supplier").'</td><td>'; 
        print  $form->select_thirdparty(null,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createexit_spares") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $exit_spares->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddatecP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
                

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'exit_sparess', $langs->trans("exit_spares"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&mid='.$mid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="exit_spares_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';



        //chantier 
        print '<tr><td>'.$langs->trans("ref").'</td><td>'; 
        print '<input type="text" value="'.$exit_spares->ref.'" name="ref_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($exit_spares->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';


        //qty
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="'.$exit_spares->qty.'" name="qty_" required="required" />';
        print '</td></tr>';

        //designation
        print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
        print '<input type="text" value="'.$exit_spares->designation.'" name="designation_" required="required" />';
        print '</td></tr>';

        //engin
        /*print '<tr><td class="fieldrequired">'.$langs->trans("machine").'</td><td>';
         $machines = $machine->getMats();
        print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : $exit_spares->machine_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

        //chantier 
        print '<tr><td>'.$langs->trans("price").'</td><td>'; 
        print '<input type="number" step="0.01" min="0" value="'.$exit_spares->price.'" name="price_" required="required" />';
        print '</td></tr>';

         //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits_list($exit_spares->product_id,'product_id_', 0, 30, 0, '', 0, 2);
        print '</td></tr>';


        //fournisseur 
        print '<tr><td>'.$langs->trans("supplier").'</td><td>'; 
        print  $form->select_thirdparty($exit_spares->supplier_id,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $exit_spares->const_site_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';




                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>