<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/fuel_consoma/class/fuel_consoma.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/fuel/class/fuel.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';

$form 		= new Form($db);
$fuel_consoma   = new fuel_consoma($db);
$ConstructionSite   = new ConstructionSite($db);
$machine   = new machine($db);
$fuel   = new fuel($db);
$var = false;
$filter = '';
$types_fuel_consomas = array(1 => $langs->trans('track'), 2 => $langs->trans('other'));
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid', 'int');
$action  = GETPOST('action', 'alpha');
$search_num     		= GETPOST('search_num');
$search_datec      		= '';
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_counter    		= GETPOST('search_counter');
$search_hours_worked    		= GETPOST('search_hours_worked');
$search_price    		= GETPOST('search_price');
$search_hours_rate    		= GETPOST('search_hours_rate');
$search_qty    		= GETPOST('search_qty');
$search_const_site    		= GETPOST('search_const_site');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_num      		= '';
$search_datec      		= '';
$search_counter    		= '';
$search_hours_worked    		= '';'';
$search_price    		= '';
$search_hours_rate    		= '';
$search_qty    		= '';
$search_const_site    		= '';
}
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = ". $db->escape($search_num) : "";
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_counter) && $search_counter != -1) ? " AND counter = '".$db->escape($search_counter)."'\n" :"";
$filter .= (!empty($search_hours_worked) && $search_hours_worked != -1) ? " AND hours_worked = ".$db->escape($search_hours_worked) : "";
$filter .= (!empty($search_price) && $search_price != -1) ? " AND price = ".$db->escape($search_price) : "";
$filter .= (!empty($search_hours_rate) && $search_hours_rate != -1) ? " AND hours_rate = ".$db->escape($search_hours_rate) : "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty) : "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape($search_const_site) : "";
$filter .= " AND machine_id = ".$mid;

$getfuel_consomas = $fuel_consoma->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getfuel_consomas == '-1') {
    print_fiche_titre($langs->trans('ListOffuel_consoma'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$fuel_consoma->error);
    exit();
}
if ($id > 0) {
	$fuel_consoma->fetch($id);
	$machine->fetch($mid);
	llxHeader('', $langs->trans('fuel_consoma'));
	print_fiche_titre($langs->trans("fuel_consoma"));
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'fuel_consoma', $langs->trans('fuel_consoma'), 1, '');
   		$html = '<table class="border" width="100%">';
		$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
		$html .= '<td colspan="2">'. $machine->code .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
		$html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
	$html .= '</table><br />';
	echo $html;
	   	print_fiche_titre($langs->trans("fuel_consoma"));

	print '<table class="border" width="100%">';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
	print '<td colspan="2">'. $fuel_consoma->num .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($fuel_consoma->datec,'day') .'</td></tr>';
	// compteur
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("counter").'</td>';
	print '<td colspan="2">'. $fuel_consoma->counter .'</td></tr>';
	//Engin
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch($fuel_consoma->machine_id);
	print '<td colspan="2">'. $machine->getNomUrl(1) .'</td></tr>';*/
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $fuel_consoma->qty .'</td></tr>';
	// prix
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
	print '<td colspan="2">'. $fuel_consoma->price .'</td></tr>';
	// heures travaillés 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("hours_worked").'</td>';
	print '<td colspan="2">'. $fuel_consoma->hours_worked .'</td></tr>';
	// tarif heure
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("hours_rate").'</td>';
	print '<td colspan="2">'. $fuel_consoma->hours_rate .'</td></tr>';
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("constraction_site").'</td>';
	$ConstructionSite->fetch($fuel_consoma->const_site_id);
	print '<td colspan="2">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='.$mid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&mid='.$mid.'" class="butAction" >'.$langs->trans('Delete').'</a>';
	print '</div>';
	 if ($action == 'delete') {
                print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('fuel_consoma'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOffuel_consoma"));
	$machine->fetch($mid);
	$head = material_prepare_head($machine);
   	dol_fiche_head($head, 'fuel_consoma', $langs->trans('ListOffuel_consoma'), 1, '');
   	$moreparam = '&mid='.$mid;

   	$html = '<table class="border" width="100%">';
		$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
		$html .= '<td colspan="2">'. $machine->code .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
		$html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
	$html .= '</table><br />';
	echo $html;

	//dol_fiche_head('', 'fuel_consoma', $langs->trans("ListOffuel_consoma"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="mid" value="'. $mid .'" type="hidden" />';
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("num"),$_SERVER["PHP_SELF"],"num", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("counter"), $_SERVER["PHP_SELF"], 'counter', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	//print_liste_field_titre($langs->trans("machine"), $_SERVER["PHP_SELF"], 'machine_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "qty", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("price"),$_SERVER["PHP_SELF"],"price", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("total"),$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("hours_worked"), $_SERVER["PHP_SELF"], 'hours_worked', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("hours_rate"), $_SERVER["PHP_SELF"], 'hours_rate', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ConstructionSite"), $_SERVER["PHP_SELF"], 'const_site_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_num" value="'.$search_num.'">';
	print '</td>';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
    // counter
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text"  name="search_counter" value="'.$search_counter.'">';
	print '</td>';
	// engin
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';*/
	// qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// price
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_price" value="'.$search_price.'">';
	print '</td>';
	// total
	print '<td class="liste_titre" olspan="1" align="center">';
	print '</td>';
	// hours_worked
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_hours_worked" value="'.$search_hours_worked.'">';
	print '</td>';
	// hours_rate
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_hours_rate" value="'.$search_hours_rate.'">';
	print '</td>';
	// const_site
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $ConstructionSite->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';


	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($fuel_consoma->rows)) {
		//$createdBy = new User($db);
		foreach($fuel_consoma->rows as $obj) {
			  $num 				= $obj->num ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $counter 			= $obj->counter ;
			  $qty 	   		    = $obj->qty ;
			  $price 		    = $obj->price ;
			  $hours_worked 	= $obj->hours_worked ;
			  $hours_rate 		= $obj->hours_rate ;
			  $ConstructionSite->fetch($obj->const_site_id) ;
			  //$machine->fetch($obj->machine_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $fuel_consoma->getNomUrl(1,  $obj->id,$mid, $num);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $counter .'</td>';
			//print '<td align="center">'. $machine->getNomUrl(1).'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $price*$qty .'</td>';
			print '<td align="center">'. $hours_worked .'</td>';
			print '<td align="center">'. $hours_rate .'</td>';
			print '<td align="center">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td>';

			
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='.$mid.'" class="butAction">'.$langs->trans('Addfuel_consoma').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>