<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class intervention extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  public $date_start;
  public $spare_parts;
  public $date_end;
  public $machine_status ;
  public $description ;
  public $cause_failure ;
  public $machine_id ;
  public $defect_machine_id ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null,$mid, $ref = null)
    {
        global $langs;
        if (!$mid) return false;
        $result	= '';
        $setRef = (null !== $ref) ? $ref : $this->id;
        $id  	= ($id  ?: $this->id);
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/material/intervention/index.php?id='. $id .'&mid='.$mid.'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->date_start= $this->date_start ? $this->db->escape($this->date_start): null;
	  $this->spare_parts = $this->spare_parts ? $this->db->escape($this->spare_parts): null;
	  $this->date_end = $this->date_end ? $this->db->escape($this->date_end): null;
	  $this->machine_id = $this->machine_id ? $this->db->escape($this->machine_id): null;
	  $this->machine_status = $this->machine_status ? $this->db->escape($this->machine_status): null;
	  $this->description = $this->description ? $this->db->escape($this->description): null;
	  $this->cause_failure = $this->cause_failure ? $this->db->escape($this->cause_failure): null;
	  $this->defect_machine_id	= $this->defect_machine_id ? $this->db->escape($this->defect_machine_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'intervention' . ' (date_start,cause_failure,spare_parts,date_end,machine_status,description,';
	$sql .= 'machine_id,defect_machine_id,created_by,created_at,updated_at) ';
	$sql .= 'VALUES ("'.$this->date_start.'", "'.$this->cause_failure.'", "'.$this->spare_parts.'","'.$this->date_end.'","'. $this->machine_status.'", "'. $this->description.'", ';
	$sql .=	 $this->machine_id.', '.$this->defect_machine_id.', '.$this->created_by.','.$this->created_at.',NULL)';
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error intervention ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'intervention';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid ;
			  $this->date_start 			= $this->db->jdate($obj->date_start); ;
			  $this->spare_parts 			= $obj->spare_parts ;
			  $this->cause_failure 			= $obj->cause_failure ;
			  $this->date_end 			= $obj->date_end ;
			  $this->machine_id 			= $obj->machine_id ;
			  $this->machine_status 	= $obj->machine_status ;
			  $this->description 	= $obj->description ;
			  $this->defect_machine_id	= $obj->defect_machine_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'intervention';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$spare_parts = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->date_start 			= $this->db->jdate($obj->date_start); ;
				  $line->spare_parts 			= $obj->spare_parts ;
				  $line->cause_failure 			= $obj->cause_failure ;
				  $line->date_end 			= $obj->date_end ;
				  $line->machine_id 			= $obj->machine_id ;
				  $line->machine_status 	= $obj->machine_status ;
				  $line->description 	= $obj->description ;
				  $line->defect_machine_id	= $obj->defect_machine_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $spare_parts;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'intervention' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now  = $now->format('Y-m-d');
			$sql .= '`updated_at` = '. $now ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'intervention' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

public function getNames()
    {
    	$this->fetchAll();
    	$names = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$names[$line->id] = $line->id;    		
    	}

    	return $names;
    }

    public function getName($id)
    {
    	$sql = 'SELECT rowid FROM ' . MAIN_DB_PREFIX . 'intervention WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->rowid;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }


}
?>