<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/intervention_alerts/class/intervention_alerts.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/intervention_systematic/class/intervention_systematic.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';

// Get parameters
$action  = GETPOST('action', 'alpha');
$iid      = GETPOST('iid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$intervention_alerts = new intervention_alerts($db);

    if (!$error) {
        
          $intervention_alerts->time_elapsed            = trim(GETPOST('time_elapsed_'));
          $intervention_alerts->inter_syst_id            = (int)$iid;
          $intervention_alerts->kmh_made     = trim(GETPOST('kmh_made_'));
          $intervention_alerts->decision     = trim(GETPOST('decision_'));
          $intervention_alerts->created_by     = $user->id;
            //if(!$intervention_alerts->check_mat($intervention_alerts->mat)){
                    $intervention_alertsID = $intervention_alerts->create();
            
                    // If no SQL error we redirect to the request card
                    if ($intervention_alertsID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?iid='.$iid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$intervention_alerts->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$intervention_alerts->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $intervention_alerts_id = (int) GETPOST('intervention_alerts_id', 'int');

    if (!$intervention_alerts_id || $intervention_alerts_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $intervention_alerts = new intervention_alerts($db);
    $intervention_alerts->fetch($intervention_alerts_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $data = array(
          'time_elapsed'    =>trim(GETPOST('time_elapsed_')),
          'inter_syst_id'    =>(int)$iid,
          'kmh_made' =>trim(GETPOST('kmh_made_')),
          'decision' =>trim(GETPOST('decision_'))
        );

		$getintervention_alertsID = $intervention_alerts->update($intervention_alerts_id, $data);
        
                if ($getintervention_alertsID > 0) {
                    header('Location: ./index.php?id='.$intervention_alerts_id.'&iid='.$iid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $intervention_alerts_id .'&action=edit&error=SQL_Create&msg='.$intervention_alerts->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new intervention_alerts($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?iid='.$iid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$intervention_alerts     = new intervention_alerts($db);
$intervention_systematic     = new intervention_systematic($db);
$machine     = new machine($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('intervention_alerts'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("intervention_alerts"));
$intervention_systematic->fetch($iid);
$machine->fetch($intervention_systematic->machine_id);
$head       = material_prepare_head($machine);
    dol_fiche_head($head, 'intervention_systematic', $langs->trans('intervention_systematic'), 0, '');
    //print_fiche_titre($langs->trans("intervention"));
    $intervent  = intervention_sys_prepare_head($intervention_systematic);
    dol_fiche_head($intervent, 'intervention_alerts', $langs->trans("intervention_alerts"), 0, '');
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addintervention_alerts'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?iid='.$iid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';



        //time_elapsed
        print '<tr><td class="fieldrequired">'.$langs->trans("time_elapsed").'</td><td>';
        print '<input type="number" value="" name="time_elapsed_" required="required" />';
        print '</td></tr>';

        //decision
        print '<tr><td class="fieldrequired">'.$langs->trans("decision").'</td><td>';
        print '<input type="text" value="" name="decision_" required="required" />';
        print '</td></tr>';

        //engin
       /* print '<tr><td class="fieldrequired">'.$langs->trans("intervention_systematic").'</td><td>';
         $intervention_systematics = $intervention_systematic->getMats();
        print $form->selectarray('inter_syst_id_', $intervention_systematics,(GETPOST('inter_syst_id_') ? GETPOST('inter_syst_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/
        
        //chantier 
        print '<tr><td>'.$langs->trans("kmh_made").'</td><td>'; 
        print '<input type="number" value="" name="kmh_made_" required="required" />';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createintervention_alerts") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $intervention_alerts->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddate_startP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'intervention_alertss', $langs->trans("intervention_alerts"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&iid='.$iid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="intervention_alerts_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

        //time_elapsed
        print '<tr><td class="fieldrequired">'.$langs->trans("time_elapsed").'</td><td>';
        print '<input type="number" value="'.$intervention_alerts->time_elapsed.'" name="time_elapsed_" required="required" />';
        print '</td></tr>';

        //decision
        print '<tr><td class="fieldrequired">'.$langs->trans("decision").'</td><td>';
        print '<input type="text" value="'.$intervention_alerts->decision.'" name="decision_" required="required" />';
        print '</td></tr>';

        //intervention systematique
       /* print '<tr><td class="fieldrequired">'.$langs->trans("intervention_systematic").'</td><td>';
         $intervention_systematics = $intervention_systematic->getMats();
        print $form->selectarray('inter_syst_id_', $intervention_systematics,(GETPOST('inter_syst_id_') ? GETPOST('inter_syst_id_') : $intervention_alerts->inter_syst_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

        //chantier 
        print '<tr><td>'.$langs->trans("kmh_made").'</td><td>'; 
        print '<input type="number" value="'.$intervention_alerts->kmh_made.'" name="kmh_made_" required="required" />';
        print '</td></tr>';

                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>